/****************************************
  Ver 1.00 : Basic 16bit version
      1.01 : compiled w/ qlib making it 32bit
      1.01a : compiled w/ PMODE/w v1.31
      1.01b : updated usage()
      1.01c : all warning removed
      1.01d : recompiled after major bug in QLIB fixed
      1.01e : made a nice little spinning star
      1.02 : atol was used (instead of atoi) to convert input file length
             That was limiting it to 64k before
      1.02a : compiled with v2.07 for better Ctrl+Break handling
      1.02b : removed obsolete CheckCtrlBreak()
      1.03 : fixed some problems (putch(8) was not working in QLIB)
             accepts Hex inputs (0x)
****************************************/

#include <qlib.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>

#include "misc.h"

void cleanup(void) {}

void usage(void) {
  printf("  Usage : FS infile outfile1 outfile2 [length]\n");
  printf("   infile = file to split into two files\n");
  printf("   outfile1 = 1st part\n");
  printf("   outfile2 = 2nd part\n");
  printf("   length = size of outfile1 [default=1/2 sizeof(infile)]\n");
  printf(" Splits 'infile' into two files 'outfile1' and 'outfile2'\n");
  exit(0);
}

byte stars[]={'-','\\','|','/'};

void prnstar(void) {
  static starpos=0;

  putch(stars[starpos++]);
  putch(8);

  if (starpos > 3) starpos=0;

}

word main(byte argc,byte **args) {
  sword hi,ho1,ho2;
  sdword len,toread,a,b;
  byte *buf;

  printf("File Splitter v1.03 - 32bit - by:Peter Quiring\n");
  if ((argc>5)||(argc<4)) usage();
  buf=GetRam(bufsiz);
  strupr(args[1]);
  strupr(args[2]);
  strupr(args[3]);
  hi=open(args[1],O_RDONLY|O_BINARY);
  if (hi==-1) error("Opening infile");
  a=filelength(hi);
  if (argc==5) {
    if (!memicmp(args[4],"0x",2)) {
      len=str2num(args[4],16);
    } else {
      len=str2num(args[4],10);
    }
    if (len>a) error("Invalid length");
  } else len=(int)(a / 2);
  ho1=_creat(args[2],FA_ARCH);
  if (ho1==-1) error("Opening outfile1");
  ho2=_creat(args[3],FA_ARCH);
  if (ho2==-1) error("Opening outfile2");
  printf("Splitting %s [%d] into %s [%d] and %s [%d]:" , args[1] , a
   , args[2], len , args[3] , a-len );
  a=0;
  do{
    toread = ((len-a)>bufsiz) ? bufsiz : len-a;
    b=read(hi,buf,toread);
    if ((b==-1)||(b!=toread)) error("Reading infile (1)");
    b=write(ho1,buf,b);
    if ((b!=(toread))||(b==-1)) error("Writing outfile1");
    a+=b;
    prnstar();
  }while (a<len);
  close(ho1);
  while (!eof(hi)) {
    b=read(hi,buf,bufsiz);
    if ((b==-1)||(!b)) error("Reading infile (2)");
    a=write(ho2,buf,b);
    if ((a==-1)||(a!=b)) error("Writing outfile2");
    prnstar();
  };
  close(ho2);
  close(hi);
  printf("Complete!\n");
  return 0;
}
