include qlib.inc
include string.inc
include stdio.inc
include conio.inc
include process.inc
include os.inc
include time.inc
include dos.inc
include alloc.inc

.data
  s1 dd ?              ;for CPUID str
  s2 dd ?
  s3 dd ?
  db 0                 ;NULL for CPUID str
  saved_cpuid dd ?     ;for CPUID EAX
  _ax dw ?             ;for FPU status/ctrl
.code

main proc

  call clrscr

  callp printf,"%s\n",_qlib_info

  mov ax,400h
  int 31h
  callp printf,"DPMI host v%d.%d\n",ah,al
  callp printf," - Host sends INTs/IRQs to "
  .if (bl & 2)
    callp printf,"real mode.\n"
  .else
    callp printf,"v86 mode.\n"
  .endif
  callp printf," - Host does "
  .if !(bl & 4)
    callp printf,"not "
  .endif
  callp printf,"support virtual memory.\n"
  
  callp printf,"Servers avail : [DPMI:"

  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,1687h
  mov [esp].callstruct._ss,0     ;FIX : v2.11 Beta #3 : Must clear SS:ESP
  mov [esp].callstruct._sp,0
  xor ecx,ecx
  mov edi,esp
  mov bx,2fh
  mov ax,300h
  int 31h
  mov eax,[esp].callstruct._eax
  add esp,sizeof callstruct

  .if ax!=0
    callp printf,"no"
  .else
    callp printf,"yes"
  .endif
  callp printf,"][VCPI:"

  mov ah,1
  mov al,_os_typ
  .if (al != OS_WIN32) && (al != OS_WINNT)
    mov ax,0de00h
    int 67h  ;detect VCPI  ;WARNING : This will cause Win95 to attempt to run in DOS-Mode
  .endif
  .if ah!=0
    callp printf,"no"
  .else
    callp printf,"yes"
  .endif
  callp printf,"][XMS:"

  ;detect XMS   ;FIX : v2.11 Beta #5 : DPMI host stops XMS check
  sub esp,sizeof callstruct
  mov [esp].callstruct._eax,4300h
  mov [esp].callstruct._ss,0     ;FIX : v2.11 Beta #3 : Must clear SS:ESP
  mov [esp].callstruct._sp,0
  xor ecx,ecx
  mov edi,esp
  mov bx,2fh
  mov ax,300h
  int 31h
  mov eax,[esp].callstruct._eax
  add esp,sizeof callstruct

  .if al!=80h
    callp printf,"no]\n"
  .else
    callp printf,"yes]\n"
  .endif

  callp print,"Server used : "
  mov al,_pmmode
  .if al==SRV_RAW
    callp print,"RAW\n"
  .elseif al==SRV_XMS
    callp print,"XMS\n"
  .elseif al==SRV_VCPI
    callp print,"VCPI\n"
  .elseif al==SRV_DPMI
    callp print,"DPMI\n"
  .elseif al==SRV_UNKNOWN
    callp print,"Unknown\n"
  .else
    callp print,"Unsupported\n"
  .endif

  callp printf,"Processor : 80%d86 : ",_processor
  push cs
  lar ax,wptr[esp]
  add esp,4   ;segments are pushed as 32bit entities (although they are still 16bit)
  shr ah,8-3
  and ah,3
  callp printf,"CPL=%i\n",ah

  callp print,"DOS Extender detected : "
  mov al,_dosXtyp
  mov dx,_dosXver

  .if al==DOSX_PMODEW
    callp printf,"PMODE/W v%d.%d\n",dh,dl
  .elseif al==DOSX_DOS4GW
    callp printf,"DOS/4GW v%d.%d\n",dh,dl
  .elseif al==DOSX_DOS32
    callp printf,"DOS32 v%d.%d\n",dh,dl
  .elseif al==DOSX_WDOSX
    callp printf,"WDOSX v%d.%d\n",dh,dl
  .else
    callp print,"Unknown\n"
  .endif

  callp print,"OS detected : "
  mov al,_os_typ
  .if al==OS_DOS
    callp print,"DOS"
  .elseif al==OS_WIN
    callp print,"Win"
  .elseif al==OS_WIN32
    callp print,"Win 95/98"
  .elseif al==OS_WINNT
    callp print,"Win NT"
  .elseif al==OS_DV
    callp print,"DesqView"
  .elseif al==OS_OS2
    callp print,"OS/2"
  .else
    callp print,"Unknown OS detected"
    jmp @f
  .endif
  callp printf," v%i.%i",_os_ver_major,_os_ver_minor
@@:  
  mov al,_os_typ
  .if al!=OS_DOS
    callp printf," : DOS v%i.%i\n",_dos_ver_major,_dos_ver_minor
  .else
    callp printf,"\n"
  .endif

  callp coreleft
  mov ecx,eax
  mov ah,48h
  mov bx,-1  ;alloc too much
  int 21h
  xor edx,edx
  mov dx,bx
  shl edx,4
  callp printf,"XMS Free RAM : %d bytes : DOS Free RAM : %d bytes\n",ecx,edx

;test if CPUID is avail
  pushfd
  pop eax
  mov ebx,eax
  xor eax,200000h
  push eax
  popfd
  pushfd
  pop eax
  .if eax!=ebx
    callp printf,"CPUID supported : "    ;0fh 0a2h
    xor eax,eax
    db 0fh,0a2h  ;CPUID
    ;EAX = capablities
    ;EBX-EDX-ECX = String
    callp printf,"EAX = %d\n",eax
    mov s1,ebx
    mov s2,edx
    mov s3,ecx
    callp printf,"  CPUID str=%s\n",offset s1
    mov eax,1
    db 0fh,0a2h  ;CPUID
    mov s1,ebx
    mov s2,edx
    mov s3,ecx
    mov saved_cpuid,eax        ; save for future use
    and eax,0F00H              ; mask everything but family
    shr eax,8
    callp printf,"  CPU Type = %d  ",al
    mov eax,saved_cpuid        ; restore data
    and al,0fh
    callp printf,"Stepping = %d  ",al
    mov eax, saved_cpuid
    and al,0F0H                ; isolate model info
    shr al,4
    callp printf,"Model = %d\n",al

 ;MMX detection  (although I could just look at _mmx)
    callp printf,"MMX "
    test  s2,800000h
    .if zero?
      callp printf,"not "
    .endif
    callp printf,"present\n"
  .else
    callp printf,"CPUID not supported\n"
    callp printf,"MMX not present\n"
  .endif
  callp printf,"Long File Name "
  .if !_lfn
    callp printf,"not "
  .endif
  callp printf,"supported\n"

  callp printf,"Debugger : "
  .if _debugger
    .if _qdebug
      callp printf,"Q Debugger\n"
    .else
      callp printf,"Watcom Debugger\n"
    .endif
  .else
    callp printf,"Not detected\n"
  .endif

  fstcw _ax
  callp printf,"FPU Control Word = %016b [%#x]\n",_ax,_ax
  xor eax,eax
  fstsw ax
  callp printf,"FPU Status  Word = %016b [%#x]\n",eax,eax

  callp printf,"DOS extender does "
  mov ax,0a00h
  mov esi,"Blah Blah Blah"
  push ebp  ;INT 31h/0a00h may destory EBP
  stc  ;this still does not help with PMODE/W
  int 31h
  pop ebp
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  .if !carry?
    callp printf,"not "
  .endif
  callp printf,"properly support API (INT 31h/0a00h)\n"

  ret
main endp

end

