#pragma inline
#include <system.h>

#ifdef __cplusplus
   typedef void (*fptr)(int);
#else
   typedef void (*fptr)();
#endif

volatile int _fpuexc=0;
volatile int _sig;
volatile int _subcode;

void Catcher(int sig,int subcode,int *reglist)
{
   //can not use printf() here - stack too small
   _fpuexc=1;
   _sig=sig;
   _subcode=subcode;
}

void main(void)
{
   word _w;

   signal(SIGFPE, (fptr)Catcher);  /* cast Catcher to appropriate type */

   asm {
     fld1
     fldz
     fdivp st(1),st
     ffree st
   }

   if (_fpuexc==1) printf("FPU Exc occured!\n");

   if ((_fpuexc==1)&&(_sig==SIGFPE)&&(_subcode==FPE_ZERODIVIDE)) {
     printf("Caught it!\n");
     _exit(1);
   }

   printf("BUG!\n");
}
