/* EDITFN.H */

/* Editor functions include file for EDITFN.C. */
/* Text editor functions designed for use with Steph. */

/* by Stephen Morphet, 1994. */

#define NO_WRAP -1

#define TABSIZE 3

#define SMALL_SCROLL 1
#define BIG_SCROLL 20

#define CHARMAX 256

#define NEWLINE   -1
#define NONEWLINE 0
#define AT_END    1

/* window contents endcodes */
#define NOEND      0
#define ENDPARA   1
#define ENDDOC    2
#define LONGWRAP   3


#define ewi _editor_spec.info[_window_spec.active]


struct __editwininfo
{
	int csr_x;				/* x position zero based */
	int csr_y;				/* y position zero based */
};

typedef struct
{
	struct __editwininfo info[__MAXWINDOWS];
								/* struct holding csr pos in each win */

	int sel_win;	/* window that has the highlight, -1 for none. */

	unsigned sel_line;
	unsigned end_line;	/* start and end lines of highlight */

	unsigned sel_char;
	unsigned end_char;	/* start and end characters of highlight */


} __ed_data;


extern __ed_data _editor_spec;


/* functions */

void editor_initialise( void );

void fix_x_cursor( void );
void fix_lineo( void );
void fix_charo( void );

void editor_mouse_select( void );
void editor_mouse_unselect( void );
void editor_mouse_minimise( void );
void editor_mouse_maximise( void );
void editor_mouse_resize( void );
void editor_mouse_activate( void );

void ems_left( void );
void ems_right( void );
void ems_pleft( void );
void ems_pright( void );
void ems_hdrag( void );

void ems_up( void );
void ems_down( void );
void ems_pup( void );
void ems_pdown( void );
void ems_vdrag( void );

void editor_filter( void );
void editor_action( void );

void _ed_pg_up( int *cxp, int *cyp );
void _ed_pg_down( int *cxp, int *cyp );

void ed_put_cursor( unsigned win );


char *_ed_makebuffer( unsigned win );
int _ed_readfile( unsigned win, char *fname );
