/* xbmatop.h                    freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mIn1 + mIn2          */
/* -------------------------------------------------------------------------- */
void addmF(
pmatrix mA,
pmatrix mB,
pmatrix mAplsB)
{

     int i;
     int j;
fraction f;

  if (mA->rows != mB->rows || mA->cols != mB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mA->rows!=mAplsB->rows||mA->cols!=mAplsB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mA->rows ; i++)
    for ( j = 0; j < mA->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mA->pblock + i *mA->cols + j) *   \
                 *(mB->pblock + i *mB->cols + j + 1))
                                    + \
                 *(mB->pblock + i *mB->cols + j)  *   \
                 *(mA->pblock + i *mA->cols + j + 1);

                                                f.denom = \

                *(mA->pblock + i *mA->cols + j + 1) * \
                *(mB->pblock + i *mB->cols + j + 1);

                 f = miniF(f);

                *(mAplsB->pblock + i *mAplsB->cols + j)       = f.numer;
                *(mAplsB->pblock + i *mAplsB->cols + j + 1)   = f.denom;
         }
}


/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mA + mIn2          */
/* -------------------------------------------------------------------------- */
void submF(
pmatrix mA,
pmatrix mB,
pmatrix mAsubB)
{

     int i;
     int j;
fraction f;

  if (mA->rows != mB->rows || mA->cols != mB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mA->rows!=mAsubB->rows||mA->cols!=mAsubB->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mA->rows ; i++)
    for ( j = 0; j < mA->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mA->pblock + i *mA->cols + j) *   \
                 *(mB->pblock + i *mB->cols + j + 1))
                                    - \
                 *(mB->pblock + i *mB->cols + j)  *   \
                 *(mA->pblock + i *mA->cols + j + 1);

                                                f.denom = \

                *(mA->pblock + i *mA->cols + j + 1) * \
                *(mB->pblock + i *mB->cols + j + 1);

                 f = miniF(f);

                *(mAsubB->pblock + i *mAsubB->cols + j)       = f.numer;
                *(mAsubB->pblock + i *mAsubB->cols + j + 1)   = f.denom;
         }
}


/* ------------------------------ FUNCTION -------------------------- multm() */
/*    mutiply two matrices giving a third matrix    mAB = mA * mB        */
/* -------------------------------------------------------------------------- */
void multmF(
pmatrix mA,
pmatrix mB,
pmatrix mAB)
{
     int i;
     int j;
     int k;
fraction fm;
fraction fa;

              for(k= 0; k < mA->rows; k++)
               {
                  for(j= 0; j < mB->cols; j++,j++)
                   { fa.numer = 0;
                     fa.denom = 1;
                    for(i= 0; i < mA->cols; i++,i++)
                    {
                    fm.numer = *(mA->pblock +  k   *(mA->cols) + i )  * \
                               *(mB->pblock + i/2  *(mB->cols) + j ) ;

                    fm.denom = *(mA->pblock +  k   *(mA->cols) + i + 1) * \
                               *(mB->pblock + i/2  *(mB->cols) + j + 1);

                    fa = addF(fa,fm);
                    }
                      fa = miniF(fa);
                     *(mAB->pblock +  k   *(mAB->cols) + j    ) = fa.numer;
                     *(mAB->pblock +  k   *(mAB->cols) + j + 1) = fa.denom;
                   }
               }
}


/* ------------------------------ FUNCTION ------------------------ smultmF() */
/*         m = scalaire * m                                                   */
/* -------------------------------------------------------------------------- */
void smultmF(
fraction s,
pmatrix mA,
pmatrix msA)
{
     int i;
     int j;
fraction f;

  for (   i = 0; i < mA->rows ; i++)
    for ( j = 0; j < mA->cols ; j++, j++)
         {
          f.numer = (*(mA->pblock + i *mA->cols + j    )) * s.numer;
          f.denom = (*(mA->pblock + i *mA->cols + j + 1)) * s.denom;

                f = miniF(f);

         (*(msA->pblock + i *msA->cols + j    )) = f.numer;
         (*(msA->pblock + i *msA->cols + j + 1)) = f.denom;
         }
}


/* ------------------------------ FUNCTION ---------------------- transpose() */
/*                     */
/* -------------------------------------------------------------------------- */
void transposemF(
pmatrix mA,
pmatrix mTrposA)
{
  int i;
  int j;

  if (mTrposA->rows * TWOCOL != mA->cols)
    {
     printf("\n transpose() error - dest matrix rows must = source matrix cols");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mA->rows * TWOCOL != mTrposA->cols)
    {
     printf("\n transpose() error - source matrix rows must = dest matrix cols");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (  i = 0 ; i < mA->rows ;     i++)
   {
    for (j = 0 ; j < mA->cols ; j++,j++)
      {
       *(mTrposA->pblock + (j/TWOCOL) *mTrposA->cols + i * TWOCOL)     = \
       *( mA->pblock +  i         *mA->cols  + j         );

       *(mTrposA->pblock + (j/TWOCOL) *mTrposA->cols + i * TWOCOL + 1) = \
       *( mA->pblock +  i         *mA->cols + j           + 1);
      }
   }
}




/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mTrposA = m + msA          */
/* -------------------------------------------------------------------------- */
fraction tracemF(
pmatrix m)
{
     int i;
fraction f;
fraction fT;

  if ((m->rows * TWOCOL) !=  m->cols)
    {
     printf("\n trF() error - Square matrix, please");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }

    f.numer = 0;
    f.denom = 1;

  for(   i = 0; i < m->rows ; i++)
     {
      fT.numer = (*(m->pblock + i *m->cols + i * TWOCOL    ));
      fT.denom = (*(m->pblock + i *m->cols + i * TWOCOL + 1));

             fT = miniF(  fT);
             f  =  addF(f,fT);
             f  = miniF(f);
     }

  return(f);
}


/* ------------------------------ FUNCTION ------------------------ powermF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void powermF(
pmatrix mA,
int     pn,
pmatrix mApn
)
{
 int i;
 int n;

double pbT1 [MXR][MXC*TWOCOL];matrix mT1  ={MXR,MXC*TWOCOL,&pbT1 [0][0]};
double pbT2 [MXR][MXC*TWOCOL];matrix mT2  ={MXR,MXC*TWOCOL,&pbT2 [0][0]};

 n = mA->rows;
                   mT1.rows=n;                 mT1.cols=n*TWOCOL;
                   mT2.rows=n;                 mT2.cols=n*TWOCOL;

 copymF(mA,mApn);

 if(!pn){mid(mApn);}
 else
 {
  copymF(mApn,&mT1);
  for(i = pn-1 ; i ; i--)
  {
   multmF(mApn,&mT1,&mT2);
   copymF(&mT2,mApn);
  }
 }
}

