/* xpc.h                        freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION ------------------------- printm() */
/*       *(mA->pblock + i *mA->cols + j)   print( row i column j )          */
/* -------------------------------------------------------------------------- */
void printcF(
pmatrix mA)
{
 int i;
 int j;

 printf("double pbX[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/2);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf("%6.0lf,%-.0lf,",*(mA->pblock + i *mA->cols + j  ),
                             *(mA->pblock + i *mA->cols + j+1) );
    }
  }

 printf("\n};\n");
 printf(" matrix mX={%d,%d*TWOCOL,&pbX[0][0]};\n",mA->rows,mA->cols/2);

 printf("\n");
}


/* ------------------------------ FUNCTION ------------------------- printm() */
/*       *(mA->pblock + i *mA->cols + j)   print( row i column j )          */
/* -------------------------------------------------------------------------- */
void printcF4(
pmatrix mA)
{
 int i;
 int j;

 printf("double pbX[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/2);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf("%4.0lf,%-.0lf,",*(mA->pblock + i *mA->cols + j  ),
                             *(mA->pblock + i *mA->cols + j+1) );
    }
  }

 printf("\n};\n");
 printf(" matrix mX={%d,%d*TWOCOL,&pbX[0][0]};\n",mA->rows,mA->cols/2);

 printf("\n");
}

/* ------------------------------ FUNCTION ------------------------- printm() */
/*       *(mA->pblock + i *mA->cols + j)   print( row i column j )          */
/* -------------------------------------------------------------------------- */
void printcF3(
pmatrix mA)
{
 int i;
 int j;

 printf("double pbX[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/2);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf("%3.0lf,%-.0lf,",*(mA->pblock + i *mA->cols + j  ),
                             *(mA->pblock + i *mA->cols + j+1) );
    }
  }

 printf("\n};\n");
 printf(" matrix mX={%d,%d*TWOCOL,&pbX[0][0]};\n",mA->rows,mA->cols/2);

 printf("\n");
}

/* ------------------------------ FUNCTION ------------------------- printm() */
/*       *(mA->pblock + i *mA->cols + j)   print( row i column j )          */
/* -------------------------------------------------------------------------- */
void printcF0(
pmatrix mA)
{
 int i;
 int j;

 printf("double pbX[%d][%d*TWOCOL]=\n", mA->rows, mA->cols/2);
 printf("{");

 for (i = 0 ; i < mA->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf("%.0lf,%-.0lf, ",*(mA->pblock + i *mA->cols + j  ),
                             *(mA->pblock + i *mA->cols + j+1) );
    }
  }

 printf("\n};\n");
 printf(" matrix mX={%d,%d*TWOCOL,&pbX[0][0]};\n",mA->rows,mA->cols/2);

 printf("\n");
}

