/* xpmaple.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printmpl(
pmatrix mA)
{
 int i;
 int j;

 printf("\n");
 printf("M := matrix(%d,%d,[", mA->rows, mA->cols/2);

 for (   i = 0 ; i < mA->rows ;     i++)
  {
   printf("\n");
   for ( j = 0 ; j < mA->cols ; j++,j++)
    {
     printf("%.0lf/(%-.0lf),",*(mA->pblock + i *mA->cols + j     ),
                              *(mA->pblock + i *mA->cols + j + 1 ));
    }
  }
  printf("\b \n");
  printf("]);");
  printf("\n");
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printGnuPlot2d(
   char filename[11],
pmatrix mA
)
{
FILE *fp;
  int j;

   fp = fopen(filename,"w");

   for (j = 0; j < mA->cols;j++,j++)
    {
     fprintf(fp,"  %.3lf  %.3lf \n",
                 *(mA->pblock + 0 *mA->cols + j     )/
                 *(mA->pblock + 0 *mA->cols + j + 1 ),
                 *(mA->pblock + 1 *mA->cols + j     )/
                 *(mA->pblock + 1 *mA->cols + j + 1 ));
    }

  fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void printGnuPlot3d(
   char filename[11],
pmatrix mA
)
{
FILE *fp;
  int j;

   fp = fopen(filename,"w");

   for (j = 0; j < mA->cols;j++,j++)
    {
     fprintf(fp,"  %.3lf  %.3lf  %.3lf \n",
                 *(mA->pblock + 0 *mA->cols + j     )/
                 *(mA->pblock + 0 *mA->cols + j + 1 ),
                 *(mA->pblock + 1 *mA->cols + j     )/
                 *(mA->pblock + 1 *mA->cols + j + 1 ),
                 *(mA->pblock + 2 *mA->cols + j     )/
                 *(mA->pblock + 2 *mA->cols + j + 1 ));
    }

  fclose(fp);
}

