/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction Norm_u;
fraction Norm_v;
fraction Norm_uplsv;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};
double pbuplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&pbuplsv[0][0]};

if     (vectrow)
  {
     mu.rows = 1;           mu.cols = n*TWOCOL;
     mv.rows = 1;           mv.cols = n*TWOCOL;
 muplsv.rows = 1;       muplsv.cols = n*TWOCOL;
  }
else if(!vectrow)
   {
     mu.rows = n;           mu.cols = 1*TWOCOL;
     mv.rows = n;           mv.cols = 1*TWOCOL;
 muplsv.rows = n;       muplsv.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,5,3);
  rndmF(&mv,5,3);

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  addmF(&mu,&mv,&muplsv);
  printf("\n\n                             u + v");
  printmF3(&muplsv);
  Norm_uplsv = normP2(&muplsv);               /* It is the square of the norm.*/

  printf("\n\n         ||u + v|| = (%.0lf/%-.0lf)**(1/2)\n",
            Norm_uplsv.numer,
            Norm_uplsv.denom);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);

  Norm_u = normP2(&mu);                       /* It is the square of the norm.*/
  printf("\n\n\n         ||u|| = (%.0lf/%-.0lf)**(1/2)\n\n",
            Norm_u.numer,
            Norm_u.denom);

  Norm_v = normP2(&mv);                       /* It is the square of the norm.*/
  printf("\n         ||v|| = (%.0lf/%-.0lf)**(1/2)\n\n",
            Norm_v.numer,
            Norm_v.denom);
  getchar();

  clrscrn();
  printf("\n       Properties of length in R**n :\n  ");
  printf("\n         ||u + v|| =< ||u|| + ||v||  \n\n");
  printf("\n  (%.0lf/%-.0lf)**(1/2) =<  ",
                 Norm_uplsv.numer,
                 Norm_uplsv.denom);

  printf(" (%.0lf/%-.0lf)**(1/2) + (%.0lf/%-.0lf)**(1/2)\n\n",
                  Norm_u.numer,
                  Norm_u.denom,
                  Norm_v.numer,
                  Norm_v.denom);

  printf("           %.3lf =<  %.3lf\n\n",
            sqrt(     Norm_uplsv.numer/     Norm_uplsv.denom),
            sqrt(Norm_u.numer/Norm_u.denom)
            +
            sqrt(Norm_v.numer/Norm_v.denom));
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n       Properties of length in R**n \n            ");
  printf("\n                                                  ");
  printf("\n         ||u + v|| =< ||u|| + ||v||               ");
  printf("\n         **************************               ");
  printf("\n\n                                                ");
  printf("\n The size of u, v    : 2x1 ... 4x1.             \n");
  printf("\n     ex : \"lngthdCF.exe\"                      \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"lngthdCF.exe 2\" -> 4x1               ");
  printf("\n          \"lngthdCF.exe 4\" -> 4x1             \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}}
else
 {    n=rndpI(5);}
   if(n<2){n=2;}

if     ( vectrow){vectrow = 0;}
else if(!vectrow){vectrow = 1;}


  AB(n,vectrow);



  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












