/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n)
{
double pbA[2][2*TWOCOL]=
{
  -1,1,   0,1,
   0,1,   1,1,
};
matrix mA={2,2*TWOCOL,&pbA[0][0]};

double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

   mu.rows = 2;           mu.cols = n*TWOCOL;
   mv.rows = 2;           mv.cols = n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,6,3);

  clrscrn();

  printf("\n Reflection about the y-axis :                  \n");
  printf("\n                | -1  0 |                         ");
  printf("\n         v[n] = |       |  u[n]                   ");
  printf("\n                |  0  1 |                         ");

  printf("\n                                       u[n] = AB\n");
  printmF2(&mu);
  gnpltvectcol2d("u",&mu);

  multmF(&mA,&mu,&mv);
  printf("\n                                       v[n] = CD\n");
  printmF2(&mv);
  gnpltvectcol2d("v",&mv);
  gnpltaxis(     "aa2d.plt");

  printf("\n\n To see the result in Gnuplot (gp373w32.exe) :           \n\n");
  printf("  * open the file aa2d.plt with Gnuplot. Gnuplot draw u and v. \n");
  printf("  * Press Return in this window. (To create a new value for u) \n");
  printf("  * Use the command Replot in Gnuplot to draw the news u and v.\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n                                              ");
  printf("\n        Reflection about the y-axis :             ");
  printf("\n        ***************************               ");
  printf("\n\n                                                ");
  printf("\n                  u = AB                          ");
  printf("\n\n                                                ");
  printf("\n                | -1  0 |                         ");
  printf("\n        v[n]  = |       |  u[n]                   ");
  printf("\n                |  0  1 |                         ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                        \n");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 10){n=10;}}
else
 {    n=rndpI(10);}
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}























