/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int p
)
{
fraction InnerProduct_0v;
fraction InnerProduct_v0;

double pb0[MXR][MXC*TWOCOL];matrix m0={MXR,MXC*TWOCOL,&pb0[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

   m0.rows = n;           m0.cols =p*TWOCOL;
   mv.rows = n;           mv.cols =p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  mzero(&m0);
  rndmF(&mv,5,3);

  clrscrn();
  printf("                                 0");
  printmF3(&m0);
  printf("                                 V");
  printmF3(&mv);

  printf("\n  Properties of inner product in Mnm :");
  printf("\n             <0,V>  =  <V,0>  = 0   \n\n");

  InnerProduct_0v = innerprod_Mnm(&m0,&mv);
  printf("  <0,V> =  %6.0lf/%-6.0lf\n\n",
            InnerProduct_0v.numer,
            InnerProduct_0v.denom);

  InnerProduct_v0 = innerprod_Mnm(&mv,&m0);
  printf("  <V,0> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_v0.numer,
            InnerProduct_v0.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in Mnm :         \n");
  printf("\n                                                \n");
  printf("\n\n\n                                              ");
  printf("\n              <0,V>  =  <V,0>  = 0                ");
  printf("\n              ********************                ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}
  }
else
 {
  n=rndpI(5);
  p=rndpI(5);
 }
   if(n<2){n=2;}
   if(p<2){p=2;}


  AB(n,p);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












