/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int p
)
{
fraction Norm_u;
fraction Norm_v;
fraction Normu_Normv;

fraction InnerProduct;

double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

       mu.rows = n;           mu.cols = p*TWOCOL;
       mv.rows = n;           mv.cols = p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mu,3,1);
  rndmF(&mv,3,1);

  clrscrn();
  printf("\n                               (n x p) : u \n");
  printmF(&mu);
  printf("\n                               (n x p) : v \n");
  printmF(&mv);
  getchar();

  clrscrn();
  Norm_u = norm_MnmP2(&mu);                   /* It is the square of the norm.*/
  Norm_v = norm_MnmP2(&mv);
  printf("\n\n\n         ||u|| = (%.0lf/%-.0lf)**(1/2)\n",
            Norm_u.numer,
            Norm_u.denom);

  printf("\n         ||v|| = (%.0lf/%-.0lf)**(1/2)\n\n",
            Norm_v.numer,
            Norm_v.denom);

  Normu_Normv = multF(Norm_u,Norm_v);
  printf("\n  ||u||  ||v|| = (%.0lf/%-.0lf)**(1/2) \n\n",
            Normu_Normv.numer,
            Normu_Normv.denom);
  getchar();

  clrscrn();
  InnerProduct = innerprod_Mnm(&mu,&mv);
  printf("                  u.v =   %.0lf/%-.0lf \n\n",
            InnerProduct.numer,
            InnerProduct.denom);

  printf("          ||u|| ||v|| =   (%.0lf/%-.0lf)**(1/2) \n\n",
            Normu_Normv.numer,
            Normu_Normv.denom);

  printf("\n     Cauchy-Schwarz inequality on the  ");
  printf("\n           inner product in Mnm\n\n");
  printf("               |u.v|  =<  ||u|| ||v|| \n\n");

  printf("              |%.0lf/%-.0lf|  =<  (%.0lf/%-.0lf)**(1/2) \n\n",
            InnerProduct.numer,InnerProduct.denom,
             Normu_Normv.numer, Normu_Normv.denom);

  printf("             |%.3lf|  =<  %.3lf \n\n",
            InnerProduct.numer/InnerProduct.denom,
        sqrt(Normu_Normv.numer/Normu_Normv.denom));

}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Cauchy-Schwarz inequality on the             ");
  printf("\n            inner product in Mnm                \n");
  printf("\n                                                  ");
  printf("\n          |u.v|  =< ||u|| ||v||                   ");
  printf("\n          *********************                   ");
  printf("\n                                                  ");
  printf("\n The size of u, v : 2x2 ... 4x4.                \n");
  printf("\n     ex : \"causchAF.exe\"                      \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"causchAF.exe 2\" -> 1x2               ");
  printf("\n          \"causchAF.exe 4\" -> 1x4             \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 4){n=4;}
  p = atoi(argv[2]); if( p > 4){p=4;}
  }
else
 {
  n=rndpI(4);
  p=rndpI(4);
 }
   if(n<2){n=2;}
   if(p<2){p=2;}


  AB(n,p);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

