/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction det;
int x;

fraction Distance_uv;
fraction Distance_uw;
fraction Distance_wv;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};
double pbw[MXR][MXC*TWOCOL];matrix mw={MXR,MXC*TWOCOL,&pbw[0][0]};

   mA.rows = n;           mA.cols = n*TWOCOL;
   mu.rows = n;           mu.cols =   TWOCOL;
   mv.rows = n;           mv.cols =   TWOCOL;
   mw.rows = n;           mw.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   5;
 if(n<3){x = 100;}

  do
  {
               rndmF(&mA,x,2);
          det = detF(&mA);
  }while(!det.numer);

  rndmF(&mu,5,2);
  rndmF(&mv,5,2);
  rndmF(&mw,5,2);

  clrscrn();
  printf("                  An invertible matrix : A \n");
  printmF(&mA);
  getchar();

  clrscrn();
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  printf("\n                               (n x 1) : w \n");
  printmF(&mw);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  Distance_uv = distance_MnmP2(&mu,&mv);  /* It is the square of the distance.*/
  printf("\n\n d(u,v) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uv.numer,
            Distance_uv.denom);
  getchar();

  clrscrn();
  printf("                                 u");
  printmF3(&mu);
  printf("                                 v");
  printmF3(&mv);
  printf("                                 w");
  printmF3(&mw);
  Distance_uw = distance_AP2(&mA,&mu,&mw);  /* It is the square of the distance.*/
  printf("\n\n d(u,w) =  (%.0lf/%-.0lf)**(1/2)\n\n",
            Distance_uw.numer,
            Distance_uw.denom);
  Distance_wv = distance_AP2(&mA,&mw,&mv);  /* It is the square of the distance.*/
  printf(" d(w,v) =  (%.0lf/%-.0lf)**(1/2)\n",
            Distance_wv.numer,
            Distance_wv.denom);
  getchar();


  clrscrn();
  printf("\n  Distance on R**n generated by A :\n  ");
  printf("\n           d(u,v) =< d(u,w) + d(w,v)      \n\n");
  printf("  (%.0lf/%-.0lf)**(1/2) =<  ",
                 Distance_uv.numer,
                 Distance_uv.denom);

  printf(" (%.0lf/%-.0lf)**(1/2) + (%.0lf/%-.0lf)**(1/2)\n\n",
                 Distance_uw.numer,
                 Distance_uw.denom,
                 Distance_wv.numer,
                 Distance_wv.denom);

  printf("           %.3lf =<  %.3lf\n\n",
            sqrt(     Distance_uv.numer/     Distance_uv.denom),
            sqrt(Distance_uw.numer/Distance_uw.denom)
            +
            sqrt(Distance_wv.numer/Distance_wv.denom));
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n\n                                          ");
  printf("\n   Distance on R**n generated by A :         ");
  printf("\n\n\n\n                                            ");
  printf("\n         d(u,v)  =<  d(u,w) + d(w,v)              ");
  printf("\n         ***************************              ");
  printf("\n\n\n\n\n\n                                        ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












