/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction det;
int x;

fraction Distance_uv;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pbu[MXR][MXC*TWOCOL];matrix mu={MXR,MXC*TWOCOL,&pbu[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

   mA.rows = n;           mA.cols = n*TWOCOL;
   mu.rows = n;           mu.cols =   TWOCOL;
   mv.rows = n;           mv.cols =   TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =   5;
 if(n<3){x = 100;}

  do
  {
               rndmF(&mA,x,2);
          det = detF(&mA);
  }while(!det.numer);

  rndmF(&mu,5,2);
  rndmF(&mv,5,2);

  clrscrn();
  printf("                  An invertible matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : u \n");
  printmF(&mu);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  getchar();

  clrscrn();
  Distance_uv = distance_AP2(&mA,&mu,&mv); /* It is the square of the distance.*/

  printf("\n  Distance on R**n generated by A :   ");
  printf("\n\n     d(u,v)  >=  0              \n\n");
  printf("\n\n     d(u,v)   =  (%.0lf/%-.0lf)**(1/2) \n\n\n",
            Distance_uv.numer,
            Distance_uv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n\n                                           ");
  printf("\n        Distance on R**n generated by A :    ");
  printf("\n\n\n\n                                            ");
  printf("\n                d(u,v) >= 0                       ");
  printf("\n                ***********                       ");
  printf("\n\n\n\n\n\n                                        ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












