/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n
)
{
fraction InnerProduct_0v;
fraction InnerProduct_v0;

double pbA[MXR][MXC*TWOCOL];matrix mA={MXR,MXC*TWOCOL,&pbA[0][0]};
double pb0[MXR][MXC*TWOCOL];matrix m0={MXR,MXC*TWOCOL,&pb0[0][0]};
double pbv[MXR][MXC*TWOCOL];matrix mv={MXR,MXC*TWOCOL,&pbv[0][0]};

   mA.rows = n;           mA.cols = n*TWOCOL;
   m0.rows = n;           m0.cols =   TWOCOL;
   mv.rows = n;           mv.cols =   TWOCOL;

/*-------------------------------- PROGRAM ---------------------------------- */
mdiagpF(&mA,5,2);
  mzero(&m0);
  rndmF(&mv,5,2);

  clrscrn();
  printf("  Copy the weights w1,..,wn on the identity matrix : A \n");
  printmF(&mA);
  printf("\n                               (n x 1) : 0 \n");
  printmF(&m0);
  printf("\n                               (n x 1) : v \n");
  printmF(&mv);
  getchar();

  clrscrn();
  printf("\n  Weighed Euclidean Inner Product on R**n :");
  printf("\n             <0,V>  =  <V,0>  = 0   \n\n");

  InnerProduct_0v = innerprod_W(&mA,&m0,&mv);
  printf("  <0,V> =  %6.0lf/%-6.0lf\n\n",
            InnerProduct_0v.numer,
            InnerProduct_0v.denom);

  InnerProduct_v0 = innerprod_W(&mA,&mv,&m0);
  printf("  <V,0> =  %6.0lf/%-6.0lf \n\n",
            InnerProduct_v0.numer,
            InnerProduct_v0.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n     Weighed Euclidean Inner Product on R**n :  \n");
  printf("\n                                                \n");
  printf("\n\n\n                                              ");
  printf("\n              <0,V>  =  <V,0>  = 0                ");
  printf("\n              ********************                ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {
  n = atoi(argv[1]); if( n > 5){n=5;}
  }
else
 {
  n=rndpI(5);
 }
   if(n<2){n=2;}


  AB(n);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












