/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
fraction det;

double pbU [MXR][MXC*TWOCOL];matrix mU={MXR,MXC*TWOCOL,&pbU[0][0]};
double pbV [MXR][MXC*TWOCOL];matrix mV={MXR,MXC*TWOCOL,&pbV[0][0]};

double pbuT[MXR][MXC*TWOCOL];matrix muT ={MXR,MXC*TWOCOL,&pbuT[0][0]};
double pbvT[MXR][MXC*TWOCOL];matrix mvT ={MXR,MXC*TWOCOL,&pbvT[0][0]};

double pbvn[MXR][MXC*TWOCOL];matrix mvn ={MXR,MXC*TWOCOL,&pbvn[0][0]};
double pvnT[MXR][MXC*TWOCOL];matrix mvnT={MXR,MXC*TWOCOL,&pvnT[0][0]};

    mU.rows = 2;           mU.cols = 2*TWOCOL;
    mV.rows = 2;           mV.cols = 2*TWOCOL;

   muT.rows = 1;          muT.cols = 2*TWOCOL;
   mvT.rows = 1;          mvT.cols = 2*TWOCOL;

   mvn.rows = 1;          mvn.cols = 2*TWOCOL;
  mvnT.rows = 1;         mvnT.cols = 2*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
               rndmF(&mU,3,1);
          det = detF(&mU);
  }while(!det.numer);

   clrscrn();

   printf(" Consider the vector space R**2 with the Euclidean inner product.\n");
   printf(" A Matrix U with linear independent rows vectors, a basis of R**2.\n");
   printmF(&mU);

   printf("\n");
   printmX(&mU,'u');

  copyrowF(&mU,0,&mV,0);      /*v1*/

  copyrowF(&mU,1,&muT,0);
  copyrowF(&mV,0,&mvT,0);

    projwn(&muT,&mvT, &mvnT);
     submF(&muT,&mvnT,&mvn);

  copyrowF(&mvn,0,&mV,1);      /*v2*/

   printf("\n If we apply the Gram-Schmidt process on the vectors\n");
   printf(" on the matrix U, we obtain a orthogonal basis.\n");
   printmF(&mV);

   printf("\n");
   printmX(&mV,'v');
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n                                          \n");
  printf("        The Gram-Schmidt process in R**2,         \n");
  printf("        with the Euclidean inner product.         \n");
  printf("        ********************************            ");
  printf("\n\n\n \n\n\n\n\n\n\n\n                             ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}


