/* inverse2.c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
int main()
{
fraction InnProd;

double pbA[3][3*TWOCOL]=
{
    3,5,   0,1,   4,5,
   16,25, -3,5, -12,25,
   12,25,  4,5,  -9,25
};
matrix mA={3,3*TWOCOL,&pbA[0][0]};

double pbu   [3][  TWOCOL];matrix mu    = {3,  TWOCOL,&pbu   [0][0]};
double pbv   [3][  TWOCOL];matrix mv    = {3,  TWOCOL,&pbv   [0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\n");
  printf(" A an n x n orthogonal matrix.\n\n");
  printf(" The column vectors of A form an orthonormal set in R**n\n");
  printf(" With the euclidean inner product.\n\n");

  printf("                                   mA :\n");
  printmF3(&mA);

  printf("\n\n");
          copycolF(&mA,0,&mu,0);
  InnProd = normP2(&mu);
  printf("  ||Ac1|| =  %.0lf/%-.0lf;   ",InnProd.numer,InnProd.denom);
          copycolF(&mA,1,&mu,0);
  InnProd = normP2(&mu);
  printf("  ||Ac2|| =  %.0lf/%-.0lf;   ",InnProd.numer,InnProd.denom);
          copycolF(&mA,2,&mu,0);
  InnProd = normP2(&mu);
  printf("  ||Ac3|| =  %.0lf/%-.0lf;  \n\n",InnProd.numer,InnProd.denom);


         copycolF(&mA,0,&mu,0);
         copycolF(&mA,1,&mv,0);
    InnProd = innerprod(&mu,&mv);
  printf("  Ac0.Ac1 =  %.0lf/%-.0lf;  ",
            InnProd.numer,
            InnProd.denom);

         copycolF(&mA,0,&mu,0);
         copycolF(&mA,2,&mv,0);
    InnProd = innerprod(&mu,&mv);
  printf("  Ac0.Ac2 =  %.0lf/%-.0lf;  ",
            InnProd.numer,
            InnProd.denom);

         copycolF(&mA,1,&mu,0);
         copycolF(&mA,2,&mv,0);
    InnProd = innerprod(&mu,&mv);
  printf("  Ac1.Ac2 =  %.0lf/%-.0lf;  ",
            InnProd.numer,
            InnProd.denom);

 printf("\n\n\n Press Return to continue");
 getchar();

 return 0;
}








