/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction T(
pmatrix mA)
{
return(tracemF(mA));
}
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void AB(int n)
{
fraction c;
fraction TA;
fraction TB;
fraction TcA;
fraction cTA;
fraction T_AplsB;
fraction TAplsTB;

double pbA     [MXR][MXC*TWOCOL];matrix mA       ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pbB     [MXR][MXC*TWOCOL];matrix mB       ={MXR,MXC*TWOCOL,&pbB     [0][0]};
double pAplsB  [MXR][MXC*TWOCOL];matrix mAplsB   ={MXR,MXC*TWOCOL,&pAplsB  [0][0]};
double pbcA    [MXR][MXC*TWOCOL];matrix mcA      ={MXR,MXC*TWOCOL,&pbcA    [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mB.rows=n;                   mB.cols=n*TWOCOL;
                 mAplsB.rows=n;               mAplsB.cols=n*TWOCOL;
                    mcA.rows=n;                  mcA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  c = rndF (    9,1);
      rndmF(&mA,9,1);
      rndmF(&mB,9,1);

  clrscrn();
  printf(" a)         T : M%dx%d -> R, \n\n",n,n);
  printf("             T(A) = trace(A) \n\n");
  printf("        Is T(A) + T(B) = T(A + B) ?\n\n");
  printf("                                                       A :");
  printmI3(&mA);
  printf("                                                       B :");
  printmI3(&mB);
  printf("\n\n");
  getchar();

  clrscrn();
  TA = T(&mA);
  printf("\n T(A) = %.0lf\n", TA.numer);
  TB = T(&mB);
  printf("\n T(B) = %.0lf\n", TB.numer);
  TAplsTB = addF(TA,TB);
  printf("\n T(A) + T(B) = %.0lf\n", TAplsTB.numer);
  printf("\n\n");

  printf("                                                   A + B :");
  addmF(&mA,&mB,&mAplsB);
  printmI3(     &mAplsB);
  T_AplsB = T(&mAplsB);
  printf("\n T(A+B) = %.0lf\n", T_AplsB.numer);
  getchar();

  clrscrn();
  printf(" b)         T : M%dx%d -> R, \n\n",n,n);
  printf("             T(A) = trace(A) \n\n");
  printf("           Is T(cA) =  cT(A) ? \n\n");
  printf("                                                       A :");
  printmI3(&mA);
  printf("                                                c = %4.0f :",c.numer);
  getchar();

  clrscrn();
  printf("                                                       A :");
  printmI3(&mA);
  printf("                                                c = %4.0f :",c.numer);
  smultmF(c,&mA,&mcA);
  printf("                                                  %4.0fA :",c.numer);
  printmI3(&mcA);
  TcA = T(&mcA);
  printf("\n T(cA) = %.0lf\n", TcA.numer);
  printf("\n\n");
  TA = T(&mA);
  printf("\n   T(A) = %.0lf\n", TA.numer);
  cTA = multF(c,TA);
  printf("\n %.0lfT(A) = %.0lf\n",c.numer, cTA.numer);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n\n                                        \n");
  printf("            T : Mnxn -> R,                     \n\n ");
  printf("            T(A) = trace(A)                     \n\n");
  printf("         Is T a linear transformation?          \n\n");
  printf("             ****************                     \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 1){n=1;}


  AB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



