#include <vlib.h>


ULONG   paralaxtable[1024];
UBYTE text[64];

void main(void)
{
static WORD    groundspr, hillsspr, hill2spr, moonspr, manspr, shadowspr;
static ULONG   speed = 64, loop, hilloff = 0;

    // Allocate buffers and get screen
    AllocDoubleBuffer(640 * 400);
    AllocSpriteBuffer(1000000);

    FindBestVesaMode(640, 400, 8, TRUE);

    GameTimer();
    ChangeTimer(TIMER120HZ);
    // Load sprites and palette
    OpenSpritebank("scenery");

    LoadSpritebankPalette(colormap);
    SetPalette(colormap);

    groundspr = LoadSprite("grass");
    hillsspr = LoadSprite("hills");
    moonspr = LoadSprite("moon");
    hill2spr = CloneSprite(hillsspr);
    manspr = LoadSprite("runningman");
    shadowspr = LoadSprite("shadow");

    // Moon will stay in one place
    MoveSprite(moonspr, screen_width - spritedata[moonspr].xsize - 64, 75);

    // So will the ground
    MoveSprite(groundspr, 0, 199);
    // Set ground to paralax
    spritedata[groundspr].flags |= SPRFLAG_PARALAX;
    spritedata[groundspr].spritefps = 2 << 8;
    // Set up pointer to paralax table
    spritedata[groundspr].paralaxptr = (ULONG *)paralaxtable;

    // This sets up a paralax table.  Initial speed is 64 (above)
    // and each line moves 24/256ths faster (the speed value is
    // divided by 256 so you can move .5 pixels per frame with 128)
    for(loop = 0; loop < spritedata[groundspr].ysize; loop++) {
        paralaxtable[loop * 2] = 0;
        paralaxtable[loop * 2 + 1] = speed;
        speed += 24;
    }

    MoveSprite(manspr, 320, 230);
    MoveSprite(shadowspr, 320, 230);
    SetMainloopSpeed(30);
    InitFPS();

    while(1) {

        ScreenFill(0);
        DrawSprite(moonspr, SPR_NORMAL);
        MoveSprite(hillsspr, 0 - hilloff, 160);
        DrawBob(hillsspr, SPR_NORMAL);
        if(hilloff + screen_width > spritedata[hillsspr].xsize) {
            MoveSprite(hill2spr, 0 - hilloff + spritedata[hillsspr].xsize, 160);
            DrawBob(hill2spr, SPR_NORMAL);
        }

        DrawBob(groundspr, SPR_NORMAL);
        DrawSprite(shadowspr, SPR_NORMAL);
        DrawSprite(manspr, SPR_NORMAL);

        PaceMainloop();
        WaitVbl();
        DoubleBuffer();

        if((fps_frames % 8) == 0)
            hilloff++;
        if(hilloff > spritedata[hillsspr].xsize)
            hilloff = 0;

        if(GetKey())
            break;

    }
    SetVideoMode(TEXT80);
    ReportFPS();
    OldTimer();
    ChangeTimer(TIMER18HZ);
    FreeSpriteBuffer();
    FreeDoubleBuffer();
}