/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 32                        
                                                                            
 Demonstrates the use of wwarp - press q to end program execution.          
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 You must have the WGT1.BLK and WGT1.PAL files in your executable dir.      
                                                                            
ͼ
*/

#include <wgt45.h>
#include <conio.h>


void main(void)
{
int i, t, c, b;
color pal[256];
block wgt1;
int top[320];
int bot[320];
int oldmode;			/* Store previous video mode */

  printf ("WGT Example #32\n\n");
  printf ("A full-screen bitmap is warped into various shapes using WWARP.\n");
  printf ("Press a key to warp the object into a new shape. Press Q to end.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();	/* Gets the current mode */
  vga256 ();			/* Initialize graphics mode */

  wgt1 = wloadblock ("wgt1.blk");	/* Load our image to play with */
  wloadpalette ("wgt1.pal", pal);       /* Load its palette */
  wsetpalette (0, 255, pal);		/* Set the palette */

  wcls (0);				/* Clear screen with black */
  wclip (0, 0, 319, 199);   		/* Use full screen */

  /* Note: wsline merely stores y coordinates of line in array. You may use
	   several calls with various x ranges to make curved lines */

  wsline (0, 199, 319, 0, top);		/* Set array top for diagonal line */
  wsline (0, 199, 319, 199, bot);	/* Array bot is horizontal line */
  wwarp (0, 319, top, bot, wgt1, 0);	/* Warp image between lines */
  getch ();				/* Wait for key */
  // squish it

  wcls (0);				/* Clear screen */
  wsline (0, 100, 100, 0, top);		/* Now create arrow shape */
  wsline (101, 70, 218, 70, top);
  wsline (219, 0, 319, 100, top);

  wsline (0, 100, 100, 199, bot);
  wsline (101, 130, 218, 130, bot);
  wsline (219, 199, 319, 100, bot);
  wwarp (0, 319, top, bot, wgt1, 0);	/* Warp image using arrays */
  getch ();				/* Wait for keypress */
  // make a double arrow

  wcls (0);				/* Clear screen with black */
  do {
    b  =rand() % 100;
    c = (rand() % 100) + 100;
    for (t = 0; t <= 319; t++)
      {
       i = rand() % 2;
       if (i == 0)
	 b++;
       else b--;

       i = rand() % 2;
       if (i == 0)
	 c++;
       else c--;

      if (b > 100)
	b = 100;

      if (b < 0)
	b = 0;
      if (c > 197)
	c = 197;
      if (c < 100)
	c = 100;

      top[t] = b;			/* Create random wavy lines */
      bot[t] = c;
     }
    wwarp (0, 319, top, bot, wgt1, 0);	/* And warp image between them */
    i = getch ();			/* Wait for keypress */
    wcls (0);				/* Clear screen with black */
   } while (i !='q');			/* End program if Q pressed */

  wfreeblock (wgt1);			/* Free memory from image */
  wsetmode (oldmode);			/* Restore initial video mode */
}
