/*
==============================================================================
		      WordUp Graphics Toolkit Version 5.0                     
			     Demonstration Program 22                         
									      
 This is a small program 'template' to help you get started with the sprite  
 library.                                                                    
									      
 *** PROJECT ***                                                             
 This program requires the files WSPR_WC.LIB and WGT5_WC.LIB to be linked.   
									      
 *** DATA FILES ***                                                          
 Make sure that INVADER.SPR is in your executable directory.                 
							   WATCOM C++ VERSION 
==============================================================================
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <malloc.h>
#include <wgt5.h>
#include <wgtspr.h>

color palette[256];             
block sprites[20];
int quit;                               /* if quit !=0, program quits */
int oldmode;

void looper (void);                      /* a routine which controls the sprites */

void main (void)
{
  if ( !vgadetected () )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #22\n\n");
  printf ("Sprite movement and animation is demonstrated in this short demo.\n");
  printf ("Press any key to end the program. Try inserting a delay to slow down the\n");
  printf ("animation.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  oldmode = wgetmode();
  vga256 ();
  wloadsprites (palette, "invader.spr", sprites, 0, 19);
  /* load first 50 sprites */
  wsetpalette (0, 255, palette);

  initialize_sprites (sprites);                  /* initialize them */
  maxsprite = 2;                                 /* number of sprites on */

/* Spriteon has the following format:
   Sprite number, x coord, y coord, sprite number in array of sprites
   Therefore sprite #1 would be displayed at 160,100 with sprite 1 in the array */

  spriteon (0, 160, 100, 1);                        /* turn on any sprites */
  spriteon (1, 10, 100, 3);                         /* you need */

/* This move will go left 1, for 300 times, and right 1 for 300 times,
   and repeat */

  movex (1, "(1,300,0)(-1,300,0)R");              /* set up any movement */
  movexon (1);                                   /* or animation needed */


/* This animation will animate sprite 2 through a sequence of sprites
   in the sprite array and keep repeating. */

  animate (1, "(3,50)(4,50)(5,50)(4,50)R");
  animon (1);

  minit ();

  do {
    looper ();
  } while (!quit);
  getch ();

  mdeinit ();                   /* Deinitialize the mouse handler */
  
  spriteoff (0);                 /* turn off sprites */
  spriteoff (1);
  /* To be safe, turn off all sprites before ending program.
     This will free any memory used from them. */

  deinitialize_sprites ();
  wfreesprites (sprites, 0, 19);      /* free memory */

  wsetmode (oldmode);
}


void looper(void)
{
  erase_sprites ();     /* clear the sprites */

  s[0].x = mouse.mx;    /* any direct sprite movements must be placed */
  s[0].y = mouse.my;    /* between erasespr and drawspr */
		/* This will set sprite one's coordinate to the mouse
		   coordinates. Move it around! */
		/* notice how sprite #2 moves and animates on its own now!
		   You don't need to change anything to make it move! */

  wretrace ();
  draw_sprites (1);                    /* draw them back on */
  if (kbhit ()) 
    quit = 1;
}
