/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 39                         
                                                                              
 Demonstrates the wfastputpixel routine.                                     
 Move the mouse around to create pixel trails.                               
                                                                              
 *** PROJECT ***                                                             
 This program requires the WGT5_WC.LIB file to be linked.                    
                                                                              
 *** DATA FILES ***                                                          
 DEFAULT.PAL must be in your executable directory.                              
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <stdio.h>
#include <conio.h>
#include <wgt5.h>


#define NUMPIX 1000

short x, y, i, j;
short px[NUMPIX+1], py[NUMPIX+1];
color pal[256];

void main(void)
{
  
  printf ("WGT Example #39\n\n");
  printf ("Pixel trails are created by memorizing mouse positions.\n");
  printf ("Click the RIGHT mouse button to end the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  vga256 ();
  wloadpalette ("default.pal", pal);
  wsetpalette (0, 255, pal);

  minit ();
  for (i = 0; i <= NUMPIX; i++)
  {
    px[i] = 0;
    py[i] = 0;
  }

  do {
    wsetcolor (0);
    wretrace ();
    for (i = NUMPIX; i >= 1; i--)
    {
      px[i] = px[i - 1];
      py[i] = py[i - 1];
    }
    wsetcolor (0);
    wfastputpixel (px[NUMPIX], py[NUMPIX]);
    wfastputpixel (319 - px[NUMPIX], 199 - py[NUMPIX]);


    wsetcolor (0);
    wfastputpixel (px[0], py[0]);
    wfastputpixel (319 - px[0], 199 - py[0]);

    px[0] = mouse.mx;
    py[0] = mouse.my;

    for (i = 0; i < NUMPIX; i++)
    {
      wsetcolor (i);
      wfastputpixel (px[i], py[i]);
      wfastputpixel (319 - px[i], 199 - py[i]);
    }
  } while (mouse.but != 2);
  mdeinit ();
  wsetmode (3);
}

