#ifndef _WGTSCROL_
#define _WGTSCROL_

#include <wgt5.h>

/*
   WordUp Graphics Toolkit V5.0  Multidirectional Scrolling Library
   Copyright 1995 Egerter Software
*/

#ifdef __cplusplus
extern "C" {
#endif

#define NORMAL 0
#define PARALLAX 1
#define MAXWINDOWS 50

extern block scrollblock[MAXWINDOWS];
extern short windowminx[MAXWINDOWS];
extern short windowminy[MAXWINDOWS];
extern short windowmaxx[MAXWINDOWS];
extern short windowmaxy[MAXWINDOWS];
extern short worldx[MAXWINDOWS];
extern short worldy[MAXWINDOWS];
extern short worldmaxx[MAXWINDOWS];
extern short worldmaxy[MAXWINDOWS];
extern short mapwidth[MAXWINDOWS];
extern short mapheight[MAXWINDOWS];
extern short tilewidth[MAXWINDOWS];
extern short tileheight[MAXWINDOWS];
extern short windowwidth[MAXWINDOWS];
extern short windowheight[MAXWINDOWS];    /* Size of window (in tiles) */

typedef struct {
        char on;
        short x;
        short y;
        unsigned short num;
        } scrollsprite;

short    is_in_window (short currentwindow, short x, short y, short range);
short    soverlap (short s1, scrollsprite *wobjects1, block *sprites1,
                   short s2, scrollsprite *wobjects2, block *sprites2);
void     wcopymap (short sourcewindow, short destwindow);
void     wendscroll (short currentwindow);
void     wfreemap (wgtmap mapname);
unsigned short wgetworldblock (short currentwindow, short posx, short posy);
unsigned char wgetworldpixel (short currentwindow, short x, short y);
void     winitscroll (short currentwindow, short mode, short link,
                      short windowwidth, short windowheight, block *tileref);
wgtmap   wloadmap (short currentwindow, char *filename, short *tiletypes,
                   scrollsprite *wobjects);
void     wputworldblock (short currentwindow, short posx, short posy,
                         unsigned short tilenum);
void     wsavemap (short currentwindow, char *filename, wgtmap savemap,
                   short *tiletypes, scrollsprite *wobjects, short numobj);
short    wscreen_coordx (short currentwindow, short xcoord);
short    wscreen_coordy (short currentwindow, short ycoord);
void     wscrollwindow (short currentwindow, short windowspeedx,
                        short windowspeedy);
void     wshowobjects (short currentwindow, short start, short end,
                       block *image_array, scrollsprite *wobjects);
void     wshowwindow (short currentwindow, short posx, short posy);
void     set_transparent_tile (unsigned char tile);

#ifdef __cplusplus
}
#endif

#endif
