#ifndef _WGTVESA_
#define _WGTVESA_

#include <wgt5.h>

#ifdef __cplusplus
 extern "C" {
#endif


/*
                            WGT VESA Include File                       
  */


#define VIDEO          0x10             /* Video interrupt is #16 */

#define V640x350       0x11c            /* Mode     is 640x350x256 */
#define V640x400       0x100            /* Mode 256 is 640x400x256 */
#define V640x480       0x101            /* Mode 257 is 640x480x256 */
#define V800x600       0x103            /* Mode 259 is 800x600x256 */
#define V1024x768      0x105            /* Mode 261 is 1024x768x256 */
#define V1280x1024     0x107            /* Mode 263 is 1280x1024x256 */
#define V1600x1200     0x124            /* Mode     is 1600x1200x256 */

/***************************************************************************
 The following structure is the VESA information structure returned by the
 VESA-detection interrupt. If a driver is detected, this structure is filled
 with information regarding the system.
***************************************************************************/

typedef struct {
  char  VESASignature[4];  /* Should be "VESA" */
  short VESAVersion;       /* Version # of driver */
  char  *OEMStringPtr;     /* Pointer to video card info string */
  long  Capabilities;      /* Bit field of video capabilities */
  short *VideoModePtr;     /* Pointer to list of supported modes */
  short TotalMemory;       /* Number of 64k banks on card */
  
  /* VBE 2.0 extension information */

  short   OemSoftwareRev;       /* OEM Software revision number         */
  char    *OemVendorNamePtr;    /* Pointer to Vendor Name string        */
  char    *OemProductNamePtr;   /* Pointer to Product Name string       */
  char    *OemProductRevPtr;    /* Pointer to Product Revision str      */
  char    reserved[222];        /* Pad to 256 byte block size           */
  char    OemDATA[256];         /* Scratch pad for OEM data             */
} VGAInfoBlock;


/***************************************************************************
 The following structure is an information structure returned by the
 Return SVGA Mode Info interrupt. If the requested mode is supported, its
 specifications are placed into this structure.
***************************************************************************/

typedef struct {
  unsigned short ModeAttributes;        /* Bit field */
  unsigned char  WinAAttributes;        /* Bit field */
  unsigned char  WinBAttributes;        /* Bit field */
  unsigned short WinGranularity;        /* Kb boundary on which window can
					   be placed in video memory */
  unsigned short WinSize;               /* Size of window in Kb */
  unsigned short WinASegment;           /* Segment address of window */
  unsigned short WinBSegment;           /* Segment address of window */
  unsigned int   WindFuncPtr;           /* Pointer to CPU windowing 
					   function*/
  unsigned short BytesPerScanLine;      /* Number of bytes in one scan
					   line */
  /* Optional information */
  /* Following information is set by some cards, but not all. */
  unsigned short XResolution;           /* Width of video mode in pixels */
  unsigned short YResolution;           /* Height of video mode in pixels */
  unsigned char  XCharSize;             /* Size of character cell in pixels */
  unsigned char  YCharSize;             /* Same */
  unsigned char  NumberOfPlanes;        /* # of planes in this mode */
  unsigned char  BitsPerPixel;          /* # of bits defining a pixel */
  unsigned char  NumberOfBanks;         /* # of banks in which scan lines are 
					   grouped (1 if VGA modes 0Dh-13h) */
  unsigned char  MemoryModel;           /* Memory organization used */
  unsigned char  BankSize;              /* Size of bank in Kb */
  unsigned char  filler[512-29];        /* Structure must be 512 bytes */
} ModeInfoBlock;

extern VGAInfoBlock    VGA;              /* VESA structure is declared as global */
extern ModeInfoBlock   VESAmode;         /* Same with the mode info structure */
extern int             VESAbanksize;     /* Size of one video bank in kbytes */

/*
                            Function Protocols                          
  */
short  wvesa_bank (short bank);         // Switch to a given bank in video memory
short  wvesa_detected (void);           // Returns 1 if SVGA support is detected
short  wvesa_getmodeinfo (short mode);  // Fills mode info structure for given mode
short  wvesa_init (short mode);         // Initializes SVGA graphics mode
void   wvesa_setlogical (unsigned short startline);
void   wvesa_setphysical (unsigned short left, unsigned short startline);
short  wvesa_setwidth (unsigned short width);
short  wvesa_supported (short mode);    // Returns 1 if requested mode is supported


/* Supported primitives and graphics functions - 256 color modes ONLY! */

void  wvesa_clip (short x, short y, short x2, short y2);
void  wvesa_cls (short color);
void  wvesa_putpixel (short x, short y);
int   wvesa_getpixel (short x, short y);
void  wvesa_line (short x, short y, short x2, short y2);
void  wvesa_hline (short x, short y, short x2);
void  wvesa_bar (short x, short y, short x2, short y2);
void  wvesa_rectangle (short x, short y, short x2, short y2);
void  wvesa_copyscreen (short sx, short sy, short sx2, short sy2, block src,
			short dx, short dy, short method);
block wvesa_newblock (short sx, short sy, short sx2, short sy2);
void  wvesa_putblock (short dx, short dy, block src, short method);
void  wvesa_outtextxy (short x, short y, wgtfont fnt, char *printit);
short wvesa_outchar (short asc, short xc, short yc, wgtfont pr);
void  wvesa_xorline (short x, short x2, short y);

#ifdef __cplusplus
 }
#endif

#endif
