/***************************************************************************
*   xmstest.h                                                              *
*   HEADER FOR tester for XMSIF                                            *
*   OS:      DOS                                                           *
*   VERSION: 1.0                                                           *
*   DATE:    12/08/91                                                      *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
*   Compiles under Borland C++ 2.0, TC 2.0, and MSC 6.00A.                 *
*                                                                          *
*   Header file for XMSTEST.                                               *
*                                                                          *
***************************************************************************/

#ifndef XMSIF_H
    **** ERROR **** MUST INCLUDE XMSIF.H BEFORE XMSTEST.H
#endif

#ifndef XMSTEST_H
#define XMSTEST_H

/*
** system includes <>
*/

/* include appropriate file according to compiler */
#ifdef __TURBOC__

#include <alloc.h>

#else

#include <malloc.h>

#endif


/*
** custom includes ""
*/

/*
** local #defines
*/

/* header and trailer messages for each test */
#define TESTHEADER()     printf(">>>TEST #%d: %s\n", testno++, gblmsg)
#define TESTTAILER()     printf("Test passed.\n")

/* minimum amount of extended memory free */
#define MINFREE          81920L

/*
** This macro is for return checking for functions which are expected
** to succeed. It makes function calls to check if
**      1) the function returned XMMOOPS
**      2) the function returned a value that isn't XMMOOPS or 0
**      3) the function set _XMMerror to an unexpected value
** The parameters are:
**      fu  - char *, name of the function
**      st  - status value returned by the function
**      ex  - expected value of _XMMerror
**      fr1 - conventional memory pointer to be freed on emergency exit
**      fr2 - XMS handle to be freed on emergency exit
**      fr3 - another XMS handle to be freed on emergency exit
*/
#define TRIPLECHECK(fu, st, ex, fr1, fr2, fr3) \
                         failcheck((fu), (st), (fr1), (fr2), (fr3)); \
                         weirdretchk((fu), (st), (fr1), (fr2), (fr3)); \
                         weirdcodechk((fu), (ex), (fr1), (fr2), (fr3))

/*
** Define LMALLOC() and LFREE() to the appropriate functions, according to
** compiler.
*/
#ifdef __TURBOC__

#define LMALLOC(kbytes)         farmalloc((((unsigned long) kbytes) * 1024L))
#define LFREE(ptr)              farfree((ptr))

#else

#define LMALLOC(kbytes)         halloc((kbytes), 1024)
#define LFREE(ptr)              hfree((ptr))

#endif

/*
** assorted defines for the copy tests
*/

#define UCF                      unsigned char far

#define HALFLEN                  ((unsigned int) (MINFREE / 2L))

#define GUARDVAL                 0x55

/*
** Checks to see if a region of memory is still incrementing word values,
** handles cleanup and exit if not.
*/
#define WORDCHECK(buf, len, msg)                                \
    if (lfarincwordcheck((UCF *) (buf), (len), 0) != 0) {       \
        printf("Copy corrupted %s.\n", (msg)); XMMfree(handle); \
        LFREE(realbuf); exit(3); }

/*
** Check source and destination buffers, respectively.
*/
#define SRCWORDCHECK(buf, len)    WORDCHECK(buf, len, "source buffer")
#define CPYWORDCHECK(buf, len)    WORDCHECK(buf, len, "copied bytes")

/*
** Checks to see if a region of memory is still filled with a given value,
** handles cleanup and exit if not.
*/
#define MEMCHECK(buf, len, val)                           \
    if (lfarmemcheck((UCF *) (buf), (len), (val)) != 0) { \
        printf("Copy corrupted destination.\n");          \
        XMMfree(handle); LFREE(realbuf); exit(3); }

/*
** Checks buffer for nonzero values.
*/
#define ZEROCHECK(buf, len)       MEMCHECK(buf, len, '\0')

/*
** Compares two regions of memory, handles cleanup and exit if not the same.
*/
#define MEMCMP(buf1, buf2, len)                                           \
    if (LFMEMCMP((void far *) (buf1), (void far *) (buf2), (len)) != 0) { \
        printf("Copy corrupted copied bytes.\n"); XMMfree(handle);        \
        LFREE(realbuf); exit(3); }

/*
** Checks guard zones to see if values changed
*/
#define GUARDCHECK(han)                                 \
    if ((farmemcheck(guard1, 1024, GUARDVAL) != 0) ||   \
        (farmemcheck(guard2, 1024, GUARDVAL) != 0) ||   \
        (farmemcheck(guard3, 1024, GUARDVAL) != 0)) {   \
            printf("Copy corrupted guard buffers.\n");  \
            XMMfree((han)); LFREE(realbuf); exit(3); }


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

/*
** global variables
*/

/*
** static globals
*/

/*
** function prototypes
*/

extern int  do_alloc_tests(unsigned long bytes);
extern void do_rawcall_tests(void);
extern void do_copy_tests(void);
extern void do_ncopy1_tests(void);
extern void do_icopy_tests(void);
extern void do_UMB_tests(void);

extern unsigned long test_XMMcoreleft(void);
extern unsigned long test_XMMallcoreleft(void);
extern int test_XMMalloc(unsigned long bytes);
extern int test_XMMrealloc(int handle, unsigned long bytes);
extern void test_XMMfree(int handle);

extern void weirdretchk(char *function, int status, void far *tofree1,
                                                     int tofree2, int tofree3);
extern void weirdcodechk(char *function, int expected, void far *tofree1,
                                                     int tofree2, int tofree3);
extern void failcheck(char *function, int status, void far *tofree1,
                                                     int tofree2, int tofree3);
extern void nofailcheck(char *function, int status, void far *tofree1,
                                                     int tofree2, int tofree3);

#endif

