ECHO OFF Create DECUSC Cross Referencer using Computer Innovations C Compiler
REM 
REM param 1 = path for CIC "stdio.h" file.
REM param 2 = path for CIC "c86s2s.lib" file (small model only).
REM 
REM To use, ARCH -m xrf | ARCH -rx xrf
REM         LCMP \cic\h\ \CIC\LIB\
REM 

IF EXIST %1STDIO.H GOTO CHK1
ECHO stdio.h path wrong <%1stdio.h>
GOTO ABT

CHK1:
IF EXIST %2C86S2S.LIB GOTO CMP
ECHO library path wrong <%2c86s2s.lib>
GOTO ABT

REM                                      ***do compilations***
CMP:
ECHO Compiling XRF0 ....
cc1 -i xrf0 -h%1
cc2 xrf0
cc3 xrf0
cc4 xrf0
IF ERRORLEVEL 1 GOTO ABT

ECHO Compiling XRF1 ....
cc1 -i xrf1 -h%1
cc2 xrf1
cc3 xrf1
cc4 xrf1
IF ERRORLEVEL 1 GOTO ABT

ECHO Compiling XRF2 ....
cc1 -i xrf2 -h%1
cc2 xrf2
cc3 xrf2 
cc4 xrf2
IF ERRORLEVEL 1 GOTO ABT

ECHO Compiling XRF3 ....
cc1 -i xrf3 -h%1
cc2 xrf3
cc3 xrf3
cc4 xrf3
IF ERRORLEVEL 1 GOTO ABT

ECHO Compiling XRFD ....
cc1 -i xrfd -h%1
cc2 xrfd
cc3 xrfd
cc4 xrfd
IF ERRORLEVEL 1 GOTO ABT

ECHO Compiling XRFR ....
cc1 -i xrfr -h%1
cc2 xrfr
cc3 xrfr
cc4 xrfr
IF ERRORLEVEL 1 GOTO ABT

ECHO Compiling SPOOL ...
cc1 -i spool -h%1
cc2 spool
cc3 spool
cc4 spool
IF ERRORLEVEL 1 GOTO ABT

DEL XRF?.C
DEL SPOOL.C
DEF XRF.H

REM                                      ***do link***
ECHO linking XRF .......
LINK XRF0+XRF1+XRF2+XRF3+XRFD+XRFR+SPOOL,XRF,,\CIC\LIB\C86S2S
IF ERRORLEVEL 1 GOTO ABT

DEL XRF?.OBJ
DEL SPOOL.OBJ
GOTO FINI

REM                                      ***ERROR TRAP***
ABT:
ECHO Compile of XRF failed.

REM                                      ***The End***
FINI:
ECHO ON
