/*
 *                      ***************
 *                      * X R F R . C *
 *                      ***************
 *
 * Do initialization things & special Rainbow code (was XRFI.C).
 *
 * Version V1.4                  1-Jul-80
 * Version V1.5                  3-Jul-80  Conditionaled date/time stuff.
 * Version V1.6 MM		 9-Jul-80  Changed date/time stuff
 * Version V1.7 MM		10-Jul-80  File name changes
 * Version V1.8 MM		21-Jul-80  Ctime() changed
 * Version V1.9 MM		22-Jul-80  Redid initialization
 * Version V1.11 RBD		26-Dec-80  Cleanup rt11 usage message
 * Version V1.12 MM		22-Dec-81  Rtime isn't in vax library
 * Version V1.13 MM		16-Feb-82  ctime fixup
 * Version V1.14 MC		29-Dec-84  tailor for DEC Rainbow
 *                               4-Jan-84  add spooler to PRINT Queue if
 *                                         installed.
 *				 8-Jan-85  Add date/time plus return name
 */

#include <stdio.h>
#include "xrf.h"

/*****************************************************************/
/*                  RAINBOW/MSDOS TAILORING                      */
/*****************************************************************/
static char ff_omode[2] = " ";
static int  ff_search_code = 0x4e00;
static unsigned char ff_fb[13] = "";	/*search name*/
static unsigned char ff_fw[13] = "";	/*def work file name*/
static unsigned char ff_fa[13] = "";	/*act work file name*/
static struct ff_str { 
  char dummy[21];		/* reserved for dos */ 
  unsigned char attribute;	/* returned attribute */ 
  unsigned time; 
  unsigned date; 
  long size;			/* size of file */ 
  unsigned char fn[13];		/* string containing the filename */ 
} ff_area; 


/*****************************************************************/
/*        Give user help on program useage.                      */
/*****************************************************************/

useage()
   {
   printf("Usage: xrf [-options] [-o outfile] infile[s]\n\n");
   printf("       -s  Spool output file to PRINT queue\n");
   printf("       -n  Narrow (80 column) output else wide (132)\n");
   printf("       -i  Expanded Symbols (31), else 8 chars.\n");
   printf("       -p  Print C source (with linenumbers) as well.\n");
   printf("       -c  Concatanate input files(s)\n");
   printf("       -o  Output to \"outfile\"\n\n");
   printf("Input files may have wild-card names\n");
   printf("Default input filetype is \".c\"\n");
   printf("Default output filename is \"<first_input_file>.REF\"\n\n");
   printf("E.G. XRF -NIC -O XRF XRF* SPOOL will do a combined\n");
   printf("     crossreference of XRF?????.C and SPOOL.C as XRF.REF\n\n");
   abort("?XRF-E-parameter error");
   }


/*****************************************************************/
/*       Initialise input file system                            */
/*****************************************************************/

initinfile(in)
char *in;

{ FILE *ffirst();
  int i;
  unsigned char *cs=ff_area.fn, *cd=ff_fw, *concat();
  if((src = ffirst(concat(ff_fb,in,".c",0), "r")) == NULL)
     abort("Cannot open %s\n", ff_fb);
  for(;*cs!='.';*cd++=*cs++);			/*save name for output*/
  *cd='\0';
}

/*****************************************************************/
/*       Initialise output file system                           */
/*****************************************************************/

initoutfile(out)
char	*out;
   {
   unsigned char *concat();
   FILE *fopen();
   if (out == NULL)out=ff_fw;
   if((lst = fopen(concat(ff_fa,out,".ref",0), "w")) == NULL)
      abort("Cannot open output reference file %s\n", ff_fa);
   }

/*****************************************************************/
/*       set next input file to be processed                     */
/* open file & initialize page header strings                    */
/*****************************************************************/


nextinfile()
{
   FILE 	*ffnext();
   unsigned char *cp=ff_area.fn,*concat();
   unsigned char datetemp[23], timetemp[9];
   int i;
   if ((src=ffnext(src)) == NULL)
      return(0);
   for(i=0;*cp!='.'&&i<8;progname[i++]=*cp++); /* set curr name */
   while(i<8)progname[i++]=' ';
   progname[i]='\0';
   if(verbose)printf("Processing %s ...\n",progname);
   concat(pghead, "\fXRF Source Listing of: ",
 		ff_area.fn,"\t",thedate," ",thetime,"\tPage ", 0);

   ff_search_code=0x4f00;			/*search next*/
   return(1);
}

/*****************************************************************/
/*          RAINBOW/MSDOS support routines                       */
/*****************************************************************/

FILE *ffirst(filename,mode)
unsigned char *filename;
unsigned char *mode;
{ struct {int ax,bx,cx,dx,si,di,ds,es;}srv;
  FILE *fopen();
  segread(&srv.si);			/* get ds value */
  srv.ax=ff_search_code=0x4e00;		/* search first*/
  srv.cx=0;				/* set search modes */
  srv.dx=filename;
  bdos(0x1a,&ff_area);			/* set the transfer address */
  strcpy(ff_omode,mode);
  if(!(sysint21(&srv,&srv)&1))return fopen(ff_area.fn,mode);
  return NULL;
} 

FILE *ffnext(iop)
FILE *iop;
{ int i;
  struct {int ax,bx,cx,dx,si,di,ds,es;}srv;
  FILE *freopen();
  segread(&srv.si);		/* get ds value */
  srv.ax=ff_search_code;
  srv.cx=0;			/* set search modes */
  srv.dx=ff_fb;
  bdos(0x1a,&ff_area);		/* set the transfer address */
  if(!(sysint21(&srv,&srv)&1))return freopen(ff_area.fn,ff_omode,iop);
  return NULL;
} 

fspool(iop)			/*trigger off spool print of output file*/
FILE *iop;
{ fclose(iop);				/*ensure file shut */
  if(spool(ff_fa))printf("ERR - Can't spool print %s\n",ff_fa);
   else printf("%s queued for printing...\n",ff_fa);
}

delete(filename)
char *filename;
{ return unlink(filename);}

/* get system date & time */
static char *dayofweek[] = { "Sunday","Monday","Tuesday","Wednesday",
                            "Thursday","Friday","Saturday" };
static char *monthname[] = { "Jan","Feb","Mar","Apr","May","Jun","Jul",
                            "Aug","Sep","Oct","Nov","Dec" };
date(d)			/* return date into d[23] */
char *d;
{ struct {int ax,bx,cx,dx,si,di,ds,es;}srv;
  srv.ax=0x2A00;
  sysint21(&srv,&srv);
  sprintf(d,"%s, %2d %s %04d",dayofweek[srv.ax&0xFF],srv.dx&0xFF,
                              monthname[srv.dx>>8],srv.cx);
}

time(t)		        /* return time into t[9] */
char *t;
{ struct {int ax,bx,cx,dx,si,di,ds,es;}srv;
  srv.ax=0x2C00;
  sysint21(&srv,&srv);
  sprintf(t,"%02d:%02d:%02d",srv.cx>>8,srv.cx&0xFF,srv.dx>>8);
}

/* concatanate 'n' strings to new output string*/
/* concat(out,ip1,ip2...ipn,0); !last parameter MUST be 0! */
/* returns pointer to output string*/

unsigned char *concat(op,ip)
unsigned char *op;
int *ip;
{ unsigned char *r=op,*cp,**cpp=&ip;

  *op='\0';
  while(*cpp){
	strcat(op,(cp=*cpp++));
	op+=strlen(cp);
	}
  return r;
}
