{
ͻ
Name    : Generic Numeric Control Post Procesor  Version  : 2.0            
Company : BillaSoft (c)1990-97;                  Writed by: Ing. Micsa Dan 
Adrress : Str.:Ghe.Doja 40 1900 TIMISOARA        Tel/Fax  : 04-056-117985  
Compiler: BorlandPascal v7.0                     Date     : 04.10.93       
ͼ
ͻ
uGNCPP -unit Generic Numeric Control Post Procesor                         
- all procedure and function starts with gnc prefix;                       
- all putting procedure starts with gncP*;                                 
- all getting function  starts with gncG*;                                 
                                                                           
- Exist four  groups of functions:                                         
  - Init & Done & Cfg (Init & Done + Version);                             
  - Putting moves (Putting methods);                                       
  - Modify & read status of each variable;                                 
  - some macro function that modify an entirely group of vars(accelerators)
ͼ
}
unit uGNCPP;

interface

 procedure gncPAboutMe(AppName:string);

{versions}
 function  gncGVer:string;
 function  gncGAcc:byte;

{Init & Done}
 procedure gncInit(App,Srf,Tool,ProcBy,OutName:string);
 procedure gncReadCFG(Cfg:string);
 procedure gncGReg;
 procedure gncDone;

{Putting methods}
 procedure gncPGeneral(F,G,S:Integer;A,B,C,I,J,K,X,Y,Z,U,V,W:double;Comment:string);
 procedure gncPSmart  (G:integer;X,Y,Z:double;bForce:boolean);
 procedure gncPNewSeq (X,Y,Z:double;bForce:boolean);
 procedure gncPOpt    (G:integer;X,Y,Z:double);{Auto init new seq very smart !!}

 procedure gncPReport (St:string); {Write a coment in report}

{Some accelerators}
 procedure gncPOutputDetailed;    {Set output detailed }
 procedure gncPOutputOptimal;     {Set output optimal  }
 procedure gncPEnableTechNC;      {Enable  tech comment in NC file  }
 procedure gncPDisableTechNC;     {Disable tech comment in NC file }
 procedure gncPEnableTechPartial; {Enable  tech comment in Partial rep. file }
 procedure gncPDisableTechPartial;{Disable tech comment in Partial rep. file }
 procedure gncPEnableTechOverall; {Enable  tech comment in Overall rep. file }
 procedure gncPDisableTechOverall;{Disable tech comment in Overall rep. file }

{return registers}
 function gncGF:integer;
 function gncGG:integer;
 function gncGS:integer;
 function gncGA:double ;
 function gncGB:double ;
 function gncGC:double ;
 function gncGI:double ;
 function gncGJ:double ;
 function gncGK:double ;
 function gncGX:double ;
 function gncGY:double ;
 function gncGZ:double ;
 function gncGU:double ;
 function gncGV:double ;
 function gncGW:double ;

{String settings}
 function gncGApp      :string;
 function gncGCfg      :string;
 function gncGSrf      :string;
 function gncGTool     :string;
 function gncGProcBy   :string;
 function gncGUserName :string;
 function gncGUserComp :string;
 function gncGSerialNr :string;
 function gncGOutName  :string;

{Technological Info LTC}
 function gncGSL :double ;
 function gncGWL :double ;
 function gncGTL :double ;
 function gncGST :double ;
 function gncGWT :double ;
 function gncGTT :double ;
 function gncGSC :double ;
 function gncGWC :double ;
 function gncGTC :double ;
 function gncGDSL:double ;
 function gncGDWL:double ;
 function gncGDTL:double ;
 function gncGDST:double ;
 function gncGDWT:double ;
 function gncGDTT:double ;
 function gncGDSC:double ;
 function gncGDWC:double ;
 function gncGDTC:double ;

{CNC.Output files}
 function gncGCNCOut      :Char   ;{    Y    ;C[Y_       ]<   Y> Process CNCFile else not}
 function gncGDXFOut      :Char   ;{    N    ;C[Y_       ]<   N> Process DXFFile else not}
 function gncGRepOut      :Char   ;{    Y    ;C[Y_       ]<   Y> Process ReportFile else not}
 function gncGNameDigitNr :Integer;{    3    ;I[0..5     ]<   3> Nr. of digits in CNC Name}
 function gncGLongName    :Char   ;{    Y    ;C[Y_       ]<   Y> If N cut in name CNC type inf.}
 function gncGExtension   :String ;{    CNC  ;S[Y_       ]< CNC> Name of extension of  CNCFile}

{CNC.Constraints}
 function gncGOptFilter   :Real   ;{    0.300;R[0.01..0.5]< 0.2> Value of optimizing filter}
 function gncGBreakKilo   :Char   ;{    Y    ;C[Y_       ]<   Y> Break CNCFile after MaxKilo or MaxLine}
 function gncGMaxKilo     :Real   ;{   32.000;R[1..1000  ]<  32> Number of Kilos in each CNC file}
 function gncGMaxLine     :Integer;{  990    ;I[10..10000]< 990> Number of Lines in each CNC file}
 function gncGOutValue    :Real   ;{    2.000;R[0..1000  ]<   2> OutValue of z in case of break CNCFile}
 function gncGAutoBreak   :Real   ;{    5.000;R[0..10    ]<  10> Break value in CNC file < OutValue}
 function gncGCondensedOut:Char   ;{    Y    ;C[Y_       ]<   Y> Y purge trivial data in CNC File}
 function gncGIndentedOut :Char   ;{    N    ;C[Y_       ]<   N> Y indent for good visibility}
 function gncGEnable2Half :Char   ;{    Y    ;C[Y_       ]<   Y> Enable 2.5 axis generation}
 function gncGFrontal     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable frontal milling}
 function gncGRelative    :Char   ;{    N    ;C[Y_       ]<   N> Enable relative coordinate}
 function gncGDecimalNr   :Integer;{    2    ;I[0..4     ]<   2> Nr. of decimals in CNC File}
 function gncGG2G3        :Char   ;{    Y    ;C[Y_       ]<   Y> Enable arc interpolation}
 function gncGG2G3Radius  :Real   ;{    2    ;R[-1e3..1e3]<   2> If G2G3=N then value to discreet arc}
 function gncGG2G3FullOut :Char   ;{    Y    ;C[Y_       ]<   Y> Enable full output for G2&G3}
 function gncGG171819Info :Char   ;{    N    ;C[Y_       ]<   Y> Enable output of plane for G2&G3}

 function gncGG0AutoPurge :Char   ;{    Y    ;C[Y_       ]<   Y> Smart purge G0 in CNC File !}
 function gncGG0AutoPut   :Char   ;{    Y    ;C[Y_       ]<   Y> Smart found optimal G0 Z high}
 function gncGG0ZCote     :Real   ;{  300.000;R[-1e9..1e9]< 300> if AutoPutG0<>Y then if G0 Z:=G0ZCote}
 function gncGG0Switch    :Real   ;{   10.000;R[-100..100]<  10> if DistCNC<G0Swich then G1 else G0}

 function gncGSHourCost   :Real   ;{    5.000;R[0.. 1e100]<   5> Cost of one hour of processing in speed}
 function gncGWHourCost   :Real   ;{   10.000;R[0.. 1e100]<  10> Cost of one hour of processing in work}

 function gncGMoneySign   :String ;{    $    ;S[ASCII    ]<   $> Sign for national money $,DM...}

 function gncGRepTechCfg  :Char   ;{    Y    ;C[Y_       ]<   Y> Copy cfg file in generated report}
 function gncGRepProtect  :Char   ;{    Y    ;C[Y_       ]<   Y> Lock and protect report file for modify}

{CNC.F&SValue}
 function gncGFAdress     :Real   ;{  100.000;R[1..10000 ]< 100> Normal advance [mm/min]}
 function gncGSAdress     :Real   ;{  100.000;R[1..10000 ]< 100> Rotation speed}
 function gncGFastAdvance :Real   ;{ 1000.000;R[1..10000 ]<1000> Fast advance   [mm/min]}

{CNC.Info}
 function gncGMotor       :Char   ;{    Y    ;C[Y_       ]<   Y> Motor  On}
 function gncGLiquid      :Char   ;{    Y    ;C[Y_       ]<   Y> Liquid On}
 function gncGAbsRel      :Char   ;{    Y    ;C[Y_       ]<   Y> Write inf. about Absolute or Relative}
 function gncGLineComment :Char   ;{    Y    ;C[Y_       ]<   Y> Y enable line comment}
 function gncGTechComment :Char   ;{    Y    ;C[Y_       ]<   Y> Y enable technological comment}

{CNC.Transform3D}
 function gncGEnableTR3D  :Char   ;{    Y    ;C[Y_       ]<   Y> Enable 2D transformations}
 function gncGXID         :Real   ;{    0.000;R[-1e3..1e3]<   0> X,I,A,U Displacement in CNC File}
 function gncGYJD         :Real   ;{    0.000;R[-1e3..1e3]<   0> Y,J,B,V Displacement in CNC File}
 function gncGZKD         :Real   ;{    0.000;R[-1e3..1e3]<   0> Z,K,C,W Displacement in CNC File}
 function gncGXIS         :Real   ;{    1.000;R[-1e3..1e3]<   1> X,I,A,U Scale in CNC File -1 for Mirror}
 function gncGYJS         :Real   ;{    1.000;R[-1e3..1e3]<   1> Y,J,B,V Scale in CNC File -1 for Mirror}
 function gncGZKS         :Real   ;{    1.000;R[-1e3..1e3]<   1> Z,K,C,W Scale in CNC File -1 for Mirror}

{CNC.PseudoAdapativeVariable}
 function gncGAdaptive    :Char   ;{    N    ;C[Y_       ]<   N> Enable adaptive control}
 function gncGFrVSRad     :Real   ;{    1.000;R[0.1..1.0 ]<   1> Difficulty of milling frontal VS radial}
 function gncGZWear       :Real   ;{    0.000;R[0.0..0.1 ]<   0> Auto increase Z cote      [mm/m]}
 function gncGFWear       :Real   ;{    1.000;R[0.9..1.0 ]<   1> Auto slow milling process [ %/m]}

{CNC.AboutDXFFile}
 function gncGTypeLine    :String ;{         ;S[ASCII    ]<    > Name of line type}
 function gncGEquip       :Char   ;{    Y    ;C[Y_       ]<   Y> Y then equip. color else ColorInit}
 function gncGAlternate   :Char   ;{    Y    ;C[Y_       ]<   Y> Y then equip. color alternate}
 function gncGColorInit   :Integer;{   15    ;I[0..255   ]<  15> If equip <> Y then G1=ColorInit}

{CNC.Sintax}
 function gncGNSeparator  :String ;{    -    ;S[ASCII    ]<   -> Sign for separator in CNC & DXFName}
 function gncGStartLine   :Integer;{    5    ;I[1..1000  ]<   5> Start line in CNC file}
 function gncGStepLine    :Integer;{    1    ;I[1..1000  ]<   1> Increment of line in CNC file}
 function gncGStartPrg    :Integer;{    1    ;I[1..1000  ]<   1> Nr of program (%StartPrg)}
 function gncGStepPrg     :Integer;{    1    ;I[1..1000  ]<   1> If Break CNCFile %StartPrg+StepPrg)}
 function gncGStartFile   :Integer;{    1    ;I[1..1000  ]<   1> Name of file to disk (+StartFile)}
 function gncGStepFile    :Integer;{    1    ;I[1..1000  ]<   1> If Break CNCFile (StartFile+StepFile)}
 function gncGDecimalPoint:String ;{    .    ;S[ASCII    ]<   .> Sign for decimal point}
 function gncGAtrSign     :String ;{    =    ;S[ASCII    ]<   => Sign for attribution   (F=P0)}
 function gncGAssSign     :String ;{    ,    ;S[ASCII    ]<   ,> Sign for assignation  (P[0],2*P[1])}
 function gncGVariableName:String ;{    P    ;S[ASCII    ]<   P> Letter for variable name}
 function gncGNDigit      :Integer;{    4    ;I[2..5     ]<   4> Nr. of digits for N   in IndentedMode}
 function gncGVDigit      :Integer;{    9    ;I[5..12    ]<   9> Nr. of digits for All in IndentedMode}
 function gncGNSign       :String ;{    N    ;S[ASCII    ]<   N> Sign for nr of line}
 function gncGCountLine   :Char   ;{    Y    ;C[Y_       ]<   Y> enable, disable writing info about line}

 function gncGBracketsON  :String ;{         ;S[ASCII    ]<    > Sign for var. array start brackets P[_}
 function gncGBracketsOFF :String ;{         ;S[ASCII    ]<    > Sign for var. array end   brackets P_]}
 function gncGCommentON   :String ;{    (    ;S[ASCII    ]<   (> Sign for Start comment}
 function gncGCommentOFF  :String ;{    )    ;S[ASCII    ]<   )> Sign for End comment}
 function gncGMotorON     :String ;{    M3   ;S[ASCII    ]<  M3> Sign for start motor}
 function gncGMotorOFF    :String ;{    M4   ;S[ASCII    ]<  M4> Sign for stop  motor}
 function gncGLiquidON    :String ;{    M8   ;S[ASCII    ]<  M8> Sign for start liquid}
 function gncGLiquidOFF   :String ;{    M9   ;S[ASCII    ]<  M9> Sign for stop  liquid}
 function gncGMAbsolute   :String ;{    G90  ;S[ASCII    ]< G90> Sign for absolute movement}
 function gncGMRelative   :String ;{    G91  ;S[ASCII    ]< G91> Sign for relative movement}
 function gncGEndOfLine   :String ;{         ;S[ASCII    ]<    > Additional Sign for end of line}
 function gncGStartStr    :String ;{%\C\\    ;S[StartStr ]<%\C\\> Start file string in CNC File}
 function gncGEndStr      :String ;{%\P\\    ;S[End  Str ]<%\P\\> End  file string in CNC File}
 function gncGG0Sign      :String ;{    G0   ;S[ASCII    ]<  G0> Sign for speed movement}
 function gncGG1Sign      :String ;{    G1   ;S[ASCII    ]<  G1> Sign for work  movement}
 function gncGG2Sign      :String ;{    G2   ;S[ASCII    ]<  G2> Sign for CW    movement}
 function gncGG3Sign      :String ;{    G3   ;S[ASCII    ]<  G3> Sign for CCW   movement}
 function gncGG4Sign      :String ;{    G4   ;S[ASCII    ]<  G4> Sign for delay movement}
 function gncGG17Sign     :String ;{    G17  ;S[ASCII    ]< G17> Sign for Arc in XY plane}
 function gncGG18Sign     :String ;{    G18  ;S[ASCII    ]< G18> Sign for Arc in YZ plane}
 function gncGG19Sign     :String ;{    G19  ;S[ASCII    ]< G19> Sign for Arc in ZX plane}

 function gncGASign       :String ;{    A    ;S[ASCII    ]<   A> Sign for A}
 function gncGBSign       :String ;{    B    ;S[ASCII    ]<   B> Sign for B}
 function gncGCSign       :String ;{    C    ;S[ASCII    ]<   C> Sign for C}
 function gncGISign       :String ;{    I    ;S[ASCII    ]<   I> Sign for I}
 function gncGJSign       :String ;{    J    ;S[ASCII    ]<   J> Sign for J}
 function gncGKSign       :String ;{    K    ;S[ASCII    ]<   K> Sign for K}
 function gncGXSign       :String ;{    X    ;S[ASCII    ]<   X> Sign for X}
 function gncGYSign       :String ;{    Y    ;S[ASCII    ]<   Y> Sign for Y}
 function gncGZSign       :String ;{    Z    ;S[ASCII    ]<   Z> Sign for Z}
 function gncGUSign       :String ;{    U    ;S[ASCII    ]<   U> Sign for U}
 function gncGVSign       :String ;{    V    ;S[ASCII    ]<   V> Sign for V}
 function gncGWSign       :String ;{    W    ;S[ASCII    ]<   W> Sign for W}
 function gncGFSign       :String ;{    F    ;S[ASCII    ]<   F> Sign for F}
 function gncGSSign       :String ;{    S    ;S[ASCII    ]<   S> Sign for S}

 function gncGSLSign      :String ;{    SL=  ;S[ASCII    ]< SL=> Sign for Speed Length}
 function gncGWLSign      :String ;{    WL=  ;S[ASCII    ]< WL=> Sign for Work  Length}
 function gncGTLSign      :String ;{    TL=  ;S[ASCII    ]< TL=> Sign for Total Length}
 function gncGSTSign      :String ;{    ST=  ;S[ASCII    ]< ST=> Sign for Speed Time}
 function gncGWTSign      :String ;{    WT=  ;S[ASCII    ]< WT=> Sign for Work  Time}
 function gncGTTSign      :String ;{    TT=  ;S[ASCII    ]< TT=> Sign for Total Time}
 function gncGSCSign      :String ;{    SC=  ;S[ASCII    ]< SC=> Sign for Speed Cost}
 function gncGWCSign      :String ;{    WC=  ;S[ASCII    ]< WC=> Sign for Work  Cost}
 function gncGTCSign      :String ;{    TC=  ;S[ASCII    ]< TC=> Sign for Total Cost}
 function gncGDSLSign     :String ;{   DSL=  ;S[ASCII    ]<DSL=> Sign for dif. Speed Length}
 function gncGDWLSign     :String ;{   DWL=  ;S[ASCII    ]<DWL=> Sign for dif. Work  Length}
 function gncGDTLSign     :String ;{   DTL=  ;S[ASCII    ]<DTL=> Sign for dif. Total Length}
 function gncGDSTSign     :String ;{   DST=  ;S[ASCII    ]<DST=> Sign for dif. Speed Time}
 function gncGDWTSign     :String ;{   DWT=  ;S[ASCII    ]<DWT=> Sign for dif. Work  Time}
 function gncGDTTSign     :String ;{   DTT=  ;S[ASCII    ]<DTT=> Sign for dif. Total Time}
 function gncGDSCSign     :String ;{   DSC=  ;S[ASCII    ]<DSC=> Sign for dif. Speed Cost}
 function gncGDWCSign     :String ;{   DWC=  ;S[ASCII    ]<DWC=> Sign for dif. Work  Cost}
 function gncGDTCSign     :String ;{   DTC=  ;S[ASCII    ]<DTC=> Sign for dif. Total Cost}

{CNC.Enable & Disable axis, moves}
 function gncGG0Enable    :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for speed movement}
 function gncGG1Enable    :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for work  movement}
 function gncGG2Enable    :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for CW    movement}
 function gncGG3Enable    :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for CCW   movement}
 function gncGG4Enable    :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for delay movement}
 function gncGG171819Enabl:Char   ;{    Y    ;C[Y_       ]<   Y> Enable for Arc in XY plane}
 function gncGAEnable     :Char   ;{    N    ;C[Y_       ]<   N> Enable for A}
 function gncGBEnable     :Char   ;{    N    ;C[Y_       ]<   N> Enable for B}
 function gncGCEnable     :Char   ;{    N    ;C[Y_       ]<   N> Enable for C}
 function gncGIEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for I}
 function gncGJEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for J}
 function gncGKEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for K}
 function gncGXEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for X}
 function gncGYEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for Y}
 function gncGZEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for Z}
 function gncGUEnable     :Char   ;{    N    ;C[Y_       ]<   N> Enable for U}
 function gncGVEnable     :Char   ;{    N    ;C[Y_       ]<   N> Enable for V}
 function gncGWEnable     :Char   ;{    N    ;C[Y_       ]<   N> Enable for W}
 function gncGFEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for F}
 function gncGSEnable     :Char   ;{    Y    ;C[Y_       ]<   Y> Enable for S}
 function gncGSLEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Speed Length}
 function gncGWLEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Work  Length}
 function gncGTLEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Total Length}
 function gncGSTEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Speed Time}
 function gncGWTEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Work  Time}
 function gncGTTEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Total Time}
 function gncGSCEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Speed Cost}
 function gncGWCEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Work  Cost}
 function gncGTCEnable    :Char   ;{    N    ;C[Y_       ]<   N> Enable for Total Cost}
 function gncGDSLEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Speed Length}
 function gncGDWLEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Work  Length}
 function gncGDTLEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Total Length}
 function gncGDSTEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Speed Time}
 function gncGDWTEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Work  Time}
 function gncGDTTEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Total Time}
 function gncGDSCEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Speed Cost}
 function gncGDWCEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Work  Cost}
 function gncGDTCEnable   :Char   ;{    N    ;C[Y_       ]<   N> Enable for dif. Total Cost}

{CNC.Enable & Disable optimize axis, moves}
 function gncGG0Optim     :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for speed movement}
 function gncGG1Optim     :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for work  movement}
 function gncGG2Optim     :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for CW    movement}
 function gncGG3Optim     :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for CCW   movement}
 function gncGG4Optim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for delay movement}
 function gncGG171819Optim:Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for Arc in XY plane}
 function gncGAOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for A}
 function gncGBOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for B}
 function gncGCOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for C}
 function gncGIOptim      :Char   ;{    N    ;C[Y_       ]<   N> Optimize for I}
 function gncGJOptim      :Char   ;{    N    ;C[Y_       ]<   N> Optimize for J}
 function gncGKOptim      :Char   ;{    N    ;C[Y_       ]<   N> Optimize for K}
 function gncGXOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for X}
 function gncGYOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for Y}
 function gncGZOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for Z}
 function gncGUOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for U}
 function gncGVOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for V}
 function gncGWOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for W}
 function gncGFOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for F}
 function gncGSOptim      :Char   ;{    Y    ;C[Y_       ]<   Y> Optimize for S}
 function gncGSLOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Speed Length}
 function gncGWLOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Work  Length}
 function gncGTLOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Total Length}
 function gncGSTOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Speed Time}
 function gncGWTOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Work  Time}
 function gncGTTOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Total Time}
 function gncGSCOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Speed Cost}
 function gncGWCOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Work  Cost}
 function gncGTCOptim     :Char   ;{    N    ;C[Y_       ]<   N> Optimize for Total Cost}
 function gncGDSLOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Speed Length}
 function gncGDWLOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Work  Length}
 function gncGDTLOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Total Length}
 function gncGDSTOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Speed Time}
 function gncGDWTOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Work  Time}
 function gncGDTTOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Total Time}
 function gncGDSCOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Speed Cost}
 function gncGDWCOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Work  Cost}
 function gncGDTCOptim    :Char   ;{    N    ;C[Y_       ]<   N> Optimize for dif. Total Cost}

{CNC.OutputReportInfo}
 function gncGRSeparator1 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Separator1}
 function gncGRProcessor  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of ProcessorName}
 function gncGRTools      :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Tools}
 function gncGRName       :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Name}
 function gncGRProcessBy  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of ProcessBy}
 function gncGRUserName   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of UserName}
 function gncGRUserComp   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of UserComp}
 function gncGRSerialNr   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of SerialNr}
 function gncGRProcessDate:Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of ProcessDate}
 function gncGRProcessHour:Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of ProcessHour}
 function gncGRAppName    :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Name of App.}
 function gncGRCfgFile    :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Name of cfg file}
 function gncGRSeparator2 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Separator2}
 function gncGRSpeedLength:Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of SpeedLentgh}
 function gncGRWorkLength :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Work Lentgh}
 function gncGRTotalLength:Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of TotalLength}
 function gncGRSpeedTime  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of SpeedTime}
 function gncGRWorkTime   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Work Time}
 function gncGRTotalTime  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of TotalTime}
 function gncGRSpeedCost  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of SpeedCost}
 function gncGRWorkCost   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Work Cost}
 function gncGRTotalCost  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of TotalCost}
 function gncGRNrOfLines  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Nr.of Lines}
 function gncGRNrOfBytes  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Nr.of Bytes}
 function gncGROptimizing :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Optimizing}
 function gncGRSeparator3 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in report of Separator3}

{CNC.OutputOveralTechDataInfo}
 function gncGOSeparator1 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Separator1}
 function gncGOProcessor  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessorName}
 function gncGOTools      :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Tools}
 function gncGOName       :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Name}
 function gncGOProcessBy  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessBy}
 function gncGOUserName   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of UserName}
 function gncGOUserComp   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of UserComp}
 function gncGOSerialNr   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SerialNr}
 function gncGOProcessDate:Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessDate}
 function gncGOProcessHour:Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessHour}
 function gncGOAppName    :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Name of App.}
 function gncGOCfgFile    :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Name of cfg file}
 function gncGOSeparator2 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Separator2}
 function gncGOSpeedLength:Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SpeedLentgh}
 function gncGOWorkLength :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Work Lentgh}
 function gncGOTotalLength:Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of TotalLength}
 function gncGOSpeedTime  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SpeedTime}
 function gncGOWorkTime   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Work Time}
 function gncGOTotalTime  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of TotalTime}
 function gncGOSpeedCost  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SpeedCost}
 function gncGOWorkCost   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Work Cost}
 function gncGOTotalCost  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of TotalCost}
 function gncGONrOfLines  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Nr.of Lines}
 function gncGONrOfBytes  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Nr.of Bytes}
 function gncGOOptimizing :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Optimizing}
 function gncGOSeparator3 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Separator3}

{CNC.OutputCNCInfo}
 function gncGCSeparator1 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Separator1}
 function gncGCProcessor  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessorName}
 function gncGCTools      :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Tools}
 function gncGCName       :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Name}
 function gncGCProcessBy  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessBy}
 function gncGCUserName   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of UserName}
 function gncGCUserComp   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of UserComp}
 function gncGCSerialNr   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of SerialNr}
 function gncGCProcessDate:Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessDate}
 function gncGCProcessHour:Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessHour}
 function gncGCAppName    :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Name of App.}
 function gncGCCfgFile    :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Name of cfg file}
 function gncGCSeparator2 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Separator2}
 function gncGCSpeedLength:Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of SpeedLentgh}
 function gncGCWorkLength :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Work Lentgh}
 function gncGCTotalLength:Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of TotalLength}
 function gncGCSpeedTime  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of SpeedTime}
 function gncGCWorkTime   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Work Time}
 function gncGCTotalTime  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of TotalTime}
 function gncGCSpeedCost  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of SpeedCost}
 function gncGCWorkCost   :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Work Cost}
 function gncGCTotalCost  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of TotalCost}
 function gncGCNrOfLines  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Nr.of Lines}
 function gncGCNrOfBytes  :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Nr.of Bytes}
 function gncGCOptimizing :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Optimizing}
 function gncGCSeparator3 :Char   ;{    Y    ;C[Y_       ]<   Y> Output in NC of Separator3}

 procedure gncPCNCOut      (V:Char   );{    Y    ;C[Y_       ]<   Y> Process CNCFile else not}
 procedure gncPDXFOut      (V:Char   );{    N    ;C[Y_       ]<   N> Process DXFFile else not}
 procedure gncPRepOut      (V:Char   );{    Y    ;C[Y_       ]<   Y> Process ReportFile else not}
 procedure gncPNameDigitNr (V:Integer);{    3    ;I[0..5     ]<   3> Nr. of digits in CNC Name}
 procedure gncPLongName    (V:Char   );{    Y    ;C[Y_       ]<   Y> If N cut in name CNC type inf.}
 procedure gncPExtension   (V:String );{    CNC  ;S[Y_       ]< CNC> Name of extension of  CNCFile}
 procedure gncPOptFilter   (V:Real   );{    0.300;R[0.01..0.5]< 0.2> Value of optimizing filter}
 procedure gncPBreakKilo   (V:Char   );{    Y    ;C[Y_       ]<   Y> Break CNCFile after MaxKilo or MaxLine}
 procedure gncPMaxKilo     (V:Real   );{   32.000;R[1..1000  ]<  32> Number of Kilos in each CNC file}
 procedure gncPMaxLine     (V:Integer);{  990    ;I[10..10000]< 990> Number of Lines in each CNC file}
 procedure gncPOutValue    (V:Real   );{    2.000;R[0..1000  ]<   2> OutValue of z in case of break CNCFile}
 procedure gncPAutoBreak   (V:Real   );{    5.000;R[0..10    ]<  10> Break value in CNC file < OutValue}
 procedure gncPCondensedOut(V:Char   );{    Y    ;C[Y_       ]<   Y> Y purge trivial data in CNC File}
 procedure gncPIndentedOut (V:Char   );{    N    ;C[Y_       ]<   N> Y indent for good visibility}
 procedure gncPEnable2Half (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable 2.5 axis generation}
 procedure gncPFrontal     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable frontal milling}
 procedure gncPRelative    (V:Char   );{    N    ;C[Y_       ]<   N> Enable relative coordinate}
 procedure gncPDecimalNr   (V:Integer);{    2    ;I[0..4     ]<   2> Nr. of decimals in CNC File}
 procedure gncPG2G3        (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable arc interpolation}
 procedure gncPG2G3Radius  (V:Real   );{    2    ;R[-1e3..1e3]<   2> If G2G3=N then value to discreet arc}
 procedure gncPG2G3FullOut (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable full output for G2&G3}
 procedure gncPG171819Info (V:Char   );{    N    ;C[Y_       ]<   Y> Enable output of plane for G2&G3}

 procedure gncPG0AutoPurge (V:Char   );{    Y    ;C[Y_       ]<   Y> Smart purge G0 in CNC File !}
 procedure gncPG0AutoPut   (V:Char   );{    Y    ;C[Y_       ]<   Y> Smart found optimal G0 Z high}
 procedure gncPG0ZCote     (V:Real   );{  300.000;R[-1e9..1e9]< 300> if AutoPutG0<>Y then if G0 Z:=G0ZCote}
 procedure gncPG0Switch    (V:Real   );{   10.000;R[-100..100]<  10> if DistCNC<G0Swich then G1 else G0}

 procedure gncPSHourCost   (V:Real   );{    5.000;R[0.. 1e100]<   5> Cost of one hour of processing in speed}
 procedure gncPWHourCost   (V:Real   );{   10.000;R[0.. 1e100]<  10> Cost of one hour of processing in work}

 procedure gncPMoneySign   (V:String );{    $    ;S[ASCII    ]<   $> Sign for national money $,DM...}

 procedure gncPRepTechCfg  (V:Char   );{    Y    ;C[Y_       ]<   Y> Copy cfg file in generated report}
 procedure gncPRepProtect  (V:Char   );{    Y    ;C[Y_       ]<   Y> Lock and protect report file for modify}

{CNC.F&SValue}
 procedure gncPFAdress     (V:Real   );{  100.000;R[1..10000 ]< 100> Normal advance [mm/min]}
 procedure gncPSAdress     (V:Real   );{  100.000;R[1..10000 ]< 100> Rotation speed}
 procedure gncPFastAdvance (V:Real   );{ 1000.000;R[1..10000 ]<1000> Fast advance   [mm/min]}

{CNC.Info}
 procedure gncPMotor       (V:Char   );{    Y    ;C[Y_       ]<   Y> Motor  On}
 procedure gncPLiquid      (V:Char   );{    Y    ;C[Y_       ]<   Y> Liquid On}
 procedure gncPAbsRel      (V:Char   );{    Y    ;C[Y_       ]<   Y> Write inf. about Absolute or Relative}
 procedure gncPLineComment (V:Char   );{    Y    ;C[Y_       ]<   Y> Y enable line comment}
 procedure gncPTechComment (V:Char   );{    Y    ;C[Y_       ]<   Y> Y enable technological comment}

{CNC.Transform3D}
 procedure gncPEnableTR3D  (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable 2D transformations}
 procedure gncPXID         (V:Real   );{    0.000;R[-1e3..1e3]<   0> X,I,A,U Displacement in CNC File}
 procedure gncPYJD         (V:Real   );{    0.000;R[-1e3..1e3]<   0> Y,J,B,V Displacement in CNC File}
 procedure gncPZKD         (V:Real   );{    0.000;R[-1e3..1e3]<   0> Z,K,C,W Displacement in CNC File}
 procedure gncPXIS         (V:Real   );{    1.000;R[-1e3..1e3]<   1> X,I,A,U Scale in CNC File -1 for Mirror}
 procedure gncPYJS         (V:Real   );{    1.000;R[-1e3..1e3]<   1> Y,J,B,V Scale in CNC File -1 for Mirror}
 procedure gncPZKS         (V:Real   );{    1.000;R[-1e3..1e3]<   1> Z,K,C,W Scale in CNC File -1 for Mirror}

{CNC.PseudoAdapativeVariable}
 procedure gncPAdaptive    (V:Char   );{    N    ;C[Y_       ]<   N> Enable adaptive control}
 procedure gncPFrVSRad     (V:Real   );{    1.000;R[0.1..1.0 ]<   1> Difficulty of milling frontal VS radial}
 procedure gncPZWear       (V:Real   );{    0.000;R[0.0..0.1 ]<   0> Auto increase Z cote      [mm/m]}
 procedure gncPFWear       (V:Real   );{    1.000;R[0.9..1.0 ]<   1> Auto slow milling process [ %/m]}

{CNC.AboutDXFFile}
 procedure gncPTypeLine    (V:String );{         ;S[ASCII    ]<    > Name of line type}
 procedure gncPEquip       (V:Char   );{    Y    ;C[Y_       ]<   Y> Y then equip. color else ColorInit}
 procedure gncPAlternate   (V:Char   );{    Y    ;C[Y_       ]<   Y> Y then equip. color alternate}
 procedure gncPColorInit   (V:Integer);{   15    ;I[0..255   ]<  15> If equip <> Y then G1=ColorInit}

{CNC.Sintax}
 procedure gncPNSeparator  (V:String );{    -    ;S[ASCII    ]<   -> Sign for separator in CNC & DXFName}
 procedure gncPStartLine   (V:Integer);{    5    ;I[1..1000  ]<   5> Start line in CNC file}
 procedure gncPStepLine    (V:Integer);{    1    ;I[1..1000  ]<   1> Increment of line in CNC file}
 procedure gncPStartPrg    (V:Integer);{    1    ;I[1..1000  ]<   1> Nr of program (%StartPrg)}
 procedure gncPStepPrg     (V:Integer);{    1    ;I[1..1000  ]<   1> If Break CNCFile %StartPrg+StepPrg)}
 procedure gncPStartFile   (V:Integer);{    1    ;I[1..1000  ]<   1> Name of file to disk (+StartFile)}
 procedure gncPStepFile    (V:Integer);{    1    ;I[1..1000  ]<   1> If Break CNCFile (StartFile+StepFile)}
 procedure gncPDecimalPoint(V:String );{    .    ;S[ASCII    ]<   .> Sign for decimal point}
 procedure gncPAtrSign     (V:String );{    =    ;S[ASCII    ]<   => Sign for attribution   (F=P0)}
 procedure gncPAssSign     (V:String );{    ,    ;S[ASCII    ]<   ,> Sign for assignation  (P[0],2*P[1])}
 procedure gncPVariableName(V:String );{    P    ;S[ASCII    ]<   P> Letter for variable name}
 procedure gncPNDigit      (V:Integer);{    4    ;I[2..5     ]<   4> Nr. of digits for N   in IndentedMode}
 procedure gncPVDigit      (V:Integer);{    9    ;I[5..12    ]<   9> Nr. of digits for All in IndentedMode}
 procedure gncPNSign       (V:String );{    N    ;S[ASCII    ]<   N> Sign for nr of line}
 procedure gncPCountLine   (V:Char   );{    Y    ;C[Y_       ]<   Y> enable, disable writing info about line}

 procedure gncPBracketsON  (V:String );{         ;S[ASCII    ]<    > Sign for var. array start brackets P[_}
 procedure gncPBracketsOFF (V:String );{         ;S[ASCII    ]<    > Sign for var. array end   brackets P_]}
 procedure gncPCommentON   (V:String );{    (    ;S[ASCII    ]<   (> Sign for Start comment}
 procedure gncPCommentOFF  (V:String );{    )    ;S[ASCII    ]<   )> Sign for End comment}
 procedure gncPMotorON     (V:String );{    M3   ;S[ASCII    ]<  M3> Sign for start motor}
 procedure gncPMotorOFF    (V:String );{    M4   ;S[ASCII    ]<  M4> Sign for stop  motor}
 procedure gncPLiquidON    (V:String );{    M8   ;S[ASCII    ]<  M8> Sign for start liquid}
 procedure gncPLiquidOFF   (V:String );{    M9   ;S[ASCII    ]<  M9> Sign for stop  liquid}
 procedure gncPMAbsolute   (V:String );{    G90  ;S[ASCII    ]< G90> Sign for absolute movement}
 procedure gncPMRelative   (V:String );{    G91  ;S[ASCII    ]< G91> Sign for relative movement}
 procedure gncPEndOfLine   (V:String );{         ;S[ASCII    ]<    > Additional Sign for end of line}
 procedure gncPStartStr    (V:String );{%\C\\    ;S[StartStr ]<%\C\\> Start file string in CNC File}
 procedure gncPEndStr      (V:String );{%\P\\    ;S[End  Str ]<%\P\\> End  file string in CNC File}
 procedure gncPG0Sign      (V:String );{    G0   ;S[ASCII    ]<  G0> Sign for speed movement}
 procedure gncPG1Sign      (V:String );{    G1   ;S[ASCII    ]<  G1> Sign for work  movement}
 procedure gncPG2Sign      (V:String );{    G2   ;S[ASCII    ]<  G2> Sign for CW    movement}
 procedure gncPG3Sign      (V:String );{    G3   ;S[ASCII    ]<  G3> Sign for CCW   movement}
 procedure gncPG4Sign      (V:String );{    G4   ;S[ASCII    ]<  G4> Sign for delay movement}
 procedure gncPG17Sign     (V:String );{    G17  ;S[ASCII    ]< G17> Sign for Arc in XY plane}
 procedure gncPG18Sign     (V:String );{    G18  ;S[ASCII    ]< G18> Sign for Arc in YZ plane}
 procedure gncPG19Sign     (V:String );{    G19  ;S[ASCII    ]< G19> Sign for Arc in ZX plane}

 procedure gncPASign       (V:String );{    A    ;S[ASCII    ]<   A> Sign for A}
 procedure gncPBSign       (V:String );{    B    ;S[ASCII    ]<   B> Sign for B}
 procedure gncPCSign       (V:String );{    C    ;S[ASCII    ]<   C> Sign for C}
 procedure gncPISign       (V:String );{    I    ;S[ASCII    ]<   I> Sign for I}
 procedure gncPJSign       (V:String );{    J    ;S[ASCII    ]<   J> Sign for J}
 procedure gncPKSign       (V:String );{    K    ;S[ASCII    ]<   K> Sign for K}
 procedure gncPXSign       (V:String );{    X    ;S[ASCII    ]<   X> Sign for X}
 procedure gncPYSign       (V:String );{    Y    ;S[ASCII    ]<   Y> Sign for Y}
 procedure gncPZSign       (V:String );{    Z    ;S[ASCII    ]<   Z> Sign for Z}
 procedure gncPUSign       (V:String );{    U    ;S[ASCII    ]<   U> Sign for U}
 procedure gncPVSign       (V:String );{    V    ;S[ASCII    ]<   V> Sign for V}
 procedure gncPWSign       (V:String );{    W    ;S[ASCII    ]<   W> Sign for W}
 procedure gncPFSign       (V:String );{    F    ;S[ASCII    ]<   F> Sign for F}
 procedure gncPSSign       (V:String );{    S    ;S[ASCII    ]<   S> Sign for S}

 procedure gncPSLSign      (V:String );{    SL=  ;S[ASCII    ]< SL=> Sign for Speed Length}
 procedure gncPWLSign      (V:String );{    WL=  ;S[ASCII    ]< WL=> Sign for Work  Length}
 procedure gncPTLSign      (V:String );{    TL=  ;S[ASCII    ]< TL=> Sign for Total Length}
 procedure gncPSTSign      (V:String );{    ST=  ;S[ASCII    ]< ST=> Sign for Speed Time}
 procedure gncPWTSign      (V:String );{    WT=  ;S[ASCII    ]< WT=> Sign for Work  Time}
 procedure gncPTTSign      (V:String );{    TT=  ;S[ASCII    ]< TT=> Sign for Total Time}
 procedure gncPSCSign      (V:String );{    SC=  ;S[ASCII    ]< SC=> Sign for Speed Cost}
 procedure gncPWCSign      (V:String );{    WC=  ;S[ASCII    ]< WC=> Sign for Work  Cost}
 procedure gncPTCSign      (V:String );{    TC=  ;S[ASCII    ]< TC=> Sign for Total Cost}
 procedure gncPDSLSign     (V:String );{   DSL=  ;S[ASCII    ]<DSL=> Sign for dif. Speed Length}
 procedure gncPDWLSign     (V:String );{   DWL=  ;S[ASCII    ]<DWL=> Sign for dif. Work  Length}
 procedure gncPDTLSign     (V:String );{   DTL=  ;S[ASCII    ]<DTL=> Sign for dif. Total Length}
 procedure gncPDSTSign     (V:String );{   DST=  ;S[ASCII    ]<DST=> Sign for dif. Speed Time}
 procedure gncPDWTSign     (V:String );{   DWT=  ;S[ASCII    ]<DWT=> Sign for dif. Work  Time}
 procedure gncPDTTSign     (V:String );{   DTT=  ;S[ASCII    ]<DTT=> Sign for dif. Total Time}
 procedure gncPDSCSign     (V:String );{   DSC=  ;S[ASCII    ]<DSC=> Sign for dif. Speed Cost}
 procedure gncPDWCSign     (V:String );{   DWC=  ;S[ASCII    ]<DWC=> Sign for dif. Work  Cost}
 procedure gncPDTCSign     (V:String );{   DTC=  ;S[ASCII    ]<DTC=> Sign for dif. Total Cost}

{CNC.Enable & Disable axis, moves}
 procedure gncPG0Enable    (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for speed movement}
 procedure gncPG1Enable    (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for work  movement}
 procedure gncPG2Enable    (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for CW    movement}
 procedure gncPG3Enable    (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for CCW   movement}
 procedure gncPG4Enable    (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for delay movement}
 procedure gncPG171819Enabl(V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for Arc in XY plane}
 procedure gncPAEnable     (V:Char   );{    N    ;C[Y_       ]<   N> Enable for A}
 procedure gncPBEnable     (V:Char   );{    N    ;C[Y_       ]<   N> Enable for B}
 procedure gncPCEnable     (V:Char   );{    N    ;C[Y_       ]<   N> Enable for C}
 procedure gncPIEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for I}
 procedure gncPJEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for J}
 procedure gncPKEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for K}
 procedure gncPXEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for X}
 procedure gncPYEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for Y}
 procedure gncPZEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for Z}
 procedure gncPUEnable     (V:Char   );{    N    ;C[Y_       ]<   N> Enable for U}
 procedure gncPVEnable     (V:Char   );{    N    ;C[Y_       ]<   N> Enable for V}
 procedure gncPWEnable     (V:Char   );{    N    ;C[Y_       ]<   N> Enable for W}
 procedure gncPFEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for F}
 procedure gncPSEnable     (V:Char   );{    Y    ;C[Y_       ]<   Y> Enable for S}
 procedure gncPSLEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Speed Length}
 procedure gncPWLEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Work  Length}
 procedure gncPTLEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Total Length}
 procedure gncPSTEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Speed Time}
 procedure gncPWTEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Work  Time}
 procedure gncPTTEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Total Time}
 procedure gncPSCEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Speed Cost}
 procedure gncPWCEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Work  Cost}
 procedure gncPTCEnable    (V:Char   );{    N    ;C[Y_       ]<   N> Enable for Total Cost}
 procedure gncPDSLEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Speed Length}
 procedure gncPDWLEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Work  Length}
 procedure gncPDTLEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Total Length}
 procedure gncPDSTEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Speed Time}
 procedure gncPDWTEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Work  Time}
 procedure gncPDTTEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Total Time}
 procedure gncPDSCEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Speed Cost}
 procedure gncPDWCEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Work  Cost}
 procedure gncPDTCEnable   (V:Char   );{    N    ;C[Y_       ]<   N> Enable for dif. Total Cost}

{CNC.Enable & Disable optimize axis, moves}
 procedure gncPG0Optim     (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for speed movement}
 procedure gncPG1Optim     (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for work  movement}
 procedure gncPG2Optim     (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for CW    movement}
 procedure gncPG3Optim     (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for CCW   movement}
 procedure gncPG4Optim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for delay movement}
 procedure gncPG171819Optim(V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for Arc in XY plane}
 procedure gncPAOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for A}
 procedure gncPBOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for B}
 procedure gncPCOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for C}
 procedure gncPIOptim      (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for I}
 procedure gncPJOptim      (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for J}
 procedure gncPKOptim      (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for K}
 procedure gncPXOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for X}
 procedure gncPYOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for Y}
 procedure gncPZOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for Z}
 procedure gncPUOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for U}
 procedure gncPVOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for V}
 procedure gncPWOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for W}
 procedure gncPFOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for F}
 procedure gncPSOptim      (V:Char   );{    Y    ;C[Y_       ]<   Y> Optimize for S}
 procedure gncPSLOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Speed Length}
 procedure gncPWLOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Work  Length}
 procedure gncPTLOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Total Length}
 procedure gncPSTOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Speed Time}
 procedure gncPWTOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Work  Time}
 procedure gncPTTOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Total Time}
 procedure gncPSCOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Speed Cost}
 procedure gncPWCOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Work  Cost}
 procedure gncPTCOptim     (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for Total Cost}
 procedure gncPDSLOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Speed Length}
 procedure gncPDWLOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Work  Length}
 procedure gncPDTLOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Total Length}
 procedure gncPDSTOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Speed Time}
 procedure gncPDWTOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Work  Time}
 procedure gncPDTTOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Total Time}
 procedure gncPDSCOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Speed Cost}
 procedure gncPDWCOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Work  Cost}
 procedure gncPDTCOptim    (V:Char   );{    N    ;C[Y_       ]<   N> Optimize for dif. Total Cost}

{CNC.OutputReportInfo}
 procedure gncPRSeparator1 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Separator1}
 procedure gncPRProcessor  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of ProcessorName}
 procedure gncPRTools      (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Tools}
 procedure gncPRName       (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Name}
 procedure gncPRProcessBy  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of ProcessBy}
 procedure gncPRUserName   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of UserName }
 procedure gncPRUserComp   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of UserComp }
 procedure gncPRSerialNr   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of SerialNr }
 procedure gncPRProcessDate(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of ProcessDate}
 procedure gncPRProcessHour(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of ProcessHour}
 procedure gncPRAppName    (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Name of App.}
 procedure gncPRCfgFile    (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Name of cfg file}
 procedure gncPRSeparator2 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Separator2}
 procedure gncPRSpeedLength(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of SpeedLentgh}
 procedure gncPRWorkLength (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Work Lentgh}
 procedure gncPRTotalLength(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of TotalLength}
 procedure gncPRSpeedTime  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of SpeedTime}
 procedure gncPRWorkTime   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Work Time}
 procedure gncPRTotalTime  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of TotalTime}
 procedure gncPRSpeedCost  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of SpeedCost}
 procedure gncPRWorkCost   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Work Cost}
 procedure gncPRTotalCost  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of TotalCost}
 procedure gncPRNrOfLines  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Nr.of Lines}
 procedure gncPRNrOfBytes  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Nr.of Bytes}
 procedure gncPROptimizing (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Optimizing}
 procedure gncPRSeparator3 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in report of Separator3}

{CNC.OutputOveralTechDataInfo}
 procedure gncPOSeparator1 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Separator1}
 procedure gncPOProcessor  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessorName}
 procedure gncPOTools      (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Tools}
 procedure gncPOName       (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Name}
 procedure gncPOProcessBy  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessBy}
 procedure gncPOUserName   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of UserName }
 procedure gncPOUserComp   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of UserComp }
 procedure gncPOSerialNr   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SerialNr }
 procedure gncPOProcessDate(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessDate}
 procedure gncPOProcessHour(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of ProcessHour}
 procedure gncPOAppName    (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Name of App.}
 procedure gncPOCfgFile    (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Name of cfg file}
 procedure gncPOSeparator2 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Separator2}
 procedure gncPOSpeedLength(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SpeedLentgh}
 procedure gncPOWorkLength (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Work Lentgh}
 procedure gncPOTotalLength(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of TotalLength}
 procedure gncPOSpeedTime  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SpeedTime}
 procedure gncPOWorkTime   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Work Time}
 procedure gncPOTotalTime  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of TotalTime}
 procedure gncPOSpeedCost  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of SpeedCost}
 procedure gncPOWorkCost   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Work Cost}
 procedure gncPOTotalCost  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of TotalCost}
 procedure gncPONrOfLines  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Nr.of Lines}
 procedure gncPONrOfBytes  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Nr.of Bytes}
 procedure gncPOOptimizing (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Optimizing}
 procedure gncPOSeparator3 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in overall rep. of Separator3}

{CNC.OutputCNCInfo}
 procedure gncPCSeparator1 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Separator1}
 procedure gncPCProcessor  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessorName}
 procedure gncPCTools      (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Tools}
 procedure gncPCName       (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Name}
 procedure gncPCProcessBy  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessBy}
 procedure gncPCUserName   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of UserName }
 procedure gncPCUserComp   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of UserComp }
 procedure gncPCSerialNr   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of SerialNr }
 procedure gncPCProcessDate(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessDate}
 procedure gncPCProcessHour(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of ProcessHour}
 procedure gncPCAppName    (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Name of App.}
 procedure gncPCCfgFile    (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Name of cfg file}
 procedure gncPCSeparator2 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Separator2}
 procedure gncPCSpeedLength(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of SpeedLentgh}
 procedure gncPCWorkLength (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Work Lentgh}
 procedure gncPCTotalLength(V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of TotalLength}
 procedure gncPCSpeedTime  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of SpeedTime}
 procedure gncPCWorkTime   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Work Time}
 procedure gncPCTotalTime  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of TotalTime}
 procedure gncPCSpeedCost  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of SpeedCost}
 procedure gncPCWorkCost   (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Work Cost}
 procedure gncPCTotalCost  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of TotalCost}
 procedure gncPCNrOfLines  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Nr.of Lines}
 procedure gncPCNrOfBytes  (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Nr.of Bytes}
 procedure gncPCOptimizing (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Optimizing}
 procedure gncPCSeparator3 (V:Char   );{    Y    ;C[Y_       ]<   Y> Output in NC of Separator3}


implementation
 function  gncGVer         ;external 'GNCPP';
 function  gncGAcc         ;external 'GNCPP';
 procedure gncGReg         ;external 'GNCPP';

 procedure gncPReport      ;external 'GNCPP';

 procedure gncInit         ;external 'GNCPP';
 procedure gncDone         ;external 'GNCPP';
 procedure gncPGeneral     ;external 'GNCPP';
 procedure gncPSmart       ;external 'GNCPP';
 procedure gncPNewSeq      ;external 'GNCPP';
 procedure gncPOpt         ;external 'GNCPP';
 procedure gncReadCFG      ;external 'GNCPP';
 function  gncGF           ;external 'GNCPP';
 function  gncGG           ;external 'GNCPP';
 function  gncGS           ;external 'GNCPP';
 function  gncGA           ;external 'GNCPP';
 function  gncGB           ;external 'GNCPP';
 function  gncGC           ;external 'GNCPP';
 function  gncGI           ;external 'GNCPP';
 function  gncGJ           ;external 'GNCPP';
 function  gncGK           ;external 'GNCPP';
 function  gncGX           ;external 'GNCPP';
 function  gncGY           ;external 'GNCPP';
 function  gncGZ           ;external 'GNCPP';
 function  gncGU           ;external 'GNCPP';
 function  gncGV           ;external 'GNCPP';
 function  gncGW           ;external 'GNCPP';
 function  gncGApp         ;external 'GNCPP';
 function  gncGCfg         ;external 'GNCPP';
 function  gncGSrf         ;external 'GNCPP';
 function  gncGTool        ;external 'GNCPP';
 function  gncGProcBy      ;external 'GNCPP';
 function  gncGOutName     ;external 'GNCPP';

 function  gncGUserName    ;external 'GNCPP';
 function  gncGUserComp    ;external 'GNCPP';
 function  gncGSerialNr    ;external 'GNCPP';

 function  gncGSL :double  ;external 'GNCPP';
 function  gncGWL :double  ;external 'GNCPP';
 function  gncGTL :double  ;external 'GNCPP';
 function  gncGST :double  ;external 'GNCPP';
 function  gncGWT :double  ;external 'GNCPP';
 function  gncGTT :double  ;external 'GNCPP';
 function  gncGSC :double  ;external 'GNCPP';
 function  gncGWC :double  ;external 'GNCPP';
 function  gncGTC :double  ;external 'GNCPP';
 function  gncGDSL:double  ;external 'GNCPP';
 function  gncGDWL:double  ;external 'GNCPP';
 function  gncGDTL:double  ;external 'GNCPP';
 function  gncGDST:double  ;external 'GNCPP';
 function  gncGDWT:double  ;external 'GNCPP';
 function  gncGDTT:double  ;external 'GNCPP';
 function  gncGDSC:double  ;external 'GNCPP';
 function  gncGDWC:double  ;external 'GNCPP';
 function  gncGDTC:double  ;external 'GNCPP';

 function  gncGCNCOut      ;external 'GNCPP';
 function  gncGDXFOut      ;external 'GNCPP';
 function  gncGRepOut      ;external 'GNCPP';
 function  gncGNameDigitNr ;external 'GNCPP';
 function  gncGLongName    ;external 'GNCPP';
 function  gncGExtension   ;external 'GNCPP';
 function  gncGOptFilter   ;external 'GNCPP';
 function  gncGBreakKilo   ;external 'GNCPP';
 function  gncGMaxKilo     ;external 'GNCPP';
 function  gncGMaxLine     ;external 'GNCPP';
 function  gncGOutValue    ;external 'GNCPP';
 function  gncGAutoBreak   ;external 'GNCPP';
 function  gncGCondensedOut;external 'GNCPP';
 function  gncGIndentedOut ;external 'GNCPP';
 function  gncGEnable2Half ;external 'GNCPP';
 function  gncGFrontal     ;external 'GNCPP';
 function  gncGRelative    ;external 'GNCPP';
 function  gncGDecimalNr   ;external 'GNCPP';
 function  gncGG2G3        ;external 'GNCPP';
 function  gncGG2G3Radius  ;external 'GNCPP';
 function  gncGG2G3FullOut ;external 'GNCPP';
 function  gncGG171819Info ;external 'GNCPP';
 function  gncGG0AutoPurge ;external 'GNCPP';
 function  gncGG0AutoPut   ;external 'GNCPP';
 function  gncGG0ZCote     ;external 'GNCPP';
 function  gncGG0Switch    ;external 'GNCPP';
 function  gncGSHourCost   ;external 'GNCPP';
 function  gncGWHourCost   ;external 'GNCPP';
 function  gncGMoneySign   ;external 'GNCPP';
 function  gncGRepTechCfg  ;external 'GNCPP';
 function  gncGRepProtect  ;external 'GNCPP';
 function  gncGFAdress     ;external 'GNCPP';
 function  gncGSAdress     ;external 'GNCPP';
 function  gncGFastAdvance ;external 'GNCPP';
 function  gncGMotor       ;external 'GNCPP';
 function  gncGLiquid      ;external 'GNCPP';
 function  gncGAbsRel      ;external 'GNCPP';
 function  gncGLineComment ;external 'GNCPP';
 function  gncGTechComment ;external 'GNCPP';
 function  gncGEnableTR3D  ;external 'GNCPP';
 function  gncGXID         ;external 'GNCPP';
 function  gncGYJD         ;external 'GNCPP';
 function  gncGZKD         ;external 'GNCPP';
 function  gncGXIS         ;external 'GNCPP';
 function  gncGYJS         ;external 'GNCPP';
 function  gncGZKS         ;external 'GNCPP';
 function  gncGAdaptive    ;external 'GNCPP';
 function  gncGFrVSRad     ;external 'GNCPP';
 function  gncGZWear       ;external 'GNCPP';
 function  gncGFWear       ;external 'GNCPP';
 function  gncGTypeLine    ;external 'GNCPP';
 function  gncGEquip       ;external 'GNCPP';
 function  gncGAlternate   ;external 'GNCPP';
 function  gncGColorInit   ;external 'GNCPP';
 function  gncGNSeparator  ;external 'GNCPP';
 function  gncGStartLine   ;external 'GNCPP';
 function  gncGStepLine    ;external 'GNCPP';
 function  gncGStartPrg    ;external 'GNCPP';
 function  gncGStepPrg     ;external 'GNCPP';
 function  gncGStartFile   ;external 'GNCPP';
 function  gncGStepFile    ;external 'GNCPP';
 function  gncGDecimalPoint;external 'GNCPP';
 function  gncGAtrSign     ;external 'GNCPP';
 function  gncGAssSign     ;external 'GNCPP';
 function  gncGVariableName;external 'GNCPP';
 function  gncGNDigit      ;external 'GNCPP';
 function  gncGVDigit      ;external 'GNCPP';
 function  gncGNSign       ;external 'GNCPP';
 function  gncGCountLine   ;external 'GNCPP';
 function  gncGBracketsON  ;external 'GNCPP';
 function  gncGBracketsOFF ;external 'GNCPP';
 function  gncGCommentON   ;external 'GNCPP';
 function  gncGCommentOFF  ;external 'GNCPP';
 function  gncGMotorON     ;external 'GNCPP';
 function  gncGMotorOFF    ;external 'GNCPP';
 function  gncGLiquidON    ;external 'GNCPP';
 function  gncGLiquidOFF   ;external 'GNCPP';
 function  gncGMAbsolute   ;external 'GNCPP';
 function  gncGMRelative   ;external 'GNCPP';
 function  gncGEndOfLine   ;external 'GNCPP';
 function  gncGStartStr    ;external 'GNCPP';
 function  gncGEndStr      ;external 'GNCPP';
 function  gncGG0Sign      ;external 'GNCPP';
 function  gncGG1Sign      ;external 'GNCPP';
 function  gncGG2Sign      ;external 'GNCPP';
 function  gncGG3Sign      ;external 'GNCPP';
 function  gncGG4Sign      ;external 'GNCPP';
 function  gncGG17Sign     ;external 'GNCPP';
 function  gncGG18Sign     ;external 'GNCPP';
 function  gncGG19Sign     ;external 'GNCPP';
 function  gncGASign       ;external 'GNCPP';
 function  gncGBSign       ;external 'GNCPP';
 function  gncGCSign       ;external 'GNCPP';
 function  gncGISign       ;external 'GNCPP';
 function  gncGJSign       ;external 'GNCPP';
 function  gncGKSign       ;external 'GNCPP';
 function  gncGXSign       ;external 'GNCPP';
 function  gncGYSign       ;external 'GNCPP';
 function  gncGZSign       ;external 'GNCPP';
 function  gncGUSign       ;external 'GNCPP';
 function  gncGVSign       ;external 'GNCPP';
 function  gncGWSign       ;external 'GNCPP';
 function  gncGFSign       ;external 'GNCPP';
 function  gncGSSign       ;external 'GNCPP';
 function  gncGSLSign      ;external 'GNCPP';
 function  gncGWLSign      ;external 'GNCPP';
 function  gncGTLSign      ;external 'GNCPP';
 function  gncGSTSign      ;external 'GNCPP';
 function  gncGWTSign      ;external 'GNCPP';
 function  gncGTTSign      ;external 'GNCPP';
 function  gncGSCSign      ;external 'GNCPP';
 function  gncGWCSign      ;external 'GNCPP';
 function  gncGTCSign      ;external 'GNCPP';
 function  gncGDSLSign     ;external 'GNCPP';
 function  gncGDWLSign     ;external 'GNCPP';
 function  gncGDTLSign     ;external 'GNCPP';
 function  gncGDSTSign     ;external 'GNCPP';
 function  gncGDWTSign     ;external 'GNCPP';
 function  gncGDTTSign     ;external 'GNCPP';
 function  gncGDSCSign     ;external 'GNCPP';
 function  gncGDWCSign     ;external 'GNCPP';
 function  gncGDTCSign     ;external 'GNCPP';
 function  gncGG0Enable    ;external 'GNCPP';
 function  gncGG1Enable    ;external 'GNCPP';
 function  gncGG2Enable    ;external 'GNCPP';
 function  gncGG3Enable    ;external 'GNCPP';
 function  gncGG4Enable    ;external 'GNCPP';
 function  gncGG171819Enabl;external 'GNCPP';
 function  gncGAEnable     ;external 'GNCPP';
 function  gncGBEnable     ;external 'GNCPP';
 function  gncGCEnable     ;external 'GNCPP';
 function  gncGIEnable     ;external 'GNCPP';
 function  gncGJEnable     ;external 'GNCPP';
 function  gncGKEnable     ;external 'GNCPP';
 function  gncGXEnable     ;external 'GNCPP';
 function  gncGYEnable     ;external 'GNCPP';
 function  gncGZEnable     ;external 'GNCPP';
 function  gncGUEnable     ;external 'GNCPP';
 function  gncGVEnable     ;external 'GNCPP';
 function  gncGWEnable     ;external 'GNCPP';
 function  gncGFEnable     ;external 'GNCPP';
 function  gncGSEnable     ;external 'GNCPP';
 function  gncGSLEnable    ;external 'GNCPP';
 function  gncGWLEnable    ;external 'GNCPP';
 function  gncGTLEnable    ;external 'GNCPP';
 function  gncGSTEnable    ;external 'GNCPP';
 function  gncGWTEnable    ;external 'GNCPP';
 function  gncGTTEnable    ;external 'GNCPP';
 function  gncGSCEnable    ;external 'GNCPP';
 function  gncGWCEnable    ;external 'GNCPP';
 function  gncGTCEnable    ;external 'GNCPP';
 function  gncGDSLEnable   ;external 'GNCPP';
 function  gncGDWLEnable   ;external 'GNCPP';
 function  gncGDTLEnable   ;external 'GNCPP';
 function  gncGDSTEnable   ;external 'GNCPP';
 function  gncGDWTEnable   ;external 'GNCPP';
 function  gncGDTTEnable   ;external 'GNCPP';
 function  gncGDSCEnable   ;external 'GNCPP';
 function  gncGDWCEnable   ;external 'GNCPP';
 function  gncGDTCEnable   ;external 'GNCPP';
 function  gncGG0Optim     ;external 'GNCPP';
 function  gncGG1Optim     ;external 'GNCPP';
 function  gncGG2Optim     ;external 'GNCPP';
 function  gncGG3Optim     ;external 'GNCPP';
 function  gncGG4Optim     ;external 'GNCPP';
 function  gncGG171819Optim;external 'GNCPP';
 function  gncGAOptim      ;external 'GNCPP';
 function  gncGBOptim      ;external 'GNCPP';
 function  gncGCOptim      ;external 'GNCPP';
 function  gncGIOptim      ;external 'GNCPP';
 function  gncGJOptim      ;external 'GNCPP';
 function  gncGKOptim      ;external 'GNCPP';
 function  gncGXOptim      ;external 'GNCPP';
 function  gncGYOptim      ;external 'GNCPP';
 function  gncGZOptim      ;external 'GNCPP';
 function  gncGUOptim      ;external 'GNCPP';
 function  gncGVOptim      ;external 'GNCPP';
 function  gncGWOptim      ;external 'GNCPP';
 function  gncGFOptim      ;external 'GNCPP';
 function  gncGSOptim      ;external 'GNCPP';
 function  gncGSLOptim     ;external 'GNCPP';
 function  gncGWLOptim     ;external 'GNCPP';
 function  gncGTLOptim     ;external 'GNCPP';
 function  gncGSTOptim     ;external 'GNCPP';
 function  gncGWTOptim     ;external 'GNCPP';
 function  gncGTTOptim     ;external 'GNCPP';
 function  gncGSCOptim     ;external 'GNCPP';
 function  gncGWCOptim     ;external 'GNCPP';
 function  gncGTCOptim     ;external 'GNCPP';
 function  gncGDSLOptim    ;external 'GNCPP';
 function  gncGDWLOptim    ;external 'GNCPP';
 function  gncGDTLOptim    ;external 'GNCPP';
 function  gncGDSTOptim    ;external 'GNCPP';
 function  gncGDWTOptim    ;external 'GNCPP';
 function  gncGDTTOptim    ;external 'GNCPP';
 function  gncGDSCOptim    ;external 'GNCPP';
 function  gncGDWCOptim    ;external 'GNCPP';
 function  gncGDTCOptim    ;external 'GNCPP';
 function  gncGRSeparator1 ;external 'GNCPP';
 function  gncGRProcessor  ;external 'GNCPP';
 function  gncGRTools      ;external 'GNCPP';
 function  gncGRName       ;external 'GNCPP';
 function  gncGRProcessBy  ;external 'GNCPP';
 function  gncGRUserName   ;external 'GNCPP';
 function  gncGRUserComp   ;external 'GNCPP';
 function  gncGRSerialNr   ;external 'GNCPP';
 function  gncGRProcessDate;external 'GNCPP';
 function  gncGRProcessHour;external 'GNCPP';
 function  gncGRAppName    ;external 'GNCPP';
 function  gncGRCfgFile    ;external 'GNCPP';
 function  gncGRSeparator2 ;external 'GNCPP';
 function  gncGRSpeedLength;external 'GNCPP';
 function  gncGRWorkLength ;external 'GNCPP';
 function  gncGRTotalLength;external 'GNCPP';
 function  gncGRSpeedTime  ;external 'GNCPP';
 function  gncGRWorkTime   ;external 'GNCPP';
 function  gncGRTotalTime  ;external 'GNCPP';
 function  gncGRSpeedCost  ;external 'GNCPP';
 function  gncGRWorkCost   ;external 'GNCPP';
 function  gncGRTotalCost  ;external 'GNCPP';
 function  gncGRNrOfLines  ;external 'GNCPP';
 function  gncGRNrOfBytes  ;external 'GNCPP';
 function  gncGROptimizing ;external 'GNCPP';
 function  gncGRSeparator3 ;external 'GNCPP';
 function  gncGOSeparator1 ;external 'GNCPP';
 function  gncGOProcessor  ;external 'GNCPP';
 function  gncGOTools      ;external 'GNCPP';
 function  gncGOName       ;external 'GNCPP';
 function  gncGOProcessBy  ;external 'GNCPP';
 function  gncGOUserName   ;external 'GNCPP';
 function  gncGOUserComp   ;external 'GNCPP';
 function  gncGOSerialNr   ;external 'GNCPP';
 function  gncGOProcessDate;external 'GNCPP';
 function  gncGOProcessHour;external 'GNCPP';
 function  gncGOAppName    ;external 'GNCPP';
 function  gncGOCfgFile    ;external 'GNCPP';
 function  gncGOSeparator2 ;external 'GNCPP';
 function  gncGOSpeedLength;external 'GNCPP';
 function  gncGOWorkLength ;external 'GNCPP';
 function  gncGOTotalLength;external 'GNCPP';
 function  gncGOSpeedTime  ;external 'GNCPP';
 function  gncGOWorkTime   ;external 'GNCPP';
 function  gncGOTotalTime  ;external 'GNCPP';
 function  gncGOSpeedCost  ;external 'GNCPP';
 function  gncGOWorkCost   ;external 'GNCPP';
 function  gncGOTotalCost  ;external 'GNCPP';
 function  gncGONrOfLines  ;external 'GNCPP';
 function  gncGONrOfBytes  ;external 'GNCPP';
 function  gncGOOptimizing ;external 'GNCPP';
 function  gncGOSeparator3 ;external 'GNCPP';
 function  gncGCSeparator1 ;external 'GNCPP';
 function  gncGCProcessor  ;external 'GNCPP';
 function  gncGCTools      ;external 'GNCPP';
 function  gncGCName       ;external 'GNCPP';
 function  gncGCUserName   ;external 'GNCPP';
 function  gncGCUserComp   ;external 'GNCPP';
 function  gncGCSerialNr   ;external 'GNCPP';
 function  gncGCProcessBy  ;external 'GNCPP';
 function  gncGCProcessDate;external 'GNCPP';
 function  gncGCProcessHour;external 'GNCPP';
 function  gncGCAppName    ;external 'GNCPP';
 function  gncGCCfgFile    ;external 'GNCPP';
 function  gncGCSeparator2 ;external 'GNCPP';
 function  gncGCSpeedLength;external 'GNCPP';
 function  gncGCWorkLength ;external 'GNCPP';
 function  gncGCTotalLength;external 'GNCPP';
 function  gncGCSpeedTime  ;external 'GNCPP';
 function  gncGCWorkTime   ;external 'GNCPP';
 function  gncGCTotalTime  ;external 'GNCPP';
 function  gncGCSpeedCost  ;external 'GNCPP';
 function  gncGCWorkCost   ;external 'GNCPP';
 function  gncGCTotalCost  ;external 'GNCPP';
 function  gncGCNrOfLines  ;external 'GNCPP';
 function  gncGCNrOfBytes  ;external 'GNCPP';
 function  gncGCOptimizing ;external 'GNCPP';
 function  gncGCSeparator3 ;external 'GNCPP';

{CNC.Constraints}
 procedure gncPCNCOut      ;external 'GNCPP';
 procedure gncPDXFOut      ;external 'GNCPP';
 procedure gncPRepOut      ;external 'GNCPP';
 procedure gncPNameDigitNr ;external 'GNCPP';
 procedure gncPLongName    ;external 'GNCPP';
 procedure gncPExtension   ;external 'GNCPP';
 procedure gncPOptFilter   ;external 'GNCPP';
 procedure gncPBreakKilo   ;external 'GNCPP';
 procedure gncPMaxKilo     ;external 'GNCPP';
 procedure gncPMaxLine     ;external 'GNCPP';
 procedure gncPOutValue    ;external 'GNCPP';
 procedure gncPAutoBreak   ;external 'GNCPP';
 procedure gncPCondensedOut;external 'GNCPP';
 procedure gncPIndentedOut ;external 'GNCPP';
 procedure gncPEnable2Half ;external 'GNCPP';
 procedure gncPFrontal     ;external 'GNCPP';
 procedure gncPRelative    ;external 'GNCPP';
 procedure gncPDecimalNr   ;external 'GNCPP';
 procedure gncPG2G3        ;external 'GNCPP';
 procedure gncPG2G3Radius  ;external 'GNCPP';
 procedure gncPG2G3FullOut ;external 'GNCPP';
 procedure gncPG171819Info ;external 'GNCPP';
 procedure gncPG0AutoPurge ;external 'GNCPP';
 procedure gncPG0AutoPut   ;external 'GNCPP';
 procedure gncPG0ZCote     ;external 'GNCPP';
 procedure gncPG0Switch    ;external 'GNCPP';
 procedure gncPSHourCost   ;external 'GNCPP';
 procedure gncPWHourCost   ;external 'GNCPP';
 procedure gncPMoneySign   ;external 'GNCPP';
 procedure gncPRepTechCfg  ;external 'GNCPP';
 procedure gncPRepProtect  ;external 'GNCPP';
 procedure gncPFAdress     ;external 'GNCPP';
 procedure gncPSAdress     ;external 'GNCPP';
 procedure gncPFastAdvance ;external 'GNCPP';
 procedure gncPMotor       ;external 'GNCPP';
 procedure gncPLiquid      ;external 'GNCPP';
 procedure gncPAbsRel      ;external 'GNCPP';
 procedure gncPLineComment ;external 'GNCPP';
 procedure gncPTechComment ;external 'GNCPP';
 procedure gncPEnableTR3D  ;external 'GNCPP';
 procedure gncPXID         ;external 'GNCPP';
 procedure gncPYJD         ;external 'GNCPP';
 procedure gncPZKD         ;external 'GNCPP';
 procedure gncPXIS         ;external 'GNCPP';
 procedure gncPYJS         ;external 'GNCPP';
 procedure gncPZKS         ;external 'GNCPP';
 procedure gncPAdaptive    ;external 'GNCPP';
 procedure gncPFrVSRad     ;external 'GNCPP';
 procedure gncPZWear       ;external 'GNCPP';
 procedure gncPFWear       ;external 'GNCPP';
 procedure gncPTypeLine    ;external 'GNCPP';
 procedure gncPEquip       ;external 'GNCPP';
 procedure gncPAlternate   ;external 'GNCPP';
 procedure gncPColorInit   ;external 'GNCPP';
 procedure gncPNSeparator  ;external 'GNCPP';
 procedure gncPStartLine   ;external 'GNCPP';
 procedure gncPStepLine    ;external 'GNCPP';
 procedure gncPStartPrg    ;external 'GNCPP';
 procedure gncPStepPrg     ;external 'GNCPP';
 procedure gncPStartFile   ;external 'GNCPP';
 procedure gncPStepFile    ;external 'GNCPP';
 procedure gncPDecimalPoint;external 'GNCPP';
 procedure gncPAtrSign     ;external 'GNCPP';
 procedure gncPAssSign     ;external 'GNCPP';
 procedure gncPVariableName;external 'GNCPP';
 procedure gncPNDigit      ;external 'GNCPP';
 procedure gncPVDigit      ;external 'GNCPP';
 procedure gncPNSign       ;external 'GNCPP';
 procedure gncPCountLine   ;external 'GNCPP';
 procedure gncPBracketsON  ;external 'GNCPP';
 procedure gncPBracketsOFF ;external 'GNCPP';
 procedure gncPCommentON   ;external 'GNCPP';
 procedure gncPCommentOFF  ;external 'GNCPP';
 procedure gncPMotorON     ;external 'GNCPP';
 procedure gncPMotorOFF    ;external 'GNCPP';
 procedure gncPLiquidON    ;external 'GNCPP';
 procedure gncPLiquidOFF   ;external 'GNCPP';
 procedure gncPMAbsolute   ;external 'GNCPP';
 procedure gncPMRelative   ;external 'GNCPP';
 procedure gncPEndOfLine   ;external 'GNCPP';
 procedure gncPStartStr    ;external 'GNCPP';
 procedure gncPEndStr      ;external 'GNCPP';
 procedure gncPG0Sign      ;external 'GNCPP';
 procedure gncPG1Sign      ;external 'GNCPP';
 procedure gncPG2Sign      ;external 'GNCPP';
 procedure gncPG3Sign      ;external 'GNCPP';
 procedure gncPG4Sign      ;external 'GNCPP';
 procedure gncPG17Sign     ;external 'GNCPP';
 procedure gncPG18Sign     ;external 'GNCPP';
 procedure gncPG19Sign     ;external 'GNCPP';
 procedure gncPASign       ;external 'GNCPP';
 procedure gncPBSign       ;external 'GNCPP';
 procedure gncPCSign       ;external 'GNCPP';
 procedure gncPISign       ;external 'GNCPP';
 procedure gncPJSign       ;external 'GNCPP';
 procedure gncPKSign       ;external 'GNCPP';
 procedure gncPXSign       ;external 'GNCPP';
 procedure gncPYSign       ;external 'GNCPP';
 procedure gncPZSign       ;external 'GNCPP';
 procedure gncPUSign       ;external 'GNCPP';
 procedure gncPVSign       ;external 'GNCPP';
 procedure gncPWSign       ;external 'GNCPP';
 procedure gncPFSign       ;external 'GNCPP';
 procedure gncPSSign       ;external 'GNCPP';
 procedure gncPSLSign      ;external 'GNCPP';
 procedure gncPWLSign      ;external 'GNCPP';
 procedure gncPTLSign      ;external 'GNCPP';
 procedure gncPSTSign      ;external 'GNCPP';
 procedure gncPWTSign      ;external 'GNCPP';
 procedure gncPTTSign      ;external 'GNCPP';
 procedure gncPSCSign      ;external 'GNCPP';
 procedure gncPWCSign      ;external 'GNCPP';
 procedure gncPTCSign      ;external 'GNCPP';
 procedure gncPDSLSign     ;external 'GNCPP';
 procedure gncPDWLSign     ;external 'GNCPP';
 procedure gncPDTLSign     ;external 'GNCPP';
 procedure gncPDSTSign     ;external 'GNCPP';
 procedure gncPDWTSign     ;external 'GNCPP';
 procedure gncPDTTSign     ;external 'GNCPP';
 procedure gncPDSCSign     ;external 'GNCPP';
 procedure gncPDWCSign     ;external 'GNCPP';
 procedure gncPDTCSign     ;external 'GNCPP';
 procedure gncPG0Enable    ;external 'GNCPP';
 procedure gncPG1Enable    ;external 'GNCPP';
 procedure gncPG2Enable    ;external 'GNCPP';
 procedure gncPG3Enable    ;external 'GNCPP';
 procedure gncPG4Enable    ;external 'GNCPP';
 procedure gncPG171819Enabl;external 'GNCPP';
 procedure gncPAEnable     ;external 'GNCPP';
 procedure gncPBEnable     ;external 'GNCPP';
 procedure gncPCEnable     ;external 'GNCPP';
 procedure gncPIEnable     ;external 'GNCPP';
 procedure gncPJEnable     ;external 'GNCPP';
 procedure gncPKEnable     ;external 'GNCPP';
 procedure gncPXEnable     ;external 'GNCPP';
 procedure gncPYEnable     ;external 'GNCPP';
 procedure gncPZEnable     ;external 'GNCPP';
 procedure gncPUEnable     ;external 'GNCPP';
 procedure gncPVEnable     ;external 'GNCPP';
 procedure gncPWEnable     ;external 'GNCPP';
 procedure gncPFEnable     ;external 'GNCPP';
 procedure gncPSEnable     ;external 'GNCPP';
 procedure gncPSLEnable    ;external 'GNCPP';
 procedure gncPWLEnable    ;external 'GNCPP';
 procedure gncPTLEnable    ;external 'GNCPP';
 procedure gncPSTEnable    ;external 'GNCPP';
 procedure gncPWTEnable    ;external 'GNCPP';
 procedure gncPTTEnable    ;external 'GNCPP';
 procedure gncPSCEnable    ;external 'GNCPP';
 procedure gncPWCEnable    ;external 'GNCPP';
 procedure gncPTCEnable    ;external 'GNCPP';
 procedure gncPDSLEnable   ;external 'GNCPP';
 procedure gncPDWLEnable   ;external 'GNCPP';
 procedure gncPDTLEnable   ;external 'GNCPP';
 procedure gncPDSTEnable   ;external 'GNCPP';
 procedure gncPDWTEnable   ;external 'GNCPP';
 procedure gncPDTTEnable   ;external 'GNCPP';
 procedure gncPDSCEnable   ;external 'GNCPP';
 procedure gncPDWCEnable   ;external 'GNCPP';
 procedure gncPDTCEnable   ;external 'GNCPP';
 procedure gncPG0Optim     ;external 'GNCPP';
 procedure gncPG1Optim     ;external 'GNCPP';
 procedure gncPG2Optim     ;external 'GNCPP';
 procedure gncPG3Optim     ;external 'GNCPP';
 procedure gncPG4Optim     ;external 'GNCPP';
 procedure gncPG171819Optim;external 'GNCPP';
 procedure gncPAOptim      ;external 'GNCPP';
 procedure gncPBOptim      ;external 'GNCPP';
 procedure gncPCOptim      ;external 'GNCPP';
 procedure gncPIOptim      ;external 'GNCPP';
 procedure gncPJOptim      ;external 'GNCPP';
 procedure gncPKOptim      ;external 'GNCPP';
 procedure gncPXOptim      ;external 'GNCPP';
 procedure gncPYOptim      ;external 'GNCPP';
 procedure gncPZOptim      ;external 'GNCPP';
 procedure gncPUOptim      ;external 'GNCPP';
 procedure gncPVOptim      ;external 'GNCPP';
 procedure gncPWOptim      ;external 'GNCPP';
 procedure gncPFOptim      ;external 'GNCPP';
 procedure gncPSOptim      ;external 'GNCPP';
 procedure gncPSLOptim     ;external 'GNCPP';
 procedure gncPWLOptim     ;external 'GNCPP';
 procedure gncPTLOptim     ;external 'GNCPP';
 procedure gncPSTOptim     ;external 'GNCPP';
 procedure gncPWTOptim     ;external 'GNCPP';
 procedure gncPTTOptim     ;external 'GNCPP';
 procedure gncPSCOptim     ;external 'GNCPP';
 procedure gncPWCOptim     ;external 'GNCPP';
 procedure gncPTCOptim     ;external 'GNCPP';
 procedure gncPDSLOptim    ;external 'GNCPP';
 procedure gncPDWLOptim    ;external 'GNCPP';
 procedure gncPDTLOptim    ;external 'GNCPP';
 procedure gncPDSTOptim    ;external 'GNCPP';
 procedure gncPDWTOptim    ;external 'GNCPP';
 procedure gncPDTTOptim    ;external 'GNCPP';
 procedure gncPDSCOptim    ;external 'GNCPP';
 procedure gncPDWCOptim    ;external 'GNCPP';
 procedure gncPDTCOptim    ;external 'GNCPP';
 procedure gncPRSeparator1 ;external 'GNCPP';
 procedure gncPRProcessor  ;external 'GNCPP';
 procedure gncPRTools      ;external 'GNCPP';
 procedure gncPRName       ;external 'GNCPP';
 procedure gncPRProcessBy  ;external 'GNCPP';
 procedure gncPRUserName   ;external 'GNCPP';
 procedure gncPRUserComp   ;external 'GNCPP';
 procedure gncPRSerialNr   ;external 'GNCPP';
 procedure gncPRProcessDate;external 'GNCPP';
 procedure gncPRProcessHour;external 'GNCPP';
 procedure gncPRAppName    ;external 'GNCPP';
 procedure gncPRCfgFile    ;external 'GNCPP';
 procedure gncPRSeparator2 ;external 'GNCPP';
 procedure gncPRSpeedLength;external 'GNCPP';
 procedure gncPRWorkLength ;external 'GNCPP';
 procedure gncPRTotalLength;external 'GNCPP';
 procedure gncPRSpeedTime  ;external 'GNCPP';
 procedure gncPRWorkTime   ;external 'GNCPP';
 procedure gncPRTotalTime  ;external 'GNCPP';
 procedure gncPRSpeedCost  ;external 'GNCPP';
 procedure gncPRWorkCost   ;external 'GNCPP';
 procedure gncPRTotalCost  ;external 'GNCPP';
 procedure gncPRNrOfLines  ;external 'GNCPP';
 procedure gncPRNrOfBytes  ;external 'GNCPP';
 procedure gncPROptimizing ;external 'GNCPP';
 procedure gncPRSeparator3 ;external 'GNCPP';
 procedure gncPOSeparator1 ;external 'GNCPP';
 procedure gncPOProcessor  ;external 'GNCPP';
 procedure gncPOTools      ;external 'GNCPP';
 procedure gncPOName       ;external 'GNCPP';
 procedure gncPOProcessBy  ;external 'GNCPP';
 procedure gncPOUserName   ;external 'GNCPP';
 procedure gncPOUserComp   ;external 'GNCPP';
 procedure gncPOSerialNr   ;external 'GNCPP';
 procedure gncPOProcessDate;external 'GNCPP';
 procedure gncPOProcessHour;external 'GNCPP';
 procedure gncPOAppName    ;external 'GNCPP';
 procedure gncPOCfgFile    ;external 'GNCPP';
 procedure gncPOSeparator2 ;external 'GNCPP';
 procedure gncPOSpeedLength;external 'GNCPP';
 procedure gncPOWorkLength ;external 'GNCPP';
 procedure gncPOTotalLength;external 'GNCPP';
 procedure gncPOSpeedTime  ;external 'GNCPP';
 procedure gncPOWorkTime   ;external 'GNCPP';
 procedure gncPOTotalTime  ;external 'GNCPP';
 procedure gncPOSpeedCost  ;external 'GNCPP';
 procedure gncPOWorkCost   ;external 'GNCPP';
 procedure gncPOTotalCost  ;external 'GNCPP';
 procedure gncPONrOfLines  ;external 'GNCPP';
 procedure gncPONrOfBytes  ;external 'GNCPP';
 procedure gncPOOptimizing ;external 'GNCPP';
 procedure gncPOSeparator3 ;external 'GNCPP';
 procedure gncPCSeparator1 ;external 'GNCPP';
 procedure gncPCProcessor  ;external 'GNCPP';
 procedure gncPCTools      ;external 'GNCPP';
 procedure gncPCName       ;external 'GNCPP';
 procedure gncPCProcessBy  ;external 'GNCPP';
 procedure gncPCUserName   ;external 'GNCPP';
 procedure gncPCUserComp   ;external 'GNCPP';
 procedure gncPCSerialNr   ;external 'GNCPP';
 procedure gncPCProcessDate;external 'GNCPP';
 procedure gncPCProcessHour;external 'GNCPP';
 procedure gncPCAppName    ;external 'GNCPP';
 procedure gncPCCfgFile    ;external 'GNCPP';
 procedure gncPCSeparator2 ;external 'GNCPP';
 procedure gncPCSpeedLength;external 'GNCPP';
 procedure gncPCWorkLength ;external 'GNCPP';
 procedure gncPCTotalLength;external 'GNCPP';
 procedure gncPCSpeedTime  ;external 'GNCPP';
 procedure gncPCWorkTime   ;external 'GNCPP';
 procedure gncPCTotalTime  ;external 'GNCPP';
 procedure gncPCSpeedCost  ;external 'GNCPP';
 procedure gncPCWorkCost   ;external 'GNCPP';
 procedure gncPCTotalCost  ;external 'GNCPP';
 procedure gncPCNrOfLines  ;external 'GNCPP';
 procedure gncPCNrOfBytes  ;external 'GNCPP';
 procedure gncPCOptimizing ;external 'GNCPP';
 procedure gncPCSeparator3 ;external 'GNCPP';

 procedure gncPOutputDetailed;    {Set output detailed }
 begin
  gncPSLOptim ('Y');gncPSLEnable ('Y');
  gncPWLOptim ('Y');gncPWLEnable ('Y');
  gncPTLOptim ('Y');gncPTLEnable ('Y');
  gncPSTOptim ('Y');gncPSTEnable ('Y');
  gncPWTOptim ('Y');gncPWTEnable ('Y');
  gncPTTOptim ('Y');gncPTTEnable ('Y');
  gncPSCOptim ('Y');gncPSCEnable ('Y');
  gncPWCOptim ('Y');gncPWCEnable ('Y');
  gncPTCOptim ('Y');gncPTCEnable ('Y');
  gncPDSLOptim('Y');gncPDSLEnable('Y');
  gncPDWLOptim('Y');gncPDWLEnable('Y');
  gncPDTLOptim('Y');gncPDTLEnable('Y');
  gncPDSTOptim('Y');gncPDSTEnable('Y');
  gncPDWTOptim('Y');gncPDWTEnable('Y');
  gncPDTTOptim('Y');gncPDTTEnable('Y');
  gncPDSCOptim('Y');gncPDSCEnable('Y');
  gncPDWCOptim('Y');gncPDWCEnable('Y');
  gncPDTCOptim('Y');gncPDTCEnable('Y');
  gncPCondensedOut('N');
  gncPIndentedOut ('Y');
 end;

 procedure gncPOutputOptimal;     {Set output optimal  }
 begin
  gncPSLOptim ('N');gncPSLEnable ('N');
  gncPWLOptim ('N');gncPWLEnable ('N');
  gncPTLOptim ('N');gncPTLEnable ('N');
  gncPSTOptim ('N');gncPSTEnable ('N');
  gncPWTOptim ('N');gncPWTEnable ('N');
  gncPTTOptim ('N');gncPTTEnable ('N');
  gncPSCOptim ('N');gncPSCEnable ('N');
  gncPWCOptim ('N');gncPWCEnable ('N');
  gncPTCOptim ('N');gncPTCEnable ('N');
  gncPDSLOptim('N');gncPDSLEnable('N');
  gncPDWLOptim('N');gncPDWLEnable('N');
  gncPDTLOptim('N');gncPDTLEnable('N');
  gncPDSTOptim('N');gncPDSTEnable('N');
  gncPDWTOptim('N');gncPDWTEnable('N');
  gncPDTTOptim('N');gncPDTTEnable('N');
  gncPDSCOptim('N');gncPDSCEnable('N');
  gncPDWCOptim('N');gncPDWCEnable('N');
  gncPDTCOptim('N');gncPDTCEnable('N');
  gncPCondensedOut('Y');
  gncPIndentedOut ('N');
 end;

 procedure gncPEnableTechNC;      {Enable tech comment }
 begin
  gncPCSeparator1  ('Y');
  gncPCProcessor   ('Y');
  gncPCTools       ('Y');
  gncPCName        ('Y');
  gncPCProcessBy   ('Y');
  gncPCUserName    ('Y');
  gncPCUserComp    ('Y');
  gncPCSerialNr    ('Y');
  gncPCProcessDate ('Y');
  gncPCProcessHour ('Y');
  gncPCAppName     ('Y');
  gncPCCfgFile     ('Y');
  gncPCSeparator2  ('Y');
  gncPCSpeedLength ('Y');
  gncPCWorkLength  ('Y');
  gncPCTotalLength ('Y');
  gncPCSpeedTime   ('Y');
  gncPCWorkTime    ('Y');
  gncPCTotalTime   ('Y');
  gncPCSpeedCost   ('Y');
  gncPCWorkCost    ('Y');
  gncPCTotalCost   ('Y');
  gncPCNrOfLines   ('Y');
  gncPCNrOfBytes   ('Y');
  gncPCOptimizing  ('Y');
  gncPCSeparator3  ('Y');
 end;

 procedure gncPDisableTechNC;     {Disable tech comment}
 begin
  gncPCSeparator1  ('N');
  gncPCProcessor   ('N');
  gncPCTools       ('N');
  gncPCName        ('N');
  gncPCProcessBy   ('N');
  gncPCUserName    ('N');
  gncPCUserComp    ('N');
  gncPCSerialNr    ('N');
  gncPCProcessDate ('N');
  gncPCProcessHour ('N');
  gncPCAppName     ('N');
  gncPCCfgFile     ('N');
  gncPCSeparator2  ('N');
  gncPCSpeedLength ('N');
  gncPCWorkLength  ('N');
  gncPCTotalLength ('N');
  gncPCSpeedTime   ('N');
  gncPCWorkTime    ('N');
  gncPCTotalTime   ('N');
  gncPCSpeedCost   ('N');
  gncPCWorkCost    ('N');
  gncPCTotalCost   ('N');
  gncPCNrOfLines   ('N');
  gncPCNrOfBytes   ('N');
  gncPCOptimizing  ('N');
  gncPCSeparator3  ('N');
 end;

 procedure gncPEnableTechPartial; {Enable tech comment }
 begin
  gncPRSeparator1  ('Y');
  gncPRProcessor   ('Y');
  gncPRTools       ('Y');
  gncPRName        ('Y');
  gncPRProcessBy   ('Y');
  gncPRUserName    ('Y');
  gncPRUserComp    ('Y');
  gncPRSerialNr    ('Y');
  gncPRProcessDate ('Y');
  gncPRProcessHour ('Y');
  gncPRAppName     ('Y');
  gncPRCfgFile     ('Y');
  gncPRSeparator2  ('Y');
  gncPRSpeedLength ('Y');
  gncPRWorkLength  ('Y');
  gncPRTotalLength ('Y');
  gncPRSpeedTime   ('Y');
  gncPRWorkTime    ('Y');
  gncPRTotalTime   ('Y');
  gncPRSpeedCost   ('Y');
  gncPRWorkCost    ('Y');
  gncPRTotalCost   ('Y');
  gncPRNrOfLines   ('Y');
  gncPRNrOfBytes   ('Y');
  gncPROptimizing  ('Y');
  gncPRSeparator3  ('Y');
 end;

 procedure gncPDisableTechPartial;{Disable tech comment}
 begin
  gncPRSeparator1  ('N');
  gncPRProcessor   ('N');
  gncPRTools       ('N');
  gncPRName        ('N');
  gncPRProcessBy   ('N');
  gncPRUserName    ('N');
  gncPRUserComp    ('N');
  gncPRSerialNr    ('N');
  gncPRProcessDate ('N');
  gncPRProcessHour ('N');
  gncPRAppName     ('N');
  gncPRCfgFile     ('N');
  gncPRSeparator2  ('N');
  gncPRSpeedLength ('N');
  gncPRWorkLength  ('N');
  gncPRTotalLength ('N');
  gncPRSpeedTime   ('N');
  gncPRWorkTime    ('N');
  gncPRTotalTime   ('N');
  gncPRSpeedCost   ('N');
  gncPRWorkCost    ('N');
  gncPRTotalCost   ('N');
  gncPRNrOfLines   ('N');
  gncPRNrOfBytes   ('N');
  gncPROptimizing  ('N');
  gncPRSeparator3  ('N');
 end;

 procedure gncPEnableTechOverall; {Enable tech comment }
 begin
  gncPOSeparator1  ('Y');
  gncPOProcessor   ('Y');
  gncPOTools       ('Y');
  gncPOName        ('Y');
  gncPOProcessBy   ('Y');
  gncPOUserName    ('Y');
  gncPOUserComp    ('Y');
  gncPOSerialNr    ('Y');
  gncPOProcessDate ('Y');
  gncPOProcessHour ('Y');
  gncPOAppName     ('Y');
  gncPOCfgFile     ('Y');
  gncPOSeparator2  ('Y');
  gncPOSpeedLength ('Y');
  gncPOWorkLength  ('Y');
  gncPOTotalLength ('Y');
  gncPOSpeedTime   ('Y');
  gncPOWorkTime    ('Y');
  gncPOTotalTime   ('Y');
  gncPOSpeedCost   ('Y');
  gncPOWorkCost    ('Y');
  gncPOTotalCost   ('Y');
  gncPONrOfLines   ('Y');
  gncPONrOfBytes   ('Y');
  gncPOOptimizing  ('Y');
  gncPOSeparator3  ('Y');
 end;

 procedure gncPDisableTechOverall;{Disable tech comment}
 begin
  gncPOSeparator1  ('N');
  gncPOProcessor   ('N');
  gncPOTools       ('N');
  gncPOName        ('N');
  gncPOProcessBy   ('N');
  gncPOUserName    ('N');
  gncPOUserComp    ('N');
  gncPOSerialNr    ('N');
  gncPOProcessDate ('N');
  gncPOProcessHour ('N');
  gncPOAppName     ('N');
  gncPOCfgFile     ('N');
  gncPOSeparator2  ('N');
  gncPOSpeedLength ('N');
  gncPOWorkLength  ('N');
  gncPOTotalLength ('N');
  gncPOSpeedTime   ('N');
  gncPOWorkTime    ('N');
  gncPOTotalTime   ('N');
  gncPOSpeedCost   ('N');
  gncPOWorkCost    ('N');
  gncPOTotalCost   ('N');
  gncPONrOfLines   ('N');
  gncPONrOfBytes   ('N');
  gncPOOptimizing  ('N');
  gncPOSeparator3  ('N');
 end;

procedure gncPAboutMe;
begin
 writeln;
 writeln;
 writeln('          ͻ');
 writeln('          ͻ          Name   :Dan MICSA                ');
 writeln('                  Company:?=>! BillaSoft           ');
 writeln('                  ͺStreet :Ghe.Doja Nr40            ');
 writeln('          ʻɻȻɻ City   :1900TIMISOARA            ');
 writeln('              Tel/Fax:04-056-196598            ');
 writeln('              www    :www.sororstm.ro\billasoft');
 writeln('          ͼȼͺeMail  :dmicsa@mb.sorostm.ro     ');
 writeln('          ͼ');
 writeln('          ͻ');
 writeln('             ͻɻ ͻͻͻ ͻ ͻ ͻͻͻ    ');
 writeln('                Ȼ                         ');
 writeln('                 ȹ   ͼͼ ͼ    ͼͼ      ');
 writeln('              ͻ                      Ȼ       ');
 writeln('                                      Ȼ      ');
 writeln('             ʼ         ͺͼ      ͼ    ');
 writeln('             Generic Numeric Control Post Processor V2.0    ');
 writeln('          ͼ');
 writeln;

{writing Info About GNCPP version}
 writeln('GNCPP Version:',gncGVer);

{writing Info About GNCPP access}
 writeln('GNCPP Access :',gncGAcc);
{writing Info About GNCPP access}
 writeln('GNCPP UsedBy :',AppName);

 writeln;

end;

begin

end.

