Unit do_mate;

(*
Ŀ
                         Unidad DO_MATE.PAS                                
Ĵ
   Versin             : 1.0                                               
   Computadora         : IBM-PC o compatible                               
   Lenguaje            : Turbo Pascal 5.5                                  
   Autor               : Bernardo Zamora Etcharren                         
Ĵ
   Explanation :                                                          
                                                        
   Contains mathematical functions used in evaluation of RPN function      
   (implements functions not present in pascal)                            
                                                                           

*)

INTERFACE

function GRADOS(rad:real):real;
{ receives radians and returns grades, ie grados(3.14159265)=180 }

function RAD(grados:real):real;
{ receives grades and returns radians, ie rad(180)=3.14159265 }

function EALA(x:real):real;
{ evaluates e elevated to x, ie eala(2)=e^2=2.718^2=7.38 }
{ used internally by the program }

function TAN(x:real):real;
{ sin(x)/cos(x) }

function ALA(base,potencia:real):real;
{ evaluates b^p, ie 2^3.1 -> ala(2,3.1) = 8.57 }
{ used internally by the program }

function ALAI(base:real;potencia:integer):real; { INTEGER EXPONENT }
{ evaluates b^p, integer exponent, ie 2^3 -> ala(2,3) = 8 }
{ used internally by the program }

function LOG(x:real):real;
{ evaluates the natural logarithm of a real number }

Function SGN(x:real):integer;
{ Returns the Sign of a number (-1,0,1) }


IMPLEMENTATION


function GRADOS(rad:real):real;
begin
  GRADOS := rad * 180 / PI;
end;

function RAD(grados:real):real;
begin
  RAD := grados * PI / 180;
end;

function EALA(x:real):real;
begin
  EALA := exp(x);
end;

function TAN(x:real):real;
begin
  TAN := SIN(x) /  COS(x);
end;

function ALA(base,potencia:real):real;
{ IF BASE < 0 THIS THING SUCKS }
begin
  ALA := exp(potencia * ln(base))
end;

function ALAI(base:real;potencia:integer):real; { INTEGER EXPONENT }
begin
  if base>0 then begin
    ALAI := exp(potencia * ln(base));
  end
  else if base<0 then begin
    ALAI := exp(potencia * ln(-base));
    if odd(potencia) then ALAI := -exp(potencia * ln(-base));
  end
  else {BASE=0}
    ALAI:=0;
end;

function LOG(x:real):real;
{ it might be accelerated using LN(10) as a constant }
begin
  LOG:=(ln (x) / ln (10) );
end;

Function SGN(x:real):integer;
begin
  sgn := 0;
  if x>0 then sgn:=1;
  if x<0 then sgn:=-1;
end;


begin
end.