
/*============================================================================

	DRVDRIV.H
	Disk device driver related stuff. Prototypes of DRVDRIV.ASM.
  This file is part of the

  PseudoCD package (version 02)
  Copyright (C) C.Kulms, 1997

  This is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This software is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this software; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

============================================================================*/

#ifndef _DRVDRIV_H_
#define _DRVDRIV_H_
#ifndef _DRIVER_H_
	#include "driver.h"
#endif

typedef struct s_DPB	/* Disk Parameter Block */
{
	char			cDisk;			/* DOS drive(r) number */
	char			cUnit;			/* sub-unit of disk's device-driver */
	unsigned	uBpS;				/* bytes per sector */
	char			cSpCmask;		/* sectors per cluster - 1 */
	char			cSpCshift;	/* sectors per cluster as shift-value */
	unsigned	uSecRsvd;		/* number of reserved sectors */
	char			cNumFAT;		/* number of FATs */
	unsigned	uNumRDE;		/* number Root Directory Entries */
	unsigned	uFirstSec;	/* first sector of data-area */
	unsigned	uMaxClu;		/* number of clusters */
	unsigned	uSpFAT;			/* sectors per FAT */
	unsigned	uRootSec;		/* first sector of root-directory */
	t_DRVHDR far	*fpDriverHeader;	/* pointer to disk's device-driver's header */
	char			cMedia;			/* disk's media-type */
	char			cAccessd;
	struct s_DPB far	*fpNextDPB;	/* pointer to next DPB */
	unsigned	uNextFree;	/* number of next free cluster (if <> 0FFFFh) */
	unsigned	uFree;			/* number of free clusters */
}	t_DPB;

/*
	lower functions; see file 'DRVDRIV.ASM'
*/
int GetDPB( char cDisk, t_DPB far *ptDPB );
void CallDriver( void far *fpStrat, void far *fpIntr, void far *pReq );

#endif /* ndef _DRVDRIV_H_ */

