' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE FUNCTION bMakeConnection (BYVAL nvIndexOfOrigin%, BYVAL nvGroupOfOrigin%, source AS CONTROL, BYVAL nvIndex%, BYVAL nvGroup%, Target AS FORM) AS INTEGER
DECLARE FUNCTION bConnectionWontWork% (nrIndex%, BYVAL nvGroupOfOrigin%, source AS CONTROL, BYVAL nvGroup%)
DECLARE SUB CalcReaction (BYVAL nvIndex%, Src AS FORM)
' Save as MolarMss.bas when compile.
'$FORM frmReaction
DECLARE SUB SwitchGeneral (BYVAL nvToFill%, BYVAL nvToEmpty%, BYVAL nvDistance%, BYVAL nvGroup%, Src AS FORM)
DECLARE SUB CommonDim ()
DECLARE SUB ShowXs (BYVAL nvGroup%, SourceForm AS FORM)
DECLARE SUB EvaluateFormula5 (BYVAL nvGroup%, SourceForm AS FORM)
DECLARE FUNCTION nDragDrop5Locate (X AS SINGLE, Y AS SINGLE, BYVAL nSize%, BYVAL nvGroup%, Target AS FORM) AS INTEGER
'$FORM frmIdealGas
DECLARE SUB CalculateMoles (BYVAL nvIndexM%, BYVAL nvIndexV%, BYVAL dvConvert AS DOUBLE, drMoles AS DOUBLE, drMolesUnc AS DOUBLE)
DECLARE SUB InfoShow (LastControl AS CONTROL, BYVAL svInfo AS STRING, BYVAL nvColor%)
'$FORM frmInfo
DECLARE FUNCTION bUnitConversion (BYVAL dvInNum AS DOUBLE, BYVAL dvInUnc AS DOUBLE, BYVAL nvUnitsIn%, BYVAL nvUnitsOut%, dOutNum AS DOUBLE, dOutUnc AS DOUBLE, nConvert%) AS INTEGER
DECLARE SUB GasOption (BYVAL Index%, Src AS FORM)
DECLARE SUB GasMoveVariable (BYVAL nvSize%)
'$FORM frmGas
DECLARE SUB SwitchTop (BYVAL nvFarRightIndex%, BYVAL nvGroup%, Src AS FORM)
DECLARE SUB SwitchBottom (BYVAL nvFarRightIndex%, BYVAL nvGroup%, Src AS FORM)
DECLARE FUNCTION nDragDrop6Locate (X AS SINGLE, Y AS SINGLE, BYVAL nSize%, BYVAL nvGroup%, Target AS FORM) AS INTEGER
DECLARE SUB EvaluateFormula6 (BYVAL nvGroup%, Src AS FORM)
DECLARE FUNCTION nOptionButton6 (Index%, BYVAL nvGroup%, CallingForm AS FORM) AS INTEGER
'$FORM frmTitration
DECLARE FUNCTION nDragDrop4Locate (X AS SINGLE, Y AS SINGLE, BYVAL nSize%, BYVAL nvGroup%, Target AS FORM) AS INTEGER
DECLARE SUB EvaluateFormula4 (BYVAL nvGroup%, SourceForm AS FORM)
'formGone'$FORM frmDilution
DECLARE FUNCTION nGetConnectColor () AS INTEGER
'$FORM frmchoose
DECLARE SUB EvaluateFormulaPct (BYVAL nvGroup%, SourceForm AS FORM)
'$FORM frmPercent
DECLARE FUNCTION nSetNextFocus (BYVAL nvIndex%) AS INTEGER
DECLARE SUB Disconnect (BYVAL nvIndex%)
'formgone'$FORM frmMolarity
'$FORM frmMdi
'$FORM frmMolarMass
'$FORM frmGramMole
'formGone'$FORM frmDensity
DECLARE SUB EvaluateFormula3 (BYVAL nvGroup%, SourceForm AS FORM)
DECLARE FUNCTION nOptionButton (Index%, BYVAL nvGroup%, CallingForm AS FORM) AS INTEGER
DECLARE SUB NextFocus (BYVAL nvIndex%, nrNextIndex%)
DECLARE SUB CalculateFormula (BYVAL Index%)
DECLARE SUB NumberFormat (BYVAL dNumber AS DOUBLE, BYVAL dStdDev AS DOUBLE, BYVAL TabStop%, srMsg AS STRING, rPrintX AS INTEGER)
DECLARE FUNCTION nGroupOfIndex (BYVAL Index AS INTEGER) AS INTEGER
DECLARE FUNCTION bAnalyzeInput (BYVAL sText AS STRING, dNumber AS DOUBLE, dError AS DOUBLE) AS INTEGER
DECLARE SUB AddThousandsSeparators (srNeedCommas AS STRING, nrDecimalPosition%)
OPTION EXPLICIT
DEFINT A-Z

'$INCLUDE: 'common.bi'
DIM SHARED msCustomName AS STRING * 3
DIM SHARED mlCustomMass AS DOUBLE
DIM SHARED mfCustomUncertainty AS SINGLE

TYPE Position
   X AS INTEGER
   Y AS INTEGER
END TYPE
DIM SHARED mLocation() AS Position          ' Positions of controls in form.
DIM SHARED mLocation4(2, 7) AS Position  ' Positions of controls in dilution.
'DIM SHARED mLocation4() AS Position ' Positions of controls in dilution.

TYPE FormLocations
   Group AS INTEGER        ' Non-zero if group is loaded.
   Left AS INTEGER
   Top AS INTEGER          ' Initial location of form on showing.
   SmallLeft AS INTEGER
   SmallTop AS INTEGER     ' Initial location of top of form when small.
END TYPE
DIM SHARED mFormPosition() AS FormLocations

' These variables remember the last positions of the forms.
DIM SHARED mnBigTop(), mnBigLeft(), mnLittleTop(), mnLittleLeft()

' Contains percent's property and units when connected.
' Used by DragDrop3 & DragDropPct
DIM SHARED msPercentProperty AS STRING
DIM SHARED mnPercentUnits
DIM SHARED mnUnits()

' Try making strings dynamic arrays to save space.
DIM SHARED msFormula() AS STRING  ' Contains the formulas to display in connected controls.
DIM SHARED msConversion() AS STRING

DIM SHARED mnIndexOfPropertyMatch() ' Used in DragDrop4, and in GasMoveVariable
DIM SHARED mnHide()
DIM SHARED mnRPressureUnits, mnRVolumeUnits

'CONST TITLEBAR_BACKCOLOR = 16

' BackColor, ForeColor (form, controls)
CONST BLUE = 1
CONST GREEN = 2
CONST RED = 4
CONST MAGENTA = 5
CONST BROWN = 6
CONST GRAY = 8
CONST BRIGHT_BLUE = 9
CONST BRIGHT_GREEN = 10
CONST BRIGHT_CYAN = 11
CONST BRIGHT_RED = 12
CONST PINK = 13
CONST BRIGHT_WHITE = 15

CONST BLACK = 0
CONST CYAN = 3
CONST WHITE = 7
CONST YELLOW = 14

CONST ENTER = 0
CONST LEAVE = 1

CONST WILDCARD = 0
CONST GRAM_PER_MOLE = 1  ' Units of the variables.
CONST GRAM = 2
CONST MOLE = 3
CONST GRAM_PER_ML = 4
CONST ML = 5
CONST MOLE_PER_L = 6
CONST LITER = 7
CONST percent = 8
CONST KELVIN = 9
CONST CELSIUS = 10
CONST FAHRENHEIT = 11
CONST PA = 12
CONST KPA = 13
CONST BAR = 14
CONST ATM = 15
CONST MMHG = 16
CONST TORR = 17
CONST PSI = 18

' Assigns the formulas displayed on connecting for frmGas.
'      Input:  nvEquation     Which set of equations to use.
'  Called by:  frmGas.cmdVariables_Click, frmGas_FormLoad
'  Module level variables:  msFormula
'        Global variables:
'
SUB AssignGasFormulas (BYVAL nvEquation)
   SELECT CASE nvEquation
      CASE 1   ' P, T
         msFormula(27) = "P1 = P2 * T1 / T2"
         msFormula(28) = "P2 = P1 * T2 / T1"
         msFormula(31) = "T2 = T1 * P2 / P1"
         msFormula(32) = "T1 = T2 * P1 / P2"
      CASE 2   ' P, V
         msFormula(27) = "P1 = P2 * V2 / V1"
         msFormula(28) = "P2 = P1 * V1 / V2"
         msFormula(26) = "V2 = V1 * P1 / P2"
         msFormula(29) = "V1 = P2 * V2 / P1"
      CASE 3   ' P, n
         msFormula(27) = "P1 = P2 * n1 / n2"
         msFormula(28) = "P2 = P1 * n2 / n1"
         msFormula(30) = "n1 = n2 * P1 / P2"
         msFormula(33) = "n2 = n1 * P2 / P1"
      CASE 4   ' T, V
         msFormula(26) = "V2 = V1 * T2 / T1"
         msFormula(29) = "V1 = V2 * T1 / T2"
         msFormula(31) = "T2 = T1 * V2 / V1"
         msFormula(32) = "T1 = T2 * V1 / V2"
      CASE 5   ' T, n
         msFormula(30) = "n1 = n2 * T2 / T1"
         msFormula(31) = "T2 = T1 * n1 / n2"
         msFormula(32) = "T1 = T2 * n2 / n1"
         msFormula(33) = "n2 = n1 * T1 / T2"
      CASE 6   ' V, n
         msFormula(26) = "V2 = V1 * n2 / n1"
         msFormula(29) = "V1 = V2 * n1 / n2"
         msFormula(30) = "n1 = n2 * V1 / V2"
         msFormula(33) = "n2 = n1 * V2 / V1"
   END SELECT
END SUB

FUNCTION bConnectionWontWork (nrIndex, BYVAL nvGroupOfOrigin, source AS CONTROL, BYVAL nvGroup)
DIM nIndex

' Destination must be a valid formula.
IF gbBadFormula(nvGroup) THEN
   InfoShow Screen.ActiveControl, "Destination is not a valid formula.", BRIGHT_WHITE
   bConnectionWontWork = TRUE
   EXIT FUNCTION
END IF

' Incoming variable must be part of a valid formula.
IF gbBadFormula(nvGroupOfOrigin) THEN
   ' Variable being dropped is not part of a valid formula.  Abandon ship.
   InfoShow Screen.ActiveControl, "Incoming variable not in a valid equation.", BRIGHT_WHITE
   bConnectionWontWork = TRUE
   EXIT FUNCTION
END IF
 
nrIndex = VAL(LEFT$(source.Tag, 2))
' Check that incoming control is a dependent variable.
IF LTRIM$(source.Parent.lblVariable(nrIndex).Tag) <> "0" THEN
   ' Variable being dropped is not a dependent variable.  Abandon ship.
   InfoShow Screen.ActiveControl, "Incoming variable must be dependent variable (left of equal sign).", BRIGHT_WHITE
   bConnectionWontWork = TRUE
   EXIT FUNCTION
END IF

END FUNCTION

' Evaluates a potential connection and makes it if ok.
'  Input:      nvIndexOfOrigin   Index of incoming control
'              nvGroupOfOrigin   Group of incoming control
'              Source            Incoming control
'              nvIndex           Index of target control
'              nvGroup           Group of target control
'              Target            Form of target control
'
'  Returns:    True if connection successful, or if error message displayed.
'              (False if connection fails, but want calling sub to handle it.)
'  Called by:  DragDrop3, DragDropPct
'  Module level variables:  mnPercentUnits, mnUnits, mnPercentUnits
'                           msFormula, msConversion
'        Global variables:  gbBadFormula, gOccupantIndex, gnUserChoice
'                           gnConnected, gdNumber, gdUncertainty
'
FUNCTION bMakeConnection (BYVAL nvIndexOfOrigin, BYVAL nvGroupOfOrigin, source AS CONTROL, BYVAL nvIndex, BYVAL nvGroup, Target AS FORM) AS INTEGER
DIM nIndependent, nDependent
DIM nUnitIn, nUnitOut, sConvert AS STRING
DIM nConnectColor, nConversionIndex
DIM bError, bReactionConnection, nNextGroup, nReactionGroup
DIM bPercentFlag, sPreviousPercentProperty AS STRING, nPreviousPercentUnits

' Check for circular connection.
' A circular connection is present if the target is connected
' to an independent variable ... connected to dependent connected
' to independent ... connected to the source.
nIndependent = nvIndex    ' Start with the target independent variable.
DO
   nNextGroup = nGroupOfIndex(nIndependent)
   IF nNextGroup = nvGroupOfOrigin THEN
      ' Circular connection.  Abandon ship.
      gnUserChoice = 99    ' Indicates form is for song.
      frmchoose.SHOW 1
      bMakeConnection = 1    ' Function value on exit.
      EXIT FUNCTION
   ELSEIF nNextGroup > 8 THEN
      ' A connection involves the reaction group, which requires further analysis.
      bReactionConnection = TRUE
   END IF

   ' Get that group's dependent variable.
   nDependent = gOccupantIndex(nNextGroup, 0)
   ' Get independent variable to which that group is connected.
   nIndependent = gnConnected(nDependent)

LOOP UNTIL nIndependent = 0   ' Quit when find unconnected dependent variable.

' Remove previous connection on target.
IF gnConnected(nvIndex) THEN Disconnect nvIndex

' Remove previous connection to source.
IF gnConnected(nvIndexOfOrigin) THEN Disconnect gnConnected(nvIndexOfOrigin)

'**************** Determine if units need to be converted (1) ***************
' Had to put this ahead of making the connection.
IF (nvIndexOfOrigin = 10 OR nvIndexOfOrigin = 11) AND gnConnected(11) = 0 AND gnConnected(10) = 0 THEN
   ' If none of percent's variables are connected, give percent new units.

   ' Save original values, so can restore if circular connection.
   bPercentFlag = TRUE
   sPreviousPercentProperty = msPercentProperty
   nPreviousPercentUnits = mnPercentUnits

   msPercentProperty = Target.txtVariable(nvIndex).Tag
   mnPercentUnits = mnUnits(nvIndex)
END IF

IF (nvIndex = 10 OR nvIndex = 11) AND (gnConnected(10) OR gnConnected(11)) THEN
   ' The target is whole or part of percent, and one of those is connected.
   ' Check that the units of percent are the same as units in source.
   nUnitOut = mnPercentUnits
ELSE
   nUnitOut = mnUnits(nvIndex)
END IF

' Make the connection.  Connection of, say, txtVariable(1) to
' txtVariable(6) is indicated by setting
'          gnConnected(1) = 6 and gnConnected(6) = 1.
gnConnected(nvIndex) = nvIndexOfOrigin    ' Target independent variable.
gnConnected(nvIndexOfOrigin) = nvIndex

IF bReactionConnection = TRUE THEN     ' Analyze reaction connections.
   FOR nReactionGroup = 9 TO 14
      ' Start with first independent connected variable (if any).
      nIndependent = gnConnected(gOccupantIndex(nReactionGroup, 0))
      DO UNTIL nIndependent = 0
         nNextGroup = nGroupOfIndex(nIndependent)
         IF nNextGroup > 8 AND nNextGroup < 12 THEN
            ' Circular connection.  Abandon ship.
            gnUserChoice = 99    ' Indicates form is for song.
            frmchoose.SHOW 1
            IF bPercentFlag THEN
               msPercentProperty = sPreviousPercentProperty
               mnPercentUnits = nPreviousPercentUnits
            END IF
            bMakeConnection = 1    ' Function value on exit.
            Disconnect nvIndex
            EXIT FUNCTION
         END IF

         ' Get that group's dependent variable.
         nDependent = gOccupantIndex(nNextGroup, 0)
         ' Get independent variable to which that group is connected.
         nIndependent = gnConnected(nDependent)

      LOOP    ' Quit when find unconnected dependent variable.
   NEXT nReactionGroup
END IF

nConnectColor = nGetConnectColor
source.Parent.lblVariable(nvIndexOfOrigin).BackColor = nConnectColor
Target.lblVariable(nvIndex).BackColor = nConnectColor

'**************** Determine if units need to be converted (2) ***************
IF nvIndexOfOrigin = 10 OR nvIndexOfOrigin = 11 THEN
   nUnitIn = mnPercentUnits
ELSE
   nUnitIn = mnUnits(nvIndexOfOrigin)
END IF

bError = bUnitConversion(gdNumber(nvIndexOfOrigin), gdUncertainty(nvIndexOfOrigin), nUnitIn, nUnitOut, gdNumber(nvIndex), gdUncertainty(nvIndex), nConversionIndex)

IF nvGroup > 8 THEN
   CalcReaction nvIndex, frmReaction
ELSE
   CalculateFormula nvIndex
END IF

' Display formula in connected variable.
Target.txtVariable(nvIndex).Text = msFormula(nvIndexOfOrigin)

' Tell user about conversion.
IF nConversionIndex > 0 THEN
   sConvert = "The conversion" + CHR$(10) + msConversion(nConversionIndex) + CHR$(10) + "has been applied" + CHR$(10) + "to the connection."
   MSGBOX sConvert, 0, "Making Connection"
END IF

IF nvIndexOfOrigin = 24 OR nvIndexOfOrigin = 25 THEN
   Disconnect nvIndex
END IF

bMakeConnection = TRUE    ' Function value on exit.
END FUNCTION

' Calculate the value of the dependent variable associated with any
' independent variable.  Place the value in txtVariable(Index).
' If the dependent variable is connected, this procedure calls itself
' for the connected independent variable.
'  Input:  Index     index of txtVariable (independent or dependent)
'
'  Called by:  itself, GeneralLostFocus, DragDrop3
'  Module level variables:  mnUnits
'        Global variables:  gOccupantIndex, gbDontStopHere, gdNumber
'                           gdUncertainty, gnConnected, gGroupDefine
'
SUB CalculateFormula (BYVAL Index)

DIM nDependent, srMsg AS STRING
DIM nrPrintPosition, N
DIM nGroup, bSetToZero
DIM nEquation, N1, N2, N3, N4, N5, N6
DIM nIndex1, nIndex2, bError
DIM dConversionFactor AS DOUBLE
DIM dMoles AS DOUBLE, dMoleUncertainty AS DOUBLE
DIM dTemp1 AS DOUBLE, dTemp2 AS DOUBLE, dTempUnc1 AS DOUBLE, dTempunc2 AS DOUBLE
DIM sMsg AS STRING

ON LOCAL ERROR GOTO ErrorFormula ' Handles overflow.

' Find the group number of the present variable.
nGroup = nGroupOfIndex(Index)
nDependent = gOccupantIndex(nGroup, 0)
FOR N = gGroupDefine(nGroup).LowestIndex TO gGroupDefine(nGroup).HighestIndex    '- nTemp
   IF NOT gbDontStopHere(N) AND gdNumber(N) = 0 THEN
      ' If any of the independent variables in the group is 0,
      ' set dependent variable to 0, unless variable is a temperature.
      IF N = 31 OR N = 32 OR N = 37 THEN
         ' Temperature of zero is handled later.
      ELSE
         bSetToZero = TRUE
         EXIT FOR
      END IF
   END IF
NEXT N

IF bSetToZero THEN
   gdNumber(nDependent) = 0
   gdUncertainty(nDependent) = 0
ELSE
   ' Calculate the dependent variable's value using a formula.
   SELECT CASE nDependent
      ' M.W. = g / mole
      CASE 1                           ' Find molar mass.
         nEquation = 1
         N1 = 1: N2 = 2: N3 = 3
         '   density =           g / mL
         '      M.W. =           g / mole
         'gdNumber(1) = gdNumber(2) / gdNumber(3)
         'mdMolarMassError =    SQR(mdGramsError ^ 2 + (mdMolarMass *     mdMolesError) ^ 2) / mdMoles
         'gdUncertainty(1) = SQR(gdUncertainty(2) ^ 2 + (gdNumber(1) * gdUncertainty(3)) ^ 2) / gdNumber(3)
      CASE 2                           ' Find grams.
         nEquation = 2
         N1 = 2: N2 = 3: N3 = 1
         '     grams =          mL * density
         '   mdGrams =     mdMoles * mdMolarMass
         'gdNumber(2) = gdNumber(3) * gdNumber(1)
         '   mdGramsError = SQR((mdMolarMass *     mdMolesError) ^ 2 + (    mdMoles * mdMolarMassError) ^ 2)
         'gdUncertainty(2) = SQR((gdNumber(1) * gdUncertainty(3)) ^ 2 + (gdNumber(3) * gdUncertainty(1)) ^ 2)
      CASE 3                           ' Find moles.
         nEquation = 1
         N1 = 3: N2 = 2: N3 = 1
         '        mL =       grams / density
         '   mdMoles =     mdGrams / mdMolarMass
         'gdNumber(3) = gdNumber(2) / gdNumber(1)
         '   mdMolesError = SQR(    mdGramsError ^ 2 + (    mdMoles * mdMolarMassError) ^ 2) / mdMolarMass
         'gdUncertainty(3) = SQR(gdUncertainty(2) ^ 2 + (gdNumber(3) * gdUncertainty(1)) ^ 2) / gdNumber(1)

      ' density = g / mL
      CASE 4                           ' Find density
         nEquation = 1
         N1 = 4: N2 = 5: N3 = 6
      CASE 5                           ' Find grams
         nEquation = 2
         N1 = 5: N2 = 6: N3 = 4
      CASE 6                           ' Find mL
         nEquation = 1
         N1 = 6: N2 = 5: N3 = 4

      ' molarity = mol / L
      CASE 7                           ' Find molarity
         nEquation = 1
         N1 = 7: N2 = 8: N3 = 9
      CASE 8                           ' Find moles
         nEquation = 2
         N1 = 8: N2 = 9: N3 = 7
      CASE 9                           ' Find liters
         nEquation = 1
         N1 = 9: N2 = 8: N3 = 7

      ' percent = part / whole * 100
      CASE 10                          ' Find whole
         nEquation = 3
         N1 = 10: N2 = 11: N3 = 12
      CASE 11                          ' Find part
         nEquation = 4
         N1 = 11: N2 = 12: N3 = 10
      CASE 12                          ' Find %
         nEquation = 3
         N1 = 12: N2 = 11: N3 = 10

      ' Molarity_f = Molarity_i * volume_i / volume_f
      ' N1 = N2 * N3 / N4
      CASE 14                          ' Find volume_f
         nEquation = 5  ' Vf=Mi*Vi/Mf
         N1 = 14: N2 = 15: N3 = 17: N4 = 16
      CASE 15                          ' Find Molarity_i
         nEquation = 5  ' Mi=Mf*Vf/Vi
         N1 = 15: N2 = 16: N3 = 14: N4 = 17
      CASE 16                          ' Find Molarity_f
         nEquation = 5  ' Mf=Mi*Vi/Vf
         N1 = 16: N2 = 15: N3 = 17: N4 = 14
      CASE 17                          ' Find volume_i
         nEquation = 5  ' Vi=Mf*Vf/Mi  Mf=16, Mi=15, Vi=17, Vf=14
         N1 = 17: N2 = 16: N3 = 14: N4 = 15

      CASE 18                          ' Find volume_2
         nEquation = 6  ' V2=M1*V1/M2*(2/1)  M1=19, M2=20, V1=21, V2=18, 2=22, 1=23
         N1 = 18: N2 = 19: N3 = 21: N4 = 22: N5 = 20: N6 = 23
      CASE 19                          ' Find Molarity_1
         nEquation = 6  ' M1=M2*V2/V1*(1/2)
         N1 = 19: N2 = 20: N3 = 18: N4 = 23: N5 = 21: N6 = 22
      CASE 20                          ' Find Molarity_2
         nEquation = 6  ' M2=M1*V1/V2*(2/1)
         N1 = 20: N2 = 19: N3 = 21: N4 = 22: N5 = 18: N6 = 23
      CASE 21                          ' Find volume_1
         nEquation = 6  ' V1=M2*V2/M1*(1/2)
         N1 = 21: N2 = 20: N3 = 18: N4 = 23: N5 = 19: N6 = 22
      CASE 22                          ' Find coefficient_2
         nEquation = 6  ' 2=M2*V2*1/M1/V1
         N1 = 22: N2 = 20: N3 = 18: N4 = 23: N5 = 19: N6 = 21
      CASE 23                          ' Find coefficient_1
         nEquation = 6  ' 1=M1*V1*2/M2/V2
         N1 = 23: N2 = 19: N3 = 21: N4 = 22: N5 = 20: N6 = 18

      CASE 26                          ' Find volume 2
         N1 = 26: N2 = 29
         IF NOT gbDontStopHere(27) THEN  ' P
            nEquation = 5  ' V2=V1*P1/P2  V1=29, P1=27, P2=28
            N3 = 27: N4 = 28
         ELSEIF NOT gbDontStopHere(32) THEN  ' T
            nEquation = 7  ' V2=V1*T2/T1  V1=29, T2=31, T1=32
            N3 = 31: N4 = 32
         ELSEIF NOT gbDontStopHere(30) THEN  ' n
            nEquation = 5  ' V2=V1*n2/n1  V1=29, n2=33, n1=30
            N3 = 33: N4 = 30
         END IF
      CASE 27                          ' Find pressure 1
         N1 = 27: N2 = 28
         IF NOT gbDontStopHere(29) THEN  ' V
            nEquation = 5  ' P1=P2*V2/V1  P2=28, V2=26, V1=29
            N3 = 26: N4 = 29
         ELSEIF NOT gbDontStopHere(32) THEN  ' T
            nEquation = 7  ' P1=P2*T1/T2  P2=28, T1=32, T2=31
            N3 = 32: N4 = 31
         ELSEIF NOT gbDontStopHere(30) THEN  ' n
            nEquation = 5  ' P1=P2*n1/n2  P2=28, n1=30, n2=33
            N3 = 30: N4 = 33
         END IF
      CASE 28                          ' Find pressure 2
         N1 = 28: N2 = 27
         IF NOT gbDontStopHere(29) THEN  ' V
            nEquation = 5  ' P2=P1*V1/V2  P1=27, V1=29, V2=26
            N3 = 29: N4 = 26
         ELSEIF NOT gbDontStopHere(32) THEN  ' T
            nEquation = 7  ' P2=P1*T2/T1  P1=27, T2=31, T1=32
            N3 = 31: N4 = 32
         ELSEIF NOT gbDontStopHere(30) THEN  ' n
            nEquation = 5  ' P2=P1*n2/n1  P1=27, n2=33, n1=30
            N3 = 33: N4 = 30
         END IF
      CASE 29                          ' Find volume 1
         N1 = 29: N2 = 26:
         IF NOT gbDontStopHere(27) THEN  ' P
            nEquation = 5  ' V1=V2*P2/P1  P2=28, V2=26, P1=27
            N3 = 28: N4 = 27
         ELSEIF NOT gbDontStopHere(32) THEN  ' T
            nEquation = 7  ' V1=V2*T1/T2  V2=26, T1=32, T2=31
            N3 = 32: N4 = 31
         ELSEIF NOT gbDontStopHere(30) THEN  ' n
            nEquation = 5  ' V1=V2*n1/n2  V2=26, n1=30, n2=33
            N3 = 30: N4 = 33
         END IF
      CASE 30                          ' Find moles 1
         N1 = 30: N2 = 33
         IF NOT gbDontStopHere(27) THEN  ' P              ' n1T1   n2T2
            nEquation = 5  ' n1=n2*P1/P2  n2=33, P1=27, P2=28 ' ---- = ----
            N3 = 27: N4 = 28                ' P1V1   P2V2
         ELSEIF NOT gbDontStopHere(32) THEN  ' T
            nEquation = 7  ' n1=n2*T2/T1  n2=33, T2=31, T1=32
            N3 = 31: N4 = 32
         ELSEIF NOT gbDontStopHere(29) THEN  ' V
            nEquation = 5  ' n1=n2*V1/V2  n2=33, V1=29, V2=26
            N3 = 29: N4 = 26
         END IF
      CASE 31                          ' Find temperature 2
         N1 = 31: N2 = 32
         IF NOT gbDontStopHere(27) THEN  ' P                   ' n2T2   n1T1
            nEquation = 8  ' T2=T1*P2/P1  T1=32, P2=28, P1=27  ' ---- = ----
            N3 = 28: N4 = 27                                   ' P2V2   P1V1
         ELSEIF NOT gbDontStopHere(30) THEN  ' n
            nEquation = 8  ' T2=T1*n1/n2  T1=32, n1=30, n2=33
            N3 = 30: N4 = 33
         ELSEIF NOT gbDontStopHere(29) THEN  ' V
            nEquation = 8  ' T2=T1*V2/V1  T1=32, V2=26, V1=29
            N3 = 26: N4 = 29
         END IF
      CASE 32                          ' Find temperature 1
         N1 = 32: N2 = 31
         IF NOT gbDontStopHere(27) THEN  ' P              ' n2T2   n1T1
            nEquation = 8  ' T1=T2*P1/P2  T2=31, P1=27, P2=28 ' ---- = ----
            N3 = 27: N4 = 28                                  ' P2V2   P1V1
         ELSEIF NOT gbDontStopHere(30) THEN  ' n
            nEquation = 8  ' T1=T2*n2/n1  T2=31, n2=33, n1=30
            N3 = 33: N4 = 30
         ELSEIF NOT gbDontStopHere(29) THEN  ' V
            nEquation = 8  ' T1=T2*V1/V2  T2=31, V1=29, V2=26
            N3 = 29: N4 = 26
         END IF
      CASE 33                          ' Find moles 2
         N1 = 33: N2 = 30:
         IF NOT gbDontStopHere(27) THEN  ' P                  ' n1T1   n2T2
            nEquation = 5  ' n2=n1*P2/P1  n1=30, P2=28, P1=27 ' ---- = ----
            N3 = 28: N4 = 27                                  ' P1V1   P2V2
         ELSEIF NOT gbDontStopHere(32) THEN  ' T
            nEquation = 7  ' n2=n1*T1/T2  n1=30, T1=32, T2=31
            N3 = 32: N4 = 31
         ELSEIF NOT gbDontStopHere(29) THEN  ' V
            nEquation = 5  ' n2=n1*V2/V1  n1=30, V2=26, V1=29
            N3 = 26: N4 = 29
         END IF

      CASE 34                          ' V
         nEquation = 9  ' V=nRT/P
         N1 = 34: N2 = 35: N3 = 38: N4 = 37: N5 = 36
      CASE 35                          ' n
         nEquation = 10  ' n=PV/TR
         N1 = 35: N2 = 36: N3 = 34: N4 = 37: N5 = 38
      CASE 36                          ' P
         nEquation = 9  ' P=nRT/V
         N1 = 36: N2 = 35: N3 = 38: N4 = 37: N5 = 34
      CASE 37                          ' T
         nEquation = 11 ' T=PV/nR
         N1 = 37: N2 = 36: N3 = 34: N4 = 35: N5 = 38
      CASE 38                          ' R
         nEquation = 10  ' R=PV/Tn
         N1 = 38: N2 = 36: N3 = 34: N4 = 37: N5 = 35

   END SELECT
   SELECT CASE nEquation
      CASE 1
         '       M.W. =           g / mole
         gdNumber(N1) = gdNumber(N2) / gdNumber(N3)
         'mdMolarMassError =    SQR(mdGramsError ^ 2 + (mdMolarMass *     mdMolesError) ^ 2) / mdMoles
         gdUncertainty(N1) = SQR(gdUncertainty(N2) ^ 2 + (gdNumber(N1) * gdUncertainty(N3)) ^ 2) / gdNumber(N3)
      CASE 2
         '   mdGrams =     mdMoles * mdMolarMass
         gdNumber(N1) = gdNumber(N2) * gdNumber(N3)
         '   mdGramsError = SQR((mdMolarMass *     mdMolesError) ^ 2 + (    mdMoles * mdMolarMassError) ^ 2)
         gdUncertainty(N1) = SQR((gdNumber(N3) * gdUncertainty(N2)) ^ 2 + (gdNumber(N2) * gdUncertainty(N3)) ^ 2)
      CASE 3                        ' Used by percent
         gdNumber(N1) = gdNumber(N2) / gdNumber(N3) * 100#
         gdUncertainty(N1) = SQR((100# * gdUncertainty(N2)) ^ 2 + (gdNumber(N1) * gdUncertainty(N3)) ^ 2) / gdNumber(N3)
      CASE 4                        ' Used by percent
         gdNumber(N1) = gdNumber(N2) * gdNumber(N3) * .01#
         gdUncertainty(N1) = SQR((gdNumber(N3) * gdUncertainty(N2)) ^ 2 + (gdNumber(N2) * gdUncertainty(N3)) ^ 2) * .01#
      CASE 5                        ' Used by dilution, gas change 2, 3, 6
         ' N1 = N2 * N3 / N4
         gdNumber(N1) = gdNumber(N2) * gdNumber(N3) / gdNumber(N4)
         gdUncertainty(N1) = ABS(gdNumber(N1)) * SQR((gdUncertainty(N2) / gdNumber(N2)) ^ 2 + (gdUncertainty(N3) / gdNumber(N3)) ^ 2 + (gdUncertainty(N4) / gdNumber(N4)) ^ 2)
      CASE 6                        ' Used by dilution
         ' N1 = N2 * N3 * N4 / N5 / N6
         gdNumber(N1) = gdNumber(N2) * gdNumber(N3) * gdNumber(N4) / gdNumber(N5) / gdNumber(N6)
         gdUncertainty(N1) = ABS(gdNumber(N1)) * SQR((gdUncertainty(N2) / gdNumber(N2)) ^ 2 + (gdUncertainty(N3) / gdNumber(N3)) ^ 2 + (gdUncertainty(N4) / gdNumber(N4)) ^ 2 + (gdUncertainty(N5) / gdNumber(N5)) ^ 2 + (gdUncertainty(N6) / gdNumber(N6 _
)) ^ 2)
      CASE 7                        ' Used by gas change 1, 4, 5
         ' Temperature units must be in Kelvin for the calculation.
         ' n1=n2*T2/T1  n2=33, T2=31, T1=32
         ' n2=n1*T1/T2  n1=30, T1=32, T2=31
         ' V1=V2*T1/T2  V2=26, T1=32, T2=31
         ' P2=P1*T2/T1  P1=27, T2=31, T1=32
         ' P1=P2*T1/T2  P2=28, T1=32, T2=31
         ' V2=V1*T2/T1  V1=29, T2=31, T1=32
         ' N1 = N2 * N3 / N4
         bError = bUnitConversion(gdNumber(N3), gdUncertainty(N3), mnUnits(N3), KELVIN, dTemp1, dTempUnc1, N)
         bError = bUnitConversion(gdNumber(N4), gdUncertainty(N4), mnUnits(N4), KELVIN, dTemp2, dTempunc2, N)
         ' On overflow, bUnitConversion returns values of 0, so no error handling is needed here.
         IF dTemp2 = 0 OR frmGas.txtVariable(N4).Text = "" OR frmGas.txtVariable(N3).Text = "" THEN
            gdNumber(N1) = 0
            gdUncertainty(N1) = 0
         ELSE
            gdNumber(N1) = gdNumber(N2) * dTemp1 / dTemp2
            gdUncertainty(N1) = ABS(gdNumber(N1)) * SQR((gdUncertainty(N2) / gdNumber(N2)) ^ 2 + (dTempUnc1 / dTemp1) ^ 2 + (dTempunc2 / dTemp2) ^ 2)
         END IF
      CASE 8                    ' Also Used by gas change formulas 1, 4, 5
         ' Temperature units must be in Kelvin for the calculation.
         ' Used by PV=PV type equations with T as dependent variable.
         ' T1=T2*P1/P2  T2=31, P1=27, P2=28
         ' N1 = N2 * N3 / N4
         bError = bUnitConversion(gdNumber(N2), gdUncertainty(N2), mnUnits(N2), KELVIN, dTemp1, dTempUnc1, N)
         IF dTemp1 = 0 OR frmGas.txtVariable(N2).Text = "" THEN
            gdNumber(N1) = 0
            gdUncertainty(N1) = 0
         ELSE
            dTemp2 = dTemp1 * gdNumber(N3) / gdNumber(N4)
            dTempunc2 = ABS(dTemp2) * SQR((dTempUnc1 / dTemp1) ^ 2 + (gdUncertainty(N3) / gdNumber(N3)) ^ 2 + (gdUncertainty(N4) / gdNumber(N4)) ^ 2)
            bError = bUnitConversion(dTemp2, dTempunc2, KELVIN, mnUnits(N1), gdNumber(N1), gdUncertainty(N1), N)
         END IF
      CASE 9
         ' V = nRT / P
         ' N1 = N2 * N3 * N4 / N5
         bError = bUnitConversion(gdNumber(N4), gdUncertainty(N4), mnUnits(N4), KELVIN, dTemp1, dTempUnc1, N)
         IF dTemp1 = 0 OR frmIdealGas.txtVariable(N4).Text = "" THEN
            gdNumber(N1) = 0
            gdUncertainty(N1) = 0
         ELSE
            gdNumber(N1) = gdNumber(N2) * gdNumber(N3) * dTemp1 / gdNumber(N5)
            gdUncertainty(N1) = ABS(gdNumber(N1)) * SQR((gdUncertainty(N2) / gdNumber(N2)) ^ 2 + (gdUncertainty(N3) / gdNumber(N3)) ^ 2 + (dTempUnc1 / dTemp1) ^ 2 + (gdUncertainty(N5) / gdNumber(N5)) ^ 2)
         END IF
      CASE 10
         ' n = PV/TR
         ' N1 = N2 * N3 / N4 / N5
         bError = bUnitConversion(gdNumber(N4), gdUncertainty(N4), mnUnits(N4), KELVIN, dTemp1, dTempUnc1, N)
         IF dTemp1 = 0 OR frmIdealGas.txtVariable(N4).Text = "" THEN
            gdNumber(N1) = 0
            gdUncertainty(N1) = 0
         ELSE
            gdNumber(N1) = gdNumber(N2) * gdNumber(N3) / dTemp1 / gdNumber(N5)
            gdUncertainty(N1) = ABS(gdNumber(N1)) * SQR((gdUncertainty(N2) / gdNumber(N2)) ^ 2 + (gdUncertainty(N3) / gdNumber(N3)) ^ 2 + (dTempUnc1 / dTemp1) ^ 2 + (gdUncertainty(N5) / gdNumber(N5)) ^ 2)
         END IF
      CASE 11
         ' T = P V / n R
         ' N1 = N2 * N3 / N4 / N5
         dTemp2 = gdNumber(N2) * gdNumber(N3) / gdNumber(N4) / gdNumber(N5)
         dTempunc2 = ABS(dTemp2) * SQR((gdUncertainty(N2) / gdNumber(N2)) ^ 2 + (gdUncertainty(N3) / gdNumber(N3)) ^ 2 + (gdUncertainty(N4) / gdNumber(N4)) ^ 2 + (gdUncertainty(N5) / gdNumber(N5)) ^ 2)
         bError = bUnitConversion(dTemp2, dTempunc2, KELVIN, mnUnits(N1), gdNumber(N1), gdUncertainty(N1), N)
   END SELECT

END IF

' Format the dependent variable.
NumberFormat gdNumber(nDependent), gdUncertainty(nDependent), 51, srMsg, nrPrintPosition
IF srMsg = "0" THEN srMsg = ""
SELECT CASE nDependent
   CASE IS < 4
      frmGramMole.txtVariable(nDependent).Text = srMsg
   CASE IS < 7
'formGone      frmDensity.txtVariable(nDependent).Text = srMsg
   CASE IS < 10
'formgone      frmMolarity.txtVariable(nDependent).Text = srMsg
   CASE IS < 13
      frmPercent.txtVariable(nDependent).Text = srMsg
   CASE IS < 18
'formGone      frmDilution.txtVariable(nDependent).Text = srMsg
      ' Also determine moles.
'formGone      IF frmDilution.cboVolumeUnit.ListIndex = 0 THEN
         dConversionFactor = 1#
'formGone      ELSE
         dConversionFactor = .001#
'formGone      END IF
      nIndex1 = gOccupantIndex(5, 1)
      nIndex2 = gOccupantIndex(5, 2)
      ' Following sub exists just to provide a separate error handler.
      CalculateMoles nIndex1, nIndex2, dConversionFactor, dMoles, dMoleUncertainty
      NumberFormat dMoles, dMoleUncertainty, 51, srMsg, nrPrintPosition
      IF srMsg = "0" THEN srMsg = ""
'formGone      frmDilution.lblMoles.Caption = srMsg
   CASE IS < 24
      frmTitration.txtVariable(nDependent).Text = srMsg
      ' Also determine moles.
      IF frmTitration.cboVolumeUnit.ListIndex = 0 THEN
         dConversionFactor = 1#
      ELSE
         dConversionFactor = .001#
      END IF
      ' Calculate moles and uncertainty.
      FOR N = 24 TO 25
         CalculateMoles N - 6, N - 4, dConversionFactor, gdNumber(N), gdUncertainty(N)
         NumberFormat gdNumber(N), gdUncertainty(N), 51, srMsg, nrPrintPosition
         IF srMsg = "0" THEN srMsg = ""
         frmTitration.txtVariable(N).Text = srMsg
      NEXT N
   CASE IS < 34
      frmGas.txtVariable(nDependent).Text = srMsg
   CASE IS < 39
      frmIdealGas.txtVariable(nDependent).Text = srMsg
END SELECT

N = gnConnected(nDependent)
IF N THEN
   bError = bUnitConversion(gdNumber(nDependent), gdUncertainty(nDependent), mnUnits(nDependent), mnUnits(N), gdNumber(N), gdUncertainty(N), nIndex1)
   IF nGroupOfIndex(N) > 8 THEN
      CalcReaction gnConnected(nDependent), frmReaction
   ELSE
      CalculateFormula N
   END IF
END IF

EXIT SUB

ErrorFormula:
   gdNumber(nDependent) = 0
   gdUncertainty(nDependent) = 0
   BEEP
   RESUME NEXT

END SUB

' Changes pressure units when combo box changes.
'  Input:  nvGroup      calling group
'          Source       calling form
'
'               Called by:  cboPressureUnit_Click in frmGas
'  Module Level variables:  mnUnits(N)
'        Global Variables:  gdNumber(), gdUncertainty()
'
SUB ChangePressureUnit (BYVAL nvGroup, source AS FORM)
DIM srMsg AS STRING, sUnits AS STRING, nrConversion
DIM nrPrintPosition
DIM N, nInitialUnits, bError
DIM dOriginalLow AS DOUBLE
DIM dOriginalHigh AS DOUBLE
DIM dOriginalLowUncertain AS DOUBLE
DIM dOriginalHighUncertain AS DOUBLE
DIM nTemp, nFirstIndex, nSecondIndex
DIM nUnitLocation

STATIC stCalledByErrorHandler

SELECT CASE nvGroup
   CASE 7
      nFirstIndex = 27
      nSecondIndex = 28
      nUnitLocation = 5
   CASE 8
      nFirstIndex = 36
      nSecondIndex = 36
      nUnitLocation = 4
END SELECT
IF source.cboPressureUnit.ListIndex = VAL(source.cboPressureUnit.Tag) THEN
   ' Do nothing if units didn't change.
   ' Needed because this is called when the present combo box
   ' selection is selected again.
   EXIT SUB
END IF

' Save original values in case of error (overflow).
dOriginalLow = gdNumber(nFirstIndex)
dOriginalHigh = gdNumber(nSecondIndex)
dOriginalLowUncertain = gdUncertainty(nFirstIndex)
dOriginalHighUncertain = gdUncertainty(nSecondIndex)

FOR N = nFirstIndex TO nSecondIndex STEP 1
   nInitialUnits = mnUnits(N)
   SELECT CASE source.cboPressureUnit.ListIndex
      CASE 0   ' Pa selected.
         mnUnits(N) = PA
         sUnits = "pascal"
      CASE 1   ' KPa selected.
         mnUnits(N) = KPA
         sUnits = "kPa"
      CASE 2   ' bar selected.
         mnUnits(N) = BAR
         sUnits = "bar"
      CASE 3   ' atm selected.
         mnUnits(N) = ATM
         sUnits = "atm"
      CASE 4   ' mm Hg selected.
         mnUnits(N) = MMHG
         sUnits = "mm Hg"
      CASE 5   ' torr selected.
         mnUnits(N) = TORR
         sUnits = "torr"
      CASE 6   ' psi selected.
         mnUnits(N) = PSI
         sUnits = "psi"
   END SELECT
   IF source.cmdSize.Tag = "2" THEN
      ' Form is large; change labels.
      source.lblVariable(N).Caption = MID$(source.lblVariable(N).Caption, 1, nUnitLocation) + sUnits
   ELSEIF nvGroup = 7 THEN
      ' Form is small.
      source.lblVariable(N).Caption = MID$(source.lblVariable(N).Caption, 1, 6) + sUnits
   END IF

   IF NOT stCalledByErrorHandler THEN
      bError = bUnitConversion(gdNumber(N), gdUncertainty(N), nInitialUnits, mnUnits(N), gdNumber(N), gdUncertainty(N), nrConversion)
   END IF
   IF bError THEN
      ' A volume of 1.E+308 L overflows if converted to mL
      ' Solution is to restore original values, reset combo box.

      gdNumber(nFirstIndex) = dOriginalLow
      gdUncertainty(nFirstIndex) = dOriginalLowUncertain
      gdNumber(nSecondIndex) = dOriginalHigh
      gdUncertainty(nSecondIndex) = dOriginalHighUncertain

      ' Restore the combo box to previous entry; this calls this sub again.
      stCalledByErrorHandler = TRUE
      nTemp = VAL(source.cboPressureUnit.Tag) ' Original combo box setting.
      source.cboPressureUnit.Tag = STR$(source.cboPressureUnit.ListIndex)  ' So selection is not same when calls itself.
      source.cboPressureUnit.ListIndex = nTemp   ' Calls this function again.
      EXIT SUB
   END IF

   ' Update displayed variables.
   IF gnConnected(N) AND gOccupantIndex(nvGroup, 0) <> N THEN
      ' Don't update connected independent variables (Leave formula showing).
   ELSE
      IF source.txtVariable(N).Text = "" THEN
         gdNumber(N) = 0
      ELSE
         NumberFormat gdNumber(N), gdUncertainty(N), 51, srMsg, nrPrintPosition
         source.txtVariable(N).Text = srMsg
      END IF
   END IF
NEXT N
stCalledByErrorHandler = False
source.cboPressureUnit.Tag = STR$(source.cboPressureUnit.ListIndex)
InfoShow Screen.ActiveControl, msConversion(nrConversion), YELLOW
END SUB

' Changes temperature units between C, K, & F when combo box changes.
'  Input:  nvGroup      calling group
'          Source       calling form
'
'               Called by:  cboTempUnit_Click in frmGas
'  Module Level variables:  mnUnits(N)
'        Global Variables:  gdNumber(), gdUncertainty()
'
SUB ChangeTempUnit (BYVAL nvGroup, source AS FORM)

DIM srMsg AS STRING, sUnits AS STRING, sMsg AS STRING
DIM nrPrintPosition, nrConversion
DIM N, nInitialUnits, bError
DIM dOriginalLow AS DOUBLE
DIM dOriginalHigh AS DOUBLE
DIM dOriginalLowUncertain AS DOUBLE
DIM dOriginalHighUncertain AS DOUBLE
DIM nTemp, nFirstIndex, nSecondIndex
DIM nUnitLocation

STATIC stCalledByErrorHandler

SELECT CASE nvGroup
   CASE 7
      nFirstIndex = 31
      nSecondIndex = 32
      nUnitLocation = 5
   CASE 8
      nFirstIndex = 37
      nSecondIndex = 37
      nUnitLocation = 4
END SELECT
IF source.cboTempUnit.ListIndex = VAL(source.cboTempUnit.Tag) THEN
   ' Do nothing if units didn't change.
   ' Needed because this is called when the present combo box
   ' selection is selected again.
   EXIT SUB
END IF

' Save original values in case of error (overflow).
dOriginalLow = gdNumber(nFirstIndex)
dOriginalHigh = gdNumber(nSecondIndex)
dOriginalLowUncertain = gdUncertainty(nFirstIndex)
dOriginalHighUncertain = gdUncertainty(nSecondIndex)

FOR N = nFirstIndex TO nSecondIndex STEP 1
   nInitialUnits = mnUnits(N)
   SELECT CASE source.cboTempUnit.ListIndex
      CASE 0   ' C selected.
         mnUnits(N) = CELSIUS
         sUnits = "C"
      CASE 1   ' K selected.
         mnUnits(N) = KELVIN
         sUnits = "K"
      CASE 2   ' F selected.
         mnUnits(N) = FAHRENHEIT
         sUnits = "F"
   END SELECT
   IF source.cmdSize.Tag = "2" THEN
      ' Form is large; change labels.
      source.lblVariable(N).Caption = MID$(source.lblVariable(N).Caption, 1, nUnitLocation) + sUnits
   ELSEIF nvGroup = 7 THEN
      ' Form is small.
      source.lblVariable(N).Caption = MID$(source.lblVariable(N).Caption, 1, 6) + sUnits
   END IF
   
   IF NOT stCalledByErrorHandler THEN
      bError = bUnitConversion(gdNumber(N), gdUncertainty(N), nInitialUnits, mnUnits(N), gdNumber(N), gdUncertainty(N), nrConversion)
   END IF
   IF bError THEN
      ' A volume of 1.E+308 L overflows if converted to mL
      ' Solution is to restore original values, reset combo box.

      gdNumber(nFirstIndex) = dOriginalLow
      gdUncertainty(nFirstIndex) = dOriginalLowUncertain
      gdNumber(nSecondIndex) = dOriginalHigh
      gdUncertainty(nSecondIndex) = dOriginalHighUncertain

      ' Restore the combo box to previous entry; this calls this sub again.
      stCalledByErrorHandler = TRUE
      nTemp = VAL(source.cboTempUnit.Tag) ' Original combo box setting.
      source.cboTempUnit.Tag = STR$(source.cboTempUnit.ListIndex)
      source.cboTempUnit.ListIndex = nTemp   ' Calls this function again.
      EXIT SUB
   END IF

   ' Update displayed variables.
   IF gnConnected(N) AND gOccupantIndex(nvGroup, 0) <> N THEN
      ' Don't update connected independent variables (Leave formula showing).
   ELSE
      IF source.txtVariable(N).Text = "" THEN
         gdNumber(N) = 0
      ELSE
         NumberFormat gdNumber(N), gdUncertainty(N), 51, srMsg, nrPrintPosition
         source.txtVariable(N).Text = srMsg
      END IF
   END IF
NEXT N
stCalledByErrorHandler = False
source.cboTempUnit.Tag = STR$(source.cboTempUnit.ListIndex)
InfoShow Screen.ActiveControl, msConversion(nrConversion), YELLOW
END SUB

' Changes volume units between mL & L when combo box changes.
'  Input:  nvGroup      calling group
'          Source       calling form
'
'  Module Level variables:  mnUnits(N)
'        Global Variables:  gdNumber(), gdUncertainty()
SUB ChangeVolumeUnit (BYVAL nvGroup, source AS FORM)
DIM srMsg AS STRING
DIM nrPrintPosition, nrConversion
DIM N, nInitialUnits
DIM dOriginalLow AS DOUBLE
DIM dOriginalHigh AS DOUBLE
DIM dOriginalLowUncertain AS DOUBLE
DIM dOriginalHighUncertain AS DOUBLE
DIM bError
DIM nTemp, nFirstIndex, nSecondIndex, nStep

STATIC stCalledByErrorHandler

SELECT CASE nvGroup
   CASE 5 ' Dilution
      nFirstIndex = 14
      nSecondIndex = 17
   CASE 6 ' Titration
      nFirstIndex = 18
      nSecondIndex = 21
   CASE 7 ' Gas change
      nFirstIndex = 26
      nSecondIndex = 29
   CASE 8 ' Ideal gas
      nFirstIndex = 34
      nSecondIndex = 34
      nStep = 1   ' Otherwise, step size is zero and get infinite loop.
END SELECT
IF source.cboVolumeUnit.ListIndex = VAL(source.cboVolumeUnit.Tag) THEN
   ' Do nothing if units didn't change.
   ' Needed because this is called when the present combo box
   ' selection is selected again.
   EXIT SUB
END IF

' Save original values in case of error (overflow).
dOriginalLow = gdNumber(nFirstIndex)
dOriginalHigh = gdNumber(nSecondIndex)
dOriginalLowUncertain = gdUncertainty(nFirstIndex)
dOriginalHighUncertain = gdUncertainty(nSecondIndex)

FOR N = nFirstIndex TO nSecondIndex STEP nSecondIndex - nFirstIndex + nStep
   nInitialUnits = mnUnits(N)
   SELECT CASE source.cboVolumeUnit.ListIndex
      CASE 0   ' L selected.
               ' Units were previously mL; convert to L.
         mnUnits(N) = LITER
         IF source.cmdSize.Tag = "2" THEN
            ' Form is large; change labels.
            IF nvGroup = 7 THEN
               source.lblVariable(N).Caption = LEFT$(source.lblVariable(N).Caption, 5) + "L"
            ELSEIF nvGroup = 8 THEN
               source.lblVariable(N).Caption = LEFT$(source.lblVariable(N).Caption, 4) + "L"
            ELSE
               source.lblVariable(N).Caption = MID$(source.lblVariable(N).Caption, 2)
            END IF
         ELSEIF nvGroup = 7 THEN
            ' Form is small.
            source.lblVariable(N).Caption = LEFT$(source.lblVariable(N).Caption, 6) + "L"
         END IF
      CASE 1   ' mL selected.
         ' Units were previously L; convert to mL.
         mnUnits(N) = ML
         IF source.cmdSize.Tag = "2" THEN
            ' Form is large; change labels.
            IF nvGroup = 7 THEN
               source.lblVariable(N).Caption = LEFT$(source.lblVariable(N).Caption, 5) + "mL"
            ELSEIF nvGroup = 8 THEN ' ideal gas
               source.lblVariable(N).Caption = LEFT$(source.lblVariable(N).Caption, 4) + "mL"
            ELSE
               source.lblVariable(N).Caption = "m" + source.lblVariable(N).Caption
            END IF
         ELSEIF nvGroup = 7 THEN
            ' Form is small.
            source.lblVariable(N).Caption = LEFT$(source.lblVariable(N).Caption, 6) + "mL"
         END IF
   END SELECT
   IF NOT stCalledByErrorHandler THEN
      bError = bUnitConversion(gdNumber(N), gdUncertainty(N), nInitialUnits, mnUnits(N), gdNumber(N), gdUncertainty(N), nrConversion)
   END IF
   IF bError THEN
      ' A volume of 1.E+308 L overflows if converted to mL
      ' Solution is to restore original values, reset combo box to liters.

      gdNumber(nFirstIndex) = dOriginalLow
      gdUncertainty(nFirstIndex) = dOriginalLowUncertain
      gdNumber(nSecondIndex) = dOriginalHigh
      gdUncertainty(nSecondIndex) = dOriginalHighUncertain

      ' Restore the combo box to previous entry; this calls this sub again.
      stCalledByErrorHandler = TRUE
      source.cboVolumeUnit.Tag = "1"
      source.cboVolumeUnit.ListIndex = 0   ' Calls this function again.
      EXIT SUB
   END IF

   ' Update displayed variables.
   IF gnConnected(N) AND gOccupantIndex(nvGroup, 0) <> N THEN
      ' Don't update connected independent variables (Leave formula showing).
   ELSE
      IF source.txtVariable(N).Text = "" THEN
         gdNumber(N) = 0
      ELSE
         NumberFormat gdNumber(N), gdUncertainty(N), 51, srMsg, nrPrintPosition
         source.txtVariable(N).Text = srMsg
      END IF
   END IF
NEXT N
stCalledByErrorHandler = False
source.cboVolumeUnit.Tag = STR$(source.cboVolumeUnit.ListIndex)
InfoShow Screen.ActiveControl, msConversion(nrConversion), YELLOW
END SUB

' Rearranges the formula or makes a connection.
'
' Input:    Source      Control being dropped
'           X           X and Y coordinates on form where control was dropped
'           Y
'           sSize       Size of form where dropped
'           nvGroup     Group where dropped
'           Target      Form where dropped
'
' Called by:  DragDrop event in forms frmGramMole, frmDensity, frmMolarity.
'  Module level variables:  mLocation, msPercentProperty
'        Global variables:  gnConnected, gOccupantIndex, gbDontStopHere
'                           gnUserChoice, gbBadFormula, gGroupDefine
'
SUB DragDrop3 (source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup, Target AS FORM)
DIM nOriginIndex, nInitialPosition, nIndexTemp
DIM nFinalPosition, N, M
DIM sProperty AS STRING, nGroupOfOrigin
DIM sTemp AS STRING
DIM bConnectionSuccessful
DIM bFoundMatch
' The label's tag is blank, index number, blank, group number, units,
' as in " 2 1gram".

nGroupOfOrigin = VAL(MID$(source.Tag, 3, 2))

IF nGroupOfOrigin = nvGroup THEN
   ' ************************* Rearrange formula ****************************
   ' Formula is being changed.

   IF sSize = "1" THEN
      ' Don't allow the formula to be rearranged if the frame is small.
      EXIT SUB
   ELSE
      ' Rearrange the formula.

      ' Determine the new position.
      IF X < 25 THEN    ' Equal sign begins at 25.
         nFinalPosition = 0
      ELSEIF Y > 1 AND X > 25 THEN
         nFinalPosition = 4
      ELSEIF X > 51 AND Y < 1 THEN
         nFinalPosition = 2
      ELSEIF X > 25 AND X < 51 AND Y < 1 THEN
         nFinalPosition = 1
      ELSE
         ' On a boundry; ignore.
         EXIT SUB
      END IF

      ' Index of control to move.
      nOriginIndex = VAL(LEFT$(source.Tag, 2))
      ' Controls' starting position.
      nInitialPosition = VAL(Target.lblVariable(nOriginIndex).Tag)

      ' Only move controls if position changed.
      IF nInitialPosition <> nFinalPosition THEN
         ' Move dragged control to present position.
         Target.txtVariable(nOriginIndex).MOVE mLocation(nFinalPosition).X, mLocation(nFinalPosition).Y
         Target.lblVariable(nOriginIndex).MOVE mLocation(nFinalPosition).X + 19, mLocation(nFinalPosition).Y
         Target.lblVariable(nOriginIndex).Tag = STR$(nFinalPosition)
         IF gnConnected(nOriginIndex) THEN
            IF nInitialPosition = 0 THEN
               ' Control was dependent variable, but isn't now.
               Disconnect gnConnected(nOriginIndex)
            ELSEIF nFinalPosition = 0 THEN
               ' Control has changed from independent to dependent variable.
               Disconnect nOriginIndex
            END IF
         END IF

         ' Move any control in final position to initial position.
         IF gOccupantIndex(nvGroup, nFinalPosition) > -1 THEN
            ' Somebody's already here, so move them to previous position.
            nIndexTemp = gOccupantIndex(nvGroup, nFinalPosition)
            Target.txtVariable(nIndexTemp).MOVE mLocation(nInitialPosition).X, mLocation(nInitialPosition).Y
            Target.lblVariable(nIndexTemp).MOVE mLocation(nInitialPosition).X + 19, mLocation(nInitialPosition).Y
            Target.lblVariable(nIndexTemp).Tag = STR$(nInitialPosition)
            IF gnConnected(nIndexTemp) THEN
               IF nFinalPosition = 0 THEN
                  ' Control was dependent variable, but isn't now.
                  Disconnect gnConnected(nIndexTemp)
               ELSEIF nInitialPosition = 0 THEN
                  ' Control has changed from independent to dependent variable.
                  Disconnect nIndexTemp
               END IF
            END IF
         END IF
         gOccupantIndex(nvGroup, nInitialPosition) = gOccupantIndex(nvGroup, nFinalPosition)
         gOccupantIndex(nvGroup, nFinalPosition) = nOriginIndex

         ' The formula has been rearranged.  The original dependent variable
         ' could still be connected (if the two independents changed places).
         ' Disconnect it if it is connected.
         nIndexTemp = gnConnected(gOccupantIndex(nvGroup, 0))
         IF nIndexTemp THEN
            Disconnect nIndexTemp
         END IF

         ' Determine if the formula is valid.
         EvaluateFormula3 nvGroup, Target

      END IF
   END IF
ELSE
   ' A label has just been dropped on this form from another form.
   ' Attempt to add connectivity.

   ' Don't ask user what to put where if equations aren't valid.
   IF bConnectionWontWork(nOriginIndex, nGroupOfOrigin, source, nvGroup) THEN EXIT SUB

   ' Get property from tag.
   sProperty = MID$(source.Tag, 5)

   ' ************************* Percent Dropped ******************************
   ' Logic for handling percent:  Consider all possibilities.
   '  If part or whole from percent is dropped on the form, it either matches
   '  anything, or else has units.  It has units if either part or whole (or
   '  both) is connected.
   '  If neither is connected,
   '     see if it was dropped on an independent variable.
   '     If not, ask the user which variable to connect to.
   '  If it has units,
   '     see if the units match an independent variable.

   IF nOriginIndex = 10 OR nOriginIndex = 11 THEN
      ' Part or whole from percent was dropped.
      IF gnConnected(10) OR gnConnected(11) THEN
         ' If the percent form has a connection, the connection's properties
         ' must match something on the target form for another connection to
         ' be made.
         sProperty = msPercentProperty
      ELSE
         ' Neither is connected, so any units will work.
         ' If not dropped on an independent variable, then ask user
         ' which to connect to.

         ' Determine the position where the variable was dropped.
         IF Target.cmdSize.Tag = "2" THEN      ' Form is large.
            IF X < 25 THEN    ' Equal sign begins at 25.
               nFinalPosition = -1
            ELSEIF X > 25 AND X < 51 AND Y > 1 THEN
               nFinalPosition = 4
            ELSEIF X > 51 AND X < 76 AND Y < 1 THEN
               nFinalPosition = 2
            ELSEIF X > 25 AND X < 51 AND Y < 1 THEN
               nFinalPosition = 1
            ELSE
               'On a boundry; ignore.
               nFinalPosition = -1
            END IF
         ELSE                                      ' Form is small.
            ' textbox and label extend from 0 to 23.
            ' part is on line 0, whole on line 1, and % on line 2.
            IF X < 24 AND Y = 0 THEN            ' First line
               ' The position of the variables vary according to which variable
               ' is the dependent one.
               nFinalPosition = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 1).Tag)
            ELSEIF X < 24 AND Y = 1 THEN        ' Second line
               nFinalPosition = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex).Tag)
            ELSEIF X < 24 AND Y = 2 THEN        ' Third line
               nFinalPosition = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 2).Tag)
            ELSE                                ' Not dropped on part or whole.
               nFinalPosition = -1
            END IF
            ' Don't allow final position to be zero (dependent variable).
            IF nFinalPosition = 0 THEN nFinalPosition = -1
         END IF

         ' Determine if it was dropped at the same location as an
         ' independent variable.
         FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
            sTemp = Target.txtVariable(N).Tag
            IF VAL(Target.lblVariable(N).Tag) = nFinalPosition THEN
               ' The nFinalPosition is never 0, so can never match the dependent variable.
               ' Force a match in a following for-next loop by pretending
               ' percent property is same as property where dropped.
               sProperty = sTemp
               EXIT FOR
            END IF
         NEXT N
         IF sProperty = "*" THEN
            ' No match was found, so it wasn't dropped on an independent
            ' variable.  Ask user where to put it.
            FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
               IF NOT gbDontStopHere(N) THEN
                  M = M + 1
                  sTemp = ", " + Target.lblVariable(N).Caption
                  frmchoose.optVariable(M).Caption = Target.txtVariable(N).Tag + sTemp
                  frmchoose.optVariable(M).Visible = TRUE
               END IF
            NEXT N
            frmchoose.Caption = Target.Caption
            frmchoose.SHOW 1
            IF gnUserChoice = 0 THEN
               EXIT SUB
            ELSE
               sProperty = Target.txtVariable(gGroupDefine(nvGroup).LowestIndex + gnUserChoice - 1).Tag
            END IF
         END IF
      END IF
   END IF

   ' ************************* Attempt Connection ***************************
   ' Incomming control's units must match an independent variable's units.
   FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
      IF Target.txtVariable(N).Tag = sProperty THEN
         ' Properties match.
         IF NOT gbDontStopHere(N) THEN
            ' Can connect because target is an independent variable.
            bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, N, nvGroup, Target)
            bFoundMatch = TRUE
            EXIT FOR
         END IF
      END IF
   NEXT N

   IF NOT bFoundMatch AND bConnectionSuccessful < 1 THEN
      InfoShow Screen.ActiveControl, "Incoming units not present right of equal sign.", BRIGHT_WHITE
   END IF
END IF

END SUB

' Rearranges the formula or makes a connection.
'
' Input:    Source      Control being dropped
'           X           X and Y coordinates on form where control was dropped
'           Y
'           sSize       Size of form where dropped
'           nvGroup     Group where dropped
'           Target      Form where dropped
'
' Called by:  DragDrop event in frmDilution and frmTitration.
'  Module level variables:  mLocation, msPercentProperty
'                           mnIndexOfPropertyMatch
'        Global variables:  gnConnected, gOccupantIndex, gbDontStopHere
'                           gnUserChoice, gbBadFormula, gGroupDefine
'
SUB DragDrop4 (source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup, Target AS FORM)
DIM nOriginIndex, nInitialPosition, nIndexTemp
DIM nFinalPosition, N, M, P
DIM nGroupOfOrigin
DIM bConnectionSuccessful
DIM nIndexPartOrWhole
DIM sProperty AS STRING
DIM nYAdjust
DIM sTemp AS STRING
DIM nSize
DIM nFoundMatch, nLabelAdjust

' The label's tag is blank, index number, blank, group number, units,
' as in " 2 1gram".
nSize = VAL(sSize)
nGroupOfOrigin = VAL(MID$(source.Tag, 3, 2))
IF nvGroup = 6 THEN
   P = 1
ELSEIF nvGroup = 5 OR nvGroup = 7 THEN
   P = 0
   IF nvGroup = 5 THEN nLabelAdjust = 3
ELSEIF nvGroup = 8 THEN
   P = 2
ELSE ' if nvGroup = 9, 10, ... 14
   IF nGroupOfOrigin > 8 THEN EXIT SUB
END IF
IF nGroupOfOrigin = nvGroup THEN
   ' Formula is being changed.

   IF nSize = 1 THEN
      ' Don't allow the formula to be rearranged if the frame is small.
      EXIT SUB
   ELSE
      ' Index of control to move.
      nOriginIndex = VAL(LEFT$(source.Tag, 2))

      ' Determine the position where control was dropped.
      IF P = 1 THEN
         IF nOriginIndex = 24 OR nOriginIndex = 25 THEN EXIT SUB  ' Ignore moles in titration.
         nFinalPosition = nDragDrop6Locate(X, Y, 2, nvGroup, Target)
      ELSEIF P = 2 THEN
         nFinalPosition = nDragDrop5Locate(X, Y, 2, nvGroup, Target)
      ELSE
         nFinalPosition = nDragDrop4Locate(X, Y, 2, nvGroup, Target)
      END IF
      IF nFinalPosition = -1 THEN EXIT SUB   ' Dropped on a boundary.
      ' Rearrange the formula.

      ' Controls' starting position.
      nInitialPosition = VAL(Target.lblVariable(nOriginIndex).Tag)

      ' Only move controls if position changed.
      IF nInitialPosition <> nFinalPosition THEN

         ' Move dragged controls to present position.
         IF nFinalPosition > 3 THEN
            ' Bottom value is above label.
            nYAdjust = 1
         ELSE
            ' Other values are below label.
            nYAdjust = -1
         END IF
         Target.txtVariable(nOriginIndex).MOVE mLocation4(P, nFinalPosition).X, mLocation4(P, nFinalPosition).Y
         Target.lblVariable(nOriginIndex).MOVE mLocation4(P, nFinalPosition).X + nLabelAdjust, mLocation4(P, nFinalPosition).Y + nYAdjust
         Target.lblVariable(nOriginIndex).Tag = STR$(nFinalPosition)
         IF gnConnected(nOriginIndex) THEN
            IF nInitialPosition = 0 THEN
               ' Control was dependent variable, but isn't now.
               Disconnect gnConnected(nOriginIndex)
            ELSEIF nFinalPosition = 0 THEN
               ' Control has changed from independent to dependent variable.
               Disconnect nOriginIndex
            END IF
         END IF

         ' Move any control in final position to initial position.
         IF gOccupantIndex(nvGroup, nFinalPosition) > -1 THEN
            ' Somebody's already here, so move them to previous position.

            nIndexTemp = gOccupantIndex(nvGroup, nFinalPosition)
            IF nInitialPosition > 3 THEN
               ' Bottom value is above label.
               nYAdjust = 1
            ELSE
               ' Other values are below label.
               nYAdjust = -1
            END IF
            Target.txtVariable(nIndexTemp).MOVE mLocation4(P, nInitialPosition).X, mLocation4(P, nInitialPosition).Y
            Target.lblVariable(nIndexTemp).MOVE mLocation4(P, nInitialPosition).X + nLabelAdjust, mLocation4(P, nInitialPosition).Y + nYAdjust
            Target.lblVariable(nIndexTemp).Tag = STR$(nInitialPosition)
            IF gnConnected(nIndexTemp) THEN
               IF nFinalPosition = 0 THEN
                  ' Control was dependent variable, but isn't now.
                  Disconnect gnConnected(nIndexTemp)
               ELSEIF nInitialPosition = 0 THEN
                  ' Control has changed from independent to dependent variable.
                  Disconnect nIndexTemp
               END IF
            END IF
         END IF
         gOccupantIndex(nvGroup, nInitialPosition) = gOccupantIndex(nvGroup, nFinalPosition)
         gOccupantIndex(nvGroup, nFinalPosition) = nOriginIndex

         ' The formula has been rearranged.  The original dependent variable
         ' could still be connected (if the two independents changed places).
         ' Disconnect it if it is connected.
         nIndexTemp = gnConnected(gOccupantIndex(nvGroup, 0))
         IF nIndexTemp THEN
            Disconnect nIndexTemp
         END IF

        ' Determine if the formula is valid.
         IF P = 1 THEN
            EvaluateFormula6 nvGroup, Target
         ELSEIF P = 0 THEN
            EvaluateFormula4 nvGroup, Target
         ELSE     'IF P = 2 THEN
            EvaluateFormula5 nvGroup, Target
         END IF

      END IF
   END IF
ELSE
   ' A label has just been dropped on this form from another form.
   ' Attempt to add connectivity.

   ' Don't ask user what to put where if equations aren't valid.
   IF bConnectionWontWork(nOriginIndex, nGroupOfOrigin, source, nvGroup) THEN EXIT SUB

   ' Get property from tag.
   sProperty = MID$(source.Tag, 5)

   ' ************************* Percent Dropped ******************************
   ' Logic for handling percent:  Consider all possibilities.
   '  If part or whole from percent is dropped on the form, it either matches
   '  anything, or else has units.  It has units if either part or whole (or
   '  both) is connected.
   '  If neither is connected,
   '     see if it was dropped on an independent variable.
   '     If not, ask the user which variable to connect to.
   '  If it has units,
   '     see if the units match an independent variable.

   IF nOriginIndex = 10 OR nOriginIndex = 11 THEN
      ' Part or whole from percent was dropped.
      IF gnConnected(10) OR gnConnected(11) THEN
         ' If the percent form already has a connection, the connection's
         ' properties must match something on the target form for another
         ' connection to be made.
         sProperty = msPercentProperty
      END IF
   END IF

   ' ************************* Attempt Connection ***************************
   ' Incomming control's units must match an independent variable's units.
   FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
      IF Target.txtVariable(N).Tag = sProperty OR sProperty = "*" THEN
         ' Units match.
         IF NOT gbDontStopHere(N) THEN
            ' Can connect because target is an independent variable.
            M = M + 1
            mnIndexOfPropertyMatch(M) = N
         END IF
      END IF
   NEXT N

   IF M = 1 THEN
      ' Make the one possible connection.
      bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, mnIndexOfPropertyMatch(1), nvGroup, Target)
   ELSEIF M > 1 THEN
      ' Determine the position where the variable was dropped.
      IF P = 1 THEN
         IF nOriginIndex = 24 OR nOriginIndex = 25 THEN EXIT SUB  ' Ignore moles in titration.
         nFinalPosition = nDragDrop6Locate(X, Y, nSize, nvGroup, Target)
      ELSEIF P = 2 THEN
         nFinalPosition = nDragDrop5Locate(X, Y, nSize, nvGroup, Target)
      ELSE
         nFinalPosition = nDragDrop4Locate(X, Y, nSize, nvGroup, Target)
      END IF

      ' If this matches an available location, connect

      IF nFinalPosition > -1 THEN
         FOR N = 1 TO M
            IF gOccupantIndex(nvGroup, nFinalPosition) = mnIndexOfPropertyMatch(N) THEN
               nFoundMatch = N
               EXIT FOR
            END IF
         NEXT N
      END IF

      IF nFoundMatch THEN
         bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, mnIndexOfPropertyMatch(nFoundMatch), nvGroup, Target)
      ELSE
         ' Ask user to choose which variable to connect to.
         gnUserChoice = -2
         FOR N = 1 TO M
            nIndexTemp = mnIndexOfPropertyMatch(N)
            IF (nIndexTemp - 42) MOD 6 <> 0 THEN   ' Skip coefficients in Reactions.
               frmchoose.optVariable(N).Visible = TRUE
               sTemp = ", " + LTRIM$(Target.lblVariable(nIndexTemp).Caption)
               frmchoose.optVariable(N).Caption = Target.txtVariable(nIndexTemp).Tag + sTemp
            END IF
         NEXT N
         frmchoose.Caption = Target.Caption
         frmchoose.SHOW 1
         IF gnUserChoice = 0 THEN
            EXIT SUB
         ELSE
            bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, mnIndexOfPropertyMatch(gnUserChoice), nvGroup, Target)
         END IF
      END IF
   END IF

   IF NOT bConnectionSuccessful THEN
      InfoShow Screen.ActiveControl, "Incoming units not present right of equal sign.", BRIGHT_WHITE
   END IF
END IF

END SUB

' Rearranges the formula or makes a connection for frmPercent
'
' Input:    Source      Control being dropped
'           X           X and Y coordinates on form where control was dropped
'           Y
'           sSize       Size of form where dropped
'           nvGroup     Group where dropped
'           Target      Form where dropped
'
' Called by:  DragDrop event in frmPercent.
'  Module level variables:  mLocation, msPercentProperty, mnIndexOfPropertyMatch
'                           mnPercentUnits, mnUnits
'        Global variables:  gnConnected, gOccupantIndex, gbDontStopHere
'                           gbBadFormula
'
SUB DragDropPct (source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup, Target AS FORM)
DIM nOriginIndex, nInitialPosition, nIndexTemp
DIM nFinalPosition, N
DIM nGroupOfOrigin
DIM bConnectionSuccessful
DIM sMsg AS STRING
DIM nXtxt, nXlbl
DIM nIndexPartOrWhole
DIM sProperty AS STRING

' The label's tag is blank, index number, blank, group number, units,
' as in " 2 1gram".

nGroupOfOrigin = VAL(MID$(source.Tag, 3, 2))
IF nGroupOfOrigin = nvGroup THEN
   ' Formula is being changed.

   IF sSize = "1" THEN
      ' Don't allow the formula to be rearranged if the frame is small.
      EXIT SUB
   ELSE
      ' Rearrange the formula.

      ' Determine the new position.
      IF X < 25 THEN    ' Equal sign begins at 25.
         nFinalPosition = 0
      ELSEIF X > 51 AND Y > 1 THEN
         nFinalPosition = 5
      ELSEIF X > 25 AND X < 51 AND Y > 1 THEN
         nFinalPosition = 4
      ELSEIF X > 51 AND Y < 1 THEN
         nFinalPosition = 2
      ELSEIF X > 25 AND X < 51 AND Y < 1 THEN
         nFinalPosition = 1
      ELSE
         ' On a boundry; ignore.
         EXIT SUB
      END IF

      ' Index of control to move.
      nOriginIndex = VAL(LEFT$(source.Tag, 2))
      ' Controls' starting position.
      nInitialPosition = VAL(Target.lblVariable(nOriginIndex).Tag)

      ' Only move controls if position changed.
      IF nInitialPosition <> nFinalPosition THEN
     
         ' Don't allow txtVariable(13), 100, to move to dependent position.
         IF (nOriginIndex = 13 AND nFinalPosition = 0) OR (nInitialPosition = 0 AND gOccupantIndex(nvGroup, nFinalPosition) = 13) THEN
            InfoShow Screen.ActiveControl, "The constant, 100, cannot be left of equal sign.", BRIGHT_WHITE
            EXIT SUB
         END IF

         IF nOriginIndex = 13 THEN
            nXtxt = 12
            nXlbl = -10
         END IF

         ' Move dragged controls to present position.
         Target.txtVariable(nOriginIndex).MOVE mLocation(nFinalPosition).X + nXtxt, mLocation(nFinalPosition).Y
         Target.lblVariable(nOriginIndex).MOVE mLocation(nFinalPosition).X + 19 + nXlbl, mLocation(nFinalPosition).Y
         Target.lblVariable(nOriginIndex).Tag = STR$(nFinalPosition)
         IF gnConnected(nOriginIndex) THEN
            IF nInitialPosition = 0 THEN
               ' Control was dependent variable, but isn't now.
               Disconnect gnConnected(nOriginIndex)
            ELSEIF nFinalPosition = 0 THEN
               ' Control has changed from independent to dependent variable.
               Disconnect nOriginIndex
            END IF
         END IF

         ' Move any control in final position to initial position.
         IF gOccupantIndex(nvGroup, nFinalPosition) > -1 THEN
            ' Somebody's already here, so move them to previous position.

            nIndexTemp = gOccupantIndex(nvGroup, nFinalPosition)
            IF nIndexTemp = 13 THEN
               nXtxt = 12
               nXlbl = -10
            ELSE
               nXtxt = 0
               nXlbl = 0
            END IF
            Target.txtVariable(nIndexTemp).MOVE mLocation(nInitialPosition).X + nXtxt, mLocation(nInitialPosition).Y
            Target.lblVariable(nIndexTemp).MOVE mLocation(nInitialPosition).X + 19 + nXlbl, mLocation(nInitialPosition).Y
            Target.lblVariable(nIndexTemp).Tag = STR$(nInitialPosition)
            IF gnConnected(nIndexTemp) THEN
               IF nFinalPosition = 0 THEN
                  ' Control was dependent variable, but isn't now.
                  Disconnect gnConnected(nIndexTemp)
               ELSEIF nInitialPosition = 0 THEN
                  ' Control has changed from independent to dependent variable.
                  Disconnect nIndexTemp
               END IF
            END IF
         END IF
         gOccupantIndex(nvGroup, nInitialPosition) = gOccupantIndex(nvGroup, nFinalPosition)
         gOccupantIndex(nvGroup, nFinalPosition) = nOriginIndex

         ' The formula has been rearranged.  The original dependent variable
         ' could still be connected (if the two independents changed places).
         ' Disconnect it if it is connected.
         nIndexTemp = gnConnected(gOccupantIndex(nvGroup, 0))
         IF nIndexTemp THEN
            Disconnect nIndexTemp
         END IF

         ' Determine if the formula is valid.
         EvaluateFormulaPct nvGroup, Target

      END IF
   END IF
ELSE
' A label has just been dropped on this form from another form.
' Attempt to add connectivity.

   ' Don't ask user what to put where if equations aren't valid.
   IF bConnectionWontWork(nOriginIndex, nGroupOfOrigin, source, nvGroup) THEN EXIT SUB

   ' Determine the position where the variable was dropped.
   IF frmPercent.cmdSize.Tag = "2" THEN      ' Form is large.
      IF X < 25 THEN    ' Equal sign begins at 25.
         nFinalPosition = 0
      ELSEIF X > 51 AND Y > 1 THEN
         nFinalPosition = 5
      ELSEIF X > 25 AND X < 51 AND Y > 1 THEN
         nFinalPosition = 4
      ELSEIF X > 51 AND Y < 1 THEN
         nFinalPosition = 2
      ELSEIF X > 25 AND X < 51 AND Y < 1 THEN
         nFinalPosition = 1
      ELSE
         'On a boundry; ignore.
         nFinalPosition = -1
      END IF
   ELSE                                      ' Form is small.
      ' textbox and label extend from 0 to 23.
      ' part is on line 0, whole on line 1, and % on line 2.
      IF X < 24 AND Y = 0 THEN            ' Part
         ' The position of the variables vary according to which variable
         ' is the dependent one.
         nFinalPosition = VAL(frmPercent.lblVariable(11).Tag)
      ELSEIF X < 24 AND Y = 1 THEN        ' Whole
         nFinalPosition = VAL(frmPercent.lblVariable(10).Tag)
      ELSE
         nFinalPosition = -1              ' Not dropped on part or whole.
      END IF
   END IF

' Logic:  The whole and part in percent are like wild cards:  they can match
' any units.  The possibilities are:
'     No connections yet.
'        If whole or part is the dependent variable, then place incoming
'        units in the independent variable, and give dependent variable the
'        same units.

'        If whole and part are both dependent variables, then place
'        incoming units in the variable on which it is dropped.
'           If it is not dropped on a specific variable, then ask
'           whether to connect to the whole or the part.

'     One connection already.
'        If dropped on the connected variable, disconnect it.  Reconnect it
'        to the dropped variable.  Give the other variable the same units.

'        If dropped on the other variable, or on the form, check that units
'        match. If they don't, display a message and quit.  Leave it to the
'        user to disconnect, if desired.

'     Two connections already.
'        If dropped on a connected variable, disconnect it.  Reconnect it
'        to the dropped variable.  Give the other variable the same units.
'        Disconnect the other variable if the units no longer match.
'                  _________________________     \   \    /  /
'                  | Wicked Witch's Castle |       \   \/  /
'                  |         1 mile        |        |    /
'                  |    i'd turn back if   |        |   |
'                  |       i were you      |        |   |
'                  |_______________________|        |   |
'                              |                    |    \
'                              |                   /       \
'              -   - -         |           -      -   -
'                              |
'                              |

'        If dropped on the form, ask which variable to connect to.

   ' Determine connection status.
   IF gnConnected(11) AND gnConnected(10) THEN
      ' Both connected.
      ' If position is on one of them as an independent variable,
      ' disconnect it.  If properties don't match, disconnect the other one.
      ' If position is something else, ask which one to disconnect.
      IF nFinalPosition = VAL(frmPercent.lblVariable(10).Tag) AND NOT gbDontStopHere(10) THEN
         ' Dropped on whole, which is an independent variable.
         nIndexPartOrWhole = 10
      ELSEIF nFinalPosition = VAL(frmPercent.lblVariable(11).Tag) AND NOT gbDontStopHere(11) THEN
         ' Dropped on part, which is an independent variable.
         nIndexPartOrWhole = 11
      ELSE
         ' Dropped somewhere else on form.  Connect to unconnected
         ' independent variable.  If just one independent variable and its
         ' connected, connect to that one.
         IF gbDontStopHere(10) THEN
            ' Whole is dependent variable; connect to part.
            nIndexPartOrWhole = 11
         ELSEIF gbDontStopHere(11) THEN
            ' Part is dependent variable; connect to whole.
            nIndexPartOrWhole = 10
         ELSE
            ' Both are independent variables.  Let user decide.
            sMsg = "Connect to the part?" + CHR$(10) + CHR$(10)
            sMsg = sMsg + "   Part       Whole       Nothing"
            N = MSGBOX(sMsg, 3, "Connect to Percent")
            IF N = 2 THEN              ' Cancel
               EXIT SUB
            ELSEIF N = 6 THEN          ' Yes
               ' Connect to the part.
               nIndexPartOrWhole = 11
            ELSEIF N = 7 THEN          ' No
               ' Connect to the whole.
               nIndexPartOrWhole = 10
            END IF
         END IF
      END IF

      ' If the properties have changed, disconnect other one.
      sProperty = MID$(source.Tag, 5)
      IF msPercentProperty <> sProperty THEN
         nIndexTemp = 21 - nIndexPartOrWhole   ' Index of the other one.
         IF gbDontStopHere(nIndexTemp) THEN
            Disconnect gnConnected(nIndexTemp)
         ELSE
            Disconnect nIndexTemp
         END IF
      END IF
      msPercentProperty = sProperty
      mnPercentUnits = mnUnits(nOriginIndex)
      bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, nIndexPartOrWhole, 4, Target)

   ELSEIF gnConnected(11) OR gnConnected(10) THEN
      ' Just one connected
      IF nFinalPosition = VAL(frmPercent.lblVariable(10).Tag) AND NOT gbDontStopHere(10) THEN
         ' Dropped on whole, which is an independent variable.
         nIndexPartOrWhole = 10
      ELSEIF nFinalPosition = VAL(frmPercent.lblVariable(11).Tag) AND NOT gbDontStopHere(11) THEN
         ' Dropped on part, which is an independent variable.
         nIndexPartOrWhole = 11
      ELSE
         ' Dropped somewhere else on form.  Connect to unconnected
         ' independent variable.  If just one independent variable and its
         ' connected, connect to that one.
         IF gbDontStopHere(10) THEN
            ' Whole is dependent variable; connect to part.
            nIndexPartOrWhole = 11
         ELSEIF gbDontStopHere(11) THEN
            ' Part is dependent variable; connect to whole.
            nIndexPartOrWhole = 10
         ELSE
            ' Both are independent variables.  Connect to unconnected one.
            IF gnConnected(11) THEN
               nIndexPartOrWhole = 10
            ELSE
               nIndexPartOrWhole = 11
            END IF
         END IF
      END IF
      IF gnConnected(nIndexPartOrWhole) THEN
         msPercentProperty = MID$(source.Tag, 5)
         mnPercentUnits = mnUnits(nOriginIndex)
      ELSE
         ' Not connected, which means the other one is.
         ' The properties must match.
         sProperty = MID$(source.Tag, 5)
         IF msPercentProperty <> sProperty THEN
            nIndexTemp = 21 - nIndexPartOrWhole    ' Index of the other one.
            IF gbDontStopHere(nIndexTemp) THEN
               Disconnect gnConnected(nIndexTemp)
            ELSE
               Disconnect nIndexTemp
            END IF
         END IF
      END IF
      bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, nIndexPartOrWhole, 4, Target)
   ELSE
      ' Neither connected.

      IF nFinalPosition = VAL(frmPercent.lblVariable(10).Tag) AND NOT gbDontStopHere(10) THEN
         ' Dropped on whole, which is an independent variable.
         nIndexPartOrWhole = 10
      ELSEIF nFinalPosition = VAL(frmPercent.lblVariable(11).Tag) AND NOT gbDontStopHere(11) THEN
         ' Dropped on part, which is an independent variable.
         nIndexPartOrWhole = 11
      ELSE
         ' Dropped somewhere else on form.
         IF gOccupantIndex(4, 0) = 12 THEN
            ' Both are dependent variables; ask user which to use.
            sMsg = "Connect to the part?" + CHR$(10) + CHR$(10)
            sMsg = sMsg + "   Part       Whole       Nothing"
            N = MSGBOX(sMsg, 3, "Connect to Percent")
            IF N = 2 THEN              ' Cancel
               EXIT SUB
            ELSEIF N = 6 THEN          ' Yes
               ' Connect to the part.
               nIndexPartOrWhole = 11
            ELSEIF N = 7 THEN          ' No
               ' Connect to the whole.
               nIndexPartOrWhole = 10
            END IF
         ELSE
            ' Either part or whole is the dependent variable.
            ' Connect to the one that is the independent variable.
            IF gOccupantIndex(4, 0) = 10 THEN
               ' Whole is dependent; connect to part.
               nIndexPartOrWhole = 11
            ELSE
               ' Part is dependent; connect to whole.
               nIndexPartOrWhole = 10
            END IF
         END IF
      END IF
      bConnectionSuccessful = bMakeConnection(nOriginIndex, nGroupOfOrigin, source, nIndexPartOrWhole, 4, Target)
      msPercentProperty = MID$(source.Tag, 5)
      mnPercentUnits = mnUnits(nOriginIndex)
   END IF
END IF

END SUB

' Determine if the formula in frmIdealGas is arranged correctly.
'  Input:  nvGroup        Group to which form belongs.
'          Src     Form to evaluate.
'
'  Called by:  DragDrop4
'  Module level variables:  mnUnits
'        Global variables:  gOccupantIndex, gbBadFormula, gbDontStopHere
'                           gGroupDefine
'
SUB EvaluateFormula5 (BYVAL nvGroup, Src AS FORM)
DIM N, bUnrecognizedFormula, N1, N2, N3, N4, N5
DIM nResult, bError
DIM nPositionN1, nPositionN2, nPositionN3, nPositionN4, nPositionN5
STATIC snTries
      N1 = gGroupDefine(nvGroup).LowestIndex       ' V
      N2 = N1 + 1                                  ' n
      N3 = N1 + 2                                  ' P
      N4 = N1 + 3                                  ' T
      N5 = N1 + 4                                  ' R
   ' Get the present positions of the variables.
   nPositionN1 = VAL(Src.lblVariable(N1).Tag)
   nPositionN2 = VAL(Src.lblVariable(N2).Tag)
   nPositionN3 = VAL(Src.lblVariable(N3).Tag)
   nPositionN4 = VAL(Src.lblVariable(N4).Tag)
   nPositionN5 = VAL(Src.lblVariable(N5).Tag)
   IF gOccupantIndex(nvGroup, 0) = N1 THEN
      ' V = n R T / P  N1 = N2 N5 N4 / N3
      IF nPositionN2 < 4 AND nPositionN4 < 4 AND nPositionN5 < 4 AND nPositionN3 > 3 THEN
         '                    on top                                    on bottom
         Src.lblDragDrop.Tag = STR$(N1)
         Src.lblDragDrop.Caption = "OB"  ' Runs optDependent_Click
      ELSE
         bUnrecognizedFormula = TRUE
      END IF
   ELSEIF gOccupantIndex(nvGroup, 0) = N2 THEN
      ' n = P V / R T   N2 = N3 N1 / N5 N4
      IF nPositionN3 < 4 AND nPositionN1 < 4 AND nPositionN5 > 3 AND nPositionN4 > 3 THEN
         '                    on top                 on bottom
         Src.lblDragDrop.Tag = STR$(N2)
         Src.lblDragDrop.Caption = "OB"  ' "Click" option button.
      ELSE
         bUnrecognizedFormula = TRUE
      END IF
   ELSEIF gOccupantIndex(nvGroup, 0) = N3 THEN
      ' P = n R T / V  N3 = N2 N5 N4 / N1
      IF nPositionN2 < 4 AND nPositionN5 < 4 AND nPositionN4 < 4 AND nPositionN1 > 3 THEN
         '                    on top                                    on bottom
         Src.lblDragDrop.Tag = STR$(N3)
         Src.lblDragDrop.Caption = "OB"  ' "Click" option button.
      ELSE
         bUnrecognizedFormula = TRUE
      END IF
   ELSEIF gOccupantIndex(nvGroup, 0) = N4 THEN
      ' T = P V / n R  N4 = N3 N1 / N2 N5
      IF nPositionN3 < 4 AND nPositionN1 < 4 AND nPositionN5 > 3 AND nPositionN2 > 3 THEN
         '                    on top                 on bottom
         Src.lblDragDrop.Tag = STR$(N4)
         Src.lblDragDrop.Caption = "OB"  ' "Click" option button.
      ELSE
         bUnrecognizedFormula = TRUE
      END IF
   ELSEIF gOccupantIndex(nvGroup, 0) = N5 THEN
      ' R = P V / n T  N5 = N3 N1 / N2 N4
      IF nPositionN3 < 4 AND nPositionN1 < 4 AND nPositionN4 > 3 AND nPositionN2 > 3 THEN
         '                    on top                 on bottom
         Src.lblDragDrop.Tag = STR$(N5)
         Src.lblDragDrop.Caption = "OB"  ' "Click" option button.
      ELSE
         bUnrecognizedFormula = TRUE
      END IF
   ELSEIF gOccupantIndex(nvGroup, 0) = -1 THEN
      bUnrecognizedFormula = TRUE
   END IF
   IF bUnrecognizedFormula THEN
      gbBadFormula(nvGroup) = TRUE
      snTries = snTries + 1
      FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
         Src.txtVariable(N).BackColor = CYAN
         gbDontStopHere(N) = TRUE
      NEXT N
      Src.cmdSize.Enabled = False
      Src.lblXT2.Visible = TRUE
      Src.lblDivisionLine.Width = 57
   ELSE
      gbBadFormula(nvGroup) = False
      Src.cmdSize.Enabled = TRUE
      IF gOccupantIndex(8, 0) = 34 OR gOccupantIndex(8, 0) = 36 THEN
         Src.lblXT2.Visible = TRUE
         Src.lblXB1.Visible = False
         Src.lblDivisionLine.Width = 57
      ELSE
         Src.lblXT2.Visible = False
         Src.lblXB1.Visible = TRUE
         Src.lblDivisionLine.Width = 37
         SwitchGeneral 1, 2, 20, nvGroup, Src
         SwitchGeneral 2, 3, 20, nvGroup, Src
         SwitchGeneral 4, 5, 20, nvGroup, Src
         SwitchGeneral 5, 6, 20, nvGroup, Src
      END IF
      CalculateFormula gOccupantIndex(nvGroup, 0)
      IF snTries > 4 THEN
         ' Play "Clair de lune" when get the formula right.
         PLAY "MBT160MLO2L8A-L2O3A-L4F.O2L8AO3E-FL2E-"
         PLAY "MLO2L8A-O3D-E-D-.L4F.L8D-.O2G-O3CD-L2C."
      END IF
      snTries = 0
   END IF

END SUB

' Selects the position of a form when it is first loaded.
'  Input:   nvGroup     Group of form being loaded
'           Source      The form being loaded
'
'  Called by:  MDI formload, and when user loads form with menu.
'  Module level variables:  mFormPosition(N).Group .SmallTop .SmallLeft
'                           mnLittleLeft  mnLittleTop()
SUB FormPosition (BYVAL nvGroup, source AS FORM)
' The locations are initialized in InitialValues.
' The locations are freed in each form's unload event.

DIM N
' Find the first free location.
FOR N = 1 TO 8
   IF mFormPosition(N).Group = 0 THEN
      mFormPosition(N).Group = nvGroup
      EXIT FOR
   END IF
NEXT N
' N is free.  Place form nvCallingGroup at that location.
source.Top = mFormPosition(N).Top
mnLittleTop(nvGroup) = mFormPosition(N).SmallTop
mnLittleLeft(nvGroup) = mFormPosition(N).SmallLeft
END SUB

' Frees a form's initial location.
' Disconnects any connections on the form; sets number & uncertainty to 0.
'   Input:  nvGroup      Group of form.
'
'   Called by many forms' Unload event.
'
'   Module level variables:  mFormPosition()
'         Global variables:  gOccupantIndex  gdNumber  gdUncertainty
'                            gGroupDefine
SUB FormPositionClear (BYVAL nvGroup)
DIM N
frmMdi.mnuWindowForm(nvGroup).Checked = False
ON LOCAL ERROR GOTO TriedToMakeLastMenuItemInvisible
frmMdi.mnuMoveConnectToForm(nvGroup - 1).Visible = False
FOR N = 1 TO 8
   IF mFormPosition(N).Group = nvGroup THEN
      mFormPosition(N).Group = 0
      EXIT FOR
   END IF
NEXT N
FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
   IF gnConnected(N) THEN
      IF gOccupantIndex(nvGroup, 0) = N THEN
         Disconnect gnConnected(N)
      ELSE
         Disconnect N
      END IF
   END IF
   gdNumber(N) = 0
   gdUncertainty(N) = 0
NEXT N
EXIT SUB

TriedToMakeLastMenuItemInvisible:
   frmMdi.mnuMoveConnect.Enabled = False
   frmMdi.mnuMoveDisconnect.Enabled = False
   RESUME NEXT

END SUB

'  Moves variables in frmGas to valid positions.
'         Input:  nvSize   Size of frmGas, 1 for small, 2 for large.
'
'     Called by:  frmGas.cmdVariables_Click
'  Module level variables:  mLocation4, mnIndexOfPropertyMatch [any array would do]
'        Global variables:  gOccupantIndex, gbDontStopHere, mnHide
'
SUB GasMoveVariable (BYVAL nvSize)
DIM nLineCounter, N, n4or5, nIndex
   IF nvSize = 2 THEN   ' Large form
      frmGas.txtVariable(gOccupantIndex(7, 0)).MOVE mLocation4(0, 0).X, mLocation4(0, 0).Y
      frmGas.lblVariable(gOccupantIndex(7, 0)).MOVE mLocation4(0, 0).X, mLocation4(0, 0).Y - 1
      frmGas.txtVariable(gOccupantIndex(7, 1)).MOVE mLocation4(0, 1).X, mLocation4(0, 1).Y
      frmGas.lblVariable(gOccupantIndex(7, 1)).MOVE mLocation4(0, 1).X, mLocation4(0, 1).Y - 1
      frmGas.txtVariable(gOccupantIndex(7, 2)).MOVE mLocation4(0, 2).X, mLocation4(0, 2).Y
      frmGas.lblVariable(gOccupantIndex(7, 2)).MOVE mLocation4(0, 2).X, mLocation4(0, 2).Y - 1
      nIndex = gOccupantIndex(7, 4)
      IF nIndex = -1 THEN
         nIndex = gOccupantIndex(7, 5)
         n4or5 = 5
      ELSE
         n4or5 = 4
      END IF
      frmGas.txtVariable(nIndex).MOVE mLocation4(0, n4or5).X, mLocation4(0, n4or5).Y
      frmGas.lblVariable(nIndex).MOVE mLocation4(0, n4or5).X, mLocation4(0, n4or5).Y + 1

      IF NOT gbDontStopHere(29) OR NOT gbDontStopHere(26) THEN       ' V1 or V2 is in equation.
         frmGas.lblVolume.MOVE 1, 5
         frmGas.lblVolume.Visible = TRUE
         frmGas.cboVolumeUnit.MOVE 10, 5
         frmGas.cboVolumeUnit.Visible = TRUE
      ELSE
         frmGas.lblVolume.Visible = False
         frmGas.cboVolumeUnit.Visible = False
      END IF
      IF NOT gbDontStopHere(27) OR NOT gbDontStopHere(28) THEN    ' P1 or P2 is in equation.
         frmGas.lblPressure.MOVE 19, 5
         frmGas.lblPressure.Visible = TRUE
         frmGas.cboPressureUnit.MOVE 30, 5
         frmGas.cboPressureUnit.Visible = TRUE
      ELSE
         frmGas.lblPressure.Visible = False
         frmGas.cboPressureUnit.Visible = False
      END IF
      IF NOT gbDontStopHere(32) OR NOT gbDontStopHere(31) THEN      ' T1 or T2 is in equation.
         frmGas.lblTemp.MOVE 44, 5
         frmGas.lblTemp.Visible = TRUE
         frmGas.cboTempUnit.MOVE 58, 5
         frmGas.cboTempUnit.Visible = TRUE
      ELSE
         frmGas.lblTemp.Visible = False
         frmGas.cboTempUnit.Visible = False
      END IF
   ELSE                       ' Small form.
      SELECT CASE VAL(frmGas.cmdVariables.Tag)
         CASE 1   ' PT
            ' Yes, it's long, but it was already dimensioned.
            mnIndexOfPropertyMatch(1) = 27: mnIndexOfPropertyMatch(2) = 32: mnIndexOfPropertyMatch(3) = 28: mnIndexOfPropertyMatch(4) = 31
            mnHide(1) = 26: mnHide(2) = 29: mnHide(3) = 30: mnHide(4) = 33
         CASE 2   ' PV
            mnIndexOfPropertyMatch(1) = 27: mnIndexOfPropertyMatch(2) = 29: mnIndexOfPropertyMatch(3) = 28: mnIndexOfPropertyMatch(4) = 26
            mnHide(1) = 30: mnHide(2) = 31: mnHide(3) = 32: mnHide(4) = 33
         CASE 3   ' Pn
            mnIndexOfPropertyMatch(1) = 27: mnIndexOfPropertyMatch(2) = 30: mnIndexOfPropertyMatch(3) = 28: mnIndexOfPropertyMatch(4) = 33
            mnHide(1) = 26: mnHide(2) = 29: mnHide(3) = 31: mnHide(4) = 32
         CASE 4   ' TV
            mnIndexOfPropertyMatch(1) = 29: mnIndexOfPropertyMatch(2) = 32: mnIndexOfPropertyMatch(3) = 26: mnIndexOfPropertyMatch(4) = 31
            mnHide(1) = 27: mnHide(2) = 28: mnHide(3) = 30: mnHide(4) = 33
         CASE 5   ' Tn
            mnIndexOfPropertyMatch(1) = 32: mnIndexOfPropertyMatch(2) = 30: mnIndexOfPropertyMatch(3) = 31: mnIndexOfPropertyMatch(4) = 33
            mnHide(1) = 26: mnHide(2) = 27: mnHide(3) = 28: mnHide(4) = 29
         CASE 6   ' Vn
            mnIndexOfPropertyMatch(1) = 29: mnIndexOfPropertyMatch(2) = 30: mnIndexOfPropertyMatch(3) = 26: mnIndexOfPropertyMatch(4) = 33
            mnHide(1) = 27: mnHide(2) = 28: mnHide(3) = 31: mnHide(4) = 32
      END SELECT
      FOR N = 1 TO 4
         frmGas.txtVariable(mnIndexOfPropertyMatch(N)).MOVE 0, N - 1
         frmGas.lblVariable(mnIndexOfPropertyMatch(N)).MOVE 19, N - 1
         frmGas.optDependent(mnIndexOfPropertyMatch(N)).MOVE 24, N - 1
         frmGas.optDependent(mnIndexOfPropertyMatch(N)).Visible = TRUE
         frmGas.optDependent(mnHide(N)).Visible = False
      NEXT N

      nLineCounter = 7
      IF NOT gbDontStopHere(27) OR NOT gbDontStopHere(28) THEN    ' P1 or P2 is in equation.
         frmGas.lblPressure.MOVE 4, 7
         frmGas.lblPressure.Visible = TRUE
         frmGas.cboPressureUnit.MOVE 15, 7
         frmGas.cboPressureUnit.Visible = TRUE
         nLineCounter = 8
      ELSE
         frmGas.lblPressure.Visible = False
         frmGas.cboPressureUnit.Visible = False
      END IF
      IF NOT gbDontStopHere(29) OR NOT gbDontStopHere(26) THEN       ' V1 or V2 is in equation.
         frmGas.lblVolume.MOVE 6, nLineCounter
         frmGas.lblVolume.Visible = TRUE
         frmGas.cboVolumeUnit.MOVE 15, nLineCounter
         frmGas.cboVolumeUnit.Visible = TRUE
         nLineCounter = nLineCounter + 1
      ELSE
         frmGas.lblVolume.Visible = False
         frmGas.cboVolumeUnit.Visible = False
      END IF
      IF NOT gbDontStopHere(32) OR NOT gbDontStopHere(31) THEN      ' T1 or T2 is in equation.
         frmGas.lblTemp.MOVE 1, nLineCounter
         frmGas.lblTemp.Visible = TRUE
         frmGas.cboTempUnit.MOVE 15, nLineCounter
         frmGas.cboTempUnit.Visible = TRUE
      ELSE
         frmGas.lblTemp.Visible = False
         frmGas.cboTempUnit.Visible = False
      END IF
   END IF
END SUB

'  Resets the values of mnUnits for various forms.
'         Input:  nvGroup    Which group's mnUnits need to be initialized.
'
'     Called by:  FormLoad of modules with combo boxes, and frmPercent.
'  Module level variables:  mnUnits
'
SUB Initialize_mnUnits (BYVAL nvGroup)
SELECT CASE nvGroup
   CASE 4
      mnUnits(10) = WILDCARD
      mnUnits(11) = WILDCARD
      msPercentProperty = ""
      mnPercentUnits = 0
   CASE 5
      mnUnits(14) = LITER
      mnUnits(15) = MOLE_PER_L
      mnUnits(16) = MOLE_PER_L
      mnUnits(17) = LITER
   CASE 6   ' titration
      mnUnits(18) = LITER
      mnUnits(19) = MOLE_PER_L
      mnUnits(20) = MOLE_PER_L
      mnUnits(21) = LITER
      mnUnits(24) = MOLE
      mnUnits(25) = MOLE
   CASE 7   ' gas change
      mnUnits(26) = LITER
      mnUnits(27) = ATM
      mnUnits(28) = ATM
      mnUnits(29) = LITER
      mnUnits(30) = MOLE
      mnUnits(31) = CELSIUS
      mnUnits(32) = CELSIUS
      mnUnits(33) = MOLE
   CASE 8   ' ideal gas
      mnRPressureUnits = PA
      mnRVolumeUnits = LITER
      mnUnits(34) = LITER
      mnUnits(36) = ATM
      mnUnits(37) = CELSIUS
END SELECT
END SUB

SUB InitialValues ()
   ' Making these dynamic saved a lot of space.
   REDIM gOccupantIndex(1 TO 14, 7) AS INTEGER  ' Who's in each position.
                                             ' The Dependent variable is always
                                             ' in position 0.
   REDIM gsOriginalText(1 TO 14) AS STRING    ' Escape recalls this former entry.

   REDIM gbDontStopHere(0 TO 74) AS INTEGER  ' True for an independent variable
                                             ' that is part of a valid formula.
   REDIM gnConnected(-1 TO 74) AS INTEGER    ' Index of connected control.
                                             ' -1 used when nothing on left of =.
   REDIM gbBadFormula(1 TO 14) AS INTEGER     ' Indicates formula has been
                                             ' rearranged and is unrecognized.
   REDIM gdNumber(1 TO 80) AS DOUBLE         ' The numbers that have been entered.
   REDIM gdUncertainty(1 TO 80) AS DOUBLE

   ' This saves memory (in the vb environment) by storing strings in a different area.
   REDIM gGroupDefine(1 TO 14) AS Definition
   REDIM mLocation(5) AS Position          ' Positions of controls in form.
   REDIM mFormPosition(1 TO 8) AS FormLocations
   REDIM mnBigTop(8), mnBigLeft(8), mnLittleTop(8), mnLittleLeft(8)
   REDIM mnUnits(1 TO 74)
   REDIM mnIndexOfPropertyMatch(1 TO 4) ' Used in DragDrop4, and in GasMoveVariable
   REDIM mnHide(1 TO 4)

   REDIM msFormula(74) AS STRING  ' Contains the formulas to display in connected controls.
   REDIM msConversion(80) AS STRING

   ' The custom name must be given a value; if left blank, it would be used
   ' for every blank entry.
   ' "333" is "impossible" for the user to enter.
   gsCustomName = "333"

   '  Define the arrangement of groups of variables.  For example, the first
   '  group, grammole, has three variables with indices ranging from 0 to 2.
   '
   gGroupDefine(1).LowestIndex = 1     ' grams moles
   gGroupDefine(1).HighestIndex = 3
   gGroupDefine(2).LowestIndex = 4     ' density
   gGroupDefine(2).HighestIndex = 6
   gGroupDefine(3).LowestIndex = 7     ' molarity
   gGroupDefine(3).HighestIndex = 9
   gGroupDefine(4).LowestIndex = 10    ' percent
   gGroupDefine(4).HighestIndex = 12
                                       ' 13 is missing: that's 100 in percent.
   gGroupDefine(5).LowestIndex = 14    ' dilution
   gGroupDefine(5).HighestIndex = 17
   gGroupDefine(6).LowestIndex = 18    ' titration
   gGroupDefine(6).HighestIndex = 25
                                       ' 24 & 25 missing:  moles.
   gGroupDefine(7).LowestIndex = 26    ' gas change
   gGroupDefine(7).HighestIndex = 33
   gGroupDefine(8).LowestIndex = 34    ' ideal gas
   gGroupDefine(8).HighestIndex = 38
   gGroupDefine(9).LowestIndex = 39    ' ideal gas
   gGroupDefine(9).HighestIndex = 44
   gGroupDefine(10).LowestIndex = 45    ' ideal gas
   gGroupDefine(10).HighestIndex = 50
   gGroupDefine(11).LowestIndex = 51    ' ideal gas
   gGroupDefine(11).HighestIndex = 56
   gGroupDefine(12).LowestIndex = 57    ' ideal gas
   gGroupDefine(12).HighestIndex = 62
   gGroupDefine(13).LowestIndex = 63    ' ideal gas
   gGroupDefine(13).HighestIndex = 68
   gGroupDefine(14).LowestIndex = 69    ' ideal gas
   gGroupDefine(14).HighestIndex = 74
   
   ' Formulas placed in txtVariable when it is connected to another variable.
   msFormula(1) = "M.M. = g / mole"
   msFormula(2) = "g = mole X M.M."
   msFormula(3) = "mole = g / M.M."
   msFormula(4) = "density = g / mL"
   msFormula(5) = "g = density X mL"
   msFormula(6) = "mL = g / density"
   msFormula(7) = "molarity = mol / L"
   msFormula(8) = "mol = molarity X L"
   msFormula(9) = "L = mol / molarity"
   msFormula(10) = "whole=part /% X100"   ' Maximum length of string.
   msFormula(11) = "part=whole X% /100"
   msFormula(12) = "%=part /whole X100"
   msFormula(14) = "Vf = Vi * Mi / Mf"
   msFormula(15) = "Mi = Mf * Vf / Vi"
   msFormula(16) = "Mf = Mi * Vi / Vf"
   msFormula(17) = "Vi = Vf * Mf / Mi"
          
   msFormula(18) = "V2 =M1*V1/M2*(2/1)"
   msFormula(19) = "M1 =M2*V2/V1*(1/2)"
   msFormula(20) = "M2 =M1*V1/V2*(2/1)"
   msFormula(21) = "V1 =M2*V2/M1*(1/2)"
   msFormula(24) = "mol=M1 * V1 *(2/1)"
   msFormula(25) = "mol = M1 * V1"

   msFormula(34) = "V = nRT/P"
   msFormula(35) = "n = PV/RT"
   msFormula(36) = "P = nRT/V"
   msFormula(37) = "T = PV/nR"
   'msFormula(38) = "R = PV/nT"
   msFormula(43) = "Reactant 1, mol"
   msFormula(44) = "Reactant 1, g"
   msFormula(49) = "Reactant 2, mol"
   msFormula(50) = "Reactant 2, g"
   msFormula(55) = "Reactant 3, mol"
   msFormula(56) = "Reactant 3, g"
   msFormula(61) = "Product 1, mol"
   msFormula(62) = "Product 1, g"
   msFormula(67) = "Product 1, mol"
   msFormula(68) = "Product 1, g"
   msFormula(73) = "Product 1, mol"
   msFormula(74) = "Product 1, g"

   mnUnits(1) = GRAM_PER_MOLE   ' Units of the variables.
   mnUnits(2) = GRAM
   mnUnits(3) = MOLE
   mnUnits(4) = GRAM_PER_ML
   mnUnits(5) = GRAM
   mnUnits(6) = ML
   mnUnits(7) = MOLE_PER_L
   mnUnits(8) = MOLE
   mnUnits(9) = LITER
   mnUnits(12) = percent
   'mnUnits(13) = -1         ' 100, matches nothing

   mnUnits(35) = MOLE
   'mnUnits(38) = ??? R

   mnUnits(39) = GRAM_PER_MOLE
   mnUnits(40) = GRAM
   mnUnits(41) = MOLE
   mnUnits(43) = MOLE
   mnUnits(44) = GRAM
   mnUnits(45) = GRAM_PER_MOLE
   mnUnits(46) = GRAM
   mnUnits(47) = MOLE
   mnUnits(49) = MOLE
   mnUnits(50) = GRAM
   mnUnits(51) = GRAM_PER_MOLE
   mnUnits(52) = GRAM
   mnUnits(53) = MOLE
   mnUnits(55) = MOLE
   mnUnits(56) = GRAM
   mnUnits(57) = GRAM_PER_MOLE
   mnUnits(58) = GRAM
   mnUnits(59) = MOLE
   mnUnits(61) = MOLE
   mnUnits(62) = GRAM
   mnUnits(63) = GRAM_PER_MOLE
   mnUnits(64) = GRAM
   mnUnits(65) = MOLE
   mnUnits(67) = MOLE
   mnUnits(68) = GRAM
   mnUnits(69) = GRAM_PER_MOLE
   mnUnits(70) = GRAM
   mnUnits(71) = MOLE
   mnUnits(73) = MOLE
   mnUnits(74) = GRAM

   'msConversion(0) = ""
   msConversion(1) = "L = mL / 1000"
   msConversion(2) = "mL = L X 1000"
   msConversion(3) = "Celsius = Kelvin - 273.15"
   msConversion(4) = "Fahrenheit = (Kelvin - 273.15) X 9/5 + 32"
   msConversion(5) = "Kelvin = Celsius + 273.15"
   msConversion(6) = "Fahrenheit = Celsius X 9/5 + 32"
   msConversion(7) = "Celsius = (Fahrenheit - 32) X 5/9"
   msConversion(8) = "Kelvin = (Fahrenheit - 32) X 5/9 + 273.15"
   msConversion(9) = "kPa = Pa / 1000"
   msConversion(10) = "bar = Pa / 10,000"
   msConversion(11) = "atm = Pa / 101325"
   msConversion(12) = "mm Hg (torr) = Pa X 760 / 101325"
   msConversion(13) = "psi = Pa X 14.69594 / 101325"
   msConversion(14) = "Pa = kPa X 1000"
   msConversion(15) = "bar = kPa / 100"
   msConversion(16) = "atm = kPa / 101.325"
   msConversion(17) = "mm Hg (torr) = kPa X 760 / 101.325"
   msConversion(18) = "psi = kPa X 14.69594 / 101.325"
   msConversion(19) = "Pa = bar X 1,000,000"
   msConversion(20) = "kPa = bar X 100"
   msConversion(21) = "atm = bar / 1.01325"
   msConversion(22) = "mm Hg (torr) = bar X 760 / 1.01325"
   msConversion(23) = "psi = bar X 14.69594 / 1.01325"
   msConversion(24) = "Pa = atm X 101,325"
   msConversion(25) = "kPa = atm X 101.325"
   msConversion(26) = "bar = atm X 1.01325"
   msConversion(27) = "mm Hg (torr) = atm X 760"
   msConversion(28) = "psi = atm X 14.69594"
   msConversion(29) = "Pa = mm Hg (torr) X 101325# / 760"
   msConversion(30) = "kPa = mm Hg (torr) X 101.325 / 760"
   msConversion(31) = "atm = mm Hg (torr) / 760"
   msConversion(32) = "bar = mm Hg (torr) X 1.01325 / 760"
   msConversion(33) = "psi = mm Hg (torr) X 14.69594 / 760"
   msConversion(34) = "Pa = psi X 101325 / 14.69594"
   msConversion(35) = "kPa = psi X 101.325 / 14.69594"
   msConversion(36) = "atm = psi / 14.69594"
   msConversion(37) = "mm Hg (torr) = psi X 760 / 14.69594"
   msConversion(38) = "bar = psi X 1.01325 / 14.69594"
   msConversion(39) = "mm Hg = torr"

   ' Define the possible positions in forms
   ' ____________________________________________________________________
   '              |       1         |      2          |      3          |
   '      0       |-----------------|-----------------|-----------------|
   ' _____________|_______4_________|______5__________|______6__________|
   '
   mLocation(0).X = 0:  mLocation(0).Y = 1      ' Locations used in
   mLocation(1).X = 27: mLocation(1).Y = 0      ' frmGramMole, frmPercent,
   mLocation(2).X = 52: mLocation(2).Y = 0      ' frmDensity, and frmMolarity
   mLocation(4).X = 27: mLocation(4).Y = 2
   mLocation(5).X = 52: mLocation(5).Y = 2

   ' Locations used in frmDilution, and frmGas.
   mLocation4(0, 0).X = 1: mLocation4(0, 0).Y = 2
   mLocation4(0, 1).X = 23: mLocation4(0, 1).Y = 1
   mLocation4(0, 2).X = 45: mLocation4(0, 2).Y = 1
   mLocation4(0, 4).X = 23: mLocation4(0, 4).Y = 3
   mLocation4(0, 5).X = 45: mLocation4(0, 5).Y = 3

   ' Locations used in frmTitration.
   mLocation4(1, 0).X = 1: mLocation4(1, 0).Y = 2
   mLocation4(1, 1).X = 23: mLocation4(1, 1).Y = 1
   mLocation4(1, 2).X = 45: mLocation4(1, 2).Y = 1
   mLocation4(1, 3).X = 67: mLocation4(1, 3).Y = 1
   mLocation4(1, 4).X = 23: mLocation4(1, 4).Y = 3
   mLocation4(1, 5).X = 45: mLocation4(1, 5).Y = 3
   mLocation4(1, 6).X = 67: mLocation4(1, 6).Y = 3

   ' Locations used in frmIdealGas.
   mLocation4(2, 0).X = 0: mLocation4(2, 0).Y = 2
   mLocation4(2, 1).X = 20: mLocation4(2, 1).Y = 1
   mLocation4(2, 2).X = 40: mLocation4(2, 2).Y = 1
   mLocation4(2, 3).X = 60: mLocation4(2, 3).Y = 1
   mLocation4(2, 4).X = 20: mLocation4(2, 4).Y = 3
   mLocation4(2, 5).X = 40: mLocation4(2, 5).Y = 3
   mLocation4(2, 6).X = 60: mLocation4(2, 6).Y = 3
   ' lblVariable(N).Tag is present location of the control.
   ' txtVariable(N).Tag is the property of that variable (mass, volume, etc.).
   ' cmdSize.Tag contains the present size of the frame.
   ' frmGramMole.Tag contains the index of the most recent active variable.

   mFormPosition(1).Top = 1
   mFormPosition(2).Top = 8
   mFormPosition(3).Top = 16
   mFormPosition(4).Top = 3
   mFormPosition(5).Top = 11
   mFormPosition(6).Top = 0
   mFormPosition(7).Top = 15
   mFormPosition(8).Top = 9
   mFormPosition(1).SmallTop = 1: mFormPosition(1).SmallLeft = 0
   mFormPosition(2).SmallTop = 11: mFormPosition(2).SmallLeft = 0
   mFormPosition(3).SmallTop = 14: mFormPosition(3).SmallLeft = 30
   mFormPosition(4).SmallTop = 3: mFormPosition(4).SmallLeft = 30
   mFormPosition(5).SmallTop = 1: mFormPosition(5).SmallLeft = 51
   mFormPosition(6).SmallTop = 11: mFormPosition(6).SmallLeft = 51
   mFormPosition(7).SmallTop = 7: mFormPosition(7).SmallLeft = 23
   mFormPosition(8).SmallTop = 0: mFormPosition(8).SmallLeft = 7
END SUB

' Determine the position where a control was dropped on 4-variable form.
'  Input:   X        X position where dropped
'           Y        Y position where dropped
'           nSize    Size of form where dropped
'           nvGroup  Group of form where dropped
'           Target   form where dropped
'
'  Returns:  Position where dropped, or -1 if on boundary
'  Called by:  DragDrop4 (used by frmDilution)
'  Module level variables:
'        Global variables:  gGroupDefine
'
FUNCTION nDragDrop4Locate (X AS SINGLE, Y AS SINGLE, BYVAL nSize, BYVAL nvGroup, Target AS FORM) AS INTEGER
' Determine the position where the variable was dropped.
IF nSize = 2 THEN     ' Form is large.
   IF X < 21 THEN    ' Equal sign begins at 21.
      nDragDrop4Locate = 0
   ELSEIF X > 43 AND Y > 2 THEN
      nDragDrop4Locate = 5
   ELSEIF X > 21 AND X < 43 AND Y > 2 THEN
      nDragDrop4Locate = 4
   ELSEIF X > 43 AND Y < 2 THEN
      nDragDrop4Locate = 2
   ELSEIF X > 21 AND X < 43 AND Y < 2 THEN
      nDragDrop4Locate = 1
   ELSE
      'On a boundry; ignore.
      nDragDrop4Locate = -1
   END IF
ELSE                    ' Form is small.
   ' textbox and label extend from 0 to 23.
   ' part is on line 0, whole on line 1, and % on line 2.
   IF X < 24 AND Y = 0 THEN            ' First line
      ' The position of the variables vary according to which variable
      ' is the dependent one.
      nDragDrop4Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 1).Tag)
   ELSEIF X < 24 AND Y = 1 THEN        ' Second line
      nDragDrop4Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 3).Tag)
   ELSEIF X < 24 AND Y = 2 THEN        ' Third line
      nDragDrop4Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 2).Tag)
   ELSEIF X < 24 AND Y = 3 THEN        ' Fourth line
      nDragDrop4Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex).Tag)
   ELSE                                ' Not dropped on part or whole.
      nDragDrop4Locate = -1
   END IF
END IF

END FUNCTION

' Determine the position where a control was dropped on 4-variable form.
'  Input:   X        X position where dropped
'           Y        Y position where dropped
'           nSize    Size of form where dropped
'           nvGroup  Group of form where dropped
'           Target   form where dropped
'
'  Returns:  Position where dropped, or -1 if on boundary
'  Called by:  DragDrop4 (used by frmIdealGas)
'  Module level variables:
'        Global variables:  gGroupDefine
FUNCTION nDragDrop5Locate (X AS SINGLE, Y AS SINGLE, BYVAL nSize, BYVAL nvGroup, Target AS FORM) AS INTEGER
' Determine the position where the variable was dropped.
IF nSize = 2 THEN     ' Large form.
   IF X < 18 THEN
      nDragDrop5Locate = 0
   ELSEIF X > 58 AND Y > 2 THEN
      nDragDrop5Locate = 6
   ELSEIF X > 38 AND X < 58 AND Y > 2 THEN
      nDragDrop5Locate = 5
   ELSEIF X > 18 AND X < 38 AND Y > 2 THEN
      nDragDrop5Locate = 4
   ELSEIF X > 58 AND Y < 2 THEN
      nDragDrop5Locate = 3
   ELSEIF X > 38 AND X < 58 AND Y < 2 THEN
      nDragDrop5Locate = 2
   ELSEIF X > 18 AND X < 38 AND Y < 2 THEN
      nDragDrop5Locate = 1
   ELSE
      nDragDrop5Locate = -1
   END IF
ELSE                    ' Small form.
   IF X < 24 AND Y = 0 THEN            ' First line
      nDragDrop5Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 1).Tag)
   ELSEIF X < 24 AND Y = 1 THEN        ' Second line
      nDragDrop5Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 3).Tag)
   ELSEIF X < 24 AND Y = 2 THEN        ' Third line
      nDragDrop5Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 2).Tag)
   ELSEIF X < 24 AND Y = 3 THEN        ' Fourth line
      nDragDrop5Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex).Tag)
   ELSEIF X < 24 AND Y = 4 THEN        ' Fifth line
      nDragDrop5Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 4).Tag)
   ELSE
      nDragDrop5Locate = -1
   END IF
END IF
END FUNCTION

'  Called by:  DragDrop4 (used by frmTitration)
'        Global variables:  gGroupDefine
FUNCTION nDragDrop6Locate (X AS SINGLE, Y AS SINGLE, BYVAL nSize, BYVAL nvGroup, Target AS FORM) AS INTEGER
' Determine the position where the variable was dropped.
IF nSize = 2 THEN     ' Large form.
   IF X < 18 THEN
      nDragDrop6Locate = 0
   ELSEIF X > 65 AND Y > 2 THEN
      nDragDrop6Locate = 6
   ELSEIF X > 43 AND X < 65 AND Y > 2 THEN
      nDragDrop6Locate = 5
   ELSEIF X > 21 AND X < 43 AND Y > 2 THEN
      nDragDrop6Locate = 4
   ELSEIF X > 65 AND Y < 2 THEN
      nDragDrop6Locate = 3
   ELSEIF X > 43 AND X < 65 AND Y < 2 THEN
      nDragDrop6Locate = 2
   ELSEIF X > 21 AND X < 43 AND Y < 2 THEN
      nDragDrop6Locate = 1
   ELSE
      nDragDrop6Locate = -1
   END IF
ELSE                    ' Small form.
   IF X < 24 AND Y = 0 THEN            ' First line
      nDragDrop6Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 1).Tag)
   ELSEIF X < 24 AND Y = 1 THEN        ' Second line
      nDragDrop6Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 3).Tag)
   ELSEIF X < 24 AND Y = 2 THEN        ' Third line
      nDragDrop6Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 2).Tag)
   ELSEIF X < 24 AND Y = 3 THEN        ' Fourth line
      nDragDrop6Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex).Tag)
   ELSEIF X < 24 AND Y = 4 THEN        ' Fifth line
      nDragDrop6Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 4).Tag)
   ELSEIF X < 24 AND Y = 5 THEN        ' Sixth line
      nDragDrop6Locate = VAL(Target.lblVariable(gGroupDefine(nvGroup).LowestIndex + 5).Tag)
   ELSE
      nDragDrop6Locate = -1
   END IF
END IF

END FUNCTION

' Sets the focus to the variable which should get it next.  This is easy for
' just two independent variables, but more complicated for connected variables.
'  Input:
'          nvIndex         Index of the variable presently having the focus.
'          nrNextIndex     Index of next variable to set focus to.
'
'        Global variables:  gOccupantIndex, gbDontStopHere, gnConnected
'                           gGroupDefine
SUB NextFocus (BYVAL nvIndex, nrNextIndex)
' Strategy:
' Go to the independent variable with next higher index in a group.
'  If not connected, set focus there.
'  If connected, go to lowest index of connected group.
'     Repeat analysis (Recursive call).  Independent variable will be found.
'  If no higher-index independent variable, and dependent variable is
'     connected, go to next group up, and set focus to next highest index.
'     (However:  Don't go to a connected group if the formula is invalid.)
'     Repeat analysis (Recursive call).
'  If dependent variable not connected, go to lowest-index of this group
'     If connected repeat analysis (Recursive call).  Will find.

DIM nPresentGroup, bNoNextIndexYet
DIM nNextHigherIndex, nConnectedIndex
DIM nTempIndex, bValidFormula, nTempIndex2

' Find the group containing the index of interest.
nPresentGroup = nGroupOfIndex(nvIndex)

IF gOccupantIndex(nPresentGroup, 0) = nvIndex THEN
   ' At group's dependent variable.
   ' Start with the lowest index independent variable.
   nNextHigherIndex = gGroupDefine(nPresentGroup).LowestIndex - 1
ELSE
   ' Find the index of the next higher independent variable in the present group.
   nNextHigherIndex = nvIndex  ' Start with present index.
END IF

' Look for higher-indexed independent variable.
DO
   nNextHigherIndex = nNextHigherIndex + 1
   IF nNextHigherIndex > gGroupDefine(nPresentGroup).HighestIndex THEN
      ' Reached highest index without finding dependent variable.
      bNoNextIndexYet = TRUE
   ELSE
      IF nNextHigherIndex <> gOccupantIndex(nPresentGroup, 0) THEN
         IF NOT gbDontStopHere(nNextHigherIndex) THEN
            ' Found independent variable.
            EXIT DO
         END IF
      END IF
   END IF
LOOP WHILE nNextHigherIndex <= gGroupDefine(nPresentGroup).HighestIndex

IF NOT bNoNextIndexYet THEN
   ' Found next highest index of independent variable.
   IF gnConnected(nNextHigherIndex) THEN
      ' Find index at other end of connection, and search in that group.
      ' Recursive call.
      NextFocus gnConnected(nNextHigherIndex), nrNextIndex
   ELSE
      ' Found a valid index for next focus.
      nrNextIndex = nNextHigherIndex
   END IF
ELSE
   ' No higher index available in this group.
   ' Check for connection to a higher group with a valid formula.
   nTempIndex = gnConnected(gOccupantIndex(nPresentGroup, 0))
   IF nTempIndex AND NOT gbDontStopHere(nTempIndex) THEN
      ' Dependent is connected; formula is valid.
      ' Find index at other end of connection, and search in that group.
      ' Recursive call.
      NextFocus nTempIndex, nrNextIndex
   ELSE
      ' No higher index available; use the lowest independent variable
      ' in present group.
      nTempIndex = gGroupDefine(nPresentGroup).LowestIndex
      IF nTempIndex = gOccupantIndex(nPresentGroup, 0) THEN
         nTempIndex = nTempIndex + 1
      END IF
      DO WHILE gbDontStopHere(nTempIndex)
         nTempIndex = nTempIndex + 1
      LOOP
      IF gnConnected(nTempIndex) THEN
         ' Recursive call.
         NextFocus gnConnected(nTempIndex), nrNextIndex
      ELSE
         nrNextIndex = nTempIndex
      END IF
   END IF
END IF

END SUB

' Gives the group to which a particular index belongs.
'  Input:   Index    Index of interest
'  Return:  Group    Group to which index belongs
' A zero returns group 1.  Called by mnuMove_Click, among others.
'        Global variables:  gGroupDefine
FUNCTION nGroupOfIndex (BYVAL Index AS INTEGER) AS INTEGER
DIM N
   FOR N = 1 TO 14
      IF Index <= gGroupDefine(N).HighestIndex THEN EXIT FOR
   NEXT N
nGroupOfIndex = N
END FUNCTION

' Selects the dependent variable in a group, and sets properties of variables.
'  Input:   Index          txtVariable index of the dependent variable.
'                          Also, index of option button.
'           nvGroup        calling group
'           Src    calling form
'
'  Return:  Index to which focus was set.
' Called by optDependent_Click
'        Module:  mnUnits
'        Global:  gbDontStopHere, gnConnected, gOccupantIndex, gGroupDefine
FUNCTION nOptionButton (Index, BYVAL nvGroup, Src AS FORM) AS INTEGER
' Set properties of variables.  If frame is small, also set positions
' where variables will go when frame is large.
  
   ' Need to set the value of the option button to true, because that
   ' doesn't happen automatically when "Click" is called from another sub.
   ' But changing the value causes optDependent to run again, which causes
   ' it to call this subroutine again.  bCalledItself causes it to
   ' immediately exit the second time (probably no harm running through a
   ' second time).
   STATIC bCalledItself                            ' False initially.
   IF bCalledItself THEN EXIT FUNCTION             ' Exits second time.
   bCalledItself = TRUE                            ' Set True.
   Src.optDependent(Index).value = TRUE    ' Causes it to call itself.
   bCalledItself = False               ' After calling itself, resumes here.

   DIM N, nNextFocus, N1, N2, N3, N4, N5, N6
   DIM nResult, sTemp AS STRING
   DIM dR AS DOUBLE, dRUnc AS DOUBLE, bError

   Src.optDependent(Index).ForeColor = CYAN

   ' Dependent text box.
   gbDontStopHere(Index) = TRUE   ' Prevent changing dependent variable value.
   Src.txtVariable(Index).BackColor = WHITE
   IF gnConnected(Index) THEN
      ' Check that the dependent variable is correctly connected.
      IF gOccupantIndex(nGroupOfIndex(gnConnected(Index)), 0) = gnConnected(Index) THEN
         ' Connected variable is also a dependent variable; disconnect it.
         Disconnect Index
      END IF
   END IF
   IF Src.txtVariable(Index).Text = "0" THEN
      ' Start with dependent blank, rather than showing 0.
      Src.txtVariable(Index).Text = ""
   END IF


   ' Other text boxes.
   FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
      ' Skip the dependent variable.
      IF N <> Index THEN
         'IF (N = 22 AND Index <> 23) OR (N = 23 AND Index <> 22) OR (N = 38 AND Index <> 38) THEN ' Percent
         IF N = 22 OR N = 23 OR N = 38 THEN    ' Percent
            Src.txtVariable(N).BackColor = WHITE
            Src.optDependent(N).ForeColor = BRIGHT_BLUE
            gbDontStopHere(N) = TRUE
         ELSEIF N = 24 OR N = 25 THEN
            ' Do Nothing
         ELSEIF nvGroup = 7 THEN
            ' Gas change group
            IF frmGas.txtVariable(N).Visible THEN
               Src.txtVariable(N).BackColor = CYAN
               Src.optDependent(N).ForeColor = BLACK
               gbDontStopHere(N) = False
            END IF
         ELSE
            Src.txtVariable(N).BackColor = CYAN
            Src.optDependent(N).ForeColor = BLACK
            gbDontStopHere(N) = False
         END IF
         ' Check that independent variables are still connected to
         ' dependent variables.
         IF gnConnected(N) THEN
            IF gOccupantIndex(nGroupOfIndex(gnConnected(N)), 0) <> gnConnected(N) THEN
               ' Connected variable also independent variable; disconnect it.
               Disconnect gnConnected(N)
            END IF
         END IF
      END IF
   NEXT N

   ' Update the positions if the frame size is small.
   IF Src.cmdSize.Tag <> "2" THEN
      IF nvGroup = 7 THEN
         GasOption Index, Src
      ELSE
         ' gram = 1, mole = 2, g/mole = 0
         N1 = gGroupDefine(nvGroup).LowestIndex
         N2 = N1 + 1          ' For group 1  N1 = 0, N2 = 1, and N3 = 2
         N3 = N1 + 2          ' For group 2, N1 = 3, N2 = 4, and N3 = 5; etc.
         N4 = N1 + 3          ' For dilution, N1 = 14, N2 = 15, N3 = 16, N4 = 17.
         N5 = N1 + 4          ' For titration, N1 = 18, N2 = 19, N3 = 20,
         N6 = N1 + 5          '                N4 = 21, N5 = 22, N6 = 23.
         SELECT CASE Index
            CASE N1   ' Molar Mass, Density, Molarity, whole, volume final, V2
               gOccupantIndex(nvGroup, 0) = N1     'Vf =Mi * Vi / Mf
               gOccupantIndex(nvGroup, 1) = N2     'N1 =N2 * N4 / N3
               gOccupantIndex(nvGroup, 4) = N3
               Src.lblVariable(N1).Tag = "0"
               Src.lblVariable(N2).Tag = "1"
               Src.lblVariable(N3).Tag = "4"

               ' The following groups have more than 3 variable to handle.
               IF nvGroup = 4 THEN
                  gOccupantIndex(nvGroup, 2) = 13  ' 100 txt & lbl
                  Src.lblVariable(13).Tag = "2"
                  Src.lblVariable(13).Top = 0
                  Src.lblVariable(13).Left = 61
                  Src.txtVariable(13).Top = 0
                  Src.txtVariable(13).Left = 64
               ELSEIF nvGroup = 5 THEN
                  gOccupantIndex(nvGroup, 2) = N4
                  Src.lblVariable(N4).Tag = "2"
                  gOccupantIndex(nvGroup, 5) = -1
               ELSEIF nvGroup = 6 THEN
                  gOccupantIndex(nvGroup, 2) = N4
                  Src.lblVariable(N4).Tag = "2"
                  gOccupantIndex(nvGroup, 3) = N5
                  Src.lblVariable(N5).Tag = "3"
                  gOccupantIndex(nvGroup, 5) = -1
                  gOccupantIndex(nvGroup, 6) = N6
                  Src.lblVariable(N6).Tag = "6"
               ELSEIF nvGroup = 8 THEN
                  gOccupantIndex(nvGroup, 2) = N5
                  Src.lblVariable(N5).Tag = "2"
                  gOccupantIndex(nvGroup, 3) = N4
                  Src.lblVariable(N4).Tag = "3"
                  gOccupantIndex(nvGroup, 5) = -1
                  gOccupantIndex(nvGroup, 6) = -1
               ELSE
                  gOccupantIndex(nvGroup, 2) = -1
                  Src.lblX.Visible = False
                  Src.lblDivisionLine.Visible = TRUE
               END IF
            CASE N2   ' grams, grams, moles, part, molarity initial, M1
               gOccupantIndex(nvGroup, 0) = N2  ' Mi = Mf * Vf / Vi
               gOccupantIndex(nvGroup, 1) = N3  ' 15   16   14   17
               gOccupantIndex(nvGroup, 2) = N1
               Src.lblVariable(N1).Tag = "2"
               Src.lblVariable(N2).Tag = "0"
               Src.lblVariable(N3).Tag = "1"
               IF nvGroup = 4 THEN
                  gOccupantIndex(nvGroup, 4) = 13  ' 100 txt & lbl
                  Src.lblVariable(13).Tag = "4"
                  Src.lblVariable(13).Top = 2
                  Src.lblVariable(13).Left = 36
                  Src.txtVariable(13).Top = 2
                  Src.txtVariable(13).Left = 39
               ELSEIF nvGroup = 5 THEN
                  gOccupantIndex(nvGroup, 4) = N4
                  Src.lblVariable(N4).Tag = "4"
                  gOccupantIndex(nvGroup, 5) = -1
               ELSEIF nvGroup = 6 THEN
                  gOccupantIndex(nvGroup, 4) = N4
                  Src.lblVariable(N4).Tag = "4"
                  gOccupantIndex(nvGroup, 3) = N6
                  Src.lblVariable(N6).Tag = "3"
                  gOccupantIndex(nvGroup, 5) = -1
                  gOccupantIndex(nvGroup, 6) = N5
                  Src.lblVariable(N5).Tag = "6"
               ELSEIF nvGroup = 8 THEN
                  gOccupantIndex(nvGroup, 4) = N5
                  Src.lblVariable(N5).Tag = "4"
                  gOccupantIndex(nvGroup, 5) = N4
                  Src.lblVariable(N4).Tag = "5"
                  gOccupantIndex(nvGroup, 3) = -1
                  gOccupantIndex(nvGroup, 6) = -1
               ELSE
                  gOccupantIndex(nvGroup, 4) = -1
                  Src.lblX.Visible = TRUE
                  Src.lblDivisionLine.Visible = False
               END IF
            CASE N3   ' moles, mL, L, percent, molarity final, M2
               gOccupantIndex(nvGroup, 0) = N3
               gOccupantIndex(nvGroup, 1) = N2
               gOccupantIndex(nvGroup, 4) = N1
               Src.lblVariable(N1).Tag = "4"
               Src.lblVariable(N2).Tag = "1"
               Src.lblVariable(N3).Tag = "0"
               IF nvGroup = 4 THEN
                  gOccupantIndex(nvGroup, 2) = 13  ' 100 txt & lbl
                  Src.lblVariable(13).Tag = "2"
                  Src.lblVariable(13).Top = 0
                  Src.lblVariable(13).Left = 61
                  Src.txtVariable(13).Top = 0
                  Src.txtVariable(13).Left = 64
               ELSEIF nvGroup = 5 THEN
                  gOccupantIndex(nvGroup, 2) = N4
                  Src.lblVariable(N4).Tag = "2"
                  gOccupantIndex(nvGroup, 5) = -1
               ELSEIF nvGroup = 6 THEN
                  gOccupantIndex(nvGroup, 2) = N4
                  Src.lblVariable(N4).Tag = "2"
                  gOccupantIndex(nvGroup, 3) = N5
                  Src.lblVariable(N5).Tag = "3"
                  gOccupantIndex(nvGroup, 5) = -1
                  gOccupantIndex(nvGroup, 6) = N6
                  Src.lblVariable(N6).Tag = "6"
               ELSEIF nvGroup = 8 THEN
                  gOccupantIndex(nvGroup, 2) = N5
                  Src.lblVariable(N5).Tag = "2"
                  gOccupantIndex(nvGroup, 3) = N4
                  Src.lblVariable(N4).Tag = "3"
                  gOccupantIndex(nvGroup, 5) = -1
                  gOccupantIndex(nvGroup, 6) = -1
               ELSE
                  gOccupantIndex(nvGroup, 2) = -1
                  Src.lblX.Visible = False
                  Src.lblDivisionLine.Visible = TRUE
               END IF                                       'N4   N1   N3   N2
            CASE N4   ' volume initial    Vi = Vf * Mf / Mi, 17 = 14 * 16 / 15
                      ' V1
               gOccupantIndex(nvGroup, 0) = N4
               gOccupantIndex(nvGroup, 1) = N1
               gOccupantIndex(nvGroup, 4) = N2
               Src.lblVariable(N1).Tag = "1"
               Src.lblVariable(N2).Tag = "4"
               Src.lblVariable(N4).Tag = "0"
               IF nvGroup = 5 THEN
                  gOccupantIndex(nvGroup, 2) = N3
                  Src.lblVariable(N3).Tag = "2"
                  gOccupantIndex(nvGroup, 5) = -1
               ELSEIF nvGroup = 6 THEN
                  gOccupantIndex(nvGroup, 2) = N3
                  Src.lblVariable(N3).Tag = "2"
                  gOccupantIndex(nvGroup, 3) = N6
                  Src.lblVariable(N6).Tag = "3"
                  gOccupantIndex(nvGroup, 5) = -1
                  gOccupantIndex(nvGroup, 6) = N5
                  Src.lblVariable(N5).Tag = "6"
               ELSEIF nvGroup = 8 THEN
                  gOccupantIndex(nvGroup, 1) = N3
                  Src.lblVariable(N3).Tag = "1"
                  gOccupantIndex(nvGroup, 2) = N1
                  Src.lblVariable(N1).Tag = "2"
                  gOccupantIndex(nvGroup, 5) = N5
                  Src.lblVariable(N5).Tag = "5"
                  gOccupantIndex(nvGroup, 3) = -1
                  gOccupantIndex(nvGroup, 6) = -1
               END IF
            CASE N5   ' Coefficient 2
               gOccupantIndex(nvGroup, 0) = N5
               Src.lblVariable(N5).Tag = "0"
               gOccupantIndex(nvGroup, 1) = N3
               Src.lblVariable(N3).Tag = "1"
               gOccupantIndex(nvGroup, 2) = N1
               Src.lblVariable(N1).Tag = "2"
               gOccupantIndex(nvGroup, 4) = N2
               Src.lblVariable(N2).Tag = "4"
               gOccupantIndex(nvGroup, 5) = N4
               Src.lblVariable(N4).Tag = "5"
               gOccupantIndex(nvGroup, 6) = -1
               IF nvGroup = 6 THEN
                  gOccupantIndex(nvGroup, 3) = N6
                  Src.lblVariable(N6).Tag = "3"
               ELSE  'IF nvGroup = 8 THEN
                  gOccupantIndex(nvGroup, 3) = -1
                  gOccupantIndex(nvGroup, 6) = -1
               END IF
            CASE N6   ' Coefficient 1
               gOccupantIndex(nvGroup, 0) = N6
               gOccupantIndex(nvGroup, 1) = N2
               gOccupantIndex(nvGroup, 2) = N4
               gOccupantIndex(nvGroup, 3) = N5
               gOccupantIndex(nvGroup, 4) = N3
               gOccupantIndex(nvGroup, 5) = N1
               gOccupantIndex(nvGroup, 6) = -1
               Src.lblVariable(N1).Tag = "5"
               Src.lblVariable(N2).Tag = "1"
               Src.lblVariable(N3).Tag = "4"
               Src.lblVariable(N4).Tag = "2"
               Src.lblVariable(N5).Tag = "3"
               Src.lblVariable(N6).Tag = "0"
         END SELECT
      END IF
   END IF

   IF nvGroup = 6 THEN
      IF gOccupantIndex(nvGroup, 0) < 22 THEN
         FOR N = 0 TO 3
            frmTitration.txtCoef1(N).Enabled = TRUE
            frmTitration.txtCoef2(N).Enabled = TRUE
            frmTitration.txtCoef1(N).BackColor = CYAN
            frmTitration.txtCoef2(N).BackColor = CYAN
         NEXT N
         Src.lblDragDrop.Caption = "U"  ' Update the coefficients.
      ELSE
         ' Dependent variable is coefficient 1 or 2
         FOR N = 0 TO 3
            frmTitration.txtCoef1(N).Enabled = False
            frmTitration.txtCoef2(N).Enabled = False
            frmTitration.txtCoef1(N).BackColor = WHITE
            frmTitration.txtCoef2(N).BackColor = WHITE
         NEXT N
      END IF
   ELSEIF nvGroup = 8 THEN
      IF gOccupantIndex(8, 0) <> 38 THEN
         ' Determine if R has changed; if so, show the reset button.
         bError = bUnitConversion(8314.51#, .001#, PA, mnUnits(36), dR, dRUnc, N)
         bError = bUnitConversion(dR, dRUnc, LITER, mnUnits(34), dR, dRUnc, N)
         NumberFormat dR, dRUnc, 51, sTemp, N
         IF sTemp <> Src.txtVariable(38).Text THEN
            Src.cmdResetR.Visible = TRUE
         END IF
      ELSE
         Src.cmdResetR.Visible = False
      END IF
   END IF
   nNextFocus = gGroupDefine(nvGroup).LowestIndex
   IF nNextFocus = Index THEN
      nNextFocus = nNextFocus + 1
   END IF
   gGroupDefine(6).HighestIndex = 21   ' Redefine the group for SetNextFocus.
   nOptionButton = nSetNextFocus(nNextFocus)
   gGroupDefine(6).HighestIndex = 25
END FUNCTION

' Converts R to same pressure and volume units used for P & V.
' Updates label for R.
'    Input:  bReset     1 if value of R is to be reset.
'   Module:  mnUnits
'   Global:  gdNumber, gdUncertainty
SUB RConvert (bReset)
DIM dR AS DOUBLE, dRUnc AS DOUBLE, N, bError
DIM sLabel AS STRING, srMsg AS STRING
        
IF bReset THEN
   bError = bUnitConversion(8314.51#, .001#, PA, mnUnits(36), dR, dRUnc, N)
   bError = bUnitConversion(dR, dRUnc, LITER, mnUnits(34), gdNumber(38), gdUncertainty(38), N)
ELSE
   bError = bUnitConversion(gdNumber(38), gdUncertainty(38), mnRPressureUnits, mnUnits(36), dR, dRUnc, N)
   bError = bUnitConversion(dR, dRUnc, mnRVolumeUnits, mnUnits(34), gdNumber(38), gdUncertainty(38), N)
END IF
mnRPressureUnits = mnUnits(36)
mnRVolumeUnits = mnUnits(34)
NumberFormat gdNumber(38), gdUncertainty(38), 51, srMsg, N
frmIdealGas.txtVariable(38).Text = srMsg
SELECT CASE frmIdealGas.cboPressureUnit.ListIndex
   CASE 0
      sLabel = "Pa"
   CASE 1
      sLabel = "kPa"
   CASE 2
      sLabel = "bar"
   CASE 3
      sLabel = "atm"
   CASE 4
      sLabel = "mm Hg"
   CASE 5
      sLabel = "torr"
   CASE 6
      sLabel = "psi"
END SELECT
SELECT CASE frmIdealGas.cboVolumeUnit.ListIndex
   CASE 0
      sLabel = "L " + sLabel
   CASE 1
      sLabel = "mL " + sLabel
END SELECT
frmIdealGas.lblVariable(38).Caption = "&R, " + sLabel + "/mol/K"
END SUB

' When the "More" (or "Less") button in frmMolarMass is pressed,
' changes the locations of forms.  Makes sure all are on screen.
' Resets form locations on changing screen size.
'
'  Input:  nvSize     Size is 1 if gaining lines, other number is loosing.
'
'  Called by:  cmdMore_Click on frmMolarMass, menu item mnuWindowLines.
'  Module level variables:  mFormPosition..., mnLittleTop, mnLittleLeft
'                           mnBigTop
'        Global variables:
'
SUB ScreenSizeChange (BYVAL nvSize)
' The position of forms is adjusted.  Size is not changed.
   DIM N, nShowingForm
   DIM nPreviousWindowState
' *********************** Redefine the initial positions ********************
   IF nvSize = 1 THEN
      ' "More" button was just pressed.  Screen getting more lines.
      ' Redefine some form positions.
      mFormPosition(2).Top = 10
      mFormPosition(3).Top = 19
      mFormPosition(4).Top = 28
      mFormPosition(5).Top = 35
      mFormPosition(6).Top = 15
      mFormPosition(7).Top = 5
      mFormPosition(8).Top = 30
      mFormPosition(3).SmallTop = 19
      mFormPosition(4).SmallTop = 28
      mFormPosition(7).SmallTop = 23
      mFormPosition(8).SmallTop = 1

      mFormPosition(3).SmallLeft = 0
      mFormPosition(4).SmallLeft = 0
      mFormPosition(7).SmallLeft = 51
      mFormPosition(8).SmallLeft = 28
   ELSE
      ' "Less" button just pressed.  Screen getting fewer lines.
      mFormPosition(2).Top = 8
      mFormPosition(3).Top = 16
      mFormPosition(4).Top = 3
      mFormPosition(5).Top = 11
      mFormPosition(6).Top = 19
      mFormPosition(7).Top = 15
      mFormPosition(8).Top = 9
      mFormPosition(3).SmallTop = 14
      mFormPosition(4).SmallTop = 3
      mFormPosition(7).SmallTop = 7
      mFormPosition(8).SmallTop = 0

      mFormPosition(3).SmallLeft = 30
      mFormPosition(4).SmallLeft = 30
      mFormPosition(7).SmallLeft = 23
      mFormPosition(8).SmallLeft = 7
   END IF
'********************* Place forms in initial positions ********************
   FOR N = 1 TO 8
      nShowingForm = mFormPosition(N).Group
      IF nShowingForm > 0 THEN
         ' A form is showing; reposition it.
         SELECT CASE nShowingForm
            CASE 1
               ' Can't repositon a maximized or minimized form.
               nPreviousWindowState = frmGramMole.WindowState  ' Save
               frmGramMole.WindowState = 0   ' Normal state.
               IF frmGramMole.cmdSize.Tag = "2" THEN     ' Large form.

                  ' Set present position of large form
                  frmGramMole.Top = mFormPosition(N).Top
                  ' (Left position of a large form is not changed.)

                  ' Set position to be used when form is small.
                  mnLittleTop(1) = mFormPosition(N).SmallTop
                  mnLittleLeft(1) = mFormPosition(N).SmallLeft
               ELSE                                      ' Small form.
                  
                  ' Set present position of small form
                  frmGramMole.Top = mFormPosition(N).SmallTop
                  frmGramMole.Left = mFormPosition(N).SmallLeft

                  ' Set position to be used when form is large.
                  mnBigTop(1) = mFormPosition(N).Top
                  ' (Left position of a large form is not changed.)
               END IF
               frmGramMole.WindowState = nPreviousWindowState  ' Restore
            CASE 2
'formGone               nPreviousWindowState = frmDensity.WindowState
'formGone               frmDensity.WindowState = 0   ' Normal state.
'formGone               IF frmDensity.cmdSize.Tag = "2" THEN
'formGone                  frmDensity.Top = mFormPosition(N).Top
                  mnLittleTop(2) = mFormPosition(N).SmallTop
                  mnLittleLeft(2) = mFormPosition(N).SmallLeft
'formGone               ELSE
'formGone                  frmDensity.Top = mFormPosition(N).SmallTop
'formGone                  frmDensity.Left = mFormPosition(N).SmallLeft
                  mnBigTop(2) = mFormPosition(N).Top
'formGone               END IF
'formGone               frmDensity.WindowState = nPreviousWindowState
            CASE 3
'formgone               nPreviousWindowState = frmMolarity.WindowState
'formgone               frmMolarity.WindowState = 0   ' Normal state.
'formgone               IF frmMolarity.cmdSize.Tag = "2" THEN
'formgone                  frmMolarity.Top = mFormPosition(N).Top
                  mnLittleTop(3) = mFormPosition(N).SmallTop
                  mnLittleLeft(3) = mFormPosition(N).SmallLeft
'formgone               ELSE
'formgone                  frmMolarity.Top = mFormPosition(N).SmallTop
'formgone                  frmMolarity.Left = mFormPosition(N).SmallLeft
                  mnBigTop(3) = mFormPosition(N).Top
'formgone               END IF
'formgone               frmMolarity.WindowState = nPreviousWindowState
            CASE 4
               nPreviousWindowState = frmPercent.WindowState
               frmPercent.WindowState = 0   ' Normal state.
               IF frmPercent.cmdSize.Tag = "2" THEN
                  frmPercent.Top = mFormPosition(N).Top
                  mnLittleTop(4) = mFormPosition(N).SmallTop
                  mnLittleLeft(4) = mFormPosition(N).SmallLeft
               ELSE
                  frmPercent.Top = mFormPosition(N).SmallTop
                  frmPercent.Left = mFormPosition(N).SmallLeft
                  mnBigTop(4) = mFormPosition(N).Top
               END IF
               frmPercent.WindowState = nPreviousWindowState
            CASE 5
'formGone               nPreviousWindowState = frmDilution.WindowState
'formGone               frmDilution.WindowState = 0   ' Normal state.
'formGone               IF frmDilution.cmdSize.Tag = "2" THEN
'formGone                  frmDilution.Top = mFormPosition(N).Top
                  mnLittleTop(5) = mFormPosition(N).SmallTop
                  mnLittleLeft(5) = mFormPosition(N).SmallLeft
'formGone               ELSE
'formGone                  frmDilution.Top = mFormPosition(N).SmallTop
'formGone                  frmDilution.Left = mFormPosition(N).SmallLeft
                  mnBigTop(5) = mFormPosition(N).Top
'formGone               END IF
'formGone               frmDilution.WindowState = nPreviousWindowState
            CASE 6
               nPreviousWindowState = frmTitration.WindowState
               frmTitration.WindowState = 0   ' Normal state.
               IF frmTitration.cmdSize.Tag = "2" THEN
                  ' 14 is frmTitration.Height.
                  IF 14 + mFormPosition(N).Top > Screen.Height - 1 THEN
                     frmTitration.Top = 7
                  ELSE
                     frmTitration.Top = mFormPosition(N).Top
                  END IF
                  mnLittleTop(6) = mFormPosition(N).SmallTop
                  mnLittleLeft(6) = mFormPosition(N).SmallLeft
               ELSE
                  frmTitration.Top = mFormPosition(N).SmallTop
                  frmTitration.Left = mFormPosition(N).SmallLeft
                  IF 14 + mFormPosition(N).Top > Screen.Height - 1 THEN
                     mnBigTop(6) = 7
                  ELSE
                     mnBigTop(6) = mFormPosition(N).Top
                  END IF
               END IF
               frmTitration.WindowState = nPreviousWindowState
            CASE 7
               nPreviousWindowState = frmGas.WindowState
               frmGas.WindowState = 0   ' Normal state.
               IF frmGas.cmdSize.Tag = "2" THEN
                  frmGas.Top = mFormPosition(N).Top
                  mnLittleTop(7) = mFormPosition(N).SmallTop
                  mnLittleLeft(7) = mFormPosition(N).SmallLeft
               ELSE
                  frmGas.Top = mFormPosition(N).SmallTop
                  frmGas.Left = mFormPosition(N).SmallLeft
                  mnBigTop(7) = mFormPosition(N).Top
               END IF
               frmGas.WindowState = nPreviousWindowState
            CASE 8
               nPreviousWindowState = frmIdealGas.WindowState
               frmIdealGas.WindowState = 0   ' Normal state.
               IF frmIdealGas.cmdSize.Tag = "2" THEN
                  frmIdealGas.Top = mFormPosition(N).Top
                  mnLittleTop(8) = mFormPosition(N).SmallTop
                  mnLittleLeft(8) = mFormPosition(N).SmallLeft
               ELSE
                  frmIdealGas.Top = mFormPosition(N).SmallTop
                  frmIdealGas.Left = mFormPosition(N).SmallLeft
                  mnBigTop(8) = mFormPosition(N).Top
               END IF
               frmIdealGas.WindowState = nPreviousWindowState
         END SELECT
      END IF
   NEXT N
   IF frmMdi.mnuWindowReaction.Checked THEN
      nPreviousWindowState = frmReaction.WindowState
      frmReaction.WindowState = 0
      IF nvSize = 1 THEN
         frmReaction.Top = 16
      ELSE
         frmReaction.Top = 1
      END IF
      frmReaction.WindowState = nPreviousWindowState
   END IF
END SUB

' Change the size of the form and placement of controls in form.
'
'  Input:   svSizeStatus   Present size of form:  1 for medium, 2 for large.
'                          The previous size is stored in cmdSize.tag.
'           nvGroup        Group of form
'           Src            Form whose size is specified.
'
'  Module level size variables.  Used by FormPosition and ScreenSizeChange.
'        mnLittleTop()  Remembers last  top position of medium frame.
'                       Module level.
'        mnLittleLeft() Remembers last left positon of medium frame.
'                       Module level.
'        mnBigTop()     Remembers last  top position of big frame.
'                       Module level.
'        mnBigLeft()    Remembers last left positon of big frame.
'                       Module level.
'        Frame sizes are not remembered.
'
'  Called by:  cmdSize_Click in frmGramMole, frmDensity, frmMolarity,
'              frmPercent, frmDilution.
'  Module level variables:  mLocation4
'        Global variables:  gGroupDefine
'
SUB SizeForm (BYVAL svSizeStatus AS STRING, BYVAL nvGroup, Src AS FORM)
DIM N, nIndex, nGroup, nTemp, nYAdjust, nIndexAdjust
DIM sLetter AS STRING, sCmpd AS STRING
DIM nUnitLabelLeft

Src.HIDE
SELECT CASE svSizeStatus
   CASE "1"   ' Make little frame large.
      ' The user may have repositioned the forms.  Remember the positions.
      mnLittleTop(nvGroup) = Src.Top
      mnLittleLeft(nvGroup) = Src.Left
      Src.Top = mnBigTop(nvGroup)
      Src.Left = mnBigLeft(nvGroup)

      Src.cmdSize.Tag = "2"
      Src.cmdSize.Height = 2
      IF nvGroup = 5 THEN
         Src.cmdSize.Top = 3
         Src.Caption = "Dilution:  (MV) final = moles = (MV)initial"
         Src.Width = 67
         Src.Height = 8
'formGone         IF frmDilution.cboVolumeUnit.ListIndex = 1 THEN
'formGone            sLetter = "m"
'formGone         END IF
         Src.lblVariable(14).Caption = sLetter + "L, fi&nal"
         Src.lblVariable(15).Caption = "mol/L, &initial"
         Src.lblVariable(16).Caption = "mol&/L, final"
         Src.lblVariable(17).Caption = sLetter + "L, &inital"
         FOR N = 14 TO 17
            Src.optDependent(N).Visible = False
            ' Get the location of the control.
            nTemp = VAL(Src.lblVariable(N).Tag)
            IF nTemp > 3 THEN
               nYAdjust = 1
            ELSE
               nYAdjust = -1
            END IF
            Src.txtVariable(N).MOVE mLocation4(0, nTemp).X, mLocation4(0, nTemp).Y
            Src.lblVariable(N).MOVE mLocation4(0, nTemp).X + 3, mLocation4(0, nTemp).Y + nYAdjust
            Src.lblVariable(N).Alignment = 2  ' Centered.
         NEXT N
         Src.lblVolume.Top = 4
         Src.cboVolumeUnit.Top = 4
      ELSEIF nvGroup = 6 THEN
         Src.cmdSize.Top = 3
         Src.Caption = "Titration:  (MV)2 = (MV)1 X stoichiometry 2 / 1"
         Src.Width = 79
         Src.Height = 14
         IF Src.cboVolumeUnit.ListIndex = 1 THEN
            sLetter = "m"
         END IF
         sCmpd = MID$(Src.lblVariable(22).Caption, 4)
         Src.lblVariable(18).Caption = sLetter + "L&, " + sCmpd
         Src.lblVariable(20).Caption = "mol&/L, " + sCmpd
         sCmpd = MID$(Src.lblVariable(23).Caption, 4)
         Src.lblVariable(19).Caption = "m&ol/L, " + sCmpd
         Src.lblVariable(21).Caption = sLetter + "&L, " + sCmpd
         Src.txtCoLb2(0).Visible = TRUE
         Src.lblInstructionBar.Visible = TRUE
         Src.lblEqualSign.Visible = TRUE
         Src.lblDivisionLine.Visible = TRUE
         Src.lblCoefficientsTop.Visible = TRUE
         Src.lblVariable(24).Visible = TRUE
         Src.txtVariable(24).Visible = TRUE
         Src.txtCoef2(0).Visible = TRUE
         FOR N = 18 TO 23
            Src.optDependent(N).Visible = False
            ' Get the location of the control.
            nTemp = VAL(Src.lblVariable(N).Tag)
            IF nTemp > 3 THEN
               nYAdjust = 1
            ELSE
               nYAdjust = -1
            END IF
            Src.txtVariable(N).MOVE mLocation4(1, nTemp).X, mLocation4(1, nTemp).Y
            Src.lblVariable(N).MOVE mLocation4(1, nTemp).X, mLocation4(1, nTemp).Y + nYAdjust
            Src.lblVariable(N).Alignment = 2  ' Centered.
         NEXT N
         Src.txtVariable(22).Width = 10
         Src.txtVariable(23).Width = 10
         Src.lblVolume.Top = 4
         Src.cboVolumeUnit.Top = 4

         ' Enable tab stops.
         FOR N = 0 TO 3
            Src.txtCoLb2(N).TabStop = TRUE
            Src.txtCoef2(N).TabStop = TRUE
            Src.txtCoef1(N).TabStop = TRUE
         NEXT N
         Src.txtCoLb1.TabStop = TRUE
         Src.txtVariable(25).TabStop = TRUE
      ELSEIF nvGroup = 7 THEN
         Src.cmdSize.Top = 3
         Src.Width = 67
         Src.Height = 8
         Src.cmdVariables.Top = 3
         Src.cmdVariables.Height = 2
         Src.lblEqualSign.Visible = TRUE
         Src.lblDivisionLine.Visible = TRUE
         GasMoveVariable 2
         ' Remove a space from labels; change label width.
         FOR N = 26 TO 33
            sCmpd = Src.lblVariable(N).Caption
            Src.lblVariable(N).Caption = LEFT$(sCmpd, 5) + MID$(sCmpd, 7)
            Src.lblVariable(N).Width = 19
            Src.optDependent(N).Visible = False
            ' Get the location of the control.
            Src.lblVariable(N).Alignment = 2  ' Centered.
         NEXT N
         Src.lblDragDrop.Tag = "2"
         Src.lblDragDrop.Caption = "AL"  ' Calls GasAssignLabels
      ELSEIF nvGroup = 8 THEN
         Src.Caption = "Ideal Gas:  PV = nRT"
         Src.cmdSize.Top = 3
         Src.Width = 79
         Src.Height = 8
         Src.cmdResetR.Top = 3
         Src.cmdResetR.Height = 2
         Src.lblVolume.Top = 5
         Src.lblVolume.Left = 1
         Src.cboVolumeUnit.Top = 5
         Src.cboVolumeUnit.Left = 10
         Src.lblPressure.Top = 5
         Src.lblPressure.Left = 20
         Src.cboPressureUnit.Top = 5
         Src.cboPressureUnit.Left = 31
         Src.lblTemp.Top = 5
         Src.lblTemp.Left = 45
         Src.cboTempUnit.Top = 5
         Src.cboTempUnit.Left = 59
         FOR N = 34 TO 38
            Src.lblVariable(N).Width = 17
            Src.optDependent(N).Visible = False
            Src.lblVariable(N).Alignment = 2  ' Centered.
            ' Get the location of the control.
            nTemp = VAL(Src.lblVariable(N).Tag)
            IF nTemp > 3 THEN
               nYAdjust = 1
            ELSE
               nYAdjust = -1
            END IF
            Src.txtVariable(N).MOVE mLocation4(2, nTemp).X, mLocation4(2, nTemp).Y
            Src.lblVariable(N).MOVE mLocation4(2, nTemp).X, mLocation4(2, nTemp).Y + nYAdjust
         NEXT N
         ' Handle visibility of "X"'s.
         IF gOccupantIndex(8, 0) = 34 OR gOccupantIndex(8, 0) = 36 THEN
            Src.lblXT2.Visible = TRUE
            Src.lblXB1.Visible = False
         ELSE
            Src.lblXT2.Visible = False
            Src.lblXB1.Visible = TRUE
         END IF
      ELSE
         Src.cmdSize.Top = 2
         Src.Width = 79
         Src.Height = 6
         FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex
            Src.optDependent(N).Visible = False
            ' Get the location of the control.
            nTemp = VAL(Src.lblVariable(N).Tag)
            Src.txtVariable(N).MOVE mLocation(nTemp).X, mLocation(nTemp).Y
            Src.lblVariable(N).MOVE mLocation(nTemp).X + 19, mLocation(nTemp).Y
         NEXT N
      END IF


   CASE "2"   ' Large frame; make little.
      mnBigTop(nvGroup) = Src.Top
      mnBigLeft(nvGroup) = Src.Left
      Src.Top = mnLittleTop(nvGroup)
      Src.Left = mnLittleLeft(nvGroup)
      Src.Width = 29

      Src.cmdSize.Tag = "1"
      Src.cmdSize.Height = 3
      nUnitLabelLeft = 19  ' Except for form 8.

      ' Set form size.
      IF nvGroup = 5 THEN
         Src.Caption = "Dilution:MfVf=MiVi"
         Src.cmdSize.Top = 4
         Src.Height = 9
         Src.txtVariable(15).Top = 0
         Src.lblVariable(15).Top = 0
         Src.lblVariable(15).Caption = "M &ini"
         Src.txtVariable(17).Top = 1
         Src.lblVariable(17).Top = 1
         Src.lblVariable(17).Caption = "&V ini"
         Src.txtVariable(16).Top = 2
         Src.lblVariable(16).Top = 2
         Src.lblVariable(16).Caption = "M fn&l"
         Src.txtVariable(14).Top = 3
         Src.lblVariable(14).Top = 3
         Src.lblVariable(14).Caption = "V f&nl"
         Src.lblVolume.Top = 5
         Src.cboVolumeUnit.Top = 5
      ELSEIF nvGroup = 6 THEN
         frmTitration.Caption = "Titrate:M2V2=M1V1"
         frmTitration.cmdSize.Top = 6
         frmTitration.Height = 11
         frmTitration.txtCoLb2(0).Visible = False
         frmTitration.lblInstructionBar.Visible = False
         frmTitration.lblEqualSign.Visible = False
         frmTitration.lblDivisionLine.Visible = False
         frmTitration.lblCoefficientsTop.Visible = False
         frmTitration.lblVariable(24).Visible = False
         frmTitration.txtVariable(24).Visible = False
         frmTitration.txtCoef2(0).Visible = False
         Src.lblVolume.Top = 7
         Src.cboVolumeUnit.Top = 7
         Src.txtVariable(18).Top = 3
         Src.lblVariable(18).Top = 3
         Src.lblVariable(18).Caption = "V2 &,"
         Src.txtVariable(19).Top = 0
         Src.lblVariable(19).Top = 0
         Src.lblVariable(19).Caption = "M1 &."
         Src.txtVariable(20).Top = 2
         Src.lblVariable(20).Top = 2
         Src.lblVariable(20).Caption = "M2 &;"
         Src.txtVariable(21).Top = 1
         Src.lblVariable(21).Top = 1
         Src.lblVariable(21).Caption = "&V1"
         Src.txtVariable(22).Top = 4
         Src.txtVariable(22).Width = 19
         Src.lblVariable(22).Top = 4
         Src.txtVariable(23).Top = 5
         Src.txtVariable(23).Width = 19
         Src.lblVariable(23).Top = 5

         ' Disable tab stops.
         FOR N = 0 TO 3
            Src.txtCoLb2(N).TabStop = False
            Src.txtCoef2(N).TabStop = False
            Src.txtCoef1(N).TabStop = False
         NEXT N
         Src.txtCoLb1.TabStop = False
         Src.txtVariable(25).TabStop = False

         nIndexAdjust = -2 ' Prevents moles from moving.
      ELSEIF nvGroup = 7 THEN
         Src.cmdSize.Top = 4
         Src.cmdVariables.Top = 4
         Src.cmdVariables.Height = 3
         Src.Height = 11
         Src.lblEqualSign.Visible = False
         Src.lblDivisionLine.Visible = False
         GasMoveVariable 1
         ' Add a space to labels; change label width.
         FOR N = 26 TO 33
            sCmpd = Src.lblVariable(N).Caption
            Src.lblVariable(N).Caption = LEFT$(sCmpd, 5) + " " + MID$(sCmpd, 6)
            Src.lblVariable(N).Width = 5
         NEXT N
         Src.lblDragDrop.Tag = "1"
         Src.lblDragDrop.Caption = "AL"  ' Calls GasAssignLabels
      ELSEIF nvGroup = 8 THEN
         nUnitLabelLeft = 17
         Src.Width = 23
         Src.Height = 13
         Src.Caption = "PV = nRT"
         Src.cmdSize.Top = 5
         Src.cmdResetR.Top = 5
         Src.cmdResetR.Height = 3
         Src.lblVolume.Top = 8
         Src.lblVolume.Left = 5
         Src.cboVolumeUnit.Top = 8
         Src.cboVolumeUnit.Left = 14
         Src.lblPressure.Top = 9
         Src.lblPressure.Left = 0
         Src.cboPressureUnit.Top = 9
         Src.cboPressureUnit.Left = 10
         Src.lblTemp.Top = 10
         Src.lblTemp.Left = 0
         Src.cboTempUnit.Top = 10
         Src.cboTempUnit.Left = 14
         Src.txtVariable(36).Top = 0
         Src.lblVariable(36).Top = 0
         Src.txtVariable(34).Top = 1
         Src.lblVariable(34).Top = 1
         Src.txtVariable(35).Top = 2
         Src.lblVariable(35).Top = 2
         Src.txtVariable(38).Top = 3
         Src.lblVariable(38).Top = 3
         Src.txtVariable(37).Top = 4
         Src.lblVariable(37).Top = 4
         ' Add a space to labels; change label width.
         FOR N = 34 TO 38
            'sCmpd = Src.lblVariable(N).Caption
            'Src.lblVariable(N).Caption = LEFT$(sCmpd, 5) + " " + MID$(sCmpd, 6)
            Src.lblVariable(N).Width = 1
         NEXT N
      ELSE
         Src.cmdSize.Top = 3
         Src.Height = 8
         nTemp = gGroupDefine(nvGroup).LowestIndex
         Src.txtVariable(nTemp).Top = 1
         Src.lblVariable(nTemp).Top = 1
         Src.txtVariable(1 + nTemp).Top = 0
         Src.lblVariable(1 + nTemp).Top = 0
         Src.txtVariable(2 + nTemp).Top = 2
         Src.lblVariable(2 + nTemp).Top = 2
      END IF

      FOR N = gGroupDefine(nvGroup).LowestIndex TO gGroupDefine(nvGroup).HighestIndex + nIndexAdjust
         IF nvGroup <> 7 THEN
            Src.txtVariable(N).Left = 0
            Src.lblVariable(N).Left = nUnitLabelLeft
            Src.optDependent(N).Visible = TRUE
         END IF
         Src.lblVariable(N).Alignment = 0  ' Left Aligned.
      NEXT N

END SELECT
Src.SHOW

' Set focus on same txtVariable as was active previously.
Src.txtVariable(VAL(Src.Tag)).SETFOCUS

END SUB

