
;	Title:	KEYLOCK.ASM
;	Author:	F. Ho 
;	Date:	28th May 1986
;	Syntax:	? LOCKSTAT()
;	Note:	returns current status of the 4 "lock" keys in the form - ICNS
;
;	Revised PBaenziger, pbprograms, 1215 Lane, Kalamzoo, MI 49001
;	(616) 349-9720 (Evenings), 323-7392 (Days, 8-4:30 EDT)
;
;       Calling syntax:  1- ? LOCKSTAT()
;                        2- X = LOCKSTAT()
;
;       Returns a character type string in the form: "icns"
;
;       where:  i = insert lock key
;	        c = caps lock key
;       	n = num lock key
;	        s = scroll lock key
;
;       If the returned string ("icns") displays any letters in upper
;       case, it means that that lock key has been "activated".
;
;       example:
;	        - if the function returns: iCnS
;
;               - it means that the Caps Lock and
;	          the Scroll Lock keys are ON
;
public LOCKSTAT
;
;
extrn  _RETC:far                       ; Clipper return character
;
;==================================================
DGROUP	GROUP	DATASG
datasg segment PUBLIC  'DATA'
;==================================================
;    
                                  ; Table for following lock status:

LOCKTABLE   DB 'icns',0	; All off Insert, Caps, Numlock, Scroll (not in org)
            DB 'icnS',0	;
            DB 'icNs',0	;
	        DB 'icNS',0	;
	        DB 'iCns',0	;
	        DB 'iCnS',0	;
	        DB 'iCNs',0	;
	        DB 'iCNS',0	;
	        DB 'Icns',0	;
	        DB 'IcnS',0	;
	        DB 'IcNs',0	;
	        DB 'IcNS',0	;
	        DB 'ICns',0	;
	        DB 'ICnS',0	;
	        DB 'ICNs',0	;
	        DB 'ICNS',0	; All on
;
;
;==================================================
datasg ends
;==================================================
;
;
;==================================================
_prog  segment byte				; byte aligned         
assume cs:_prog,ds:DGROUP,es:NOTHING	; original ->datasg
;==================================================
;
LOCKSTAT	proc	far	; far process
		push	bp	; not really needed on an IBM PC/AT - IBM
				; BIOS does not change BP.  But in case of
				; a badly behaved clone with inferior BIOS
				; it may be good protection
				
		mov	ah,02		; request current shift status (into AL)
		int	16h			; issue keyboard input int

	     ;Returns shift state in AL in upper nibble
	     ; 80h - Insert state
	     ; 40h - Caps Lock state
	     ; 20h - Num Lock state
	     ; 10h - Scroll Lock state

		; The index value of the KEYBOARD FLAG is in the upper
		; nibble of AL.  To use it as a pointer, we have to divide it
		; by 16 (or shift it right 4 times, move it into the lower
		; nibble.  However, LOCKTABLE has 5 byte steps, so we have
		; to multiply back by 5.  One way to do it is:
		;	1 - Clear out the lower nibble, extend the returned
		;	    byte to a word
		;	2 - shift right 2 times (divide by 4).  This is
		;        the same as dividing by 16, then multiplying
		;        by 4.  This is all that would be needed for a 
		;        4 byte step table. 
		;	3 - save this intermediate value in BL (or wherever)
		;	4 - shift right 2 more times for a total of 4
		;	    right shifts (divided by 16)
		;	5 - add in the saved value from step 3.  This gives
		;        use the 5 byte step index in AX
		;    6 - add the value to the base offset of LOCKTABLE
		;        BX is now pointing to the correct entry,
		;        ready for transfer back to CLIPPER after pushing
		;        it and the segment value

		SUB AH, AH	; Make a word value out of AL
		AND AL, 0F0H	; Clear out lower nibble
		MOV CL, 2	     ; Divide by 4 - 2 shift right
		SHR AL, CL
		MOV BL, AL	; Save the divided by 4 value
		SHR AL, CL	; Divide by 4 - a total of 16
		ADD AL, BL	; Now we have the 5 byte a step index
					; into LOCKTABLE in AX
		LEA BX, LOCKTABLE	; Get the base offset
		ADD BX, AX		; Now points to correct entry
		MOV AX, DGROUP		; And also the right segment
		
		; restore stack to original position
		pop	bp					; restore stack base pointer

		push	ax					; push AX (segment)
		push	bx					; push BX (offset)
		call	_RETC				; call Clipper return for type CHAR
         ADD SP, 4					; quicker

		ret						; far return

LOCKSTAT	endp						; end of process
;
_prog	ends						; end of segment
		end						; end of programme

