; CLIPMEMA.ASM   Functions for CLIPMEM, Nantucket News, Winter 1987
; Author:  D. Morgan
; Date  :  February, 1987

PUBLIC	DOS_SIZ
PUBLIC	EM_AMT
PUBLIC	MEM_AMT
EXTRN	_PARNI:FAR
EXTRN	_RETNI:FAR
PRO_NAM	SEGMENT
	ASSUME	CS:PRO_NAM

; DOS_SIZ() function for Clipper CLIPMEM program
;	    to return size of DOS
;
; Syntax:	DOS_SIZ()
; Returns:	<expN> representing address in memory where
;		calling Clipper program begins (Program Segment
;		Prefix address). Expressed in paragraphs. Mul-
;		tiply by 16 to express in bytes instead; then
;		divide by 1024 if you want K.
;
; Notes:	requires DOS 3.x or greater.
;		CLIPMEM implicitly assumes where your program
;		begins is where DOS ends. If you've loaded
;		memory resident programs before running your
;		program this may not be strictly true.
;		See Programmer's Guide to the IBM PC, P. Norton,
;		 Microsoft Press, p. 324
;		and Advanced MS-DOS, R. Duncan, Microsoft Press,
;		 pp. 21,384
;
DOS_SIZ	PROC	FAR	
	PUSH	BP	;STANDARD SAVES ETC.
	MOV	BP,SP
	PUSH	DS
	PUSH	ES
	PUSH	BX

       	MOV	AH,62H	;GET PROGRAM SEGMENT PREFIX ADDRESS
	INT	21H	;
			;LEAVES SEGMENT ADDRESS OF THIS PROCESS
			; (JUST ABOVE DOS) IN BX
	MOV	AX,BX	;SEND IT BACK TO CLIPPER

	POP	BX
	POP	ES	;STANDARD RESTORES BEFORE CALLING _RETs
	POP	DS
	POP	BP
	PUSH	AX
	CALL	_RETNI
	ADD	SP,2
 	RET
DOS_SIZ	ENDP


; EM_AMT() function for Clipper CLIPMEM program
;	   to return whether and how much Expanded Memory
;
; Syntax:	EM_AMT() 
; Returns:	<expN>
;		0 if no EMM (Expanded Memory Manager)
;	       -1 if EMM is present, but error in using it
;               n otherwise, equal to the number of pages
;		  of installed Expanded Memory; 1 page=16K
;
; Notes:	See Advanced MS-DOS, R. Duncan, Microsoft
;		 Press, pp. 182, 443
;		and The Lotus/Intel/Microsoft Expanded Memory
;		 Specification, pp. 2-7, 3-1, 3-7
;
EM_AMT	PROC	FAR	
	PUSH	BP	;STANDARD SAVES ETC.
	MOV	BP,SP
	PUSH	DS
	PUSH	ES

	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	SI

	MOV	AH,35H	;GET INTERRUPT VECTOR
	MOV	AL,67H	; FOR THE EMM SERVICE ROUTINES (67H)
	INT	21H

	MOV	DI,000AH     ;POINT TO WHERE THE ROUTINES KEEP
	PUSH	CS	     ; THEIR MAGIC NAME "EMMXXXX0"
	POP	DS
	LEA	SI,EMM_NAME  ;POINT TO OUR COPY OF THE MAGIC NAME
	MOV	CX,8	     ;COMPARE WHOLE NAME
	CLD
	REPE	CMPSB		;CHECK 'EM FOR EQUALITY
	JNE	EMM_ISNT	;IF THEY DIFFER, NO EMM OUT THERE

EMM_IS:
	MOV	AH,42H		;IF EMM OUT THERE, ASK FOR HOW
	INT	67H		; MUCH EXPANDED MEMORY THERE IS
	OR	AH,AH
	JNZ	ERROR1
	MOV	AX,DX		;AND SEND THE NUMBER OF 16K
	JMP	CLEANUP		; PAGES BACK TO CLIPPER
ERROR1:
	MOV	AX,-1
	JMP	CLEANUP

EMM_ISNT:
	MOV	AX,0		;IF NO EMM, SEND CLIPPER ZERO

CLEANUP:
	POP	SI
	POP	DI
	POP	CX
	POP	BX

	POP	ES	;STANDARD RESTORES BEFORE CALLING _RETs
	POP	DS
	POP	BP
	PUSH	AX
	CALL	_RETNI
	ADD	SP,2
 	RET
EMM_NAME	DB	"EMMXXXX0"  ;ALWAYS EMBEDDED IN EMM
EM_AMT	ENDP


; MEM_AMT() function for Clipper CLIPMEM program
;
; Syntax:	MEM_AMT()
; Returns:	top of memory 
; 
; Notes:	see Program Segment Prefix layout detail,
;		in DOS Technical Reference Manual 
;
MEM_AMT	PROC	FAR	
	PUSH	BP	;STANDARD SAVES ETC.
	MOV	BP,SP
	PUSH	DS
	PUSH	ES
	PUSH	BX

       	MOV	AH,62H	;GET PROGRAM SEGMENT PREFIX ADDRESS
	INT	21H	;
			;LEAVES SEGMENT ADDRESS OF THIS PROCESS
			;(JUST ABOVE DOS) IN BX
	MOV	DS,BX
	MOV	BX,2
	MOV	AX,[BX]

	POP	BX
	POP	ES	;STANDARD RESTORES BEFORE CALLING _RETs
	POP	DS
	POP	BP
	PUSH	AX
	CALL	_RETNI
	ADD	SP,2
 	RET
MEM_AMT	ENDP

PRO_NAM	ENDS
	END		;END OF ASSEMBLY
