**********
* EDIT.prg
* 16th April 1987
* dPowells & fHo
* - this routine somewhat simulates dBASE III's EDIT routine
*
* - will start on current record
* - does not support multi-page FMT files
* - assumes that you are GETting directly into the DBF fields 
*   and for ALL fields - that is, from field 1 to field FCOUNT().
*
* - also demonstrates how to deactivate/activate another SET KEY 
*   within a SET KEY procedure
*
* - syntax: DO edit
*
* - e.g.,
*        CLEAR
*        GOTO 10                  && invoke EDIT on record 10
*        SET FORMAT TO fmt_file
*        DO edit
*        RETURN
*



*-----
* pre-set keys to procedures that simulate actions of
* dBASE's following keys during EDIT mode
*-----
set key 5 to UKEY            && UP key
set key 3 to PDKEY           && PAGE-DOWN key
set key 13 to ENKEY          && ENTER key
set key 18 to PUKEY          && PAGE-UP key
set key 24 to DKEY           && DOWN key

set key 31 to INTMODE        && "dummy" key (^-)

*-----
* main loop:
* - where editing actually takes place until ESC key
*   is pressed, or when file extremes are encountered
*-----
do while .t.
    read
    if lastkey() = 27        && exit if ESC is pressed
         exit
    endif
enddo

*-----
* turn OFF the assigned procedures and
* return keys to native mode
*-----
set key 5 to
set key 3 to
set key 13 to
set key 18 to
set key 24 to

set key 31 to


* close databases
return                       && end of EDIT routine
*
*
**********


procedure UKEY
*-----
* UP key
*-----
parameters AA,BB,CC     && 3 dummy parameters declared to 
                        ** maintain stack
    if upper(trim(CC)) == upper(trim(fieldname(1)))
    *-----
    * if current GET is same as first field then
    * save this record and go to previous one
    *-----
         keyboard chr(23)         && stuff keyboard with "Ctrl-W"
         skip -1                  && go to previous record
         if bof()                 && if beginning_of_file
              keyboard chr(27)    && stuff keyboard with "Esc"
         endif
    else
    *-----
    * otherwise, disable UP-arrow's pre-assigned procedure,
    * go up - chr(5), then invoke procedure that
    * reassigns procedure
    *-----
         set key 5 to
         keyboard chr(5) + chr(31)
    endif
return


procedure DKEY
*-----
* DOWN key
*-----
parameters AA,BB,CC
    if upper(trim(CC)) == upper(trim(fieldname(fcount())))
    *-----
    * if current GET is same as last field or 1st field then
    * save this record and go to next one
    *-----
         keyboard chr(23)
         RRR = recno()
         skip
         if eof()
              go RRR
              set key 13 to
              keyboard chr(13) + chr(31) + chr(27)
         endif
    else
    *-----
    * otherwise, turn off assigned procedure,
    * go down - chr(24), then invoke procedure that
    * reassigns procedure
    *-----
         set key 24 to
         keyboard chr(24) + chr(31)
    endif
return


procedure ENKEY
*-----
* ENTER key
*-----
parameters AA,BB,CC
    if upper(trim(CC)) == upper(trim(fieldname(fcount())))
    *-----
    * if current GET is same as last field or 1st field then
    * save this record and go to next one
    *-----
         keyboard chr(23)
         RRR = recno()
         skip
         if eof()
              go RRR
              set key 13 to
              keyboard chr(13) + chr(31) + chr(27)
         endif
    else
    *-----
    * otherwise, turn off assigned procedure,
    * enter - chr(13), then invoke procedure that
    * reassigns procedure
    *-----
         set key 13 to
         keyboard chr(13) + chr(31)
    endif
return


procedure PUKEY
*-----
* PAGE-UP key
*-----
parameters AA,BB,CC
    *-----
    * save current record and
    * go to previous one
    *-----
    keyboard chr(23)
    skip -1
    if bof()
         keyboard chr(27)
    endif
return


procedure PDKEY
*-----
* PAGE-DOWN key
*-----
parameters AA,BB,CC
    *-----
    * save current record and
    * go to next one
    *-----
    keyboard chr(23)
    RRR = recno()
    skip
    if eof()
         go RRR
         set key 13 to
         keyboard chr(13) + chr(31) + chr(27)
    endif
return


procedure INTMODE
*-----
* CONTROL-MINUS key
* - this procedure reassigns procedures to their
*   respective keys
*   (inter-mode ("dummy-key"))
*-----
parameters AA,BB,CC
    set key 5 to UKEY
    set key 24 to DKEY
    set key 13 to ENKEY
return

* eof *
*******
