; File......: FLOPTST.ASM
; Author....: Joseph LaCour
; Date......: $Date:   23 Sep 1991 14:56:42  $
; Revision..: $Revision:   1.3  $
; Log file..: $Logfile:   E:/nanfor/src/floptst.asv  $
; 
; This is an original work by Joseph LaCour and is placed in the
; public domain.
;
;
;  ACKNOWLEDGEMENTS:
;
;          PAOLO RAMOZZI FOR HIS WORK IN DBDCHECK FOR SHOWING HOW TO
;          USE INT 13H.
;
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/floptst.asv  $
;  
;     Rev 1.3   23 Sep 1991 14:56:42   GLENN
;  Bug reports from Craig Austin, James Finnal, and Ted Means.  Line 128
;  had MOV FDRIVE,AL which should have been MOV FDRIVE,BL.  This caused the
;  function to erroneously use the last drive available instead of the one
;  specified by the calling process.
;  
;     Rev 1.2   15 Aug 1991 23:07:48   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   11 May 1991 00:21:42   GLENN
;  File header changed to conform to Toolkit standard.
;

;  $DOC$
;  $FUNCNAME$
;      FT_FLOPTST()
;  $CATEGORY$
;      DOS/BIOS
;  $ONELINER$
;      Test diskette drive status
;  $SYNTAX$
;      FT_FLOPTST( <nDrive> ) -> nStatus
;  $ARGUMENTS$
;      <nDrive> is the diskette drive number, 0 = A:, 1 = B:
;  $RETURNS$  
;      -1 - Wrong Parameters
;       0 - Drive Loaded and ready to read or write
;       1 - Drive Door Open or Diskette inserted upside down
;       2 - Diskette is unformatted
;       3 - Write protected
;       4 - Undetermined
;  $DESCRIPTION$
;      FT_FLOPTST() is designed as a full replacement for ISDRIVE().  Where
;      ISDRIVE() returns just .T. or .F. depending if the diskette drive is
;      ready or not, FT_FLOPTST() returns a numeric code designating the
;      diskette drive's status.
;
;      FT_FLOPTST() is particularly useful in backup and restore programs
;      that need to test the floppy drive before writing/reading from a
;      floppy disk.
;  $EXAMPLES$
;      iStatus := FT_FLOPTST( 1 )

;      DO CASE
;         CASE iStatus == 1
;            Qout( "The door to drive A is open." )
;         CASE iStatus == 2
;            Qout( "The diskette in drive A is not formatted." )
;         CASE iStatus == 3
;            Qout( "The diskette in drive A is write-protected." )
;         CASE iStatus == 4
;            Qout( "Something is wrong with drive A, but I don't know what." )
;      ENDCASE
;  $END$


public  FT_FLOPTST

EXTRN   __PARNI:FAR
EXTRN   __PARINFO:FAR
EXTRN   __RETNI:FAR

_FT_DATASEG  SEGMENT PUBLIC  'DATA'

FDRIVE          DB      0
BOOT_SECT       DB      512 DUP (0)

_FT_DATASEG  ENDS

_NANFOR   SEGMENT 'CODE'
        ASSUME  CS:_NANFOR,DS:_FT_DATASEG,ES:_FT_DATASEG,SS:NOTHING


FT_FLOPTST      PROC    FAR

                XOR     AX,AX                        ; GET # OF PARAMETERS
                PUSH    AX                           ;
                CALL    __PARINFO                    ; CALL INFORMATION FUNCTION
                ADD     SP,2                         ; FIX UP THE STACK
                CMP     AL,1                         ; # OF PARAMETERS = 1 ?
                JNB     GETTYPE                      ; YES. GET THE TYPE
                JMP     SHORT FERROR                 ; NO. RETURN ERROR

GETTYPE:
                MOV     AX,1                         ; SPECIFY FIRST PARAM
                PUSH    AX
                CALL    __PARINFO                    ; CALL INFO FUNCTION
                ADD     SP,2                         ; FIX UP THE STACK
                TEST    AX,2                         ; NUMERIC?
                JNZ     GETDRIVE                     ; YES.  GET DRIVE
                JMP     SHORT FERROR                 ; NO.  REPORT ERROR

GETDRIVE:
                MOV     AX,1                         ; GET 1ST PARAMETER (drive)
                push    ax                           ;
                call    __parni                      ; must be a integer type
                add     sp,2                         ; fix up the stack
                push    ax                           ; save drive
                int     11h                          ; get equipment list
                mov     ah,0                         ; clear high byte
                mov     cl,6                         ; set shift count
                shr     al,cl                        ; shift diskette count
                pop     bx                           ; restore drive
                cmp     bl,al                        ; does drive exist?
                jbe     ParamOk                      ; yes, so continue
derror:         jmp     short Ferror                 ; Invalid drive

ParamOk:
                push    ds                           ; Save DS
                mov     dx,_FT_DATASEG               ; DATA SEGMENT
                MOV     DS,DX                        ; IN DS REGISTER
                MOV     ES,DX                        ; IN ES REGISTER
                MOV     FDRIVE,BL                    ; SAVE DRIVE NUMBER
                XOR     AX,AX                        ; RESET DISKETTE SYSTEM
                INT     13H                          ; CALL BIOS
                CALL    _FTFLOPT                     ; TEST DISKETTE TYPE
                POP     DS                           ; RESTORE DS
                JMP     SHORT EXIT                   ; RETURN

FERROR:
                MOV     AX,-1                        ; BAD PARAMETERS

EXIT:
                PUSH     AX                          ; PUSH RETURN VALUE
                CALL     __RETNI                     ; AND RETURN IT TO CLIPPER
                ADD      SP,2                        ; FIX UP THE STACK

                RET                                  ; FAR RETURN TO CLIPPER

FT_FLOPTST      ENDP

;-----------------------------------------------------------;
; LOCAL SUBROUTINE - CALL BIOS INT 13 FOR READ SECTOR       ;
;-----------------------------------------------------------;

_FTINT13        PROC    NEAR
                PUSH    BX                           ; SAVE REGS
                PUSH    ES                           ;
                PUSH    AX                           ;
                INT     13H                          ; CALL BIOS (read sector)
                jnc     ftIntRet                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
                jnc     ftIntRet                     ; Read ok. Exit
                xor     ax,ax                        ; reset diskette system
                int     13h                          ; call BIOS
                pop     ax                           ; restore regs
                pop     es                           ; for retry
                push    es                           ; save regs
                push    ax                           ;
                int     13h                          ; call BIOS (read sector)
ftIntRet:       pop     bx                           ; restore regs
                pop     es                           ;
                pop     bx                           ;
                ret                                  ; near return

_ftint13        endp

;-----------------------------------------------------------;
; Local subroutine - check boot sector                      ;
;-----------------------------------------------------------;

_ftflopt        proc    near

                push    di                           ; preserve
                mov     di,OFFSET _FT_DataSeg:boot_sect   ; address of buffer
ftflopred:
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive number in DL
                mov     cx,0001h                     ; track 0, sector 1
                mov     bx,di                        ; buffer addr in ES:BX
                mov     ax,0201h                     ; read one sector
                call    _ftint13                     ; call BIOS
                jnc     Flop1                        ; Read ok. Continue
                cmp     ah,80h                       ; drive not ready ?
                je      Flop_out                     ; Yes.
                cmp     ah,02h                       ; unformatted?
                je      Flop_for                     ; Yes
                mov     ax,4                         ; otherwise, unknown
                jmp     short Flop_End               ; and exit
Flop1:
                xor     dx,dx                        ; clear DX
                mov     dl,fdrive                    ; drive number in DL
                mov     cx,0001h                     ; track 0, sector 1
                mov     bx,di                        ; buffer addr in ES:BX
                mov     ax,0301h                     ; write one sector
                call    _ftint13                     ; call BIOS
                jnc     Flop_OK                      ; Write ok. Disk s/b AOK
                cmp     ah,03h                       ; Write protected?
                jne     Flop_OK                      ; No disk AOK
                mov     ax,3
                jmp     short Flop_End
Flop_out:
                mov     ax,1
                jmp     short Flop_End
Flop_for:
                mov     ax,2
                jmp     short Flop_End
Flop_OK:
                xor     ax,ax                        ; AX = 0
Flop_End:
                pop     di                           ; restore
                ret                                  ; near return

_ftflopt        endp

_nanfor         ends
                end


