; File......: NWTTS1.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   15 Aug 1991 23:07:22  $
; Revision..: $Revision:   1.2  $
; Log File..: $Logfile:   E:/nanfor/src/nwtts1.asv  $
;
; This is an original work by James R. Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/nwtts1.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:07:22   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   12 Apr 1991 00:02:54   GLENN
;  Librarian error!  I changed James' function name, adding the ft_ 
;  prefix, after testing (error!) and didn't realize that .asm function 
;  _must_ obey the 10-character limit or the symbol isn't found by the
;  linker.  Changed the function name to ft_ttsavai() (although calling
;  it from Clipper the old way will work).  Apologies to all.
;  
;     Rev 1.0   01 Apr 1991 01:03:38   GLENN
;  Nanforum Toolkit
;  


; $DOC$
; $FUNCNAME$
;     FT_TTSAVAIL()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     Check whether default Novell file server supports TTS
; $SYNTAX$
;     FT_TTSAVAIL() -> nResult
; $ARGUMENTS$
;     None
; $RETURNS$
;        0 - TTS unavailable or not supported.
;        1 - TTS is installed and available.
;      253 - TTS is disabled.
; $DESCRIPTION$
;    This routine is used to check the default NetWare file server for TTS
;    availability.  You must have Novell NetWare SFT Level II or above to
;    use these functions.  Using these functions on a non SFT II file server
;    will return unsuccessful values.  You must have TTS installed on your
;    file server.
;
;    This routine was designed and written for Novell Advanced NetWare 2.15
;    SFT Level II and Novell NetWare 386 v 3.0 and above.
;
;    This source code was written for Microsoft Macro Assembler v5.1.
; $EXAMPLES$
;    IF FT_TTSAVAIL() == 1   // If TTS is available
;      FT_TTSBEGIN()         // Begin transaction
;    ENDIF
; $SEEALSO$
;    FT_TTSABORT() FT_TTSBEGIN() FT_TTSEND() FT_TTSSTAT()
; $END$

PUBLIC      FT_TTSAVAI                    ; Make routine visible

EXTRN       __RETNI:FAR                   ; Declare externals
EXTRN       __RET:FAR
_NanFor     SEGMENT 'CODE'
            ASSUME cs:_NanFor             ; Point to my code
FT_TTSAVAI  PROC    FAR
            push    bp                    ; Save Base Pointer
            mov     bp,sp                 ; Point to top of stack
            push    ds                    ; Save registers
            push    es
            push    si
            push    di
            mov     ah,0c7h               ; Novell API function c7
            mov     al,02h                ; Subfunction 02
            int     21h                   ; TTS Is Availible?
            mov     ah,00h                ; Zero out high byte of AX
            push    ax                    ; Push AX onto stack
            call    __RETNI               ; Pass AX back to Clipper
            add     sp,2                  ; Adjust stack
            pop     di                    ; Restore registers
            pop     si
            pop     es
            pop     ds
            pop     bp
            call    __RET                 ; Clean up for Clipper
            ret                           ; Pass control back to Clipper
FT_TTSAVAI  ENDP
_NanFor     ENDS
            END
