/*
 * File......: PEEK.C
 * Author....: Ted Means
 * Date......: $Date:   15 Aug 1991 23:08:18  $
 * Revision..: $Revision:   1.2  $
 * Log file..: $Logfile:   E:/nanfor/src/peek.c_v  $
 * 
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log:   E:/nanfor/src/peek.c_v  $
 * 
 *    Rev 1.2   15 Aug 1991 23:08:18   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 * 
 *    Rev 1.1   14 Jun 1991 19:53:46   GLENN
 * Minor edit to file header
 * 
 *    Rev 1.0   01 Apr 1991 01:02:52   GLENN
 * Nanforum Toolkit
 * 
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_PEEK()
 *  $CATEGORY$
 *     DOS/BIOS
 *  $ONELINER$
 *     Retrieve a byte from a specified memory location.
 *  $SYNTAX$
 *     FT_PEEK( <nSegment>, <nOffset> ) -> nValue
 *  $ARGUMENTS$
 *     <nSegment> is the segment of the desired memory address.
 *
 *     <nOffset>  is the offset of the desired memory address.
 *  $RETURNS$
 *     <nValue> will be a value from 0 to 255 if all parameters were valid and
 *              the function was able to retrieve the desired byte.
 *     <nValue> will be -1 if invalid parameters were passed.
 *  $DESCRIPTION$
 *     Use this function if you have a need to examine a specific memory
 *     location.  The function will return the byte at the specified
 *     address as a numeric value.  If you need this value as a character,
 *     use the Chr() function to convert it.
 *
 *     This function was written for version 5.1 of MicroSoft C.  You may
 *     have to modify the source code to use another compiler.
 *  $EXAMPLES$
 *     local nVMode := FT_PEEK( 0, 1097 )  // Get the current video mode
 *  $END$
 */

#include <extend.h>

CLIPPER FT_PEEK(void)
{
   auto unsigned char * byteptr;

   if ( (PCOUNT >= 2) && (ISNUM(1)) && (ISNUM(2)) )
   {
      * ((unsigned int *) &byteptr)     = _parni(2);
      * ((unsigned int *) &byteptr + 1) = _parni(1);
      _retni( (unsigned int) (*byteptr) );
   }
   else
      _retni( -1 );
   return;
}
