; File......: SHADOW.ASM
; Author....: Ted Means
; Date......: $Date:   16 Oct 1992 00:07:06  $
; Revision..: $Revision:   1.4  $
; Log file..: $Logfile:   C:/nanfor/src/shadow.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   C:/nanfor/src/shadow.asv  $
;  
;     Rev 1.4   16 Oct 1992 00:07:06   GLENN
;  Just making sure we had Ted's current revision.
;  
;     Rev 1.3   28 Sep 1992 21:41:06   GLENN
;  Ted Means completely and totally rewrote this to compile under TASM's
;  IDEAL mode, with more features.  See the documentation.  It should be
;  compatible with the old Reginald Walton function, but is much faster.
;  
;     Rev 1.2   15 Aug 1991 23:07:26   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   11 May 1991 00:29:22   GLENN
;  Major re-write by Ted Means.  He sped it up.  It will also cooperate
;  with Clipper's internal _gtmaxrow and _gtmaxcol settings.  
;  
;     Rev 1.0   02 Apr 1991 18:25:40   GLENN
;  Nanforum Toolkit
;
;

;  $DOC$
;  $FUNCNAME$
;      FT_SHADOW()
;  $CATEGORY$
;      Video
;  $ONELINER$
;      Draw a non-destructive shadow on the screen
;  $SYNTAX$
;     FT_SHADOW( <nTop>, <nLeft>, <nBottom>, <nRight>, <nAttr> ) -> NIL
;  $ARGUMENTS$
;     <nTop>    is the top row of the shadow area.
;     <nLeft>   is the upper left column of the shadow area.
;     <nBottom> is the bottom row of the shadow area.
;     <nRight>  is the lower right column of the shadow area.
;     <nAttr>   is the screen attribute to use for drawing the shadow.
;  $RETURNS$
;     NIL
;  $DESCRIPTION$
;     This function allows you to implement the popular "shadow effect."  It
;     draws a shadow using the specified screen coordinates.  The entire
;     specified region is shadowed.
;
;     *** INTERNALS ALERT ***  This function uses several Clipper internal 
;     routines.  If using internals scares you, then stay away from this
;     function, you gutless weasel.  The use of the internals helps to make
;     the function more well-behaved.  Clipper's display context is not
;     violated -- if you use dispbegin() before drawing the shadow, it will
;     not appear until the corresponding call to dispend().  This makes for
;     much smoother screen i/o if you have several screen objects that
;     you wish to shadow.
;
;     The source code is written to TASM IDEAL mode.
;  $EXAMPLES$
;     FT_Shadow(10,10,10,50, 8)  // draw a dim shadow
;        
;     FT_Shadow(10,10,10,40,47)  // draw a green shadow
;  $END$

IDEAL                                        ; Invoke TASM IDEAL mode

Public   FT_Shadow

Extrn    __ParNI:Far
Extrn    __xGrab:Far
Extrn    __xFree:Far
Extrn    __gtSave:Far                        ; INTERNAL!!!
Extrn    __gtRest:Far                        ; INTERNAL!!!

nTop     EQU       Word Ptr BP - 2
nLeft    EQU       Word Ptr BP - 4
nBottom  EQU       Word Ptr BP - 6
nRight   EQU       Word Ptr BP - 8
nAttr    EQU       Byte Ptr BP - 10
nSize    EQU       Word Ptr BP - 12

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_Shadow Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,12                     ; Allocate locals

         Mov       CX,5                      ; Set param count
@@Coord: Push      CX                        ; Put on stack
         Call      __ParNI                   ; Retrieve param
         Pop       CX                        ; Get count back
         Push      AX                        ; Put value on stack
         Loop      @@Coord                   ; Get next value

         Pop       [nTop]                    ; Get top coordinate
         Pop       [nLeft]                   ; Get left coordinate
         Pop       [nBottom]                 ; Get bottom coordinate
         Pop       [nRight]                  ; Get right coordinate
         Pop       [Word Ptr BP - 10]        ; Get attribute

         Mov       AX,[nBottom]              ; Load bottom coordinate
         Sub       AX,[nTop]                 ; Subtract top
         Inc       AX                        ; Calc length

         Mov       DX,[nRight]               ; Load right coordinate
         Sub       DX,[nLeft]                ; Subtract left
         Inc       DX                        ; Calc width
         Mul       DX                        ; Calc buffer size
         Mov       [nSize],AX                ; Store size

         SHL       AX,1                      ; Account for attribute bytes
         Push      AX                        ; Put size on stack
         Call      __xGrab                   ; Allocate virtual memory

         Push      DX                        ; Put buffer segment on stack
         Push      AX                        ; Put buffer offset on stack
         Push      [nRight]
         Push      [nBottom]                 ; Get bottom coordinate
         Push      [nLeft]
         Push      [nTop]                    ; Get top row
         Call      __gtSave                  ; Save screen image

         Mov       BX,SP                     ; Point BX to buffer pointer
         Mov       AL,[nAttr]                ; Get attribute
         Mov       CX,[nSize]                ; Get length
         Push      DI                        ; Save DI
         LES       DI,[SS:BX + 8]            ; Load pointer to buffer
@@Top:   Inc       DI                        ; Point to attribute byte
         Stosb                               ; Set attribute
         Loop      @@Top                     ; Do next byte
         Pop       DI                        ; Restore DI
         Call      __gtRest                  ; Put shadowed image onscreen

@@Done:  Add       SP,8                      ; Remove params from stack
         Call      __xFree                   ; Free buffer
         Mov       SP,BP                     ; Realign stack
         Pop       BP                        ; Restore BP
         Ret
Endp     FT_Shadow
Ends     _NanFor
End


