* Function: PATHTO
* Author..: Richard Low
* Syntax..: PATHTO(exp<C>)  Where exp<C> is name of file to find path to.
* Usage...: To find the DOS path pointing to a file.
* Returns.: DOS path pointing to filename specified by exp<C>, or a NULL
*           string if the file was not found in any of the paths.
*

FUNCTION PATHTO
PARAMETER p_filename
PRIVATE f_dospath, f_path

f_dospath = GETE('PATH')                                              && get dos's path from environment (in EXTEND.LIB)
DO WHILE LEN(TRIM(f_dospath)) > 0                                     && parse for path to help files

   IF ';' $ f_dospath                                                 && if a semicolon is found in path
      f_path = TRIM(SUBSTR(f_dospath,1,AT(';',f_dospath)-1))          && parse each section of the path
   ELSE                                                               && otherwise
      f_path = TRIM(f_dospath)                                        && only one path in the path
   ENDIF

   IF FILE( f_path + '\' + p_filename )                               && found it
      RETURN (f_path + '\')
   ENDIF

   IF ';' $ f_dospath
      f_dospath = TRIM(SUBSTR(f_dospath,AT(';',f_dospath)))           && snip off beginning of path before semicolon
      IF LEN(f_dospath) = 1                                           && only a semicolon left
         EXIT                                                         && quit looking
      ENDIF                                                           && otherwise
      f_dospath = SUBSTR(f_dospath,2)                                 && snip off the leading semicolon
   ELSE
      EXIT
   ENDIF

ENDDO
RETURN ('')
