; I will read your rights first:
;
; You are entitled to remove this program and its accompanying
; files from your system and forget all about it.
;
; I do claim that this program is good and on my machine (a pc clone)
; I do claim it works, maybe it works on your machine too but thats
; for you, totally on your own risk, to find out.
;
; If you don't like this then once more:
; You are entitled to remove this program and its accompanying
; files from your system and forget all about it.
;
; HOWEVER if you like this small program you are encouraged to send
; me a dollar or whatever you can afford.
; A nice postcard is also welcome.
;
; In time when I have received enough dollars I may afford my own
; Internet connection. Until then send me mail with a stamp on it.
;
; Suggestions and funds are welcomed by:
;
;               A.M.C. van Kinderen
;               Haagbeukhof 249
;               3355 AG Nederland
;               Europa.
;
; ===================================================================
;
;               ClockFix.exe
;
; This Terminate Stay Resident (TSR) utility corrects a single
; mistake in DOS. If you leave your computer on and don't do
; anything on it that requires the clock then your machines date
; will lose a day each time passing midnight...
; So it is not your Real Time Clock (RTC) that is causing this
; annoying problem it is DOS that does that.
;
; This TSR compensates for that. It looks at a flag if it is passed
; midnight and if so updates the DOS system time from the RTC. Which also
; resets the flag it looks at. So it actually runs only once a day.
;
; Load it from your autoexec.bat file
;
               .model small

CODE           segment para public 'CODE'
               ASSUME CS:CODE

Programme      db 13, "ClockFix 1.9 950606 (C) by "
Copyright      db "A.M.C. van Kinderen.",13,10,0,26

;=============================================================================
; TimInt chains into interrupt 08h.   (Invoked by the BIOS)
;=============================================================================
INT08H         dd      ?                       ;interrupt 08h vector timer

TimInt         proc    far                     ;checking for midnight
               push    ax
               push    es
               mov     ax,00040h               ;system data segment
               mov     es,ax
               mov     ah,byte ptr es:[0006eh] ;[18]00B0h maximum
               cmp     byte ptr cs:LastTime,ah ;compare with previous time
               mov     byte ptr cs:LastTime,ah ;update previous always
               pop     es
               pop     ax
               jz      Jmp08h                  ;no change since last update
               cmp     byte ptr cs:LastTime,0  ;has it changed to midnight?
               jnz     Jmp08h                  ;if not jump

;it is passed midnight set flag so IdleInt updates system with RTC
               inc     byte ptr cs:UpdateFlag  ;checked by IdleInt
Jmp08h:        jmp     INT08H                  ;jump to original interrupt

TimInt         endp

LastTime       db      ?                       ;high byte of system timer
UpdateFlag     db      0                       ;the actual messenger
;=============================================================================

; The BIOS may not invoke DOS interrupts, thats why the UpdateFlag is used
; to signal the DOS idle interrupt to do an update.
; The DOS idle interrupt may both invoke DOS and BIOS calls without problems.

;=============================================================================
; IdleInt chains into interrupt 28h. (Invoked by DOS with its full stack)
;=============================================================================
INT28H         dd      ?    ;                  ;DOS idle interrupt

IdleInt        proc    far                     ;
               cmp     byte ptr cs:UpdateFlag,0;check messenger flag
               jz      Jmp28h                  ;No change since last update
;it is passed midnight update system with RTC
               push    ax                      ;save used registers
               push    bx
               push    cx
               push    dx

               push    es
               xor     ax,ax
               mov     es,ax
               mov     byte ptr es:[00470h],1  ;0:470 equals 40:70
               mov     ah,02ah
               int     021h                    ;get system date
               pop     es

               mov     ah,004h                 ;get rtc date
               int     01Ah                    ;through the bios
               jnc     date_ok                 ;if no carry data is alright
               mov     ah,004h                 ;get rtc date once more
               int     01Ah                    ;maybe it was just in an update
               jc      rtc_problem             ;jump if the rtc doesn't do IT
date_ok:                          ;ch=century, cl=year, dh=month, dl=day
               mov     al,cl                   ;al=bcd year
               call    bcd2bin                 ;now al contains binary year
               mov     cl,al                   ;cl=bin year
               mov     al,ch                   ;al=bcd century
               call    bcd2bin                 ;now al contains binary century
               mov     ah,100                  ;multiply century by 100
               mul     ah                      ;ah:al := al * ah
               sub     ch,ch                   ;zero top byte
               add     ax,cx                   ;ax contains century * 100 + year
               mov     cx,ax                   ;this year cx is 1995 binary

               mov     al,dh                   ;al=bcd month
               call    bcd2bin                 ;al=bin month
               mov     dh,al                   ;now dh contains binary month
               mov     al,dl                   ;al=bcd day
               call    bcd2bin                 ;al=bin day
               mov     dl,al                   ;now dl contains binary day

               mov     ah,02bh                 ;set DOS system date
               int     021h

               mov     ah,002h                 ;get rtc time
               int     01Ah                    ;through the bios
               jnc     time_ok                 ;if no carry data is alright
               mov     ah,002h                 ;get rtc time once more
               int     01Ah                    ;maybe it was just in an update
               jc      rtc_problem             ;jump if the rtc doesn't do IT

time_ok:                          ;ch=hour, cl=minute, dh=secs, dl=/100
               mov     al,ch                   ;al=bcd hour
               call    bcd2bin                 ;al=bin hour
               mov     ch,al                   ;now ch contains binary hour
               mov     al,cl                   ;al=bcd minute
               call    bcd2bin                 ;al=bin minute
               mov     cl,al                   ;now cl contains binary minute
               mov     al,dh                   ;al=bcd second
               call    bcd2bin                 ;al=bin second
               mov     dh,al                   ;now dh contains binary second

;you can add 10ms units, if your clock runs slow [0..99]
;This allows you to compensate for 6 minutes a year maximum.
               mov     dl,1                    ;run 3.6s fast each year
               mov     ah,002dh                ;set DOS system time
               int     021h                    ;time should stay the same

               dec     byte ptr cs:UpdateFlag  ;decrement flag (reset)
               inc     byte ptr cs:[signal]    ;show success

rtc_problem:   pop     dx                      ;restore used registers
               pop     cx
               pop     bx
               pop     ax
Jmp28h:        jmp     INT28H                  ;jump to original interrupt

bcd2bin:       mov     bl,al                   ;bcd digits in bl
               and     bl,0f0h                 ;tens digit *16 in bl
               shr     bl,1                    ;tens digit *8 in bl
               mov     bh,bl                   ;tens digit *8 in bh
               shr     bl,1                    ;tens digit *4 in bl
               shr     bl,1                    ;tens digit *2 in bl
               and     al,00fh                 ;units digit in al
               add     al,bh                   ;units + 8*tens
               add     al,bl                   ;units + (8+2)*tens
               retn

Signal         db      0                       ;counts succesful runs

IdleInt        endp

;=============================================================================
; NON-resident code starts here
;=============================================================================

Initialize     proc    near
               ASSUME  CS:CODE, DS:CODE
               push    cs                   ;set code segment
               pop     ds                   ;as our datasegment
               mov     ah,030h              ;get dosversion
               int     021h                 ;al=major, ah=minor
               xchg    ah,al                ;ah=major, al=minor
               cmp     ax,00330h            ;must be at least 3.30
               jae     StartInstall
               mov     ah,040h              ;display copyright
               mov     bx,001h              ;stdout
               mov     cx,offset StartInstall - offset WrongDOS
               mov     dx,offset WrongDOS
               int     021h
               mov     ax,04c01h            ;set errorlevel 1
               int     021h                 ;and exit
WrongDOS:      db      13,,7,"Error: Dos version must be 3.30 or later",13,10
StartInstall:
; Start with a simple and limited check if already installed.
; This check will fail if the timer interrupt has been chained by an other
; program after ours did that.
               mov     ax,03508h            ;get old timer interrupt vector
               int     021h
               mov     cx,(offset LastTime - offset TimInt)
               mov     di,bx                ;es:[di] pointing to previous ISR
               mov     si,offset TimInt     ;ds:[si] pointing to our ISR
               rep     cmpsb
               jz      Already_installed

               mov     ah,062h              ;get program segment prefix (PSP)
               int     021h                 ;in bx
               mov     es,bx                ;load into a segment register
               mov     es,es:[0002ch]       ;get segment of environment
               mov     ah,049h              ;deallocate the programme's
               int     021h                 ;environment block
;--Hook into interrupt 08H
               mov     ax,03508h            ;get old timer interrupt vector
               int     021h
               mov     word ptr [INT08H],bx ;and save it
               mov     word ptr [INT08H+2],es
               mov     ax,02508h            ;then set the new vector
               mov     dx,offset TimInt
               int     021h

;--Hook into interrupt 28H
               mov     ax,03528h            ;get old Idle interrupt vector
               int     021h
               mov     word ptr [INT28H],bx ;and save it
               mov     word ptr [INT28H+2],es
               mov     ax,02528h            ;then set the new vector
               mov     dx,offset IdleInt
               int     021h

;--Display copyright notice, then terminate and remain resident in memory.
               mov     ah,040h              ;display copyright
               mov     bx,001h              ;stdout
               mov     cx,offset INT08H - offset Programme
               mov     dx,offset Programme
               int     021h
               mov     ax,03100h            ;stay resident
               mov     dx,(offset Initialize - offset Code + 15) shr 4
               add     dx,16                ;16 paras in front of programme
               int     021h

Already_installed:
               mov     ax,03508h            ;get old timer interrupt vector
               int     021h
               mov     ah,es:[Signal]       ;get signal count
               mov     bx,offset Success    ;point to result
F100:                                       ;simple binary to ascii conversion
N100:
               sub     ah,100
               jc      F10
               inc     byte ptr [bx]
               jmp     N100
F10:
               add     ah,100
               inc     bx
N10:
               sub     ah,10
               jc      F1
               inc     byte ptr [bx]
               jmp     N10
F1:
               add     ah,10
               inc     bx
N1:
               sub     ah,1
               jc      F
               inc     byte ptr [bx]
               jmp     N1
F:
               mov     ah,040h              ;display message
               mov     bx,001h              ;stdout
               mov     cx,offset Count_end - offset Count_display
               mov     dx,offset Count_display
               int     021h
               mov     ax,04c02h            ;set errorlevel 2
               int     021h                 ;and exit
Count_display: db      13,7,"ClockFix already installed.",13,10
Success:       db      "000 successful updates.",13,10
Count_end:
Initialize     endp

STACK          0h                           ;just to satisfy linker
CODE           ends
               End     Initialize

