	include	mmclock.mac
	title	MM58167A BIOS routines -- Copyright 1990 Wales

; ======================================================================
;
; BIOS routines for the MM58167A clock/calendar.
; (C) Copyright 1990 Richard B. Wales.  All Rights Reserved.
;
; Global routines:
;
;	SetBIOS
;		Sets the BIOS time-of-day count.

; ======================================================================
;
; Global symbols.
	public	SetBIOS

; ======================================================================
;
; SetBIOS
;
;	Set the BIOS time-of-day count.
;	This routine is used so that the BIOS time-of-day count will be
;	in agreement with the system time from the MM58167A (to within
;	about half a second).
;
;	Arguments:
;
;		CH	Hours (0-23).
;		CL	Minutes (0-59).
;		DH	Seconds (0-59).
;		DL	Hundredths of a second (0-99).

SetBIOS	proc	near


	; Validate the input arguments.
	cmp	ch, 23
	ja	short done
	cmp	cl, 59
	ja	short done
	cmp	dh, 59
	ja	short done
	cmp	dl, 99
	ja	short done

	; Use AX as an accumulator for the time-of-day count.
	xor	ax, ax

	; Add hundredths of a second (46/256 tick per 1/100 sec).
        xor	bx, bx
	mov	bl, dl
	shl	bx, 1
	add	ax, bx			; add DL *  2/256
	shl	bx, 1
	add	ax, bx			; add DL *  4/256
	shl	bx, 1
	add	ax, bx			; add DL *  8/256
	shl	bx, 1
	shl	bx, 1
	add	ax, bx			; add DL * 32/256
	; (maximum value so far = 17.789)

	; Add seconds (18 + 52/256 ticks per second).
	xor	bx, bx
	mov	bl, dh
	shl	bx, 1
	shl	bx, 1
	add	ax, bx			; add DH *  4/256
	shl	bx, 1
	shl	bx, 1
	add	ax, bx			; add DH * 16/256
	shl	bx, 1
	add	ax, bx			; add DH * 32/256
	mov	al, ah
	xor	ah, ah			; throw away fraction now
	shr	bx, 1
	add	ax, bx			; add DH * 16
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	add	ax, bx			; add DH *  2
	; (maximum value so far = 1091)

	; Add minutes (1092 ticks per minute).
	xor	bx, bx
	mov	bl, cl
        mov	cl, 4
	shl	bx, 1
	shl	bx, 1
	add	ax, bx			; add CL *    4
	shl	bx, cl
	add	ax, bx			; add CL *   64
	shl	bx, cl
	add	ax, bx			; add CL * 1024
	; (maximum value so far = 65,519)

	; Use BX as an accumulator for the high-order 16 bits.
	; Initialize BX to the number of hours (65,536 ticks per hour).
	; This is not quite enough (should be 65,544); the extra will
	; be taken care of in a moment.
	xor	bx, bx
	mov	bl, ch			; add CH * 65536

	; Add 8 more ticks per hour.  There might be a carry from AX
	; into BX after this is done.
	mov	cl, ch
	xor	ch, ch
	xor	dx, dx			; use DX = 0 when adding carry
	shl	cx, 1
	shl	cx, 1
	shl	cx, 1
	add	ax, cx			; add CH * 8
	adc	bx, dx			; handle carry (if any)
	; (maximum final value = 1,573,031;
	;  compare with 1,573,040 = one full day)

	; We now have the high-order 16 bits in BX, and the low-order
	; 16 bits in AX.  Give this value to the BIOS to store as the
	; time-of-day count.
	mov	cx, bx
	mov	dx, ax
	mov	ah, 1
	int	1Ah

	; That's all.
done:	ret

SetBIOS	endp

code	ends

	end