	       INCLUDE MODEL.INC
;
;---------------------------------------------------------------------------
;   Function:	void _bye_getname(s)
;
;   Parms:	int *s;  -> ptr to string buffer
;
;   Purpose:	This function returns a null terminated string up
;		to 64 characters in length. The string contains the
;		callers name currently on line set from a previous
;		call by '_bye_setname()'.
;
;   Return:	void
;---------------------------------------------------------------------------
;
	       PUBLIC __bye_getname

__bye_getname  PROC

	       push bp			;standard 'C' function entry
	       mov  bp,sp
	       push di
	       push si
	       push ds
	       push es

	     IF @datasize
	       les  di,ARG1		;ES:DI = ptr string dest
	     ELSE
	       mov  di,ARG1		;DI = near ptr to string dest
	     ENDIF

	       push es			;save ES
	       mov  ah,21		;AH=21 for get name ptr
	       int  BYE_VECT		;ES:BX = far ptr to name buffer
	       mov  si,bx
	       mov  ax,es
	       mov  ds,ax		;DS:SI = far ptr to source
	       pop  es			;restore ES

	       cld			;clear direction flag
getn_loop:     lodsb			;read a byte from source DS:SI
	       stosb			;store a byte at ES:DI
	       cmp  al,0		;end of string yet?
	       jne  SHORT getn_loop	;no, loop back again

getn_end:      pop  es
	       pop  ds
	       pop  si
	       pop  di
	       mov  sp,bp		;standard 'C' exit
	       pop  bp
	       ret

__bye_getname  ENDP
	       END

