	       INCLUDE MODEL.INC
;
;---------------------------------------------------------------------------
;   Function:	void _bye_setcd(flag)
;
;   Parms:	flag = 0    carrier check disabled
;		flag = 1    carrier check enabled
;
;   Purpose:	Sets a flag in BYE-PC to ignore carrier detect
;		status. This is used before writing to a file to
;		prevent warm booting while writing to disk in the
;		event carrier is lost during a disk write.
;
;   Return:	void
;---------------------------------------------------------------------------
;
	       PUBLIC __bye_setcd

__bye_setcd    PROC

	       push bp			;standard 'C' function entry
	       mov  bp,sp

	       mov  ax,ARG1		;cd check state in AL
	       mov  ah,4		;AH=4 for set CD check
	       int  BYE_VECT

	       mov  sp,bp		;standard 'C' exit
	       pop  bp
	       ret

__bye_setcd    ENDP
	       END

