        ON ESCAPE GOSUB Exit
        LEGEND " Modem diagnostic"
;***    TRACE ON
;
; ----- MdmDiag: Modem diagnostic routine for COM-AND.
;
;       R.McG; 8/90, Chicago
; ----------------------------------------------------------------
;       Usages:
;          S0 carries the original port/speed when entered
;          N99,N98 contain original cursor row, col
; ----------------------------------------------------------------
;
;       Initialization..
;
        SAVE 0,0,"_SSIZE"-1,79          ; Save original screen
        CURSOR N99,N98
        CLEAR                           ; Clear screen
        COMPARMS S0                     ; Get current settings
        S0 = S0(11:14)                  ; Make it easy
;
;       Find the port to use, and take register values
;
        GOSUB TestPort                  ; Find which ports exist
        GOSUB GetPort                   ; Set port name we'll use (into S1)
        SET PORT S1                     ; Switch to desired port
        COMBASE S1 N0                   ; Get port base addr from str in s1
        GOSUB GetRegs                   ; Using N0, rtn N1-N7 values
;
;       Display the port/base addr
;
        BOX   0,0,3,38 (default)
        ATSAY 1,2 (default) "Comm setting: "*"_PARM"
        STRFMT S2 "%x" N0
        ATSAY 2,2 (default) "Base address: "*S2
        COMVEC S1 N0
        ATSAY 2,25 (default) "IRQ: "*N0
;
;       Display the LCR
;
        S1 = " Line Control Register "
        S2 = "DLB STB STP EPS PEN STB WS1 WS0"
        N8 = 40
        N9 = 0
        N0 = N1
        GOSUB DISPREG
;
;       Display the LSR
;
        S1 = " Line Status Register "
        S2 = "    TSE THE BI  FE  PE  OE  DR "
        N9 = 4
        N0 = N2
        GOSUB DISPREG
;
;       Display the MCR
;
        S1 = " Modem Control Register "
        S2 = "            LP  OT2 OT1 RTS DTR"
        N9 = 8
        N0 = N3
        GOSUB DISPREG
;
;       Display the MSR
;
        S1 = " Modem Status Register "
        S2 = "RLS RI  DSR CTS DRD TER DDR DCS"
        N9 = 12
        N0 = N4
        GOSUB DISPREG
;
;       Display the IIR
;
        S1 = " Interrupt ID Register "
        S2 = "                    ID2 ID1 ITP"
        N9 = 16
        N0 = N5
        GOSUB DISPREG
;
;       Display the IER
;
        S1 = " Interrupt Enable Register "
        S2 = "                ESI ELI ETI ERI"
        N9 = 20
        N0 = N6
        GOSUB DISPREG
;
;       Display the IMR
;
        S1 = " Interrupt Mask Register "
        S2 = "IQ7 IQ6 IQ5 IQ4 IQ3 IQ2 IQ1 IQ0"
        N8 = 0
        N9 = 4
        N0 = N7
        GOSUB DISPREG
;
;       Wait for a Keypress
;
        LEGEND " Modem Diagnostic - press any key to quit"
        KEYGET S1
;
;       And we're done
;
Exit:
        SET PORT S0             ; Restore original port
        DO                      ; There may be multiple saves outstanding
           RESTORE              ; .. restore all
           UNTIL FAILURE
        LOCATE N99,N98
        EXIT
;
; ----- Display a register's value
;          S1  passed -> Legend for Box
;          S2  passed -> 1st line of box display (we'll draw 2nd)
;          N0  passed -> Register value
;          N9  passed -> Row number of top of box
;          N8  passed -> Col number of topleft of box
;
DISPREG:
        BOX   N9,N8,N9+3,N8+38 (default)
        ATSAY N9+1,N8+2 (default) S2
        ATSAY N9,N8+2 (default) S1
        N10 = 128
        N11 = 1
        S3 = ""
        WHILE N10 GT 0
              IF 0 NE (N0 & N10) S3(N11:N11) = "1"
              N10 = N10/2
              N11 = N11+4
              ENDWHILE
        ATSAY N9+2,N8+2 (default) S3
        RETURN
;
; ----- Get register values
;          N0  passed -> Base address for port
;          N1-N7 returned: register values
;
GetRegs:
        INPUT N1,N0+3           ; Line control reg
        INPUT N2,N0+5           ; Line status reg
        INPUT N3,N0+4           ; Modem control reg
        INPUT N4,N0+6           ; Modem status reg
        INPUT N5,N0+2           ; Interrupt ID reg
        INPUT N6,N0+1           ; Interrupt enable
        INPUT N7,0x21           ; Interrupt make register (8259)
        RETURN
;
; ----- Get Port name to use
;          S0  passed default port name
;          S1  returned: port name to be used
;
GetPort:
        WOPEN 10,10,17,50 (default)
        ATSAY 10,12 (default) " Modem Diag Select "
        IF FLAG(0) ATSAY 11,12 (default) "1) Select COM1"
        IF FLAG(1) ATSAY 12,12 (default) "2) Select COM2"
        IF FLAG(2) ATSAY 13,12 (default) "3) Select COM3"
        IF FLAG(3) ATSAY 14,12 (default) "4) Select COM4"
        ATSAY 15,12 (default)            "5) Use default (also c/r)"
        ATSAY 16,12 (default)            "Select from above: "
        ATSAY 17,20 (default) " Press ESC to exit "
        LOCATE 16,32
        KEYGET S1
        SWITCH S1
               CASE "1"
                    S1 = "COM1"
                    ENDCASE
               CASE "2"
                    S1 = "COM2"
                    ENDCASE
               CASE "3"
                    S1 = "COM3"
                    ENDCASE
               CASE "4"
                    S1 = "COM4"
                    ENDCASE
               CASE "5"                 ; Default case
                    S1 = S0             ; .. use it
                    ENDCASE
               CASE "0D"                ; Default case
                    S1 = S0             ; .. use it
                    ENDCASE
               DEFAULT
                    SOUND 100,100
                    WCLOSE              ; We'll reopen above
                    GOTO GetPort        ; .. try again
                    ENDCASE
               ENDSWITCH
        WCLOSE
        RETURN
;
; ----- Test existing ports...
;          S0 passed is the default port
;          FLAGS 0-3 are returned t/f according to the corresponding
;          port's existance
;
TestPort:
        SET FLAG(0) OFF
        SET FLAG(1) OFF
        SET FLAG(2) OFF
        SET FLAG(3) OFF
        SET PORT COM1
        IF "_UART" GE 0 SET FLAG(0) ON
        SET PORT COM2
        IF "_UART" GE 0 SET FLAG(1) ON
        SET PORT COM3
        IF "_UART" GE 0 SET FLAG(2) ON
        SET PORT COM4
        IF "_UART" GE 0 SET FLAG(3) ON
        SET PORT S0             ; Restore default
        RETURN
;
; ----- Subroutine: Fatal error.  Open a window, and display a message
;       S0 passes the error message(s)
;
Error:
        WOPEN 10,10,12,70 (contrast) Err_Esc
        ATSAY 10,12 (contrast) " Modem Diag Error "
        ATSAY 11,12 (contrast) S0(0:55); Max msg width 55 chars
        ATSAY 12,26 (contrast) " Press any key to continue "
        ;
        ;    Wait a keypress
        ;
        KEYGET S0                       ; Wait for any key
        WCLOSE
        RETURN
        ;
        ;    Escape during this screen
        ;
     Err_Esc:
        RETURN
