   S29 = "Talker  ver 1.1     " ; 20 chars long
   S28 = "talker.ovl"           ; Our overlay file
   S27 = "pc-vco.exc"           ; Our exception file
   ON ESCAPE GOSUB Esc_Exit		; ESC exit
;
; ----- Talker: Scripted interface to VOICE.EXE
;
;	R.McG; 3/90, Chicago
; ----------------------------------------------------------------
; Usages:
;	  S29 -----> Legend line
;	  S28 -----> Our own overlay file name
;	  S27 -----> Our exception file
;	  S26 -----> Previous overlay file name (or null)
;	  S25 -----> Previous overlay entry point (or NONE)
;
; -----------------------------------------------------------------------
;
;	Initialization
;
;	Initial values
;
   LEGEND S29				; Display ourselves
   S26 = "_OVERLAY"                     ; Save previous overlay, if any
   S25 = "_OVENTRY"                     ; Save previous overlay entry point
;
;	Set-up the overlay (our interface to VOICE.EXE).
;	.. define an end-entry pt of '9' at the same time
;
   OVERLAY S28	9			; Load our overlay (end entry pt = 9)
   IF FAILED				; Stop here if can't load overlay
      MESS "!Cannot overlay file: "*S28*"!"
      GOTO Exit
      ENDIF
;
;	Use the overlay to 'open' the driver
;
   SCALL 6,N0				; Entry addr 6 -> open_talk
   IF NOT ZERO N0			; If anything but zero rtnd
      MESS "!Cannot open voice driver!"
      IF NOT ISFILE "voice.exe" MESS "!VOICE.EXE must be on current subdir!"
      GOTO Exit
      ENDIF
;
;	Load an exception file, if its present
;
   SCALL 12,S27,N0			; Entry addr 12 -> Load exception file
   IF NOT ZERO N0			; If anything but zero rtnd
      MESS "!Exception file load error: "*N0*" using: "*S27*"!"
      ENDIF				; Not fatal error
   GOTO Loop				; And start
;
;	Script termination
;
Exit:
   IF OVERLAY SCALL 9			; Entry addr 9 -> Close voice driver
   OVERLAY CLEAR			; Clear our own
   IF NOT NULL S26			; If there was a previous,
      OVERLAY S26 S25			; .. replace it and its end action
      ENDIF
   EXIT
;
;	Escape pressed
;
Esc_Exit:
   S0 = "Do you wish to terminate TALKER?"
   GOSUB Ask_YN 			; Prompt
   IF FAILED RETURN			; "N" -> continue
   GOTO Exit				; Terminate
;
;	Wait for something
;
Loop:
   WHILE FKEY or NOT RECEIVE		; While nothing being received
	 IF FKEY GOTO Fkey		; Skip if a func key pending
	 ENDWHILE			; .. loop to make kbd fast
   RGET S0 80 10			; Get 80 chars - wait up to 10 secs
   IF FAILED GOTO Loop			; IF nothing received, Loop
   SCALL 0,S0				; Pass buffer to the driver
   IF NOT FULL GOTO Loop		; If not full rcv buffer
;
;	Flush the rcv buffer
;
   LEGEND S29*"Flushing buffer"         ; Change legend
   WHILE FULL				; While buffer full (host xoffed)
	 RGET S0 80 30			; Read a line and display, no voice
	 ENDWHILE			;
   LEGEND S29				; Replace legend
   GOTO Loop				; And loop
;
;	Function key pending
;
Fkey:
   KEYGET S0				; Read the function key
   SWITCH S0
      CASE "2E00"                       ; Alt-C
	 CLEAR (text)			; Perform
	 LEGEND S29			; Repaint legend
      ENDCASE
      CASE "1200"                       ; Alt-E
	 GOTO Echo
      ENDCASE
      CASE "2C00"                       ; Alt-Z
	 GOTO Mask
      ENDCASE
      CASE "2600"                       ; Alt-L
	 GOTO ScrSize
      ENDCASE
      CASE "2300"                       ; Alt-H
	 HANGUP 			; perform
      ENDCASE
      CASE "2200"                       ; Alt-G
	 GOTO Blnkln
      ENDCASE
      CASE "2D00"                       ; Alt-X
	 GOTO EndPgm
      ENDCASE

      CASE "7500"                       ; Ctl-End
	 BREAK				; Perform
      ENDCASE
      CASE "7200"                       ; Ctl-PrtSc
	 GOTO Printer
      ENDCASE

      CASE "7800"                       ; Alt-1
	 MACRO 1			; Perform
      ENDCASE
      CASE "7900"                       ; Alt-2
	 MACRO 2			; Perform
      ENDCASE
      CASE "7A00"                       ; Alt-3
	 MACRO 3			; Perform
      ENDCASE
      CASE "7B00"                       ; Alt-4
	 MACRO 4			; Perform
      ENDCASE
      CASE "7C00"                       ; Alt-5
	 MACRO 5			; Perform
      ENDCASE
      CASE "7D00"                       ; Alt-6
	 MACRO 6			; Perform
      ENDCASE
      CASE "7E00"                       ; Alt-7
	 MACRO 7			; Perform
      ENDCASE
      CASE "7F00"                       ; Alt-8
	 MACRO 8			; Perform
      ENDCASE
      CASE "8000"                       ; Alt-9
	 MACRO 9			; Perform
      ENDCASE
      CASE "8100"                       ; Alt-0
	 MACRO 0			; Perform
      ENDCASE

      CASE "4100"                       ; F7
	 GOTO Log
      ENDCASE
      CASE "4300"                       ; F9
	 GOTO LogHold
      ENDCASE
      CASE "4400"                       ; F10
	 GOSUB Help			; Note uncharacteristic GOSUB
      ENDCASE
      CASE "7100"                       ; Alt-F10
	 SHELL				; Shell to DOS
      ENDCASE
      ;
      ; Other keypresses are unrecognized
      ;
      DEFAULT
	 SOUND 100,100			; Signal error
      ENDCASE
   ENDSWITCH
   GOTO Loop				; And continue
;
;	End pgm
;
EndPgm:
   SET TTHRU ON 		; Inhibit type-through
   STACK "^@-"                  ; Stack another Alt-X
   GOTO Exit			; End script (and COM-AND)
;
;	Toggle echo
;
Echo:
   IF STRCMP "_DUPL" "HALF"     ; Test current setting
      SET DUPLEX FULL		; .. toggle
   ELSE SET DUPLEX HALF 	; .. toggle
   GOTO Loop			; And continue
;
;	Toggle mask
;
Mask:
   IF STRCMP "_MASK" "ON "      ; Test current setting
      SET MASK OFF		; .. toggle
   ELSE SET MASK ON		; .. toggle
   GOTO Loop			; And continue
;
;	Toggle screen size
;
ScrSize:
   IF GT "_SSIZ" 25
      SET 25			; .. toggle
   ELSE SET 43			; .. toggle
   LEGEND S29			; Repaint legend
   GOTO Loop			; And continue
;
;	Toggle printer
;
Printer:
   IF STRCMP "_PRINT" "ON "     ; Test state
      PRINTER OFF		; .. toggle
   ELSE PRINTER ON
   GOTO Loop			; And continue
;
;	Toggle the blank line eater
;
Blnkln:
   IF STRCMP "_BSUP" "ON "      ; Test current setting
      SET BSUPPRESS OFF 	; .. toggle
   ELSE SET BSUPPRESS ON	; .. toggle
   GOTO Loop			; And continue
;
;	Toggle the log function
;
Log:
   IF STRCMP "_LOGG" "OFF"
      S1 = "Enter the transcript file name:"
      GOSUB Ask_File		; Get script file name
      IF NOT SUCCESS or NULL S0 ; IF ESC'd out
	 GOTO Loop
	 ENDIF
      LOG OPEN S0
   ELSE
      LOG CLOSE
      ENDIF
   GOTO Loop			; Set-up the line to add to output
;
;	Toggle the log hold function
;
LogHold:
   IF STRCMP "_LOGG" "OFF"      ; If not logging
      GOTO Loop
      ENDIF
   IF STRCMP "_LOGH" "OFF"
      LOG SUSPEND
   ELSE LOG RESUME
   GOTO Loop			; Set-up the line to add to output
;
; ----- Subroutine: Ask for a script file name
;	S1 passes the prompt used
;	SUCCESS returns fact script file successfully opened
;	S0 returns the fname
;
Ask_File:
   WOPEN 10 10 13 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " TALKER Fname "
   ATSAY 11 12 (contrast) S1(0:56)
   ATSAY 13 30 (contrast) " Press ESC to cancel "

   ATGET 12 12 (contrast) 54 S0; Read new fname
   WCLOSE
   ;
   ;	   Attempt to execute the entry
   ;
   LJ S0			; Left justify
   S0 = S0 &""                  ; Trim spaces
   UPPER S0			; Make pretty
   IF NOT NULL S0		; If nothing entered
      SET SUCCESS ON
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Escape during a subwindow
;	.. S0 is returned null
;
Ask_Esc:
   S0 = ""                      ; Make a null return
   RETURN
;
; ----- Subroutine: Ask a question and take a y/n answer
;	S0 passes the text to be displayed
;	SUCCESS returns fact of y/n
;
Ask_YN:
   WOPEN 10 10 13 70 (contrast) ASK_ESC
   ATSAY 10 12 (contrast) " Talker Y/N "
   ATSAY 11 12 (contrast) S0(0:55)
   ATSAY 13 30 (contrast) " CR or ESC to exit "

   ATGET 12 12 (contrast) 1 S0 ; Read y/n
   WCLOSE
   ;
   ;	   Interperet the response
   ;
   IF NULL S0 or FIND S0 "Y"    ; If c/r yes
      SET SUCCESS ON
   ELSE
      SET SUCCESS OFF
      ENDIF
   RETURN			; And done
;
; ----- Subroutine: Help
;
Help:
   WOPEN  0, 0,23,79 (default) HELPESC
   ATSAY  0, 2 (Default) " Talker Help "
   ATSAY 23,28 (Default) " Press any key to continue "
;
;	Help message
;
   ATSAY  1,2 (default) "   The TALKER script expects to find the voice driver (VOICE.EXE) already"
   ATSAY  2,2 (default) "loaded.  If it does not find the voice driver loaded, this script will try"
   ATSAY  3,2 (default) "to load VOICE.EXE from the current subdirectory.  If the driver does not"
   ATSAY  4,2 (default) "load, it may be for one of two reasons - (1) insufficient memory to load"
   ATSAY  5,2 (default) "the driver, or (2) VOICE.EXE not found on the current subdirectory."
   ATSAY  6,2 (default) ""
   ATSAY  7,2 (default) "   The TALKER script itself loads the file TALKER.EXE.  This file is NOT a"
   ATSAY  8,2 (default) "program that runs by itself... it is a set of machine language subroutines"
   ATSAY  9,2 (default) "to the TALKER.CMD script.  These routines provide the interface to the voice"
   ATSAY 10,2 (default) "driver.  The script calls routines in TALKER to speak."
   ATSAY 11,2 (default) ""
   ATSAY 12,2 (default) "   If the TALKER script loads VOICE.EXE, it will terminate VOICE.EXE when"
   ATSAY 13,2 (default) "the script terminates.  If TALKER does NOT load VOICE.EXE (already running)"
   ATSAY 14,2 (default) "you may terminate VOICE.EXE with the VEND.COM utility."
   ATSAY 15,2 (default) ""
   ATSAY 16,2 (default) "   While TALKER is running, type-through is available, and certain function"
   ATSAY 17,2 (default) "keys are activated:  These are:"
   ATSAY 18,2 (default) ""
   ATSAY 19,2 (default) "Alt-C (clear)     Alt-H (hangup)        Alt-0/9 (macro)    Ctl-Prtsc (print)"
   ATSAY 20,2 (default) "Alt-E (echo)      Alt-X (exit COM-AND)                     Ctl-End (break)"
   ATSAY 21,2 (default) "Alt-L (scr size)  Alt-Z (mask)          F7 (transcript)  "
   ATSAY 22,2 (default) "Alt-G (blnkln)    Alt-F10 (shell)       F9 (hold transc) "
;
;	Wait for a keypress, and return
;
   KEYGET S0
   WCLOSE
   RETURN
   ;
   ;	ESCAPE during this screen
   ;
HELPESC:
   RETURN
