CDTEST    SEGMENT BYTE PUBLIC 'CODE'
page      55,132
          ASSUME  CS:CDTEST,DS:CDTEST,ES:CDTEST,SS:CDTEST
          ORG     100H        ; ASSUME & ORG set-up for COM program
;
CD        EQU     80H         ; mask for Carrier Detect
TIMING    EQU     60000       ; time limit for loop
LOOP_CNT  EQU     60          ; number of times to loop
;
P_CODE:   mov     cx,LOOP_CNT ; set-up loop counter
;
TEST_CD:  mov     ah,3        ; set-up to request status of comm port
          mov     dx,0        ; 0 = COM1 (use 1 for COM2)
          int     14h         ; call RS232_IO routine
;
          and     al,CD       ; check for Carrier Detect bit on
          jnz     CD_ON       ; CD detected, jump to positive exit
;
          dec     cx          ; lower timer
          jcxz    TIME_OUT    ; time ran out, jump to negative exit
;
          call    TIMER       ; go to timing loop
          jmp     TEST_CD     ; check again
;
TIMER:    push    cx          ; save loop counter
          mov     cx,TIMING   ; set-up timing for loop
LOOPING:  dec     cx          ; count down time
          cmp     cx,0        ; has time ran out ?
          jne     LOOPING     ; time has not ran out
          pop     cx          ; time ran out, restore loop counter
          ret                 ; & go back to main loop
;
TIME_OUT: mov     al,01       ; set ERRORLEVEL to 1
          mov     ah,4ch      ; set up to exit
          int     21h         ; exit negative
;
CD_ON:    mov     al,00       ; set ERRORLEVEL to 0
          mov     ah,4ch      ; set up to exit
          int     21h         ; exit positive
;
CDTEST    ENDS
          END     P_CODE
     ah,4ch      ; set up to exit
          int     21h         ; exit positive
;
CDTEST    ENDS
    