/*
 * C K C D . C
 *
 * Author: Scott Coleman, SysOp
 *         Xanadu BBS
 *         217/384-2127
 *         FIDOnet: 1:233/69.0
 *         Internet: coleman@f69.n233.z1.fidonet.org
 *
 * Written: 2/19/89
 *
 * Last Updated: 9/14/89
 *
 * Description: Checks the status of the carrier detect (RLSD) line for
 *     the serial port specified on the command line. The program exits
 *     with an exit code reflecting the state of the RLSD line:
 *         ERRORLEVEL 2 == Error in processing
 *         ERRORLEVEL 1 == CD is high
 *         ERRORLEVEL 0 == CD is low
 *
 * Usage: ckcd [1 | 2]
 *     where 1 == COM1:
 *           2 == COM2:
 *
 */

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

/* bitmask for carrier detect line */
#define RLSD 0x80
#define VERSION "1.1"

void main(int argc, char *argv[])
{
int port = 0;  /* port number to check, default COM1: */
union REGS r;  /* input registers for BIOS call */

    /* blatant BBS plug */
    fprintf(stderr, "ckcd version %s  Copyright (C) 1989 Xanadu Consulting  All Rights Reserved.\n", VERSION);
    fprintf(stderr, "Call Xanadu BBS  217/384-2127  1:233/69.0\n\n");

    /* check for optional argument */
    if (argc == 2) {
	port = atoi(argv[1]) - 1;  /* get desired com port number */
	if (port < 0 || port > 1) {
	    fprintf(stderr, "Usage: %s [1 | 2]\n", argv[0]);
	    exit (2);
	    }
	}

    /* check specified port for carrier */
    fprintf(stderr, "Checking for carrier on COM%d:\n", port+1);
    r.h.ah = 3;  /* get serial port status */
    r.x.dx = port;
    int86(0x14, &r, &r);
    if (r.h.ah & RLSD) {  /* carrier detected? */
	fprintf(stderr, "Carrier detected on COM%d:\n", port+1);
	exit (1);
	}
    else {
	fprintf(stderr, "No carrier on COM%d:\n", port+1);
	exit (0);
	}
}



