#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

/****************************************************************************/
/* Function prototypes                                                      */

int  main( void );
void CVT100Init( void );
void terminal( void );
void badexit( char * );

/****************************************************************************/
/* Global Data                                                              */

char modeline[] =
"F5-Communications  F6-Video  F7-Keyboard  F8-VT emulation  F9-File     F10-Exit";

/****************************************************************************/
/* External Variables                                                       */

extern unsigned int _stacklen = 4000;
extern unsigned int _heaplen = 5120;

/****************************************************************************/
/* Local Static Data                                                        */


/****************************************************************************/
/****************************************************************************/

/* M A I N -- Main function for emulator */

main()
{

   CVT100Init();                  /* Initialization */
   ttopen();                      /* Open selected com port */
   terminal();                    /* Emulate the terminal for awhile */
   ttclose();                     /* Close the communications port */
   CloseLogFile();                /* Close log file if open */
   gotoxy(1,25);                  /* When leaving set cursor to screen bottom*/
   return(0);                     /* Thats all */
}


/* C V T 1 0 0 I N I T -- Initialize the VT100 emulator */

void CVT100Init() {

   FileInit();                    /* Initialize File System *first* */
   TTinit();                      /* Initialize communications system */
   VidInit();                     /* Initialize video system */
   KeyInit();                     /* Initialize Keyboard system */
   VTInit();                      /* Initialize VT Emulation */
}

/* T E R M I N A L -- Perform terminal emulation */

void terminal()
{
   int thru = 0;
   int key;
   int c;

   while (!thru) {                /* Continue until exited */
      if (ConChk()) {                /* If a keystroke is present */
         if (DoKey() == -1)          /* Then interpret it */
            thru = 1;                /* Watch for done flag here */
      }
      if (ttchk())                /* If incoming communications chars */
         ConOut( ttinc() );       /* Output the character to emulation system*/
   }
}



/* B A D E X I T -- Exit the program displaying a fatal error message */

void badexit( char * message ) {
   char line[132];
   register char * s = line;

   ttclose();
   gotoxy(1,25);                  /* start message on last line of display*/

   while ( (*s = *message++) != '\0')
      s++;
   *s++ = '\a';                   /* Concantonate a '$' to the message */
   *s = '$';

   _DX = (unsigned) line;
   _AH = 9;
   geninterrupt(0x21);            /* Display message using DOS function 9 */
   exit(1);                       /* Exit with errorlevel 1 */
}


