/****************************************************************************/
/*     These routines test the data-compression and expansion routines      */
/*     To alter:                                                            */
/*     MAKE TEST                                                            */
/*     ( use the MAKE file )                                                */
/*                                                                          */
/*     When compiling, you will get 3 warning messages about unused         */
/*     parameters. This is because of the dummy screen() routine which      */
/*     does nothing except keep the linker happy.                           */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*     When executed, this program uses the timer-tick for data and tests   */
/*     compression/expansion for all data lengths used.                     */
/*     It takes about 84 hours to execute.  It aborts on the first error.   */
/*                                                                          */
/*     Since one might like to stop it to use their computer, I added       */
/*     routines so it may be restarted with the last buffer size.           */
/*                                                                          */
/*     This routine thoroughly tests both the file I/O and the compression  */
/*     expansion, CRC routines to verify that they will NOT corrupt any     */
/*     data. These tests are exhaustive. They were used to find the         */
/*     MicroSoft stream-I/O bug and are the reason I changed to the         */
/*     Unix-type "handle" file routines.                                    */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include <stdlib.h>                     /* Used for _free()                 */
#include <string.h>
#if defined (TURBOC)
    #include <alloc.h>
#else
    #include <malloc.h>
#endif
#include <time.h>
#define SCREEN
#include "jmodem.h"

byte far *tick = (byte far *) 0x46C;
SYS syst;
short main (void);
char input[64];
byte *in_buf;
byte *out_buf;
byte *cmp_buf;
byte *sav_ptr;
void show_hex(word, byte *);
char file_name[]="JMODEM.$$$";
word status;
short handle;

short main()
{
    word i,j,k,l;
    short flag = 1;
    short max = DAT_MAX;
    l =  DAT_MAX;
    printf("\nBuffer size? (%d) ",DAT_MAX);
    gets(input);
    sscanf(input," %d",&l);
    max = l;

    in_buf  = (byte *) malloc(l);                      /* Allocate buffer */
    if (!in_buf)                                       /* If an error     */
    {
        printf("\nMemory error!");
        return 1;
    }
    out_buf = (byte *) malloc(l);                       /* Allocate buffer */
    if (!out_buf)                                       /* If an error     */
    {
        printf("\nMemory error!");
        return 1;
    }

    printf("Will write %d records.",l);
    input[0] = 0x00;
    while (input[0] != 'C' && input[0] != 'F')
    {
        printf("\nTest CRC and compressor or File I/O? (C/F) ");
        gets(input);
        input[0] = input[0] & (char)95;
    }
    switch (input[0])
    {
        case 'F':
        {
        printf("\nWant to check CRC / comp. after the file test? (Y/N) ");
            gets(input);
            if ( (input[0] & 95) == 'Y')
                flag = 0;
            sav_ptr = out_buf;
            for (i=0; i<l; i++)
                *out_buf++ = (byte) i;
            out_buf = sav_ptr;
            while (l)
            {
                remove ("JMODEM.OLD");
                printf("\nOpening file %s for write.",file_name);
                status = file_io(CREATE, &handle, 
                                         file_name, (byte *) 0x0000) ;
                if (status)
                {
                    printf("\nOpen failed~!");
                    return(1);
                }
                printf("\nWriting file %s",file_name);
                for (i=0; i<100; i++)
                {
                    printf("\nRecord %d,",i);
                    status = file_io( WRITE ,            /* Function        */
                                 &handle,                /* File handle     */
                                 out_buf,                /* Where data is   */
                                 l );                    /* Amount to write */
                    if (status != l)
                    {
                        printf(" only wrote %d bytes!",status);
                        return 1;
                    }
                    printf(" %d bytes okay.",status);
                 }
                 printf("\nClosing file");
                 file_io(CLOSE,                          /* Function        */
                       &handle,                          /* Open handle     */
                       file_name,                        /* Name not used   */
                       (byte *) 0x0000);                 /* Buffer not used */

                printf("\nOpening file %s for read.",file_name);
                status = file_io(OPEN_READ, &handle,
                                            file_name,
                                            (byte *) 0x0000);
                if (status)
                {
                    printf("\nOpen failed~!");
                    return(1);
                }

                printf("\nReading file %s",file_name);
                for (i=0; i<100; i++)
                {
                    printf("\nRecord %d,",i);
                    status = file_io( READ ,             /* Function        */
                                 &handle,                /* File handle     */
                                 in_buf,                 /* Where data is   */
                                 l );                    /* Amount to write */
                    if (status != l)
                    {
                        printf(" only read %d bytes!",status);
                        return 1;
                    }
                    printf(" %d bytes okay,",status);

                    printf(" comparing,");
                    k = memicmp (out_buf, in_buf,l);
                    if (k)
                    {
                        printf(" did not compare!");
                        return(1);
                    }
                    printf(" okay.");

                 }
                 printf("\nClosing file");
                 file_io(CLOSE,                          /* Function        */
                       &handle,                          /* Open handle     */
                   file_name,                            /* Name not used   */
                   (byte *) 0x0000);                     /* Buffer not used */
            l--;
            }
            remove ("JMODEM.OLD");
            remove ("JMODEM.$$$");
            if (flag)
                return(0);
        }
        case 'C':
        {
            l = max;
            cmp_buf = (byte *) malloc(DAT_LEN);          /* Allocate buffer */
            if (!cmp_buf)                                /* In an error     */
            {
                printf("\nMemory error!");
                return 1;
            }
            printf("\nFilling the input buffer with consecutive bytes.");
            sav_ptr = in_buf;                           /* Save            */
            for (i=0; i< l; i++)
                *in_buf++ = (byte) i;                   /* Fill the buffer */

            in_buf = sav_ptr;
            printf("\nAttempting to compress.");
            j = encode ( l,in_buf, cmp_buf);            /* Compress the data*/
            printf("\nEncoder returned %u.",j);         /* Won't compress   */

            while (l--)
            {
                in_buf = sav_ptr;
                printf("\nFilling the buffer with %u bytes.",l);
                for (i=0; i< l; i++)
                {
                    *in_buf++ = *tick;
                    j = 8;
                    while (j--);                        /* Waste some time */
                }
                in_buf = sav_ptr;
/*              show_hex(l,in_buf); */
                printf("\nCompressing,");
                j = encode ( l,in_buf, cmp_buf);
                printf(" returned %u.",j);
  /*            show_hex(j,cmp_buf); */

                in_buf = sav_ptr;
                printf("\nExpanding,");
                j = decode (j,cmp_buf,out_buf);

                printf(" returned %u.",j);
                if (j != l)
                    return(1);

                printf("\nComparing,");
                k = memicmp (out_buf, in_buf,j);
                if (k)
                {
                    printf(" did not compare!\n");
                    return(1);
                }
                printf(" okay.");

                printf("\nCalculating CRC.");       /* Calculate CRC    */
                k = calc_crc(SET_CRC,j,out_buf);
                printf("\nChecking CRC of %4.4X,",k);
                j = calc_crc(GET_CRC,j,out_buf);    /* Check CRC    */
                if (j)
                {
                    printf(" bad CRC!\n");
                    return(1);
                }
                printf(" okay.\n");

                in_buf = sav_ptr;
                printf("\nFilling buffer with %u nulls.",l);
                for (i=0; i< l; i++)
                    *in_buf++ = (byte) 0;

                in_buf = sav_ptr;
                printf("\nCompressing,");
                j = encode ( l,in_buf, cmp_buf);
                printf(" returned %u.",j);

                in_buf = sav_ptr;
                printf("\nExpanding,");
                j = decode (j,cmp_buf,out_buf);

                printf(" returned %u.",j);
                if (j != l)
                    return(1);

                printf("\nComparing,");
                k = memicmp (out_buf, in_buf,j);
                if (k)
                {
                    printf(" did not compare!");
                    return(1);
                }
                printf(" okay.\n");
            }
        }
    }
    return 0;

}
/* Dummy routine to keep the linker happy. */

void screen (short one, SYS *two)
{
    one = (short) two;
}

void show_hex(word len, byte *string)
{
    word i;

    while (len)
    {
        i = 16;
        while ( (len) && (i) )
            {
            printf("%2.2X ",*string++);
            len --;
            i--;
            }

    printf("\n");
    }
    return;
}
