/*-
 * PTY service routines.  (pty.c)
 *
 * Mutex in UNIX
 *
 * Bryan So, September 28, 1990
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/file.h>

#include "pty.h"


/*
 * Short hands for programming convenience
 */

#define Master (pty->master)
#define Slave (pty->slave)
#define Name (pty->name)


/*
 * Close the pseudo-terminal
 */
pty_close(pty)
Pty *pty;
{
     close(Master);
     close(Slave);
}


/*
 * Create the master part of a pseudo-terminal pair.  Return the file
 * descriptor if successful, or -1 if error.
 *
 * If successful, a pty file (i.e. /dev/pty??) will be opened for read/
 * write and can be accessed by pty_fd(pty).  Further, the Name field
 * will be modified to be the corresponding /dev/tty?? file.
 */
int pty_master(pty)
Pty *pty;
{
     int c, i;

     /*
      * Try all the pty files of the form /dev/pty[pqrs][0-9a-f]
      * until one of them is available for use.
      */
     for (c = 'p'; c <= 's'; c++)
	  for (i = 0; i < 16; i++) {
	       sprintf(Name, "/dev/pty%c%x", c, i);
	       if ((Master = open(Name, O_RDWR)) > 0) {
	       /*
	        * Check for availability of the other side 
	        */
		    Name[5] = 't';
		    if (access(Name, R_OK | W_OK) == 0)
			 return Master;
		    else
			 close(Master);
	       }
	  }
     return -1;
}


/*
 * Done with master.
 */
#undef Master



/*
 * Create slave part of the pseudo-terminal pairs.  Make sure that
 * the control terminal is properly disconnected from the calling
 * process.  Return the file descriptor of the slave if successul,
 * or -1 in case of error.
 *
 * It is assumed the user has called pty_master with this pty struct-
 * ure before calling pty_slave; otherwise, the result is undefined.
 */
int pty_slave(pty)
Pty *pty;
{
     int fd;

    /*
     * Disconnect the control terminal of the calling process so that
     * the slave can have its own.
     */
     if ((fd = open("/dev/tty", O_RDWR)) >= 0)
	  ioctl(fd, TIOCNOTTY, 0);                    /** Note **/

    /*
     * Reopen Name as the control terminal 
     */
     return Slave = open(Name, O_RDWR);
}
           /*- ** Note **
            *    Most programs close the control terminal, this seems to
            *    cause losing characters to happen if typed before this
            *    point.
	    */
      

/*
 * Done with the short hands
 */

#undef Slave
#undef Name


#if 0

#include <sys/types.h>

main()
{
     Pty p;
     int e;
     fd_set rs, org;
     char s[80];

     tty_cbreak(0);
     tty_noecho(0);
     e = pty_master(&p);
     if (e != -1)
	  printf("DEBUG e, fd = %d, %d, name = %s\n", e, p.master, p.name);

     FD_ZERO(&org);
     FD_SET(0, &org);
     FD_SET(p.master, &org);
     rs = org;
     puts("Waiting... ");
     select(p.master+1, &rs, 0, 0, 0);
     if (FD_ISSET(0, &rs)) {
	  puts("stdin");
	  printf("%d read = ", read(0, s, 1));
          printf("%c\n", s[0]);
     }
     if (FD_ISSET(p.master, &rs))
	  puts("master");

     tty_nocbreak(0);
     tty_echo(0);
     close(p.master);

     return 0;
}

#endif

