/*-
 * TTY service.  (tty.h)
 *
 * Mutex in UNIX
 *
 *      This module implements some utility routines for managing UNIX
 *	terminal modes.
 *........................................................................
 * Tty t;
 *
 *      Tty is a structure that stores the bookkeeping information about
 *	each terminal setup.
 *........................................................................
 * int  tty_raw(int fd)
 * int  tty_cbreak(int fd)
 * int  tty_echo(int fd)
 *
 *	Change the file descriptor to raw/cbreak/echo mode.  Return -1 if
 *	error.
 *........................................................................
 * int  tty_noraw(int fd)
 * int  tty_nocbreak(int fd)
 * int  tty_noecho(int fd)
 *
 *	Reverse of the above.  Also return -1 if error.
 *........................................................................
 * int  tty_get_mode(Tty *mode, int fd)
 *
 *	Get the current mode of a descriptor fd and store it into mode.
 *	Later, tty_set_mode can be used to reset this file back to mode.
 *	Return -1 if error.
 *........................................................................
 * int  tty_set_mode(Tty *mode, int fd)
 *
 *      Set the terminal descriptor fd to have the same terminal mode as
 *	mode.  Mode should be obtained by calling tty_get_mode beforehand.
 *	Return -1 if error.
 *........................................................................
 * int  tty_copy(int source, int dest)
 *
 *	Set the terminal modes of the descriptor dest to be the same as
 *	the source.  Return -1 if error.
 *........................................................................
 *
 * Bryan So, September 28, 1990
 */

#if !defined(TTY_H)

#define TTY_H

#include <sys/types.h>
#include <sys/ioctl.h>


/*
 * Main tty structure.
 */

typedef struct {
     struct sgttyb tty_sgttyb;
     struct tchars tty_tchars;
     struct ltchars tty_ltchars;
     struct winsize tty_winsize;
     int tty_lmode;
     int tty_ldisc;
} Tty;


/*
 * Public Functions
 */

#if defined(__STDC__)

extern int tty_set_mode(Tty *tty, int fd);
extern int tty_get_mode(Tty *tty, int fd);
extern int tty_copy(int source, int dest);
extern int tty_raw(int fd);
extern int tty_cbreak(int fd);
extern int tty_echo(int fd);
extern int tty_noraw(int fd);
extern int tty_nocbreak(int fd);
extern int tty_noecho(int fd);

#else

extern int tty_set_mode();
extern int tty_get_mode();
extern int tty_copy();
extern int tty_raw();
extern int tty_cbreak();
extern int tty_echo();
extern int tty_noraw();
extern int tty_nocbreak();
extern int tty_noecho();

#endif


#endif
